/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.binders;

import es.bsc.compss.types.execution.ThreadBinder;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableComputingUnitsException;

public class BindToResource
implements ThreadBinder {
    private static final String UNSUFFICIENT_CUS = "Not enough available computing units for task execution";
    private final int[] bindedComputingUnits;

    public BindToResource(int numThreads) {
        this.bindedComputingUnits = new int[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.bindedComputingUnits[i] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int[] bindComputingUnits(int jobId, int numCUs, int[] preferredAllocation) throws UnsufficientAvailableComputingUnitsException {
        if (preferredAllocation != null && preferredAllocation.length == numCUs) {
            int[] nArray = this.bindedComputingUnits;
            // MONITORENTER : this.bindedComputingUnits
            if (this.isAllocationAvailable(preferredAllocation)) {
                this.assignAllocation(preferredAllocation, jobId);
                // MONITOREXIT : nArray
                return preferredAllocation;
            }
            // MONITOREXIT : nArray
        }
        int[] assignedCoreUnits = new int[numCUs];
        int numAssignedCores = 0;
        if (numCUs <= 0) return assignedCoreUnits;
        int[] nArray = this.bindedComputingUnits;
        // MONITORENTER : this.bindedComputingUnits
        for (int coreId = 0; coreId < this.bindedComputingUnits.length; ++coreId) {
            if (this.bindedComputingUnits[coreId] == -1) {
                this.bindedComputingUnits[coreId] = jobId;
                assignedCoreUnits[numAssignedCores] = coreId;
                ++numAssignedCores;
            }
            if (numAssignedCores == numCUs) break;
        }
        // MONITOREXIT : nArray
        if (numAssignedCores == numCUs) return assignedCoreUnits;
        this.releaseComputingUnits(jobId);
        throw new UnsufficientAvailableComputingUnitsException(UNSUFFICIENT_CUS);
    }

    private void assignAllocation(int[] previousAllocation, int jobId) {
        for (int coreId : previousAllocation) {
            this.bindedComputingUnits[coreId] = jobId;
        }
    }

    private boolean isAllocationAvailable(int[] previousAllocation) {
        for (int coreId : previousAllocation) {
            if (this.bindedComputingUnits[coreId] == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseComputingUnits(int jobId) {
        int[] nArray = this.bindedComputingUnits;
        synchronized (this.bindedComputingUnits) {
            for (int coreId = 0; coreId < this.bindedComputingUnits.length; ++coreId) {
                if (this.bindedComputingUnits[coreId] != jobId) continue;
                this.bindedComputingUnits[coreId] = -1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

