/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.types.StdIOStream;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class BinaryInvoker
extends Invoker {
    private static final int NUM_BASE_BINARY_ARGS = 1;
    private final String binary;
    private final boolean failByEV;
    private BinaryRunner br;

    public BinaryInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        BinaryDefinition binaryImpl = null;
        try {
            binaryImpl = (BinaryDefinition)invocation.getMethodImplementation().getDefinition();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()), e);
        }
        this.binary = binaryImpl.getBinary();
        this.failByEV = binaryImpl.isFailByEV();
        this.br = null;
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        LOGGER.info("Invoked " + this.binary + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            LOGGER.error("Exception running binary", (Throwable)iee);
            throw new JobExecutionException(iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams languageParams = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (languageParams instanceof PythonParams) {
                    PythonParams pp = (PythonParams)languageParams;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException(se);
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            if (invocationParam.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(invocationParam, retValue);
                continue;
            }
            invocationParam.setValue(retValue);
            invocationParam.setValueClass(retValue.getClass());
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String pythonInterpreter = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.getPythonInterpreter();
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
        String[] cmd = null;
        cmd = new String[1 + binaryParams.size()];
        cmd[0] = this.binary;
        for (int i = 0; i < binaryParams.size(); ++i) {
            cmd[1 + i] = binaryParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[BINARY INVOKER] Begin binary call to " + this.binary);
            outLog.println("[BINARY INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
            outLog.print("[BINARY INVOKER] BINARY CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[BINARY INVOKER] Binary STDIN: " + streamValues.getStdIn());
            outLog.println("[BINARY INVOKER] Binary STDOUT: " + streamValues.getStdOut());
            outLog.println("[BINARY INVOKER] Binary STDERR: " + streamValues.getStdErr());
        }
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, this.failByEV);
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling binary process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

