/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class COMPSsNode
implements Comparable<COMPSsNode> {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final String DELETE_ERR = "Error deleting intermediate files";
    protected static final String URI_CREATION_ERR = "Error creating new URI";
    private static final String MASTER_NAME_PROPERTY = System.getProperty("compss.masterName");
    private static final String UNDEFINED_MASTER_NAME = "master";
    protected static final String MASTER_NAME;
    private NodeMonitor monitor;

    public COMPSsNode(NodeMonitor monitor) {
        this.monitor = monitor;
    }

    public abstract String getName();

    public static String getMasterName() {
        return MASTER_NAME;
    }

    public abstract void start() throws InitNodeException;

    public abstract void setInternalURI(MultiURI var1) throws UnstartedNodeException;

    public abstract Job<?> newJob(int var1, TaskDescription var2, Implementation var3, Resource var4, List<String> var5, JobListener var6, List<Integer> var7, Integer var8);

    public abstract void sendData(LogicalData var1, DataLocation var2, DataLocation var3, LogicalData var4, Transferable var5, EventListener var6);

    public abstract void obtainData(LogicalData var1, DataLocation var2, DataLocation var3, LogicalData var4, Transferable var5, EventListener var6);

    public abstract void enforceDataObtaining(Transferable var1, EventListener var2);

    public abstract void stop(ShutdownListener var1);

    public abstract SimpleURI getCompletePath(DataType var1, String var2);

    public String getOutputDataTarget(String tgtName, DependencyParameter param) {
        DataType type = param.getType();
        tgtName = param.generateDataTargetName(tgtName);
        if (type.equals((Object)DataType.PSCO_T) || type.equals((Object)DataType.EXTERNAL_PSCO_T)) {
            if (DEBUG) {
                LOGGER.debug("Generated data target for param: " + tgtName);
            }
            return tgtName;
        }
        if (DEBUG) {
            LOGGER.debug("Generated data target for param: " + this.getCompletePath(type, tgtName).getPath());
        }
        return this.getCompletePath(param.getType(), tgtName).getPath();
    }

    public abstract void deleteTemporary();

    public abstract boolean generatePackage();

    public abstract void shutdownExecutionManager(ExecutorShutdownListener var1);

    public abstract boolean generateWorkersDebugInfo();

    @Override
    public int compareTo(COMPSsNode host) {
        return this.getName().compareTo(host.getName());
    }

    public abstract void increaseComputingCapabilities(ResourceDescription var1);

    public abstract void reduceComputingCapabilities(ResourceDescription var1);

    public abstract void removeObsoletes(List<MultiURI> var1);

    public void setMonitor(NodeMonitor monitor) {
        this.monitor = monitor;
    }

    public void idleReservedResourcesDetected(ResourceDescription resources) {
        this.monitor.idleReservedResourcesDetected(resources);
    }

    public void reactivatedReservedResourcesDetected(ResourceDescription resources) {
        this.monitor.reactivatedReservedResourcesDetected(resources);
    }

    public abstract void verifyNodeIsRunning();

    public final void disruptedConnection() {
        this.monitor.lostNode();
    }

    static {
        String hostName = "";
        if (MASTER_NAME_PROPERTY != null && !MASTER_NAME_PROPERTY.equals("") && !MASTER_NAME_PROPERTY.equals("null")) {
            hostName = MASTER_NAME_PROPERTY;
        } else {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                hostName = localHost.getHostName();
            }
            catch (UnknownHostException e) {
                ErrorManager.warn("ERROR_UNKNOWN_HOST: " + e.getLocalizedMessage());
                hostName = UNDEFINED_MASTER_NAME;
            }
        }
        MASTER_NAME = hostName;
    }
}

