/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.conn.types.StarterCommand;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WorkerStarterCommand
implements StarterCommand {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String LIB_SEPARATOR = ":";
    private static final String CLASSPATH_FROM_ENVIRONMENT = System.getProperty("compss.worker.cp") != null && !System.getProperty("compss.worker.cp").isEmpty() ? System.getProperty("compss.worker.cp") : "";
    private static final String PYTHONPATH_FROM_ENVIRONMENT = System.getProperty("compss.worker.pythonpath") != null && !System.getProperty("compss.worker.pythonpath").isEmpty() ? System.getProperty("compss.worker.pythonpath") : "";
    private static final String LIBPATH_FROM_ENVIRONMENT = System.getenv("LD_LIBRARY_PATH") != null && !System.getenv("LD_LIBRARY_PATH").isEmpty() ? System.getenv("LD_LIBRARY_PATH") : "";
    private static final boolean IS_CPU_AFFINITY_DEFINED = System.getProperty("compss.worker.cpu_affinity") != null && !System.getProperty("compss.worker.cpu_affinity").isEmpty();
    protected static final String CPU_AFFINITY = IS_CPU_AFFINITY_DEFINED ? System.getProperty("compss.worker.cpu_affinity") : "disabled";
    private static final boolean IS_GPU_AFFINITY_DEFINED = System.getProperty("compss.worker.gpu_affinity") != null && !System.getProperty("compss.worker.gpu_affinity").isEmpty();
    protected static final String GPU_AFFINITY = IS_GPU_AFFINITY_DEFINED ? System.getProperty("compss.worker.gpu_affinity") : "disabled";
    private static final boolean IS_FPGA_AFFINITY_DEFINED = System.getProperty("compss.worker.gpu_affinity") != null && !System.getProperty("compss.worker.gpu_affinity").isEmpty();
    protected static final String FPGA_AFFINITY = IS_FPGA_AFFINITY_DEFINED ? System.getProperty("compss.worker.gpu_affinity") : "disabled";
    private static final boolean IS_IO_EXECUTORS_DEFINED = System.getProperty("compss.worker.io_executors") != null && !System.getProperty("compss.worker.io_executors").isEmpty();
    protected static final String IO_EXECUTORS = IS_IO_EXECUTORS_DEFINED ? System.getProperty("compss.worker.io_executors") : "0";
    private static final String WORKER_APPDIR_FROM_ENVIRONMENT = System.getProperty("compss.worker.appdir") != null && !System.getProperty("compss.worker.appdir").isEmpty() ? System.getProperty("compss.worker.appdir") : "";
    private static final String WORKER_ENV_SCRIPT_FROM_ENVIRONMENT = System.getProperty("compss.worker.env_script") != null && !System.getProperty("compss.worker.env_script").isEmpty() ? System.getProperty("compss.worker.env_script") : "";
    protected static final String DEPLOYMENT_ID = System.getProperty("compss.uuid");
    protected String workerName;
    protected int workerPort;
    protected String masterName;
    protected String workingDir;
    protected String sandboxedWorkingDir;
    protected String installDir;
    protected String appDir = "";
    protected String workerClasspath = "";
    protected String workerPythonpath = "";
    protected String workerLibPath = "";
    protected String workerEnvScriptPath = "";
    protected String[] jvmFlags;
    protected String[] fpgaArgs;
    protected String workerDebug;
    protected String storageConf;
    protected String executionType;
    protected String workerPersistentC;
    protected String pythonInterpreter;
    protected String pythonVersion;
    protected String pythonVirtualEnvironment;
    protected String pythonPropagateVirtualEnvironment;
    protected String pythonExtraeFile;
    protected String pythonMpiWorker;
    protected String pythonWorkerCache;
    protected int totalCPU;
    protected int totalGPU;
    protected int totalFPGA;
    protected int limitOfTasks;
    protected String hostId;
    protected String lang;

    public WorkerStarterCommand(String workerName, int workerPort, String masterName, String workingDir, String installDir, String appDir, String classpathFromFile, String pythonpathFromFile, String libPathFromFile, String envScriptPathFromFile, int totalCPU, int totalGPU, int totalFPGA, int limitOfTasks, String hostId) {
        this.workerName = workerName;
        this.workerPort = workerPort;
        this.masterName = masterName;
        this.workingDir = workingDir;
        this.sandboxedWorkingDir = workingDir;
        this.installDir = installDir;
        if (!appDir.isEmpty()) {
            if (!WORKER_APPDIR_FROM_ENVIRONMENT.isEmpty()) {
                LOGGER.warn("Path passed via appdir option and xml AppDir field.The path provided by the xml will be used");
            }
            this.appDir = appDir;
        } else if (!WORKER_APPDIR_FROM_ENVIRONMENT.isEmpty()) {
            this.appDir = WORKER_APPDIR_FROM_ENVIRONMENT;
        }
        if (!envScriptPathFromFile.isEmpty()) {
            if (!WORKER_ENV_SCRIPT_FROM_ENVIRONMENT.isEmpty()) {
                LOGGER.warn("Path passed via env_script option and xml EnvironmentPath field.The path provided by the xml will be used");
            }
            this.workerEnvScriptPath = envScriptPathFromFile;
        } else if (!WORKER_ENV_SCRIPT_FROM_ENVIRONMENT.isEmpty()) {
            this.workerEnvScriptPath = WORKER_ENV_SCRIPT_FROM_ENVIRONMENT;
        }
        this.workerClasspath = !classpathFromFile.isEmpty() ? (!CLASSPATH_FROM_ENVIRONMENT.isEmpty() ? classpathFromFile + LIB_SEPARATOR + CLASSPATH_FROM_ENVIRONMENT : classpathFromFile) : CLASSPATH_FROM_ENVIRONMENT;
        this.workerPythonpath = !pythonpathFromFile.isEmpty() ? (!PYTHONPATH_FROM_ENVIRONMENT.isEmpty() ? pythonpathFromFile + LIB_SEPARATOR + PYTHONPATH_FROM_ENVIRONMENT : pythonpathFromFile) : PYTHONPATH_FROM_ENVIRONMENT;
        this.workerLibPath = !libPathFromFile.isEmpty() ? (!LIBPATH_FROM_ENVIRONMENT.isEmpty() ? libPathFromFile + LIB_SEPARATOR + LIBPATH_FROM_ENVIRONMENT : libPathFromFile) : LIBPATH_FROM_ENVIRONMENT;
        String workerJVMflags = System.getProperty("compss.worker.jvm_opts");
        this.jvmFlags = new String[0];
        if (workerJVMflags != null && !workerJVMflags.isEmpty()) {
            this.jvmFlags = workerJVMflags.split(",");
        }
        String workerFPGAargs = System.getProperty("compss.worker.fpga_reprogram");
        this.fpgaArgs = new String[0];
        if (workerFPGAargs != null && !workerFPGAargs.isEmpty()) {
            this.fpgaArgs = workerFPGAargs.split(" ");
        }
        this.workerDebug = Boolean.toString(LogManager.getLogger("es.bsc.compss.Worker").isDebugEnabled());
        this.storageConf = System.getProperty("compss.storage.conf");
        if (this.storageConf == null || this.storageConf.equals("") || this.storageConf.equals("null")) {
            this.storageConf = "null";
        }
        this.executionType = System.getProperty("compss.task.execution");
        if (this.executionType == null || this.executionType.equals("") || this.executionType.equals("null")) {
            this.executionType = COMPSsConstants.TaskExecution.COMPSS.toString();
        }
        this.workerPersistentC = System.getProperty("compss.worker.persistent.c");
        if (this.workerPersistentC == null || this.workerPersistentC.isEmpty() || this.workerPersistentC.equals("null")) {
            this.workerPersistentC = "false";
        }
        this.pythonInterpreter = System.getProperty("compss.python.interpreter");
        if (this.pythonInterpreter == null || this.pythonInterpreter.isEmpty() || this.pythonInterpreter.equals("null")) {
            this.pythonInterpreter = "python";
        }
        this.pythonVersion = System.getProperty("compss.python.version");
        if (this.pythonVersion == null || this.pythonVersion.isEmpty() || this.pythonVersion.equals("null")) {
            this.pythonVersion = "2";
        }
        this.pythonVirtualEnvironment = System.getProperty("compss.python.virtualenvironment");
        if (this.pythonVirtualEnvironment == null || this.pythonVirtualEnvironment.isEmpty() || this.pythonVirtualEnvironment.equals("null")) {
            this.pythonVirtualEnvironment = "null";
        }
        this.pythonPropagateVirtualEnvironment = System.getProperty("compss.python.propagate_virtualenvironment");
        if (this.pythonPropagateVirtualEnvironment == null || this.pythonPropagateVirtualEnvironment.isEmpty() || this.pythonPropagateVirtualEnvironment.equals("null")) {
            this.pythonPropagateVirtualEnvironment = "true";
        }
        this.pythonExtraeFile = System.getProperty("compss.extrae.file.python");
        if (this.pythonExtraeFile == null || this.pythonExtraeFile.isEmpty() || this.pythonExtraeFile.equals("null")) {
            this.pythonExtraeFile = "null";
        }
        this.pythonMpiWorker = System.getProperty("compss.python.mpi_worker");
        if (this.pythonMpiWorker == null || this.pythonMpiWorker.isEmpty() || this.pythonMpiWorker.equals("null")) {
            this.pythonMpiWorker = "false";
        }
        this.pythonWorkerCache = System.getProperty("compss.python.worker_cache");
        if (this.pythonWorkerCache == null || this.pythonWorkerCache.isEmpty() || this.pythonWorkerCache.equals("null")) {
            this.pythonWorkerCache = "false";
        }
        this.lang = System.getProperty("compss.lang");
        this.totalCPU = totalCPU;
        this.totalGPU = totalGPU;
        this.totalFPGA = totalFPGA;
        this.limitOfTasks = limitOfTasks;
        this.hostId = hostId;
    }

    @Override
    public String getBaseWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }

    @Override
    public void setNodeId(String nodeId) {
        this.hostId = nodeId;
    }

    @Override
    public void setSandboxedWorkingDir(String sandboxedWorkingDir) {
        this.sandboxedWorkingDir = sandboxedWorkingDir;
    }
}

