/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources.configuration;

import es.bsc.compss.types.resources.configuration.Configuration;
import java.io.File;

public class MethodConfiguration
extends Configuration {
    private static final String DEPLOYMENT_ID = System.getProperty("compss.uuid");
    private String host;
    private String user = "";
    private String installDir = "";
    private String workingDir = "";
    private String sandboxWorkingDir;
    private int totalComputingUnits = 0;
    private int totalGPUComputingUnits = 0;
    private int totalFPGAComputingUnits = 0;
    private int totalOTHERComputingUnits = 0;
    private String appDir = "";
    private String classpath = "";
    private String pythonpath = "";
    private String libraryPath = "";
    private String envScript = "";
    private int minPort;
    private int maxPort;

    public MethodConfiguration(String adaptorName) {
        super(adaptorName);
    }

    public MethodConfiguration(MethodConfiguration clone) {
        super(clone);
        this.host = clone.host;
        this.user = clone.user;
        this.installDir = clone.installDir;
        this.workingDir = clone.workingDir;
        this.sandboxWorkingDir = clone.sandboxWorkingDir;
        this.totalComputingUnits = clone.totalComputingUnits;
        this.totalGPUComputingUnits = clone.totalGPUComputingUnits;
        this.totalFPGAComputingUnits = clone.totalFPGAComputingUnits;
        this.totalOTHERComputingUnits = clone.totalOTHERComputingUnits;
        this.appDir = clone.appDir;
        this.classpath = clone.classpath;
        this.pythonpath = clone.pythonpath;
        this.libraryPath = clone.libraryPath;
        this.envScript = clone.envScript;
        this.minPort = clone.minPort;
        this.maxPort = clone.maxPort;
    }

    public MethodConfiguration copy() {
        return new MethodConfiguration(this);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host != null ? host : "";
        String newHost = this.getHost().replace("/", "_").replace(":", "_");
        String sandboxWorkingDir = this.getWorkingDir() + DEPLOYMENT_ID + File.separator + newHost + File.separator;
        this.setSandboxWorkingDir(sandboxWorkingDir);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user != null ? user : "";
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir == null ? "" : (installDir.isEmpty() ? "" : (!installDir.endsWith(File.separator) ? installDir + File.separator : installDir));
    }

    public String getSandboxWorkingDir() {
        return this.sandboxWorkingDir;
    }

    public void setSandboxWorkingDir(String sandboxWorkingDir) {
        this.sandboxWorkingDir = sandboxWorkingDir;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir == null ? File.separator + "tmp" + File.separator : (workingDir.isEmpty() ? File.separator + "tmp" + File.separator : (!workingDir.endsWith(File.separator) ? workingDir + File.separator : workingDir));
        String host = this.getHost().replace("/", "_").replace(":", "_");
        String sandboxWorkingDir = this.workingDir + DEPLOYMENT_ID + File.separator + host + File.separator;
        this.setSandboxWorkingDir(sandboxWorkingDir);
    }

    public int getTotalComputingUnits() {
        return this.totalComputingUnits;
    }

    public void setTotalComputingUnits(int totalCUs) {
        this.totalComputingUnits = totalCUs > 0 ? totalCUs : 0;
    }

    public int getTotalGPUComputingUnits() {
        return this.totalGPUComputingUnits;
    }

    public void setTotalGPUComputingUnits(int totalGPUs) {
        this.totalGPUComputingUnits = totalGPUs > 0 ? totalGPUs : 0;
    }

    public int getTotalFPGAComputingUnits() {
        return this.totalFPGAComputingUnits;
    }

    public void setTotalFPGAComputingUnits(int totalFPGAs) {
        this.totalFPGAComputingUnits = totalFPGAs > 0 ? totalFPGAs : 0;
    }

    public int getTotalOTHERComputingUnits() {
        return this.totalOTHERComputingUnits;
    }

    public void setTotalOTHERComputingUnits(int totalOTHERs) {
        this.totalOTHERComputingUnits = totalOTHERs > 0 ? totalOTHERs : 0;
    }

    public String getAppDir() {
        return this.appDir;
    }

    public void setAppDir(String appDir) {
        this.appDir = appDir == null || appDir.isEmpty() ? "" : (!appDir.endsWith(File.separator) ? appDir + File.separator : appDir);
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath == null ? "" : classpath;
    }

    public String getPythonpath() {
        return this.pythonpath;
    }

    public void setPythonpath(String pythonpath) {
        this.pythonpath = pythonpath == null ? "" : pythonpath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath == null ? "" : libraryPath;
    }

    public String getEnvScript() {
        return this.envScript;
    }

    public void setEnvScript(String envScriptPath) {
        this.envScript = envScriptPath == null ? "" : envScriptPath;
    }

    public int getMinPort() {
        return this.minPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }
}

