/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.util.TraceMerger;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PythonTraceMerger
extends TraceMerger {
    private static final String PYTHON_WORKER_SUBDIR = "python";
    private static final String PYTHON_WORKER_TRACE_SUFFIX = "_python_trace.prv";
    private String workingDir;

    public PythonTraceMerger(String workingDir) throws IOException {
        String masterDir = workingDir + File.separator + "trace";
        String workersDir = workingDir + File.separator + "trace" + File.separator + PYTHON_WORKER_SUBDIR;
        this.workingDir = workingDir;
        File masterF = new File(masterDir);
        String traceNamePrefix = Tracer.getTraceNamePrefix();
        File[] matchingMasterFiles = masterF.listFiles((dir, name) -> name.startsWith(traceNamePrefix) && name.endsWith(".prv"));
        if (matchingMasterFiles == null || matchingMasterFiles.length < 1) {
            throw new FileNotFoundException("Master trace " + traceNamePrefix + "*" + ".prv" + " not found at directory " + masterDir);
        }
        if (matchingMasterFiles.length > 1) {
            LOGGER.warn("Found more than one master trace, using " + matchingMasterFiles[0] + " to merge.");
        }
        this.setUpMaster(matchingMasterFiles[0]);
        File workerF = new File(workersDir);
        File[] workersTraces = workerF.listFiles((dir, name) -> name.endsWith(PYTHON_WORKER_TRACE_SUFFIX));
        this.setUpWorkers(workersTraces);
        LOGGER.debug("Trace's merger initialization successful");
    }

    public void removeTemporalFiles() {
        if (!DEBUG) {
            String workerFolder = this.workingDir + File.separator + "trace" + File.separator + PYTHON_WORKER_SUBDIR;
            LOGGER.debug("Removing folder " + workerFolder);
            try {
                PythonTraceMerger.removeFolder(workerFolder);
            }
            catch (IOException ioe) {
                LOGGER.warn("Could not remove python temporal tracing folder" + ioe.toString());
            }
        }
    }

    public void merge() throws Exception {
        this.mergePRVsWithTraceNumAndSyncEvents();
        this.mergePCFsHardwareCounters();
        LOGGER.debug("Merging finished.");
        this.removeTemporalFiles();
    }
}

