/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.connectors.Connector;
import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.connectors.Cost;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.listeners.ResourceCreationListener;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.util.CloudImageManager;
import es.bsc.compss.util.CloudTypeManager;
import es.bsc.compss.util.CoreManager;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudProvider {
    private static final String WARN_NO_VALID_INSTANCE = "WARN: Cannot find a containing/contained instanceType";
    private static final String WARN_NO_VALID_IMAGE = "WARN: Cannot find a containing/contained instanceType";
    private static final String WARN_CANNOT_TURN_ON = "WARN: Connector cannot turn on resource";
    private final String name;
    private final Integer limitOfVMs;
    private final Set<CloudMethodWorker> hostedWorkers;
    private final CloudImageManager imgManager;
    private final CloudTypeManager typeManager;
    private final Connector connector;
    private final Cost cost;
    private int currentVMCount;
    private final List<ResourceCreationRequest> pendingRequests;
    private int[] pendingCoreCount;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.CloudManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public CloudProvider(String providerName, Integer limitOfVMs, String runtimeConnectorClass, String connectorJarPath, String connectorMainClass, Map<String, String> connectorProperties) throws ConnectorException {
        this.name = providerName;
        this.limitOfVMs = limitOfVMs;
        this.currentVMCount = 0;
        this.hostedWorkers = new HashSet<CloudMethodWorker>();
        this.imgManager = new CloudImageManager();
        this.typeManager = new CloudTypeManager();
        try {
            Class<?> conClass = Class.forName(runtimeConnectorClass);
            Class[] parameterTypes = new Class[]{CloudProvider.class, String.class, String.class, Map.class};
            Constructor<?> ctor = conClass.getConstructor(parameterTypes);
            Object conector = ctor.newInstance(this, connectorJarPath, connectorMainClass, connectorProperties);
            this.connector = (Connector)conector;
            this.cost = (Cost)conector;
        }
        catch (Exception e) {
            throw new ConnectorException(e);
        }
        this.pendingRequests = new LinkedList<ResourceCreationRequest>();
        this.pendingCoreCount = new int[CoreManager.getCoreCount()];
    }

    public void addCloudImage(CloudImageDescription cid) {
        this.imgManager.add(cid);
    }

    public void addInstanceType(CloudInstanceTypeDescription rd) {
        this.typeManager.addType(rd);
    }

    public void newCoreElementsDetected(List<Integer> newCores) {
        this.typeManager.newCoreElementsDetected(newCores);
        this.pendingCoreCount = new int[CoreManager.getCoreCount()];
        for (ResourceCreationRequest creationRequest : this.pendingRequests) {
            int[][] newRequestedSimultaneousTaskCount = this.computeSimultaneousCounts(creationRequest.getRequested());
            creationRequest.updateRequestedSimultaneousTaskCount(newRequestedSimultaneousTaskCount);
            int coreId = 0;
            while (coreId < newRequestedSimultaneousTaskCount.length) {
                int coreSlots = 0;
                for (int implId = 0; implId < newRequestedSimultaneousTaskCount[coreId].length; ++implId) {
                    coreSlots = Math.max(coreSlots, newRequestedSimultaneousTaskCount[coreId][implId]);
                }
                int n = coreId++;
                this.pendingCoreCount[n] = this.pendingCoreCount[n] + coreSlots;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public float getCurrentCostPerHour() {
        return this.cost.currentCostPerHour().floatValue();
    }

    public float getTotalCost() {
        return this.cost.getTotalCost().floatValue();
    }

    public Collection<CloudInstanceTypeDescription> getAllTypes() {
        return this.typeManager.getAllTypes();
    }

    public Set<String> getAllInstanceTypeNames() {
        return this.typeManager.getAllTypeNames();
    }

    public CloudInstanceTypeDescription getInstanceType(String name) {
        return this.typeManager.getType(name);
    }

    public List<CloudInstanceTypeDescription> getCompatibleTypes(MethodResourceDescription requirements) {
        return this.typeManager.getCompatibleTypes(requirements);
    }

    public Collection<CloudImageDescription> getAllImages() {
        return this.imgManager.getAllImages();
    }

    public Set<String> getAllImageNames() {
        return this.imgManager.getAllImageNames();
    }

    public CloudImageDescription getImage(String name) {
        return this.imgManager.getImage(name);
    }

    public List<CloudImageDescription> getCompatibleImages(MethodResourceDescription requirements) {
        return this.imgManager.getCompatibleImages(requirements);
    }

    public Float getInstanceCostPerHour(CloudMethodResourceDescription instanceDescription) {
        return this.cost.getMachineCostPerHour(instanceDescription);
    }

    public int[][] getSimultaneousImpls(String type) {
        return this.typeManager.getSimultaneousImpls(type);
    }

    public boolean isAutomaticScalingEnabled() {
        return this.connector.isAutomaticScalingEnabled();
    }

    public long getNextCreationTime() throws Exception {
        return this.connector.getNextCreationTime();
    }

    public long getTimeSlot() throws Exception {
        return this.connector.getTimeSlot();
    }

    public List<ResourceCreationRequest> getPendingRequests() {
        return this.pendingRequests;
    }

    public int[] getPendingCoreCounts() {
        return this.pendingCoreCount;
    }

    public int getCurrentVMCount() {
        return this.currentVMCount;
    }

    public Set<CloudMethodWorker> getHostedWorkers() {
        return this.hostedWorkers;
    }

    public void stopReached() {
        this.connector.stopReached();
    }

    public void terminateAll() {
        this.currentVMCount = 0;
        this.hostedWorkers.clear();
        this.connector.terminateAll();
    }

    public ResourceCreationRequest requestResourceCreation(CloudMethodResourceDescription instanceDescription, ResourceCreationListener listener) {
        boolean isRequestAccepted;
        int[][] simultaneousCounts = this.computeSimultaneousCounts(instanceDescription);
        String requestID = "compss" + UUID.randomUUID().toString();
        ResourceCreationRequest rcr = new ResourceCreationRequest(instanceDescription, simultaneousCounts, this, requestID, listener);
        if (DEBUG) {
            LOGGER.debug("[Cloud Manager] Asking for resource creation with image " + instanceDescription.getImage().getImageName());
        }
        if (isRequestAccepted = this.connector.turnON(requestID, rcr)) {
            CloudMethodResourceDescription cmrd = rcr.getRequested();
            for (int[] typeCount : cmrd.getTypeComposition().values()) {
                this.currentVMCount += typeCount[0];
            }
            this.pendingRequests.add(rcr);
            int coreId = 0;
            while (coreId < simultaneousCounts.length) {
                int coreSlots = 0;
                for (int implId = 0; implId < simultaneousCounts[coreId].length; ++implId) {
                    coreSlots = Math.max(coreSlots, simultaneousCounts[coreId][implId]);
                }
                int n = coreId++;
                this.pendingCoreCount[n] = this.pendingCoreCount[n] + coreSlots;
            }
            return rcr;
        }
        LOGGER.warn(WARN_CANNOT_TURN_ON);
        return null;
    }

    private int[][] computeSimultaneousCounts(CloudMethodResourceDescription cloudDescription) {
        int coreCount = CoreManager.getCoreCount();
        int[][] simultaneousCounts = new int[coreCount][];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            int implCount = CoreManager.getNumberCoreImplementations(coreId);
            simultaneousCounts[coreId] = new int[implCount];
        }
        for (Map.Entry<CloudInstanceTypeDescription, int[]> typeEntry : cloudDescription.getTypeComposition().entrySet()) {
            CloudInstanceTypeDescription citd = typeEntry.getKey();
            int count = typeEntry.getValue()[0];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                for (int implId = 0; implId < simultaneousCounts[coreId].length; ++implId) {
                    int[] nArray = simultaneousCounts[coreId];
                    int n = implId;
                    nArray[n] = nArray[n] + citd.getSlotsImpl()[coreId][implId] * count;
                }
            }
        }
        return simultaneousCounts;
    }

    public void refusedCreation(ResourceCreationRequest rcr) {
        CloudMethodResourceDescription cmrd = rcr.getRequested();
        for (int[] typeCount : cmrd.getTypeComposition().values()) {
            this.currentVMCount -= typeCount[0];
        }
        this.pendingRequests.remove(rcr);
        int[][] simultaneousCounts = rcr.requestedSimultaneousTaskCount();
        int coreId = 0;
        while (coreId < simultaneousCounts.length) {
            int coreSlots = 0;
            for (int implId = 0; implId < simultaneousCounts[coreId].length; ++implId) {
                coreSlots = Math.max(coreSlots, simultaneousCounts[coreId][implId]);
            }
            int n = coreId++;
            this.pendingCoreCount[n] = this.pendingCoreCount[n] - coreSlots;
        }
    }

    public void confirmedCreation(ResourceCreationRequest rcr, CloudMethodWorker worker, CloudMethodResourceDescription granted) {
        CloudMethodResourceDescription cmrd = rcr.getRequested();
        for (int[] typeCount : cmrd.getTypeComposition().values()) {
            this.currentVMCount -= typeCount[0];
        }
        for (int[] typeCount : granted.getTypeComposition().values()) {
            this.currentVMCount += typeCount[0];
        }
        this.pendingRequests.remove(rcr);
        int[][] simultaneousCounts = rcr.requestedSimultaneousTaskCount();
        int coreId = 0;
        while (coreId < simultaneousCounts.length) {
            int coreSlots = 0;
            for (int implId = 0; implId < simultaneousCounts[coreId].length; ++implId) {
                coreSlots = Math.max(coreSlots, simultaneousCounts[coreId][implId]);
            }
            int n = coreId++;
            this.pendingCoreCount[n] = this.pendingCoreCount[n] - coreSlots;
        }
        this.hostedWorkers.add(worker);
    }

    public void requestResourceReduction(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        LOGGER.debug("[Cloud Manager] Destroying resource " + worker.getName() + " for reduction");
        Map<CloudInstanceTypeDescription, int[]> composition = reduction.getTypeComposition();
        for (int[] typeCount : composition.values()) {
            this.currentVMCount -= typeCount[0];
        }
        if (worker.getDescription().getTypeComposition().isEmpty()) {
            this.hostedWorkers.remove(worker);
        }
        this.connector.terminate(worker, reduction);
    }

    public CloudMethodWorker getHostedWorker(String name) {
        for (CloudMethodWorker vm : this.hostedWorkers) {
            if (!vm.getName().equals(name)) continue;
            return vm;
        }
        return null;
    }

    public boolean canHostMoreInstances() {
        if (this.limitOfVMs == null) {
            return true;
        }
        if (this.limitOfVMs == -1) {
            return true;
        }
        return this.currentVMCount < this.limitOfVMs;
    }

    public CloudMethodResourceDescription getResourceDescription(String instanceTypeName, String imageName) {
        CloudMethodResourceDescription result = null;
        CloudInstanceTypeDescription type = this.typeManager.getType(instanceTypeName);
        if (type != null) {
            CloudImageDescription image = this.imgManager.getImage(imageName);
            if (image != null) {
                result = new CloudMethodResourceDescription(type, image);
                result.setValue(this.cost.getMachineCostPerHour(result));
            } else {
                LOGGER.warn("WARN: Cannot find a containing/contained instanceType");
            }
        } else {
            LOGGER.warn("WARN: Cannot find a containing/contained instanceType");
        }
        return result;
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("PROVIDER = [").append("\n");
        sb.append(prefix).append("\t").append("NAME = ").append(this.name).append("\n");
        sb.append(prefix).append("\t").append("CURRENT_VM = ").append(this.currentVMCount).append("\n");
        sb.append(prefix).append("\t").append("LIMIT_VM = ").append(this.limitOfVMs).append("\n");
        sb.append(this.imgManager.getCurrentState(prefix + "\t"));
        sb.append(this.typeManager.getCurrentState(prefix + "\t"));
        sb.append(prefix).append("\t").append("VIRTUAL_INSTANCES = [").append("\n");
        for (CloudMethodWorker vm : this.hostedWorkers) {
            CloudMethodResourceDescription cmrd = vm.getDescription();
            sb.append(cmrd.getCurrentState(prefix + "\t")).append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

