/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.log;

import es.bsc.compss.util.ErrorManager;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class LoggerManager {
    private static boolean loggerAlreadyLoaded = false;
    private static final String ERROR_COMPSs_LOG_BASE_DIR = "ERROR: Cannot create .COMPSs base log directory";
    private static final String ERROR_APP_OVERLOAD = "ERROR: Cannot erase overloaded directory";
    private static final String ERROR_APP_LOG_DIR = "ERROR: Cannot create application log directory";
    private static final String WARN_FOLDER_OVERLOAD = "WARNING: Reached maximum number of executions for this application. To avoid this warning please clean .COMPSs folder";
    private static final int MAX_OVERLOAD = 100;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.API");
    private static String userExecutionDirPath;
    private static String compssLogBaseDirPath;
    private static String appLogDirPath;

    private LoggerManager() {
    }

    private static boolean deleteDirectory(File directory) {
        if (!directory.exists()) {
            return false;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    LoggerManager.deleteDirectory(f);
                    continue;
                }
                if (f.delete()) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static void init() {
        if (loggerAlreadyLoaded) {
            LOGGER.debug("LoggerManager already initialized, no need for a second initialization");
            return;
        }
        loggerAlreadyLoaded = true;
        userExecutionDirPath = System.getProperty("user.dir");
        boolean mustCreateExecutionSandbox = true;
        String specificOpt = System.getProperty("compss.specificLogDir");
        if (specificOpt != null && !specificOpt.isEmpty()) {
            compssLogBaseDirPath = specificOpt.endsWith(File.separator) ? specificOpt : specificOpt + File.separator;
            mustCreateExecutionSandbox = false;
        } else {
            String baseOpt = System.getProperty("compss.baseLogDir");
            if (baseOpt != null && !baseOpt.isEmpty()) {
                baseOpt = baseOpt.endsWith(File.separator) ? baseOpt : baseOpt + File.separator;
                compssLogBaseDirPath = baseOpt + ".COMPSs" + File.separator;
            } else {
                compssLogBaseDirPath = System.getProperty("user.home") + File.separator + ".COMPSs" + File.separator;
            }
        }
        if (!new File(compssLogBaseDirPath).exists() && !new File(compssLogBaseDirPath).mkdir()) {
            ErrorManager.error("ERROR: Cannot create .COMPSs base log directory at " + compssLogBaseDirPath);
        }
        if (mustCreateExecutionSandbox) {
            String appLog;
            String appName = System.getProperty("compss.serviceName") != null ? System.getProperty("compss.serviceName") : System.getProperty("compss.appName");
            int overloadCode = 1;
            String oldest = appLog = compssLogBaseDirPath + appName + "_0" + String.valueOf(overloadCode) + File.separator;
            while (new File(appLog).exists() && overloadCode <= 100) {
                if (new File(oldest).lastModified() > new File(appLog).lastModified()) {
                    oldest = appLog;
                }
                if (++overloadCode < 10) {
                    appLog = compssLogBaseDirPath + appName + "_0" + String.valueOf(overloadCode) + File.separator;
                    continue;
                }
                appLog = compssLogBaseDirPath + appName + "_" + String.valueOf(overloadCode) + File.separator;
            }
            if (overloadCode > 100) {
                appLog = oldest;
                System.err.println(WARN_FOLDER_OVERLOAD);
                System.err.println("Overwriting entry: " + appLog);
                if (!LoggerManager.deleteDirectory(new File(appLog))) {
                    ErrorManager.error(ERROR_APP_OVERLOAD);
                }
            }
            if (!new File(appLogDirPath = appLog).mkdir()) {
                ErrorManager.error(ERROR_APP_LOG_DIR);
            }
        } else {
            appLogDirPath = compssLogBaseDirPath;
        }
        System.setProperty("compss.appLogDir", appLogDirPath);
        ((LoggerContext)LogManager.getContext(false)).reconfigure();
    }

    public static void setUserExecutionDirPath(String userExecutionDirPath) {
        LOGGER.debug("User execution dir path: " + userExecutionDirPath);
        LoggerManager.userExecutionDirPath = userExecutionDirPath;
    }

    public static String getUserExecutionDirPath() {
        return userExecutionDirPath;
    }

    public static void setCompssLogBaseDirPath(String compssLogBaseDirPath) {
        LOGGER.debug("Compss log base dir path: " + compssLogBaseDirPath);
        LoggerManager.compssLogBaseDirPath = compssLogBaseDirPath;
    }

    public static String getCompssLogBaseDirPath() {
        return compssLogBaseDirPath;
    }

    public static void setAppLogDirPath(String appLogDirPath) {
        LOGGER.debug("App log dir path: " + appLogDirPath);
        LoggerManager.appLogDirPath = appLogDirPath;
    }

    public static String getAppLogDirPath() {
        return appLogDirPath;
    }
}

