/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors.utils;

import es.bsc.compss.connectors.AbstractConnector;
import es.bsc.compss.connectors.VM;
import es.bsc.compss.connectors.utils.DeletionThread;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeadlineThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors");
    private static final long MIN_DEADLINE_INTERVAL = 10000L;
    private static final long MAX_DEADLINE_INTERVAL = 60000L;
    private static final long DELETE_SAFETY_INTERVAL = 30000L;
    private static final long INITIAL_SLEEP_TIME = 1000L;
    private AbstractConnector ac;
    private boolean keepGoing;

    public DeadlineThread(AbstractConnector ac) {
        this.ac = ac;
        this.keepGoing = true;
    }

    public static long getMinDeadlineInterval() {
        return 10000L;
    }

    public static long getMaxDeadlineInterval() {
        return 60000L;
    }

    public static long getDeleteSafetyInterval() {
        return 30000L;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("[Abstract Connector] Connector " + this.ac.getProvider().getName() + " deadline");
        long sleepTime = 1000L;
        while (this.keepGoing) {
            try {
                LOGGER.debug("[Abstract Connector] Deadline thread sleeps " + sleepTime + " ms.");
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            sleepTime = this.getSleepTime();
            List<VM> vmsAlive = this.ac.getCopyOfAliveVms();
            if (vmsAlive.isEmpty()) {
                LOGGER.debug("[Abstract Connector] No VMs alive deadline sleep set to " + sleepTime + " ms.");
                continue;
            }
            LOGGER.debug("[Abstract Connector] VMs alive initial sleep set to " + sleepTime + " ms.");
            for (VM vmInfo : vmsAlive) {
                long timeLeft = this.timeLeft(vmInfo.getStartTime());
                if (timeLeft <= 30000L) {
                    if (!vmInfo.isToDelete()) continue;
                    LOGGER.info("[Abstract Connector] Deleting vm " + vmInfo.getName() + " because is marked to delete and it is on the safety delete interval");
                    this.ac.removeFromAliveVms(vmInfo);
                    this.ac.removeFromDeleteVms(vmInfo);
                    DeletionThread dt = new DeletionThread(this.ac, vmInfo);
                    dt.start();
                    continue;
                }
                if (sleepTime <= timeLeft - 30000L) continue;
                sleepTime = timeLeft - 30000L;
                LOGGER.debug("[Abstract Connector] Evaluating sleep time for " + vmInfo.getName() + " because an interval near to finish " + sleepTime + " ms.");
            }
        }
    }

    public void terminate() {
        this.keepGoing = false;
        this.interrupt();
    }

    private long getSleepTime() {
        long time = this.ac.getTimeSlot();
        if (time <= 0L) {
            return 10000L;
        }
        if ((time -= 30000L) > 60000L) {
            return 60000L;
        }
        return time;
    }

    private long timeLeft(long time) {
        long now = System.currentTimeMillis();
        long limit = this.ac.getTimeSlot();
        if (limit <= 0L) {
            return 0L;
        }
        long result = limit - (now - time) % limit;
        LOGGER.debug("Calculating sleep time at " + time + " now is " + now + ": remaining --> " + limit + " - " + (now - time) + " % " + limit + " = " + result + " ms to deadline");
        return result;
    }
}

