/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.parameter;

import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import java.util.Map;

public class DictCollectionParameter
extends DependencyParameter {
    private static final long serialVersionUID = 1L;
    private String dictCollectionId;
    private Map<Parameter, Parameter> parameters;

    public DictCollectionParameter(String dictCollectionId, Map<Parameter, Parameter> parameters, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename, ParameterMonitor monitor) {
        super(DataType.DICT_COLLECTION_T, direction, stream, prefix, name, contentType, weight, keepRename, monitor);
        this.parameters = parameters;
        this.dictCollectionId = dictCollectionId;
    }

    public String getDictCollectionId() {
        return this.dictCollectionId;
    }

    public void setDictCollectionId(String dictCollectionId) {
        this.dictCollectionId = dictCollectionId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DictCollectionParameter ").append(this.dictCollectionId).append("\n");
        sb.append("Name: ").append(this.getName()).append("\n");
        sb.append("Contents:\n");
        for (Map.Entry<Parameter, Parameter> entry : this.parameters.entrySet()) {
            sb.append("\t").append(entry.getKey()).append(" - ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public Map<Parameter, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<Parameter, Parameter> parameters) {
        this.parameters = parameters;
    }
}

