/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.exceptions.NoResourceAvailableException;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.project.ProjectFile;
import es.bsc.compss.types.project.exceptions.ProjectFileValidationException;
import es.bsc.compss.types.project.jaxb.ApplicationType;
import es.bsc.compss.types.project.jaxb.AttachedDiskType;
import es.bsc.compss.types.project.jaxb.AttachedDisksListType;
import es.bsc.compss.types.project.jaxb.CloudPropertiesType;
import es.bsc.compss.types.project.jaxb.CloudPropertyType;
import es.bsc.compss.types.project.jaxb.CloudType;
import es.bsc.compss.types.project.jaxb.DataNodeType;
import es.bsc.compss.types.project.jaxb.HttpType;
import es.bsc.compss.types.project.jaxb.ImagesType;
import es.bsc.compss.types.project.jaxb.InstanceTypeType;
import es.bsc.compss.types.project.jaxb.InstanceTypesType;
import es.bsc.compss.types.project.jaxb.MasterNodeType;
import es.bsc.compss.types.project.jaxb.MemoryType;
import es.bsc.compss.types.project.jaxb.OSType;
import es.bsc.compss.types.project.jaxb.PackageType;
import es.bsc.compss.types.project.jaxb.ProcessorPropertyType;
import es.bsc.compss.types.project.jaxb.ProcessorType;
import es.bsc.compss.types.project.jaxb.SoftwareListType;
import es.bsc.compss.types.project.jaxb.StorageType;
import es.bsc.compss.types.resources.DataResourceDescription;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.HTTPResourceDescription;
import es.bsc.compss.types.resources.HTTPWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.ResourcesFile;
import es.bsc.compss.types.resources.configuration.HTTPConfiguration;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.exceptions.ResourcesFileValidationException;
import es.bsc.compss.types.resources.jaxb.CloudProviderType;
import es.bsc.compss.types.resources.jaxb.ComputeNodeType;
import es.bsc.compss.types.resources.jaxb.EndpointType;
import es.bsc.compss.types.resources.jaxb.ImageType;
import es.bsc.compss.types.resources.jaxb.PriceType;
import es.bsc.compss.types.resources.jaxb.SharedDiskType;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.SharedDiskManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ResourceLoader {
    private static final int HTTP_CONNECTIONS = Integer.MAX_VALUE;
    private static String resources_XML;
    private static String resources_XSD;
    private static String project_XML;
    private static String project_XSD;
    private static ResourcesFile resources;
    private static ProjectFile project;
    private static final Logger LOGGER;

    public static void load(String resourcesXML, String resourcesXSD, String projectXML, String projectXSD) throws ResourcesFileValidationException, ProjectFileValidationException, NoResourceAvailableException {
        ResourceLoader.init(resourcesXML, resourcesXSD, projectXML, projectXSD);
        if (resources_XML != null && project_XML != null) {
            ResourceLoader.loadFiles();
            ResourceLoader.loadRuntime();
        } else {
            LOGGER.warn("No resource/project file detected. Starting runtime without computing resources.");
        }
    }

    private static void init(String resourcesXML, String resourcesXSD, String projectXML, String projectXSD) {
        LOGGER.info("ResourceLoader init");
        resources_XML = resourcesXML;
        resources_XSD = resourcesXSD;
        project_XML = projectXML;
        project_XSD = projectXSD;
    }

    private static void loadFiles() throws ResourcesFileValidationException, ProjectFileValidationException {
        LOGGER.info("ResourceLoader loading files");
        try {
            LOGGER.debug("ResourceLoader loading resources.xml");
            resources = new ResourcesFile(new File(resources_XML), resources_XSD, LOGGER);
        }
        catch (JAXBException | SAXException e) {
            throw new ResourcesFileValidationException(e);
        }
        try {
            LOGGER.debug("ResourceLoader loading project.xml");
            project = new ProjectFile(new File(project_XML), project_XSD, LOGGER);
        }
        catch (JAXBException | SAXException e) {
            throw new ProjectFileValidationException(e);
        }
    }

    private static void loadRuntime() throws NoResourceAvailableException {
        List<HttpType> https;
        CloudType cloudType;
        List<DataNodeType> dataNodes;
        LOGGER.info("ResourceLoader loading Runtime");
        boolean computeNodeExist = false;
        boolean httpResourceExists = false;
        boolean cloudProviderExist = false;
        MasterNodeType master = project.getMasterNode();
        boolean exist = ResourceLoader.loadMaster(master);
        computeNodeExist = computeNodeExist || exist;
        List<es.bsc.compss.types.project.jaxb.ComputeNodeType> computeNodes = project.getComputeNodes_list();
        if (computeNodes != null) {
            for (es.bsc.compss.types.project.jaxb.ComputeNodeType computeNodeType : computeNodes) {
                ComputeNodeType cnResources = resources.getComputeNode(computeNodeType.getName());
                if (cnResources != null) {
                    exist = ResourceLoader.loadComputeNode(computeNodeType, cnResources);
                    computeNodeExist = computeNodeExist || exist;
                    continue;
                }
                ErrorManager.warn("ComputeNode " + computeNodeType.getName() + " not defined in the resources file");
            }
        }
        if ((dataNodes = project.getDataNodes_list()) != null) {
            for (DataNodeType dnProject : dataNodes) {
                es.bsc.compss.types.resources.jaxb.DataNodeType dnResources = resources.getDataNode(dnProject.getName());
                if (dnResources != null) {
                    ResourceLoader.loadDataNode(dnProject, dnResources);
                    continue;
                }
                ErrorManager.warn("DataNode " + dnProject.getName() + " not defined in the resources file");
            }
        }
        if ((cloudType = project.getCloud()) != null) {
            cloudProviderExist = ResourceLoader.loadCloud(cloudType);
        }
        if ((https = project.getHttpServices_list()) != null) {
            for (HttpType hProject : https) {
                es.bsc.compss.types.resources.jaxb.HttpType hResources = resources.getHttpService(hProject.getBaseUrl());
                if (hResources != null) {
                    exist = ResourceLoader.loadHttpService(hProject, hResources);
                    httpResourceExists = httpResourceExists || exist;
                    continue;
                }
                ErrorManager.warn("No HTTP Service with URL '" + hProject.getBaseUrl() + "' is defined in the resources file");
            }
        }
        if (!(computeNodeExist || cloudProviderExist || httpResourceExists)) {
            throw new NoResourceAvailableException();
        }
    }

    private static boolean loadMaster(MasterNodeType master) {
        HashMap<String, String> sharedDisks = new HashMap<String, String>();
        List<Object> masterInformation = master.getProcessorOrMemoryOrStorage();
        MethodResourceDescription mrd = new MethodResourceDescription();
        if (masterInformation != null) {
            for (Object object : masterInformation) {
                if (object instanceof ProcessorType) {
                    ProcessorType procNode = (ProcessorType)object;
                    String procName = procNode.getName();
                    int computingUnits = project.getProcessorComputingUnits(procNode);
                    String architecture = project.getProcessorArchitecture(procNode);
                    float speed = project.getProcessorSpeed(procNode);
                    String type = project.getProcessorType(procNode);
                    float internalMemory = project.getProcessorMemorySize(procNode);
                    ProcessorPropertyType procProp = project.getProcessorProperty(procNode);
                    String propKey = procProp != null ? procProp.getKey() : "";
                    String propValue = procProp != null ? procProp.getValue() : "";
                    mrd.addProcessor(procName, computingUnits, architecture, speed, type, internalMemory, propKey, propValue);
                    continue;
                }
                if (object instanceof MemoryType) {
                    MemoryType memNode = (MemoryType)object;
                    mrd.setMemorySize(project.getMemorySize(memNode));
                    mrd.setMemoryType(project.getMemoryType(memNode));
                    continue;
                }
                if (object instanceof StorageType) {
                    StorageType strNode = (StorageType)object;
                    mrd.setStorageSize(project.getStorageSize(strNode));
                    mrd.setStorageType(project.getStorageType(strNode));
                    mrd.setStorageBW(project.getStorageBW(strNode));
                    continue;
                }
                if (object instanceof OSType) {
                    OSType osNode = (OSType)object;
                    mrd.setOperatingSystemType(project.getOperatingSystemType(osNode));
                    mrd.setOperatingSystemDistribution(project.getOperatingSystemDistribution(osNode));
                    mrd.setOperatingSystemVersion(project.getOperatingSystemVersion(osNode));
                    continue;
                }
                if (object instanceof SoftwareListType) {
                    SoftwareListType softwares = (SoftwareListType)object;
                    List<String> apps = softwares.getApplication();
                    if (apps == null) continue;
                    for (String appName : apps) {
                        mrd.addApplication(appName);
                    }
                    continue;
                }
                if (object instanceof AttachedDisksListType) {
                    List<AttachedDiskType> disksList;
                    AttachedDisksListType disks = (AttachedDisksListType)object;
                    if (disks == null || (disksList = disks.getAttachedDisk()) == null) continue;
                    for (AttachedDiskType disk : disksList) {
                        SharedDiskType diskResources = resources.getSharedDisk(disk.getName());
                        if (diskResources != null) {
                            String diskName = disk.getName();
                            String diskMountPoint = disk.getMountPoint();
                            sharedDisks.put(diskName, diskMountPoint);
                            continue;
                        }
                        ErrorManager.warn("SharedDisk " + disk.getName() + " defined in the master node is not defined in the resources.xml. Skipping");
                    }
                    continue;
                }
                if (object instanceof es.bsc.compss.types.project.jaxb.PriceType) continue;
                LOGGER.warn("MasterNode has an unrecognized parameter: " + object.getClass());
            }
        }
        ((DynamicMethodWorker)((Object)Comm.getAppHost())).increaseFeatures(mrd);
        Comm.getAppHost().updateDisks(sharedDisks);
        for (Map.Entry entry : sharedDisks.entrySet()) {
            SharedDiskManager.addSharedToMachine((String)entry.getKey(), (String)entry.getValue(), Comm.getAppHost());
        }
        if (mrd.getTotalCPUComputingUnits() > 0) {
            ResourceManager.addDynamicWorker((DynamicMethodWorker)((Object)Comm.getAppHost()), mrd);
            return true;
        }
        return false;
    }

    private static boolean loadComputeNode(es.bsc.compss.types.project.jaxb.ComputeNodeType cnProject, ComputeNodeType cnResources) {
        HashMap<String, String> sharedDisks;
        PriceType priceType;
        String name = cnProject.getName();
        MethodResourceDescription mrd = new MethodResourceDescription();
        List<es.bsc.compss.types.resources.jaxb.ProcessorType> processors = resources.getProcessors(cnResources);
        if (processors != null) {
            for (es.bsc.compss.types.resources.jaxb.ProcessorType processorType : processors) {
                String procName = processorType.getName();
                int computingUnits = resources.getProcessorComputingUnits(processorType);
                String architecture = resources.getProcessorArchitecture(processorType);
                float speed = resources.getProcessorSpeed(processorType);
                Iterator<String> type = resources.getProcessorType(processorType);
                float internalMemory = resources.getProcessorMemorySize(processorType);
                es.bsc.compss.types.resources.jaxb.ProcessorPropertyType procProp = resources.getProcessorProperty(processorType);
                String propKey = procProp != null ? procProp.getKey() : "";
                String propValue = procProp != null ? procProp.getValue() : "";
                mrd.addProcessor(procName, computingUnits, architecture, speed, (String)((Object)type), internalMemory, propKey, propValue);
            }
        }
        mrd.setMemorySize(resources.getMemorySize(cnResources));
        mrd.setMemoryType(resources.getMemoryType(cnResources));
        mrd.setStorageSize(resources.getStorageSize(cnResources));
        mrd.setStorageBW(resources.getStorageBW(cnResources));
        mrd.setStorageType(resources.getStorageType(cnResources));
        mrd.setOperatingSystemType(resources.getOperatingSystemType(cnResources));
        mrd.setOperatingSystemDistribution(resources.getOperatingSystemDistribution(cnResources));
        mrd.setOperatingSystemVersion(resources.getOperatingSystemVersion(cnResources));
        List<String> apps = resources.getApplications(cnResources);
        if (apps != null) {
            for (String appName : apps) {
                mrd.addApplication(appName);
            }
        }
        if ((priceType = resources.getPrice(cnResources)) != null) {
            mrd.setPriceTimeUnit(priceType.getTimeUnit());
            mrd.setPricePerUnit(priceType.getPricePerUnit());
        }
        if ((sharedDisks = resources.getSharedDisks(cnResources)) != null) {
            List<String> declaredSharedDisks = resources.getSharedDisks_names();
            for (String diskName : sharedDisks.keySet()) {
                if (declaredSharedDisks != null && declaredSharedDisks.contains(diskName)) continue;
                ErrorManager.warn("SharedDisk " + diskName + " defined in the ComputeNode " + name + " is not defined in the resources.xml. Skipping");
                sharedDisks.remove(diskName);
            }
        }
        String loadedAdaptor = System.getProperty("compss.comm");
        List<String> queuesProject = project.getAdaptorQueues(cnProject, loadedAdaptor);
        List<String> queuesResources = resources.getAdaptorQueues(cnResources, loadedAdaptor);
        if (queuesProject == null) {
            for (String queue : queuesResources) {
                mrd.addHostQueue(queue);
            }
        } else {
            for (String queue : queuesResources) {
                if (!queuesProject.contains(queue)) continue;
                mrd.addHostQueue(queue);
            }
        }
        Map<String, Object> adaptorPropertiesProject = project.getAdaptorProperties(cnProject, loadedAdaptor);
        Map<String, Object> adaptorPropertiesResources = resources.getAdaptorProperties(cnResources, loadedAdaptor);
        MethodConfiguration config = null;
        try {
            config = (MethodConfiguration)Comm.constructConfiguration(loadedAdaptor, adaptorPropertiesProject, adaptorPropertiesResources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn("Adaptor " + loadedAdaptor + " configuration constructor failed", cce);
            return false;
        }
        config.setHost(cnProject.getName());
        config.setUser(project.getUser(cnProject));
        config.setInstallDir(project.getInstallDir(cnProject));
        config.setWorkingDir(project.getWorkingDir(cnProject));
        int limitOfTasks = project.getLimitOfTasks(cnProject);
        if (limitOfTasks >= 0) {
            config.setLimitOfTasks(limitOfTasks);
        } else {
            config.setLimitOfTasks(mrd.getTotalCPUComputingUnits());
        }
        config.setTotalComputingUnits(mrd.getTotalCPUComputingUnits());
        config.setTotalGPUComputingUnits(mrd.getTotalGPUComputingUnits());
        config.setTotalFPGAComputingUnits(mrd.getTotalFPGAComputingUnits());
        config.setTotalOTHERComputingUnits(mrd.getTotalOTHERComputingUnits());
        ApplicationType app = project.getApplication(cnProject);
        if (app != null) {
            config.setAppDir(app.getAppDir());
            config.setLibraryPath(app.getLibraryPath());
            config.setClasspath(app.getClasspath());
            config.setPythonpath(app.getPythonpath());
            config.setEnvScript(app.getEnvironmentScript());
        }
        LOGGER.debug("Adding method worker " + name);
        MethodWorker methodWorker = ResourceLoader.createMethodWorker(name, mrd, sharedDisks, config);
        ResourceManager.addStaticResource(methodWorker);
        return true;
    }

    private static boolean loadHttpService(HttpType hProject, es.bsc.compss.types.resources.jaxb.HttpType hResources) {
        HashMap<String, Object> projectProperties = new HashMap<String, Object>();
        projectProperties.put("Http", hProject);
        HashMap<String, Object> resourcesProperties = new HashMap<String, Object>();
        resourcesProperties.put("Http", hResources);
        String httpAdaptorName = "es.bsc.compss.http.master.HTTPAdaptor";
        HTTPConfiguration config = null;
        try {
            config = (HTTPConfiguration)Comm.constructConfiguration(httpAdaptorName, projectProperties, resourcesProperties);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn("HTTP configuration constructor failed", cce);
            return false;
        }
        int limitOfTasks = hProject.getLimitOfTasks();
        if (limitOfTasks >= 0) {
            config.setLimitOfTasks(limitOfTasks);
        } else {
            config.setLimitOfTasks(Integer.MAX_VALUE);
        }
        LOGGER.debug("Adding http worker " + hProject.getBaseUrl());
        HTTPResourceDescription hrd = new HTTPResourceDescription(hResources.getServiceName(), Integer.MAX_VALUE);
        HTTPWorker newResource = new HTTPWorker(hProject.getBaseUrl(), hrd, config);
        ResourceManager.addStaticResource(newResource);
        return true;
    }

    private static MethodWorker createMethodWorker(String name, MethodResourceDescription rd, Map<String, String> sharedDisks, MethodConfiguration mc) {
        int taskCount = ResourceLoader.getValidMinimum(mc.getLimitOfTasks(), rd.getTotalCPUComputingUnits());
        mc.setLimitOfTasks(taskCount);
        int taskCountGPU = ResourceLoader.getValidMinimum(mc.getLimitOfGPUTasks(), rd.getTotalGPUComputingUnits());
        mc.setLimitOfGPUTasks(taskCountGPU);
        int taskCountFPGA = ResourceLoader.getValidMinimum(mc.getLimitOfFPGATasks(), rd.getTotalFPGAComputingUnits());
        mc.setLimitOfFPGATasks(taskCountFPGA);
        int taskCountOther = ResourceLoader.getValidMinimum(mc.getLimitOfOTHERsTasks(), rd.getTotalOTHERComputingUnits());
        mc.setLimitOfOTHERsTasks(taskCountOther);
        DynamicMethodWorker methodWorker = new DynamicMethodWorker(name, rd, mc, sharedDisks);
        return methodWorker;
    }

    private static int getValidMinimum(int x, int y) {
        if (x < 0 && y < 0) {
            return 0;
        }
        if (x < 0) {
            return y;
        }
        if (y < 0) {
            return x;
        }
        return Math.min(x, y);
    }

    private static boolean loadCloud(CloudType cloud) {
        Integer initialVMs = project.getInitialVMs(cloud);
        Integer minVMs = project.getMinVMs(cloud);
        Integer maxVMs = project.getMaxVMs(cloud);
        ResourceManager.setCloudVMsBoundaries(minVMs, initialVMs, maxVMs);
        boolean cloudEnabled = false;
        List<String> cpResources = resources.getCloudProviders_names();
        for (es.bsc.compss.types.project.jaxb.CloudProviderType cp : project.getCloudProviders_list()) {
            if (cpResources.contains(cp.getName())) {
                boolean isEnabled = ResourceLoader.loadCloudProvider(cp, resources.getCloudProvider(cp.getName()));
                cloudEnabled = cloudEnabled || isEnabled;
                continue;
            }
            ErrorManager.warn("CloudProvider " + cp.getName() + " not defined in resources.xml file. Skipping");
        }
        return cloudEnabled;
    }

    private static boolean loadCloudProvider(es.bsc.compss.types.project.jaxb.CloudProviderType cpProject, CloudProviderType cpResources) {
        CloudProvider provider;
        String cpName = cpProject.getName();
        String runtimeConnector = System.getProperty("compss.conn");
        String connectorJarPath = "";
        String connectorMainClass = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        EndpointType endpoint = cpResources.getEndpoint();
        connectorJarPath = resources.getConnectorJarPath(endpoint);
        connectorMainClass = resources.getConnectorMainClass(endpoint);
        properties.put("Server", resources.getServer(endpoint));
        properties.put("Port", resources.getPort(endpoint));
        List<Object> objList = cpProject.getImagesOrInstanceTypesOrLimitOfVMs();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudPropertiesType)) continue;
                CloudPropertiesType cloudProps = (CloudPropertiesType)obj;
                for (CloudPropertyType prop : cloudProps.getProperty()) {
                    properties.put(prop.getName(), prop.getValue());
                }
            }
        }
        String appName = System.getProperty("compss.appName");
        appName = appName.toLowerCase();
        appName = appName.replace('.', '-');
        properties.put("app-name", appName);
        int limitOfVMs = -1;
        int maxCreationTime = -1;
        LinkedList<CloudImageDescription> images = new LinkedList<CloudImageDescription>();
        LinkedList<CloudInstanceTypeDescription> instanceTypes = new LinkedList<CloudInstanceTypeDescription>();
        objList = cpProject.getImagesOrInstanceTypesOrLimitOfVMs();
        if (objList != null) {
            for (Object obj : objList) {
                if (obj instanceof ImagesType) {
                    ImagesType imageList = (ImagesType)obj;
                    for (es.bsc.compss.types.project.jaxb.ImageType imProject : imageList.getImage()) {
                        ImageType imResources;
                        CloudImageDescription cid = ResourceLoader.createImage(imProject, imResources = resources.getImage(cpResources, imProject.getName()), properties);
                        if (cid == null) continue;
                        images.add(cid);
                        int localCT = cid.getCreationTime();
                        if (localCT <= maxCreationTime) continue;
                        maxCreationTime = localCT;
                    }
                    continue;
                }
                if (obj instanceof InstanceTypesType) {
                    InstanceTypesType instancesList = (InstanceTypesType)obj;
                    for (InstanceTypeType instanceProject : instancesList.getInstanceType()) {
                        String instanceName = instanceProject.getName();
                        es.bsc.compss.types.resources.jaxb.InstanceTypeType instanceResources = resources.getInstance(cpResources, instanceName);
                        if (instanceResources != null) {
                            CloudInstanceTypeDescription cmrd = ResourceLoader.createInstance(instanceResources);
                            if (cmrd == null) continue;
                            instanceTypes.add(cmrd);
                            continue;
                        }
                        ErrorManager.warn("Instance " + instanceName + " not defined in resources.xml. Skipping");
                    }
                    continue;
                }
                if (!(obj instanceof Integer)) continue;
                limitOfVMs = (Integer)obj;
            }
        }
        if (maxCreationTime > 0) {
            properties.put("max-vm-creation-time", Integer.toString(maxCreationTime));
        }
        try {
            provider = ResourceManager.registerCloudProvider(cpName, limitOfVMs, runtimeConnector, connectorJarPath, connectorMainClass, properties);
        }
        catch (Exception e) {
            ErrorManager.warn("Exception loading CloudProvider " + cpName, e);
            return false;
        }
        for (CloudImageDescription cid : images) {
            provider.addCloudImage(cid);
        }
        for (CloudInstanceTypeDescription instance : instanceTypes) {
            provider.addInstanceType(instance);
        }
        return true;
    }

    private static CloudImageDescription createImage(es.bsc.compss.types.project.jaxb.ImageType imProject, ImageType imResources, Map<String, String> properties) {
        PriceType p;
        String imageName = imProject.getName();
        LOGGER.debug("Loading Image" + imageName);
        CloudImageDescription cid = new CloudImageDescription(imageName, properties);
        cid.setOperatingSystemType(resources.getOperatingSystemType(imResources));
        cid.setOperatingSystemDistribution(resources.getOperatingSystemDistribution(imResources));
        cid.setOperatingSystemVersion(resources.getOperatingSystemVersion(imResources));
        List<String> apps = resources.getApplications(imResources);
        if (apps != null) {
            for (String appName : apps) {
                cid.addApplication(appName);
            }
        }
        if ((p = resources.getPrice(imResources)) != null) {
            cid.setPriceTimeUnit(p.getTimeUnit());
            cid.setPricePerUnit(p.getPricePerUnit());
        }
        cid.setCreationTime(resources.getCreationTime(imResources));
        HashMap<String, String> sharedDisks = resources.getSharedDisks(imResources);
        if (sharedDisks != null) {
            List<String> declaredSharedDisks = resources.getSharedDisks_names();
            for (String diskName : sharedDisks.keySet()) {
                if (declaredSharedDisks != null && declaredSharedDisks.contains(diskName)) continue;
                ErrorManager.warn("SharedDisk " + diskName + " defined in the Image " + imageName + " is not defined in the resources.xml. Skipping");
                sharedDisks.remove(diskName);
            }
        }
        cid.setSharedDisks(sharedDisks);
        String loadedAdaptor = System.getProperty("compss.comm");
        List<String> queuesProject = project.getAdaptorQueues(imProject, loadedAdaptor);
        List<String> queuesResources = resources.getAdaptorQueues(imResources, loadedAdaptor);
        for (String queue : queuesResources) {
            if (!queuesProject.contains(queue)) continue;
            cid.addQueue(queue);
        }
        Map<String, Object> adaptorPropertiesProject = project.getAdaptorProperties(imProject, loadedAdaptor);
        Map<String, Object> adaptorPropertiesResources = resources.getAdaptorProperties(imResources, loadedAdaptor);
        MethodConfiguration config = null;
        try {
            config = (MethodConfiguration)Comm.constructConfiguration(loadedAdaptor, adaptorPropertiesProject, adaptorPropertiesResources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn("Adaptor configuration constructor failed", cce);
            return null;
        }
        config.setHost(imProject.getName());
        config.setUser(project.getUser(imProject));
        config.setInstallDir(project.getInstallDir(imProject));
        config.setWorkingDir(project.getWorkingDir(imProject));
        config.setLimitOfTasks(project.getLimitOfTasks(imProject));
        ApplicationType app = project.getApplication(imProject);
        if (app != null) {
            config.setAppDir(app.getAppDir());
            config.setLibraryPath(app.getLibraryPath());
            config.setClasspath(app.getClasspath());
            config.setPythonpath(app.getClasspath());
            config.setEnvScript(app.getEnvironmentScript());
        }
        List<PackageType> packages = project.getPackages(imProject);
        for (PackageType pack : packages) {
            cid.addPackage(pack.getSource(), pack.getTarget());
            SoftwareListType software = pack.getIncludedSoftware();
            if (software == null) continue;
            cid.addAllApplications(software.getApplication());
        }
        cid.setConfig(config);
        return cid;
    }

    private static CloudInstanceTypeDescription createInstance(es.bsc.compss.types.resources.jaxb.InstanceTypeType instance) {
        String type = instance.getName();
        MethodResourceDescription mrd = new MethodResourceDescription();
        List<es.bsc.compss.types.resources.jaxb.ProcessorType> processors = resources.getProcessors(instance);
        if (processors != null) {
            for (es.bsc.compss.types.resources.jaxb.ProcessorType p : processors) {
                String procName = p.getName();
                int computingUnits = resources.getProcessorComputingUnits(p);
                String architecture = resources.getProcessorArchitecture(p);
                float speed = resources.getProcessorSpeed(p);
                String procType = resources.getProcessorType(p);
                float internalMemory = resources.getProcessorMemorySize(p);
                es.bsc.compss.types.resources.jaxb.ProcessorPropertyType procProp = resources.getProcessorProperty(p);
                String propKey = procProp != null ? procProp.getKey() : "";
                String propValue = procProp != null ? procProp.getValue() : "";
                mrd.addProcessor(procName, computingUnits, architecture, speed, procType, internalMemory, propKey, propValue);
            }
        }
        mrd.setMemorySize(resources.getMemorySize(instance));
        mrd.setMemoryType(resources.getMemoryType(instance));
        mrd.setStorageSize(resources.getStorageSize(instance));
        mrd.setStorageType(resources.getStorageType(instance));
        mrd.setStorageBW(resources.getStorageBW(instance));
        PriceType p = resources.getPrice(instance);
        if (p != null) {
            mrd.setPriceTimeUnit(p.getTimeUnit());
            mrd.setPricePerUnit(p.getPricePerUnit());
        }
        return new CloudInstanceTypeDescription(type, mrd);
    }

    private static void loadDataNode(DataNodeType dnProject, es.bsc.compss.types.resources.jaxb.DataNodeType dnResources) {
        String host = resources.getHost(dnResources);
        String path = resources.getPath(dnResources);
        DataResourceDescription dd = new DataResourceDescription(host, path);
        dd.setStorageSize(resources.getStorageSize(dnResources));
        dd.setStorageType(resources.getStorageType(dnResources));
        dd.setStorageBW(resources.getStorageBW(dnResources));
        String name = dnProject.getName();
        LOGGER.warn("Cannot load DataNode " + name + ". DataNodes are not supported inside the Runtime");
    }

    static {
        LOGGER = LogManager.getLogger("es.bsc.compss.Components.ResourceManager");
    }
}

