/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.listener.TracingCopyListener;
import es.bsc.compss.types.data.listener.WorkersDebugInformationListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.transferable.SafeCopyTransferable;
import es.bsc.compss.types.data.transferable.TracingCopyTransferable;
import es.bsc.compss.types.data.transferable.WorkersDebugInfoCopyTransferable;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.ResourcesPool;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.SharedDiskManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ResourceImpl
implements Comparable<Resource>,
Resource,
NodeMonitor {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final boolean CACHE_PROFILING_ENABLED = Boolean.parseBoolean(System.getProperty("compss.python.cache_profiler"));
    protected final String name;
    private final COMPSsNode node;
    protected Map<String, String> sharedDisks;
    private final List<LogicalData> obsoletes = new LinkedList<LogicalData>();
    private final Set<LogicalData> privateFiles = new HashSet<LogicalData>();
    private boolean isLost = false;

    public ResourceImpl(String name, Configuration conf, Map<String, String> sharedDisks) {
        this.name = name;
        this.node = Comm.initWorker(conf, this);
        this.sharedDisks = sharedDisks;
        SharedDiskManager.addMachine(this);
        ResourcesPool.add(this);
    }

    public ResourceImpl(COMPSsNode node, Map<String, String> sharedDisks) {
        this.name = node.getName();
        this.node = node;
        node.setMonitor(this);
        this.sharedDisks = sharedDisks;
        SharedDiskManager.addMachine(this);
        ResourcesPool.add(this);
    }

    public ResourceImpl(ResourceImpl clone) {
        this.name = clone.name;
        this.node = clone.node;
        ResourcesPool.add(this);
    }

    @Override
    public void start() throws InitNodeException {
        this.node.start();
        if (this.sharedDisks != null) {
            for (Map.Entry<String, String> disk : this.sharedDisks.entrySet()) {
                SharedDiskManager.addSharedToMachine(disk.getKey(), disk.getValue(), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalData> getAllDataFromHost() {
        HashSet<LogicalData> data = new HashSet<LogicalData>();
        List<String> sharedDisks = SharedDiskManager.getAllSharedNames(this);
        for (String diskName : sharedDisks) {
            Set<LogicalData> sharedData = SharedDiskManager.getAllSharedFiles(diskName);
            if (sharedData == null) continue;
            Set<LogicalData> set = sharedData;
            synchronized (set) {
                data.addAll(sharedData);
            }
        }
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            data.addAll(this.privateFiles);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogicalData(LogicalData ld) {
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            this.privateFiles.add(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogicalData(LogicalData ld) {
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            this.privateFiles.remove(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addObsolete(LogicalData obsolete) {
        if (this.getType() == ResourceType.WORKER) {
            List<LogicalData> list = this.obsoletes;
            synchronized (list) {
                this.obsoletes.add(obsolete);
            }
        }
        this.removeLogicalData(obsolete);
        List<String> sharedDisks = SharedDiskManager.getAllSharedNames(this);
        for (String diskName : sharedDisks) {
            SharedDiskManager.removeLogicalData(diskName, obsolete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<MultiURI> pollObsoletes() {
        LogicalData[] obs = null;
        List<LogicalData> list = this.obsoletes;
        synchronized (list) {
            obs = this.obsoletes.toArray(new LogicalData[this.obsoletes.size()]);
            this.obsoletes.clear();
        }
        LinkedList<MultiURI> obsoleteRenamings = new LinkedList<MultiURI>();
        for (LogicalData ld : obs) {
            for (MultiURI u : ld.getURIsInHost(this)) {
                if (u == null) continue;
                obsoleteRenamings.add(u);
            }
        }
        return obsoleteRenamings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearObsoletes() {
        List<LogicalData> list = this.obsoletes;
        synchronized (list) {
            this.obsoletes.clear();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public COMPSsNode getNode() {
        return this.node;
    }

    @Override
    public void setInternalURI(MultiURI u) throws UnstartedNodeException {
        this.node.setInternalURI(u);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return this.node.newJob(taskId, taskParams, impl, this, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    @Override
    public void getData(LogicalData srcData, Transferable reason, EventListener listener) {
        this.getData(srcData, srcData.getName(), srcData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, String newName, Transferable reason, EventListener listener) {
        this.getData(srcData, newName, srcData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, DataLocation target, Transferable reason, EventListener listener) {
        this.getData(srcData, target, srcData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, LogicalData tgtData, Transferable reason, EventListener listener) {
        this.getData(srcData, srcData.getName(), tgtData, reason, listener);
    }

    @Override
    public void getData(LogicalData ld, String newName, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (reason.getType() == DataType.BINDING_OBJECT_T) {
            BindingObject bo;
            if (ld.getValue() == null) {
                LOGGER.warn("[Resource] Getting data: " + newName + ", source logical data value is null. Trying with data target from reason ");
                bo = BindingObject.generate(reason.getDataTarget());
                newName = newName + "#" + bo.getType() + "#" + bo.getElements();
            } else {
                bo = BindingObject.generate((String)ld.getValue());
                newName = newName + "#" + bo.getType() + "#" + bo.getElements();
            }
        }
        DataLocation target = this.node.getTargetLocation(this, reason.getType(), newName);
        this.getData(ld, target, tgtData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        this.node.obtainData(srcData, null, target, tgtData, reason, listener);
    }

    @Override
    public void enforceDataObtaning(Transferable t, EventListener listener) {
        this.node.enforceDataObtaining(t, listener);
    }

    @Override
    public SimpleURI getCompleteRemotePath(DataType type, String name) {
        return this.node.getCompletePath(type, name);
    }

    public String getOutputDataTargetPath(String tgtName, DependencyParameter param) {
        return this.node.getOutputDataTarget(tgtName, param);
    }

    @Override
    public void retrieveUniqueDataValues() {
        if (this.isLost) {
            return;
        }
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        if (this.getNode().compareTo(masterNode) == 0) {
            if (DEBUG) {
                LOGGER.debug("The resource is part of the master process. No need to retrieve any data value.");
            }
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Retrieving data resource " + this.getName());
        }
        Semaphore sem = new Semaphore(0);
        SafeCopyListener listener = new SafeCopyListener(sem);
        Set<LogicalData> lds = this.getAllDataFromHost();
        Map<String, String> disks = SharedDiskManager.terminate(this);
        for (LogicalData ld : lds) {
            DataLocation lastLoc;
            if (ld.getCopiesInProgress().size() > 0) {
                ld.notifyToInProgressCopiesEnd(listener);
            }
            if ((lastLoc = ld.removeHostAndCheckLocationToSave(this, disks)) == null) continue;
            listener.addOperation();
            DataLocation safeLoc = null;
            String safePath = null;
            boolean isBindingData = false;
            if (lastLoc.getType().equals((Object)LocationType.BINDING)) {
                BindingObject bo = BindingObject.generate(lastLoc.getPath());
                safePath = ProtocolType.BINDING_URI.getSchema() + Comm.getAppHost().getWorkingDirectory() + ld.getName() + "#" + bo.getType() + "#" + bo.getElements();
            } else {
                safePath = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getWorkingDirectory() + ld.getName();
            }
            try {
                SimpleURI uri = new SimpleURI(safePath);
                safeLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + safePath, e);
            }
            if (isBindingData) {
                masterNode.obtainData(ld, lastLoc, safeLoc, ld, new SafeCopyTransferable(DataType.BINDING_OBJECT_T), listener);
                continue;
            }
            masterNode.obtainData(ld, lastLoc, safeLoc, ld, new SafeCopyTransferable(), listener);
        }
        if (DEBUG) {
            LOGGER.debug("Waiting for finishing saving copies for " + this.getName());
        }
        if (listener.getOperations() > 0) {
            listener.enable();
            try {
                sem.acquire();
            }
            catch (InterruptedException ex) {
                LOGGER.error("Error waiting for files in resource " + this.getName() + " to get saved");
            }
        }
        if (DEBUG) {
            LOGGER.debug("Unique files saved for " + this.getName());
        }
    }

    @Override
    public void retrieveTracingAndDebugData() {
        if (this.isLost) {
            LOGGER.debug(" Will not retrieve Tracing and Debug Data because the node: " + this.getName() + " is lost.");
            return;
        }
        if (Tracer.isActivated() && this.node.generatePackage()) {
            this.getTracingPackageToMaster();
            if (DEBUG) {
                LOGGER.debug("Tracing package obtained for " + this.getName());
            }
        }
        if (DEBUG && this.node.generateWorkersDebugInfo()) {
            this.getWorkersDebugInfo();
            LOGGER.debug("Workers Debug files obtained for " + this.getName());
            this.getBindingWorkersDebugInfo();
            LOGGER.debug("Binding Workers Debug files obtained for " + this.getName());
        }
        if (CACHE_PROFILING_ENABLED) {
            this.getCacheProfilerDebugInfo();
            LOGGER.debug("Cache Profiler Debug files obtained for " + this.getName());
        }
    }

    @Override
    public void deleteIntermediate() {
        this.node.deleteTemporary();
    }

    @Override
    public void disableExecution() {
        if (this.isLost) {
            LOGGER.debug(" Skipping ExecutionManager shutdown because the node: " + this.getName() + " is lost.");
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Shutting down Execution Manager on Resource " + this.getName());
        }
        Semaphore sem = new Semaphore(0);
        ExecutorShutdownListener executorShutdownListener = new ExecutorShutdownListener(sem);
        executorShutdownListener.addOperation();
        this.node.shutdownExecutionManager(executorShutdownListener);
        executorShutdownListener.enable();
        if (DEBUG) {
            LOGGER.debug("Waiting for shutting down the execution manager of " + this.getName());
        }
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for execution manager in resource " + this.getName() + " to stop");
        }
        if (DEBUG) {
            LOGGER.debug("Execution manager of " + this.getName() + " stopped");
        }
    }

    @Override
    public void stop(ShutdownListener sl) {
        if (this.isLost) {
            LOGGER.debug(" Skipping StopWorker because the node: " + this.getName() + " is lost.");
            sl.addOperation();
            sl.notifyEnd();
            return;
        }
        this.deleteIntermediate();
        sl.addOperation();
        this.node.stop(sl);
    }

    private void getTracingPackageToMaster() {
        DataLocation tgt;
        DataLocation source;
        Semaphore sem = new Semaphore(0);
        String fileName = this.getName() + "_compss_trace.tar.gz";
        SimpleURI fileOriginURI = this.node.getCompletePath(DataType.FILE_T, fileName);
        if (DEBUG) {
            LOGGER.debug("Copying tracing package from : " + fileOriginURI.getPath() + ",to : " + Tracer.getExtraeOutputDir() + File.separator + fileName);
        }
        TracingCopyListener tracingListener = new TracingCopyListener(sem);
        tracingListener.addOperation();
        try {
            source = DataLocation.createLocation(this, fileOriginURI);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + fileOriginURI.getPath(), e);
            return;
        }
        String targetPath = ProtocolType.FILE_URI.getSchema() + Tracer.getExtraeOutputDir() + File.separator + fileName;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            tgt = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + targetPath);
            return;
        }
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        masterNode.obtainData(new LogicalData("tracing" + this.getName()), source, tgt, new LogicalData("tracing" + this.getName()), new TracingCopyTransferable(), tracingListener);
        tracingListener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for tracing files in resource " + this.getName() + " to get saved");
        }
        if (DEBUG) {
            LOGGER.debug("Removing " + this.getName() + " tracing temporary files");
        }
        File f = null;
        try {
            f = new File(source.getPath());
            if (!f.delete()) {
                LOGGER.error("Unable to remove tracing temporary files of node " + this.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to remove tracing temporary files of node " + this.getName(), (Throwable)e);
        }
    }

    private void getWorkersDebugInfo() {
        if (DEBUG) {
            LOGGER.debug("Copying Workers Information");
        }
        Semaphore sem = new Semaphore(0);
        WorkersDebugInformationListener wdil = new WorkersDebugInformationListener(sem);
        wdil.addOperation();
        String outFileName = "worker_" + this.getName() + ".out";
        SimpleURI outFileOrigin = this.node.getCompletePath(DataType.FILE_T, "log" + File.separator + "static_" + outFileName);
        String outFileTarget = ProtocolType.FILE_URI.getSchema() + LoggerManager.getWorkersLogDir() + outFileName;
        DataLocation outSource = null;
        try {
            outSource = DataLocation.createLocation(this, outFileOrigin);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + outFileOrigin.toString(), e);
        }
        DataLocation outTarget = null;
        try {
            SimpleURI uri = new SimpleURI(outFileTarget);
            outTarget = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + outFileTarget);
        }
        LOGGER.debug("- Source: " + outFileOrigin);
        LOGGER.debug("- Target: " + outFileTarget);
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        masterNode.obtainData(new LogicalData("workerOut" + this.getName()), outSource, outTarget, new LogicalData("workerOut" + this.getName()), new WorkersDebugInfoCopyTransferable(), wdil);
        wdil.addOperation();
        String errFileName = "worker_" + this.getName() + ".err";
        SimpleURI errFileOrigin = this.node.getCompletePath(DataType.FILE_T, "log" + File.separator + "static_" + errFileName);
        String errFileTarget = ProtocolType.FILE_URI.getSchema() + LoggerManager.getWorkersLogDir() + errFileName;
        DataLocation errSource = null;
        try {
            errSource = DataLocation.createLocation(this, errFileOrigin);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + errFileOrigin.toString(), e);
        }
        DataLocation errTarget = null;
        try {
            SimpleURI uri = new SimpleURI(errFileTarget);
            errTarget = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + errFileTarget);
        }
        LOGGER.debug("- Source: " + errFileOrigin);
        LOGGER.debug("- Target: " + errFileTarget);
        masterNode.obtainData(new LogicalData("workerErr" + this.getName()), errSource, errTarget, new LogicalData("workerErr" + this.getName()), new WorkersDebugInfoCopyTransferable(), wdil);
        wdil.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for worker debug files in resource " + this.getName() + " to get saved");
        }
        LOGGER.debug("Worker files from resource " + this.getName() + "received");
    }

    private void getBindingWorkersDebugInfo() {
        if (DEBUG) {
            LOGGER.debug("Copying Binding Workers Information");
        }
        Semaphore sem = new Semaphore(0);
        WorkersDebugInformationListener wdil = new WorkersDebugInformationListener(sem);
        wdil.addOperation();
        String outFileNameOriginal = "log/binding_worker.out";
        String outFileName = "binding_worker_" + this.getName() + ".out";
        SimpleURI outFileOrigin = this.node.getCompletePath(DataType.FILE_T, outFileNameOriginal);
        String outFileTarget = ProtocolType.FILE_URI.getSchema() + LoggerManager.getWorkersLogDir() + outFileName;
        DataLocation outSource = null;
        try {
            outSource = DataLocation.createLocation(this, outFileOrigin);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + outFileOrigin.toString(), e);
        }
        DataLocation outTarget = null;
        try {
            SimpleURI uri = new SimpleURI(outFileTarget);
            outTarget = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + outFileTarget);
        }
        LOGGER.debug("- Source: " + outFileOrigin);
        LOGGER.debug("- Target: " + outFileTarget);
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        masterNode.obtainData(new LogicalData("bindingWorkerOut" + this.getName()), outSource, outTarget, new LogicalData("bindingWorkerOut" + this.getName()), new WorkersDebugInfoCopyTransferable(), wdil);
        wdil.addOperation();
        String errFileNameOriginal = "log/binding_worker.err";
        String errFileName = "binding_worker_" + this.getName() + ".err";
        SimpleURI errFileOrigin = this.node.getCompletePath(DataType.FILE_T, errFileNameOriginal);
        String errFileTarget = ProtocolType.FILE_URI.getSchema() + LoggerManager.getWorkersLogDir() + errFileName;
        DataLocation errSource = null;
        try {
            errSource = DataLocation.createLocation(this, errFileOrigin);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + errFileOrigin.toString(), e);
        }
        DataLocation errTarget = null;
        try {
            SimpleURI uri = new SimpleURI(errFileTarget);
            errTarget = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + errFileTarget);
        }
        LOGGER.debug("- Source: " + errFileOrigin);
        LOGGER.debug("- Target: " + errFileTarget);
        masterNode.obtainData(new LogicalData("bindingWorkerErr" + this.getName()), errSource, errTarget, new LogicalData("bindingWorkerErr" + this.getName()), new WorkersDebugInfoCopyTransferable(), wdil);
        wdil.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for worker debug files in resource " + this.getName() + " to get saved");
        }
        LOGGER.debug("Worker files from resource " + this.getName() + "received");
    }

    private void getCacheProfilerDebugInfo() {
        if (DEBUG) {
            LOGGER.debug("Copying Cache Profiler Workers Information");
        }
        Semaphore sem = new Semaphore(0);
        WorkersDebugInformationListener wdil = new WorkersDebugInformationListener(sem);
        wdil.addOperation();
        String cacheProfiler = "cache_profiler.json";
        String outCacheProfiler = "cache_profiler_" + this.getName() + ".json";
        SimpleURI cacheProfilerOutFileOrigin = this.node.getCompletePath(DataType.FILE_T, cacheProfiler);
        String cacheProfilerOutFileTarget = ProtocolType.FILE_URI.getSchema() + LoggerManager.getWorkersLogDir() + outCacheProfiler;
        DataLocation cacheProfilerOutSource = null;
        try {
            cacheProfilerOutSource = DataLocation.createLocation(this, cacheProfilerOutFileOrigin);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + cacheProfilerOutFileOrigin.toString(), e);
        }
        DataLocation cacheProfilerOutTarget = null;
        try {
            SimpleURI uriCacheProfiler = new SimpleURI(cacheProfilerOutFileTarget);
            cacheProfilerOutTarget = DataLocation.createLocation(Comm.getAppHost(), uriCacheProfiler);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + cacheProfilerOutFileTarget);
        }
        LOGGER.debug("- Cache Source: " + cacheProfilerOutSource);
        LOGGER.debug("- Cache Target: " + cacheProfilerOutTarget);
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        masterNode.obtainData(new LogicalData("cache_profiler.json"), cacheProfilerOutSource, cacheProfilerOutTarget, new LogicalData("cache_profiler.json"), new WorkersDebugInfoCopyTransferable(), wdil);
        wdil.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for cache profiler debug files in resource " + this.getName() + " to get saved");
        }
        LOGGER.debug("Cache profiler files from resource " + this.getName() + " received");
    }

    @Override
    public void idleReservedResourcesDetected(ResourceDescription resources) {
    }

    @Override
    public void reactivatedReservedResourcesDetected(ResourceDescription resources) {
    }

    public boolean isLost() {
        return this.isLost;
    }

    @Override
    public void lostNode() {
        this.isLost = true;
        ResourceManager.notifyRestart(this.name);
    }

    public void startingNode() {
        this.isLost = false;
    }
}

