/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.parameter;

import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import java.io.Serializable;

public abstract class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataType type;
    private final Direction direction;
    private final StdIOStream stream;
    private final String prefix;
    private final String name;
    private final String contentType;
    private final double weight;
    private final boolean keepRename;
    private final ParameterMonitor monitor;

    public Parameter(DataType type, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename, ParameterMonitor monitor) {
        this.type = type;
        this.direction = direction;
        this.stream = stream;
        this.prefix = prefix == null || prefix.isEmpty() ? "null" : prefix;
        this.name = name;
        this.contentType = contentType;
        this.weight = weight;
        this.keepRename = keepRename;
        this.monitor = monitor;
    }

    public abstract boolean isPotentialDependency();

    public abstract boolean isCollective();

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public StdIOStream getStream() {
        return this.stream;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isKeepRename() {
        return this.keepRename;
    }

    public ParameterMonitor getMonitor() {
        return this.monitor;
    }
}

