/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.execution.utils;

import es.bsc.compss.binders.BindToMap;
import es.bsc.compss.binders.BindToResource;
import es.bsc.compss.binders.Unbinded;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.types.execution.ThreadBinder;
import es.bsc.compss.types.execution.exceptions.InvalidMapException;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableResourcesException;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ExecManager");
    private final List<PendingRequest> pendingRequests;
    private final ThreadBinder binderCPUs;
    private final ThreadBinder binderGPUs;
    private final ThreadBinder binderFPGAs;

    public ResourceManager(int cusCPU, String cpuMap, int cusGPU, String gpuMap, int cusFPGA, String fpgaMap) throws InvalidMapException {
        ThreadBinder binderFPGAsTmp;
        ThreadBinder binderGPUsTmp;
        ThreadBinder binderCPUsTmp;
        LOGGER.debug("Instantiate CPU Binder with " + cusCPU + " CUs");
        try {
            switch (cpuMap) {
                case "disabled": {
                    binderCPUsTmp = new Unbinded();
                    break;
                }
                case "automatic": {
                    String resourceMap = BindToMap.getResourceCpuDescription();
                    binderCPUsTmp = new BindToMap(cusCPU, resourceMap);
                    break;
                }
                default: {
                    binderCPUsTmp = new BindToMap(cusCPU, cpuMap);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not load the desidered mapping policy for the CPU computing units. Using default policy (automatic)");
            String resourceMap = BindToMap.getResourceCpuDescription();
            binderCPUsTmp = new BindToMap(cusCPU, resourceMap);
        }
        this.binderCPUs = binderCPUsTmp;
        LOGGER.debug("Instantiate GPU Binder with " + cusGPU + " CUs");
        try {
            switch (gpuMap) {
                case "disabled": {
                    binderGPUsTmp = new Unbinded();
                    break;
                }
                case "automatic": {
                    binderGPUsTmp = new BindToResource(cusGPU);
                    break;
                }
                default: {
                    binderGPUsTmp = new BindToMap(cusGPU, gpuMap);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not load the desidered mapping policy for the GPU computing units. Using default policy (automatic)");
            binderGPUsTmp = new BindToResource(cusGPU);
        }
        this.binderGPUs = binderGPUsTmp;
        LOGGER.debug("Instantiate FPGA Binder with " + cusFPGA + " CUs");
        try {
            switch (fpgaMap) {
                case "disabled": {
                    binderFPGAsTmp = new Unbinded();
                    break;
                }
                case "automatic": {
                    binderFPGAsTmp = new BindToResource(cusFPGA);
                    break;
                }
                default: {
                    binderFPGAsTmp = new BindToMap(cusFPGA, fpgaMap);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not load the desidered mapping policy for the FPGA computing units. Using default policy (automatic)");
            binderFPGAsTmp = new BindToResource(cusFPGA);
        }
        this.binderFPGAs = binderFPGAsTmp;
        this.pendingRequests = new LinkedList<PendingRequest>();
    }

    public synchronized InvocationResources acquireResources(int jobId, ResourceDescription rd, InvocationResources preferredAllocation) throws UnsufficientAvailableResourcesException {
        int fpgas;
        int gpus;
        int cpus;
        try {
            MethodResourceDescription mrd = (MethodResourceDescription)rd;
            cpus = mrd.getTotalCPUComputingUnits();
            gpus = mrd.getTotalGPUComputingUnits();
            fpgas = mrd.getTotalFPGAComputingUnits();
        }
        catch (ClassCastException e) {
            cpus = 0;
            gpus = 0;
            fpgas = 0;
        }
        int[] preferredCPUs = null;
        int[] preferredGPUs = null;
        int[] preferredFPGAs = null;
        if (preferredAllocation != null) {
            preferredCPUs = preferredAllocation.getAssignedCPUs();
            preferredGPUs = preferredAllocation.getAssignedGPUs();
            preferredFPGAs = preferredAllocation.getAssignedFPGAs();
        }
        int[] assignedCPUs = null;
        int[] assignedGPUs = null;
        int[] assignedFPGAs = null;
        try {
            assignedCPUs = this.binderCPUs.bindComputingUnits(jobId, cpus, preferredCPUs);
            assignedGPUs = this.binderGPUs.bindComputingUnits(jobId, gpus, preferredGPUs);
            assignedFPGAs = this.binderFPGAs.bindComputingUnits(jobId, fpgas, preferredFPGAs);
        }
        catch (UnsufficientAvailableResourcesException uare) {
            if (assignedCPUs != null) {
                this.binderCPUs.releaseComputingUnits(jobId);
                if (assignedGPUs != null) {
                    this.binderCPUs.releaseComputingUnits(jobId);
                }
            }
            throw uare;
        }
        return new InvocationResources(assignedCPUs, assignedGPUs, assignedFPGAs);
    }

    public synchronized void reacquireResources(int jobId, ResourceDescription rd, InvocationResources allocatedResources, Semaphore sem) {
        try {
            InvocationResources newResources = this.acquireResources(jobId, rd, allocatedResources);
            allocatedResources.reconfigure(newResources);
            sem.release();
        }
        catch (UnsufficientAvailableResourcesException uare) {
            PendingRequest p = new PendingRequest(jobId, rd, allocatedResources, sem);
            this.pendingRequests.add(p);
        }
    }

    public synchronized void releaseResources(int jobId) {
        this.binderCPUs.releaseComputingUnits(jobId);
        this.binderGPUs.releaseComputingUnits(jobId);
        this.binderFPGAs.releaseComputingUnits(jobId);
        Iterator<PendingRequest> iter = this.pendingRequests.iterator();
        while (iter.hasNext()) {
            PendingRequest req = iter.next();
            int reqJobId = req.jobId;
            ResourceDescription reqRequirments = req.requirements;
            InvocationResources reqAllocation = req.allocation;
            try {
                InvocationResources newResources = this.acquireResources(reqJobId, reqRequirments, reqAllocation);
                reqAllocation.reconfigure(newResources);
                req.sem.release();
                iter.remove();
            }
            catch (UnsufficientAvailableResourcesException unsufficientAvailableResourcesException) {}
        }
    }

    private static class PendingRequest {
        private final int jobId;
        private final ResourceDescription requirements;
        private final InvocationResources allocation;
        private final Semaphore sem;

        public PendingRequest(int jobId, ResourceDescription requirements, InvocationResources allocation, Semaphore sem) {
            this.jobId = jobId;
            this.requirements = requirements;
            this.allocation = allocation;
            this.sem = sem;
        }
    }
}

