/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.persistent;

import es.bsc.compss.execution.types.ExecutorContext;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.external.persistent.PersistentMirror;
import es.bsc.compss.executor.types.ExternalTaskStatus;
import es.bsc.compss.executor.types.ParameterResult;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import java.util.Iterator;
import java.util.List;

public abstract class PersistentInvoker
extends ExternalInvoker {
    public PersistentInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandbox, assignedResources);
        super.appendOtherExecutionCommandArguments();
    }

    @Override
    protected void invokeExternalMethod() throws JobExecutionException {
        ExternalTaskStatus taskStatus;
        Integer exitValue;
        int jobId = this.invocation.getJobId();
        String taskCMD = this.command.getAsString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing in binding: " + taskCMD);
        }
        String result = PersistentInvoker.executeInBinding(taskCMD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result: " + result);
        }
        if ((exitValue = (taskStatus = new ExternalTaskStatus(result.split(" "))).getExitValue()) != 0) {
            throw new JobExecutionException("Job " + jobId + " has failed. Exit values is " + exitValue);
        }
        LOGGER.debug("Updating parameters for job " + jobId);
        List<ParameterResult> results = taskStatus.getResults();
        Iterator<? extends InvocationParam> cip = this.invocation.getParams().iterator();
        Iterator cr = results.iterator();
        while (cr.hasNext()) {
            this.updateParam(cip.next(), (ParameterResult)cr.next());
        }
        LOGGER.debug("Job " + jobId + " has finished with exit value 0");
    }

    private void updateParam(InvocationParam param, ParameterResult result) {
        DataType resultType;
        if (param.isCollective()) {
            Iterator cip = ((InvocationParamCollection)param).getCollectionParameters().iterator();
            Iterator<ParameterResult> cr = ((ParameterResult.CollectiveResult)((Object)param)).getElements().iterator();
            while (cip.hasNext()) {
                this.updateParam((InvocationParam)cip.next(), cr.next());
            }
        }
        if ((resultType = result.getType()) != null && resultType == DataType.EXTERNAL_PSCO_T) {
            param.setType(resultType);
            param.setValue(((ParameterResult.SingleResult)result).getValue());
        }
    }

    public static native String executeInBinding(String var0);

    public static native void initThread();

    public static native void finishThread();

    public static PersistentMirror getMirror(InvocationContext context, ExecutorContext platform) {
        int threads = platform.getSize();
        return new PersistentMirror(context, threads);
    }

    static {
        System.loadLibrary("bindings_common");
    }
}

