/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.parameter;

import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import java.util.Iterator;
import java.util.List;

public class CollectiveParameter
extends DependencyParameter {
    private static final long serialVersionUID = 1L;
    private String collectionId;
    private List<Parameter> elements;

    public CollectiveParameter(DataType type, String id, Direction direction, StdIOStream stream, String prefix, String name, String contentType, double weight, boolean keepRename, ParameterMonitor monitor, List<Parameter> elements) {
        super(type, direction, stream, prefix, name, contentType, weight, keepRename, monitor);
        this.collectionId = id;
        this.elements = elements;
    }

    @Override
    public boolean isCollective() {
        return true;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public List<Parameter> getElements() {
        return this.elements;
    }

    public void setElements(List<Parameter> elements) {
        this.elements = elements;
    }

    @Override
    public String toString() {
        if (this.getType() == DataType.COLLECTION_T) {
            return this.toCollectionString();
        }
        return this.toDictionaryString();
    }

    private String toDictionaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DictCollectionParameter ").append(this.getCollectionId()).append("\n");
        sb.append("Name: ").append(this.getName()).append("\n");
        sb.append("Contents:\n");
        Iterator<Parameter> it = this.getElements().iterator();
        while (it.hasNext()) {
            Parameter key = it.next();
            Parameter value = it.next();
            sb.append("\t").append(key).append(" - ").append(value).append("\n");
        }
        return sb.toString();
    }

    private String toCollectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CollectionParameter ").append(this.getCollectionId()).append("\n");
        sb.append("Name: ").append(this.getName()).append("\n");
        sb.append("Contents:\n");
        for (Parameter s : this.getElements()) {
            sb.append("\t").append(s).append("\n");
        }
        return sb.toString();
    }
}

