/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.external.piped;

import es.bsc.compss.executor.external.ExternalExecutorException;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;
import es.bsc.compss.executor.external.piped.exceptions.ClosedPipeException;
import es.bsc.compss.executor.external.piped.exceptions.UnknownCommandException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControlPipePair {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private boolean readerAlive = false;
    private boolean closed = false;
    private final PipePair pipe;
    private Thread reader;
    private final List<PipeCommand> unusedCommands;
    private final Map<PipeCommand, PendingCommandStatus> waitingCommands;

    public ControlPipePair(String basePipePath, String id, PipedMirror mirror) {
        this.pipe = new PipePair(basePipePath, id, mirror);
        this.waitingCommands = new TreeMap<PipeCommand, PendingCommandStatus>();
        this.unusedCommands = new LinkedList<PipeCommand>();
    }

    public boolean sendCommand(PipeCommand command) {
        return this.pipe.sendCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCommand(PipeCommand command) throws ClosedPipeException {
        PipeCommand unusedCommand;
        PendingCommandStatus status = new PendingCommandStatus(command);
        ControlPipePair controlPipePair = this;
        synchronized (controlPipePair) {
            unusedCommand = this.pollMatchingUnusedCommand(command);
            if (unusedCommand == null) {
                if (this.closed) {
                    throw new ClosedPipeException();
                }
                this.waitingCommands.put(command, status);
                if (!this.readerAlive && !this.closed) {
                    this.readerAlive = true;
                    this.reader = new Thread(new ControlPipeReader());
                    this.reader.start();
                }
            } else {
                command.join(unusedCommand);
            }
        }
        if (unusedCommand == null) {
            try {
                status.waitUntilCompletion();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private PipeCommand pollMatchingUnusedCommand(PipeCommand command) {
        Iterator<PipeCommand> commandsItr = this.unusedCommands.iterator();
        while (commandsItr.hasNext()) {
            PipeCommand unusedCommand = commandsItr.next();
            if (unusedCommand.compareTo(command) != 0) continue;
            commandsItr.remove();
            return unusedCommand;
        }
        return null;
    }

    public String getOutboundPipe() {
        return this.pipe.getOutboundPipe();
    }

    public String getInboundPipe() {
        return this.pipe.getInboundPipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noLongerExists() {
        ControlPipePair controlPipePair = this;
        synchronized (controlPipePair) {
            this.closed = true;
        }
        this.pipe.noLongerExists();
        this.pipe.delete();
    }

    public void delete() {
        this.readerAlive = false;
        this.pipe.noLongerExists();
        this.pipe.delete();
    }

    private static class PendingCommandStatus {
        private final PipeCommand expectedCommand;
        private final Semaphore sem = new Semaphore(0);
        private boolean failed;

        private PendingCommandStatus(PipeCommand command) {
            this.expectedCommand = command;
            this.failed = false;
        }

        private void waitUntilCompletion() throws InterruptedException, ClosedPipeException {
            this.sem.acquire();
            if (this.failed) {
                throw new ClosedPipeException();
            }
        }

        private void completed(boolean failure, PipeCommand receivedCommand) {
            this.failed = failure;
            if (!failure) {
                this.expectedCommand.join(receivedCommand);
            }
            this.sem.release(Integer.MAX_VALUE);
        }
    }

    private class ControlPipeReader
    implements Runnable {
        private ControlPipeReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread.currentThread().setName("Pipe " + ControlPipePair.this.pipe.getPipesLocation() + " Reader");
            try {
                while (ControlPipePair.this.readerAlive) {
                    PipeCommand command;
                    try {
                        command = ControlPipePair.this.pipe.readCommand();
                    }
                    catch (UnknownCommandException uce) {
                        LOGGER.warn("UNKNOWN COMMAND RECEIVED TRHOUGH PIPE " + ControlPipePair.this.pipe.getInboundPipe() + ": " + uce.getMessage());
                        continue;
                    }
                    ControlPipePair controlPipePair = ControlPipePair.this;
                    synchronized (controlPipePair) {
                        PendingCommandStatus commandStatus = (PendingCommandStatus)ControlPipePair.this.waitingCommands.remove(command);
                        if (commandStatus == null) {
                            ControlPipePair.this.unusedCommands.add(command);
                        } else {
                            commandStatus.completed(false, command);
                        }
                    }
                }
                return;
            }
            catch (ExternalExecutorException eee) {
                ControlPipePair controlPipePair = ControlPipePair.this;
                synchronized (controlPipePair) {
                    Iterator iterator = ControlPipePair.this.waitingCommands.values().iterator();
                    while (iterator.hasNext()) {
                        PendingCommandStatus commandStatus = (PendingCommandStatus)iterator.next();
                        commandStatus.completed(true, null);
                    }
                    return;
                }
            }
        }
    }
}

