/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.wdc.affinity;

import es.bsc.wdc.affinity.Processor;
import es.bsc.wdc.affinity.ThreadAffinity;
import es.bsc.wdc.affinity.ThreadAffinityException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CPUInfo {
    private static Processor[] processors;

    private static InputStream openFile(String filename) throws FileNotFoundException {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
            if (is == null) {
                throw e;
            }
            return is;
        }
    }

    public static Set<Processor> loadFile(String fileName) throws ThreadAffinityException, IOException {
        String line;
        HashSet<Processor> procs = new HashSet<Processor>();
        BufferedReader br = new BufferedReader(new InputStreamReader(CPUInfo.openFile(fileName), "UTF-8"));
        Processor currentProc = null;
        while ((line = br.readLine()) != null) {
            if (line.trim().isEmpty()) {
                if (currentProc != null) {
                    procs.add(currentProc);
                    currentProc = null;
                    continue;
                }
                throw new ThreadAffinityException("Unexpected format. Empty line without processor defined");
            }
            String[] words = line.split("\\s*:\\s*", 2);
            if (words.length == 2) {
                if (words[0].equals("processor")) {
                    try {
                        int processorNumber = Integer.parseInt(words[1]);
                        currentProc = new Processor(processorNumber);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ThreadAffinityException("Processor title does not cnatin a number." + line);
                    }
                }
                if (currentProc == null) continue;
                currentProc.getProperties().put(words[0], words[1]);
                continue;
            }
            throw new ThreadAffinityException("Unexpected format. Lines is not following key:value format.");
        }
        return procs;
    }

    public static Processor[] getProcessors() {
        return processors;
    }

    public static Processor currentProcessor() throws ThreadAffinityException {
        int cpuSequence = ThreadAffinity.getCurrentThreadProcessor();
        return processors[cpuSequence];
    }

    public static Map<String, Set<Processor>> getProcessorsByPropertyType(String property) {
        HashMap<String, Set<Processor>> map = new HashMap<String, Set<Processor>>();
        for (Processor p : processors) {
            String value = p.getProperties().get(property);
            if (value == null) continue;
            HashSet<Processor> set = (HashSet<Processor>)map.get(value);
            if (set == null) {
                set = new HashSet<Processor>();
                map.put(value, set);
            }
            set.add(p);
        }
        return map;
    }

    public static Set<Processor> getProcessorsByPropertyValue(String property, String value) {
        HashSet<Processor> set = new HashSet<Processor>();
        for (Processor p : processors) {
            String procValue = p.getProperties().get(property);
            if (procValue == null || !procValue.equals(value)) continue;
            set.add(p);
        }
        return set;
    }

    static {
        try {
            Set<Processor> procs = CPUInfo.loadFile("/proc/cpuinfo");
            processors = new Processor[procs.size()];
            Iterator<Processor> iterator = procs.iterator();
            while (iterator.hasNext()) {
                Processor p;
                CPUInfo.processors[p.getNumber()] = p = iterator.next();
            }
        }
        catch (Exception e) {
            System.err.println("Error loading cpu info.");
            e.printStackTrace();
        }
    }
}

