/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class JuliaDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 6;
    private static final String ERROR_JULIA_SCRIPT = "ERROR: Invalid juliaScript";
    public static final String SCRIPT_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "julia" + File.separator + "run_julia.sh";
    private String juliaExecutor;
    private String juliaArgs;
    private String juliaScript;
    private String workingDir;
    private boolean failByEV;
    private int computingNodes;

    public JuliaDefinition() {
    }

    public JuliaDefinition(String juliaExecutor, String juliaArgs, String juliaScript, String workingDir, boolean failByEV, int computingNodes) {
        this.juliaExecutor = juliaExecutor;
        this.juliaArgs = juliaArgs;
        this.juliaScript = juliaScript;
        this.workingDir = workingDir;
        this.failByEV = failByEV;
        this.computingNodes = computingNodes;
    }

    public JuliaDefinition(String[] implTypeArgs, int offset) {
        this.juliaExecutor = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.juliaArgs = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.juliaScript = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 4]);
        this.computingNodes = Integer.parseInt(implTypeArgs[offset + 5]);
        if (this.juliaScript == null || this.juliaScript.isEmpty()) {
            throw new IllegalArgumentException("Empty juliaScript annotation for JULIA method ");
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        String script = this.juliaScript;
        if (!script.startsWith(File.separator)) {
            script = auxParam + File.separator + script;
        }
        lArgs.add(script);
        String executor = this.juliaExecutor;
        if (executor == null || executor.isEmpty() || executor.equals("[unassigned]")) {
            executor = "julia";
        }
        lArgs.add(executor);
        String args = this.juliaArgs;
        if (args == null || args.isEmpty() || args.equals("[unassigned]")) {
            args = "";
        }
        lArgs.add(args);
        String workingDir = this.workingDir;
        if (workingDir == null || workingDir.isEmpty() || workingDir.equals("[unassigned]")) {
            workingDir = ".";
        }
        lArgs.add(workingDir);
        lArgs.add(Boolean.toString(this.failByEV));
        lArgs.add(Integer.toString(this.computingNodes));
    }

    public String getJuliaScript() {
        return this.juliaScript;
    }

    public String getJuliaExecutor() {
        return this.juliaExecutor;
    }

    public String getJuliaArgs() {
        return this.juliaArgs;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean getFailByEV() {
        return this.failByEV;
    }

    public int getComputingNodes() {
        return this.computingNodes;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.JULIA;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder("{\"type\":\"JULIA\",");
        sb.append("\"julia_executor\":\"").append(this.juliaExecutor).append("\",");
        sb.append("\"julia_script\":\"").append(this.juliaScript).append("\"");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return super.toString() + " Julia Method with executor " + this.juliaExecutor + " and args " + this.juliaArgs + " and script " + this.juliaScript;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JULIA Implementation \n");
        sb.append("\t Julia executor: ").append(this.juliaExecutor).append("\n");
        sb.append("\t Julia args: ").append(this.juliaArgs).append("\n");
        sb.append("\t Julia script: ").append(this.juliaScript).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Computing Nodes: ").append(this.computingNodes).append("\n");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.juliaScript = (String)in.readObject();
        this.juliaExecutor = (String)in.readObject();
        this.juliaArgs = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.failByEV = in.readBoolean();
        this.computingNodes = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.juliaScript);
        out.writeObject(this.juliaExecutor);
        out.writeObject(this.juliaArgs);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.failByEV);
        out.writeInt(this.computingNodes);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    public void checkArguments() {
        if (this.juliaExecutor == null || this.juliaExecutor.isEmpty() || this.juliaExecutor.equals("[unassigned]")) {
            this.juliaExecutor = "julia";
        }
        if (this.juliaArgs == null || this.juliaArgs.isEmpty() || this.juliaArgs.equals("[unassigned]")) {
            this.juliaArgs = "";
        }
        if (this.juliaScript == null || this.juliaScript.isEmpty()) {
            throw new IllegalArgumentException(ERROR_JULIA_SCRIPT);
        }
    }

    public void setJuliaScript(String juliaScript) {
        this.juliaScript = juliaScript;
    }
}

