/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.listener.WorkersDebugInformationListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.location.SharedDisk;
import es.bsc.compss.types.data.transferable.SafeCopyTransferable;
import es.bsc.compss.types.data.transferable.WorkersDebugInfoCopyTransferable;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.ResourcesPool;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ResourceImpl
implements Comparable<Resource>,
Resource,
NodeMonitor {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final boolean CACHE_PROFILING_ENABLED = Boolean.parseBoolean(System.getProperty("compss.python.cache_profiler"));
    protected final String name;
    private final COMPSsNode node;
    protected Map<String, String> sharedDisksSetup;
    private final List<SharedDisk> sharedDisks = new LinkedList<SharedDisk>();
    private final Map<SharedDisk, String> sharedDisk2Mountpoint = new HashMap<SharedDisk, String>();
    private final List<LogicalData> obsoletes = new LinkedList<LogicalData>();
    private final Set<LogicalData> privateFiles = new HashSet<LogicalData>();
    private boolean isLost = false;

    public ResourceImpl(String name, Configuration conf, Map<String, String> sharedDisks) {
        this.name = name;
        this.node = Comm.initWorker(conf, this);
        this.sharedDisksSetup = sharedDisks;
        ResourcesPool.add(this);
    }

    public ResourceImpl(COMPSsNode node, Map<String, String> sharedDisks) {
        this.name = node.getName();
        this.node = node;
        node.setMonitor(this);
        this.sharedDisksSetup = sharedDisks;
        ResourcesPool.add(this);
    }

    public ResourceImpl(ResourceImpl clone) {
        this.name = clone.name;
        this.node = clone.node;
        ResourcesPool.add(this);
    }

    private String getAnalysisFolder() {
        return LoggerManager.getWorkersLogDir() + File.separator + this.getName() + File.separator + "Analysis";
    }

    private String getLogFolder() {
        return LoggerManager.getWorkersLogDir() + File.separator + this.getName() + File.separator + "Log";
    }

    @Override
    public void addSharedDisk(String diskName, String mountpoint) {
        SharedDisk disk = SharedDisk.createDisk(diskName);
        disk.addMountpoint(this, mountpoint);
        this.sharedDisks.add(disk);
        this.sharedDisk2Mountpoint.put(disk, mountpoint);
    }

    @Override
    public SharedDisk getSharedDiskFromPath(String path) {
        if (path == null) {
            return null;
        }
        for (Map.Entry<SharedDisk, String> e : this.sharedDisk2Mountpoint.entrySet()) {
            if (!path.startsWith(e.getValue())) continue;
            return e.getKey();
        }
        return null;
    }

    @Override
    public void start() throws InitNodeException {
        this.node.start();
        if (this.sharedDisksSetup != null) {
            for (Map.Entry<String, String> disk : this.sharedDisksSetup.entrySet()) {
                this.addSharedDisk(disk.getKey(), disk.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalData> getAllDataFromHost() {
        HashSet<LogicalData> data = new HashSet<LogicalData>();
        for (SharedDisk disk : this.sharedDisks) {
            Set<LogicalData> sharedData;
            Set<LogicalData> set = sharedData = disk.getAllSharedFiles();
            synchronized (set) {
                data.addAll(sharedData);
            }
        }
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            data.addAll(this.privateFiles);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogicalData(LogicalData ld) {
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            this.privateFiles.add(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogicalData(LogicalData ld) {
        Set<LogicalData> set = this.privateFiles;
        synchronized (set) {
            this.privateFiles.remove(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addObsolete(LogicalData obsolete) {
        if (this.getType() == ResourceType.WORKER) {
            List<LogicalData> list = this.obsoletes;
            synchronized (list) {
                this.obsoletes.add(obsolete);
            }
        }
        this.removeLogicalData(obsolete);
        for (SharedDisk disk : this.sharedDisks) {
            disk.removeLogicalData(obsolete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<MultiURI> pollObsoletes() {
        LogicalData[] obs = null;
        List<LogicalData> list = this.obsoletes;
        synchronized (list) {
            obs = this.obsoletes.toArray(new LogicalData[this.obsoletes.size()]);
            this.obsoletes.clear();
        }
        LinkedList<MultiURI> obsoleteRenamings = new LinkedList<MultiURI>();
        for (LogicalData ld : obs) {
            for (MultiURI u : ld.getURIsInHost(this)) {
                if (u == null) continue;
                obsoleteRenamings.add(u);
            }
        }
        return obsoleteRenamings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearObsoletes() {
        List<LogicalData> list = this.obsoletes;
        synchronized (list) {
            this.obsoletes.clear();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public COMPSsNode getNode() {
        return this.node;
    }

    @Override
    public void setInternalURI(MultiURI u) throws UnstartedNodeException {
        this.node.setInternalURI(u);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return this.node.newJob(taskId, taskParams, impl, this, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    @Override
    public void getData(LogicalData srcData, Transferable reason, EventListener listener) {
        this.getData(srcData, srcData.getName(), srcData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, String newName, Transferable reason, EventListener listener) {
        this.getData(srcData, newName, srcData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, DataLocation target, Transferable reason, EventListener listener) {
        this.getData(srcData, target, srcData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, LogicalData tgtData, Transferable reason, EventListener listener) {
        this.getData(srcData, srcData.getName(), tgtData, reason, listener);
    }

    @Override
    public void getData(LogicalData ld, String newName, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (reason.getType() == DataType.BINDING_OBJECT_T) {
            BindingObject bo;
            if (ld.getValue() == null) {
                LOGGER.warn("[Resource] Getting data: " + newName + ", source logical data value is null. Trying with data target from reason ");
                bo = BindingObject.generate(reason.getDataTarget());
                newName = newName + "#" + bo.getType() + "#" + bo.getElements();
            } else {
                bo = BindingObject.generate((String)ld.getValue());
                newName = newName + "#" + bo.getType() + "#" + bo.getElements();
            }
        }
        DataLocation target = this.node.getTargetLocation(this, reason.getType(), newName);
        this.getData(ld, target, tgtData, reason, listener);
    }

    @Override
    public void getData(LogicalData srcData, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        this.node.obtainData(srcData, null, target, tgtData, reason, listener);
    }

    @Override
    public void enforceDataObtaning(Transferable t, EventListener listener) {
        this.node.enforceDataObtaining(t, listener);
    }

    @Override
    public SimpleURI getCompleteRemotePath(DataType type, String name) {
        return this.node.getCompletePath(type, name);
    }

    public String getOutputDataTargetPath(String tgtName, DependencyParameter param) {
        return this.node.getOutputDataTarget(tgtName, param);
    }

    @Override
    public void retrieveUniqueDataValues() {
        if (this.isLost) {
            return;
        }
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        if (this.getNode().compareTo(masterNode) == 0) {
            if (DEBUG) {
                LOGGER.debug("The resource is part of the master process. No need to retrieve any data value.");
            }
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Retrieving data resource " + this.getName());
        }
        Semaphore sem = new Semaphore(0);
        SafeCopyListener listener = new SafeCopyListener(sem);
        Set<LogicalData> lds = this.getAllDataFromHost();
        HashMap<SharedDisk, String> disks = new HashMap<SharedDisk, String>();
        for (SharedDisk sd : this.sharedDisks) {
            String mountpoint = sd.removeMountpoint(this);
            disks.put(sd, mountpoint);
        }
        this.sharedDisks.clear();
        for (LogicalData ld : lds) {
            DataLocation lastLoc;
            if (ld.getCopiesInProgress().size() > 0) {
                ld.notifyToInProgressCopiesEnd(listener);
            }
            if ((lastLoc = ld.removeHostAndCheckLocationToSave(this, disks)) == null) continue;
            listener.addOperation();
            DataLocation safeLoc = null;
            String safePath = null;
            boolean isBindingData = false;
            if (lastLoc.getType().equals((Object)LocationType.BINDING)) {
                BindingObject bo = BindingObject.generate(lastLoc.getPath());
                safePath = ProtocolType.BINDING_URI.getSchema() + Comm.getAppHost().getWorkingDirectory() + ld.getName() + "#" + bo.getType() + "#" + bo.getElements();
            } else {
                safePath = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getWorkingDirectory() + ld.getName();
            }
            try {
                SimpleURI uri = new SimpleURI(safePath);
                safeLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + safePath, e);
            }
            if (isBindingData) {
                masterNode.obtainData(ld, lastLoc, safeLoc, ld, new SafeCopyTransferable(DataType.BINDING_OBJECT_T), listener);
                continue;
            }
            masterNode.obtainData(ld, lastLoc, safeLoc, ld, new SafeCopyTransferable(), listener);
        }
        if (DEBUG) {
            LOGGER.debug("Waiting for finishing saving copies for " + this.getName());
        }
        if (listener.getOperations() > 0) {
            listener.enable();
            try {
                sem.acquire();
            }
            catch (InterruptedException ex) {
                LOGGER.error("Error waiting for files in resource " + this.getName() + " to get saved");
            }
        }
        if (DEBUG) {
            LOGGER.debug("Unique files saved for " + this.getName());
        }
    }

    private Boolean isCompressedFile(Set<String> files) {
        if (files == null) {
            return false;
        }
        if (files.isEmpty()) {
            return false;
        }
        if (files.size() == 1) {
            String path = files.iterator().next();
            return path.endsWith(".tar.gz");
        }
        return false;
    }

    private void decompressAndDelete(String tarFile, String targetFolder) {
        if (DEBUG) {
            LOGGER.debug("Decompressing tar: " + tarFile + "; to: " + targetFolder);
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append("tar -xf " + tarFile + " -C " + targetFolder + " && ");
        cmd.append("rm -rf " + tarFile);
        LOGGER.debug("Executing: " + cmd);
        try {
            new ProcessBuilder("/bin/bash", "-c", cmd.toString()).inheritIO().start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Could not decompress: " + tarFile + "; to: " + targetFolder, (Throwable)e);
        }
    }

    private void copyTracingFilesToTracingFolder() {
        Path sourceDirectory = Paths.get(this.getAnalysisFolder(), new String[0]);
        Path targetDirectory = Paths.get(Tracer.getExtraeOutputDir(), new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(sourceDirectory, "*_compss_trace.tar.gz");){
            for (Path sourceFile : directoryStream) {
                Path targetFile = targetDirectory.resolve(sourceFile.getFileName());
                Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not copy tracing files from " + sourceDirectory + " to: " + targetDirectory);
        }
    }

    private void generateAndRetrieveWorkerAnalysis() {
        Set<String> analysisFiles = this.node.generateWorkerAnalysisFiles();
        LOGGER.debug("Analysis files generated by: " + this.getName() + " : " + (analysisFiles != null ? analysisFiles.toString() : "null"));
        if (analysisFiles == null || analysisFiles.isEmpty()) {
            LOGGER.debug("analysis files don't need to be retrieved");
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Retrieving analysis files from worker: " + this.getName() + " : " + analysisFiles.toString());
        }
        this.retrieveWorkerFiles(analysisFiles, this.getAnalysisFolder());
        if (DEBUG) {
            LOGGER.debug("Tracing files obtained for " + this.getName());
        }
        this.copyTracingFilesToTracingFolder();
    }

    private void generateAndRetrieveWorkerDebug() {
        Set<String> logFiles = this.node.generateWorkerDebugFiles();
        LOGGER.debug("Debug files generated by: " + this.getName() + " : " + (logFiles != null ? logFiles.toString() : "null"));
        if (logFiles == null || logFiles.isEmpty()) {
            LOGGER.debug("log files don't need to be retrieved");
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Retrieving debug files from worker: " + this.getName() + " : " + logFiles.toString());
            LOGGER.debug("    files: " + logFiles.toString());
        }
        this.retrieveWorkerFiles(logFiles, this.getLogFolder());
        if (DEBUG) {
            LOGGER.debug("Log files obtained for " + this.getName());
        }
    }

    @Override
    public void retrieveTracingAndDebugData() {
        if (this.isLost) {
            LOGGER.debug("Will not retrieve Tracing and Debug Data because the node: " + this.getName() + " is lost.");
            return;
        }
        if (Tracer.isActivated() || CACHE_PROFILING_ENABLED) {
            this.generateAndRetrieveWorkerAnalysis();
        }
        if (DEBUG) {
            this.generateAndRetrieveWorkerDebug();
        }
    }

    @Override
    public void deleteIntermediate() {
        this.node.deleteTemporary();
    }

    @Override
    public void disableExecution() {
        if (this.isLost) {
            LOGGER.debug(" Skipping ExecutionManager shutdown because the node: " + this.getName() + " is lost.");
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Shutting down Execution Manager on Resource " + this.getName());
        }
        Semaphore sem = new Semaphore(0);
        ExecutorShutdownListener executorShutdownListener = new ExecutorShutdownListener(sem);
        executorShutdownListener.addOperation();
        this.node.shutdownExecutionManager(executorShutdownListener);
        executorShutdownListener.enable();
        if (DEBUG) {
            LOGGER.debug("Waiting for shutting down the execution manager of " + this.getName());
        }
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for execution manager in resource " + this.getName() + " to stop");
        }
        if (DEBUG) {
            LOGGER.debug("Execution manager of " + this.getName() + " stopped");
        }
    }

    @Override
    public void stop(ShutdownListener sl) {
        if (this.isLost) {
            LOGGER.debug(" Skipping StopWorker because the node: " + this.getName() + " is lost.");
            sl.addOperation();
            sl.notifyEnd();
            return;
        }
        this.deleteIntermediate();
        sl.addOperation();
        this.node.stop(sl);
    }

    private void retrieveWorkerFiles(Set<String> filesPaths, String folderPath) {
        if (DEBUG) {
            LOGGER.debug("Copying Workers Information");
        }
        COMPSsNode masterNode = Comm.getAppHost().getNode();
        Path pathPath = Paths.get(folderPath, new String[0]);
        try {
            Files.createDirectories(pathPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Error while creating folder to store worker files", (Throwable)e);
        }
        Semaphore[] completedObtainData = new Semaphore[filesPaths.size()];
        int semaphoreCounter = 0;
        for (String sourcePath : filesPaths) {
            String fileName = sourcePath.substring(sourcePath.lastIndexOf("/") + 1);
            String targetPath = folderPath + File.separator + fileName;
            Semaphore sem = new Semaphore(0);
            completedObtainData[semaphoreCounter++] = sem;
            WorkersDebugInformationListener wdil = new WorkersDebugInformationListener(sem);
            wdil.addOperation();
            DataLocation sourceDataLocation = null;
            SimpleURI sourceUri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + sourcePath);
            try {
                sourceDataLocation = DataLocation.createLocation(this, sourceUri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + sourceUri.toString(), e);
            }
            DataLocation targetDataLocation = null;
            SimpleURI targetUri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + targetPath);
            try {
                targetDataLocation = DataLocation.createLocation(Comm.getAppHost(), targetUri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + targetUri.toString(), e);
            }
            LOGGER.debug("- Retrieving file from worker: " + sourceDataLocation.toString());
            masterNode.obtainData(new LogicalData(fileName), sourceDataLocation, targetDataLocation, new LogicalData(fileName), new WorkersDebugInfoCopyTransferable(), wdil);
            wdil.enable();
        }
        for (Semaphore sem : completedObtainData) {
            try {
                sem.acquire();
            }
            catch (InterruptedException ex) {
                LOGGER.error("Error waiting for worker debug files in resource " + this.getName() + " to get saved");
            }
            LOGGER.debug("Worker files from resource " + this.getName() + "received");
        }
    }

    private Set<String> getFilesPathFromFolder(String folderPath) {
        Set<String> pathSet = Stream.of(new File(folderPath).listFiles()).filter(file -> !file.isDirectory()).map(File::getName).collect(Collectors.toSet());
        return pathSet;
    }

    private void copyTracingFiles() {
        String folderPath = this.getAnalysisFolder();
        Set<String> files = this.getFilesPathFromFolder(folderPath);
        LOGGER.debug("Copying files" + files.toString() + " from folder " + folderPath.toString() + " to folder " + Tracer.getExtraeOutputDir());
        for (String fileName : files) {
            if (!fileName.endsWith("_compss_trace.tar.gz")) continue;
            Path src = Paths.get(folderPath + File.separator + fileName, new String[0]);
            Path tgt = Paths.get(Tracer.getExtraeOutputDir() + File.separator + this.getName() + fileName, new String[0]);
            try {
                Files.copy(src, tgt, new CopyOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to copy tracing files inside master folders", (Throwable)e);
            }
        }
    }

    @Override
    public void idleReservedResourcesDetected(ResourceDescription resources) {
    }

    @Override
    public void reactivatedReservedResourcesDetected(ResourceDescription resources) {
    }

    public boolean isLost() {
        return this.isLost;
    }

    @Override
    public void lostNode() {
        this.isLost = true;
        ResourceManager.notifyRestart(this.name);
    }

    public void startingNode() {
        this.isLost = false;
    }
}

