/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class COMPSsDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 7;
    public static final String SIGNATURE = "compss.NESTED";
    private static final String DEFAULT_RUNCOMPSS = "runcompss";
    private static final String DEFAULT_FLAGS = "";
    private String runcompss;
    private String flags;
    private String appName;
    private String appParams;
    private String workerInMaster;
    private String workingDir;
    private boolean failByEV;
    private String parentAppId;

    public COMPSsDefinition() {
    }

    public COMPSsDefinition(String runcompss, String flags, String workerInMaster, String appName, String appParams, String workingDir, boolean failByEV) {
        this.runcompss = runcompss != null && !runcompss.isEmpty() && !runcompss.equals("[unassigned]") ? runcompss : DEFAULT_RUNCOMPSS;
        this.flags = flags != null && !flags.isEmpty() && !flags.equals("[unassigned]") ? flags : DEFAULT_FLAGS;
        this.appName = appName;
        this.workerInMaster = workerInMaster;
        this.appParams = appParams;
        this.workingDir = workingDir;
        this.failByEV = failByEV;
        this.parentAppId = new File(System.getProperty(LoggerManager.getLogDir())).getName();
    }

    public COMPSsDefinition(String[] implTypeArgs, int offset) {
        this.runcompss = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.flags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        if (this.runcompss == null || this.runcompss.isEmpty() | this.runcompss.equals("[unassigned]")) {
            this.runcompss = DEFAULT_RUNCOMPSS;
        }
        if (this.flags == null || this.flags.isEmpty() || this.flags.equals("[unassigned]")) {
            this.flags = DEFAULT_FLAGS;
        }
        this.appName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.appParams = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        this.workerInMaster = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 4]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 5]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[6]);
        String appLogDir = LoggerManager.getLogDir();
        if (appLogDir != null && !appLogDir.isEmpty()) {
            this.parentAppId = new File(appLogDir).getName();
        }
        if (this.appName == null || this.appName.isEmpty()) {
            throw new IllegalArgumentException("Empty appName annotation for COMPSs method ");
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.runcompss);
        lArgs.add(this.flags);
        lArgs.add(this.appName);
        lArgs.add(this.appParams);
        lArgs.add(this.workerInMaster);
        lArgs.add(this.workingDir);
        lArgs.add(Boolean.toString(this.failByEV));
    }

    public String getRuncompss() {
        return this.runcompss;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppParams() {
        return this.appParams;
    }

    public String getWorkerInMaster() {
        return this.workerInMaster;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    public String getParentAppId() {
        return this.parentAppId;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.COMPSs;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder("{\"type\":\"COMPSs\",");
        sb.append("\"runcompss\":\"").append(this.runcompss).append("\",");
        sb.append("\"flags\":\"").append(this.flags).append("\",");
        sb.append("\"app_name\":\"").append(this.appName).append("\",");
        sb.append("\"app_params\":\"").append(this.appParams).append("\",");
        sb.append("\"worker_in_master\":\"").append(this.workerInMaster).append("\",");
        sb.append("\"working_dir\":\"").append(this.workingDir).append("\",");
        sb.append("\"fail_by_ev\":").append(this.failByEV).append(",");
        sb.append("\"parent_app_id\":\"").append(this.parentAppId).append("\"");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return " COMPSs Method with appName " + this.appName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.runcompss = (String)in.readObject();
        this.flags = (String)in.readObject();
        this.appName = (String)in.readObject();
        this.appParams = (String)in.readObject();
        this.workerInMaster = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.failByEV = in.readBoolean();
        this.parentAppId = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.runcompss);
        out.writeObject(this.flags);
        out.writeObject(this.appName);
        out.writeObject(this.appParams);
        out.writeObject(this.workerInMaster);
        out.writeObject(this.workingDir);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.parentAppId);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    public boolean hasParamsString() {
        return this.appParams != null && !this.appParams.equals("[unassigned]");
    }
}

