/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.location.SharedDisk;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import java.util.LinkedList;
import java.util.List;

public class BindingObjectLocation
extends DataLocation {
    private String id;
    private BindingObject bindingObject;
    private MultiURI uri;

    public BindingObjectLocation(Resource host, BindingObject bo) {
        this.id = bo.getId();
        this.uri = new MultiURI(ProtocolType.BINDING_URI, host, this.id + "#" + bo.getType() + "#" + bo.getElements());
        this.bindingObject = bo;
    }

    @Override
    public LocationType getType() {
        return LocationType.BINDING;
    }

    @Override
    public ProtocolType getProtocol() {
        return ProtocolType.BINDING_URI;
    }

    public String getId() {
        return this.id;
    }

    public BindingObject getBindingObject() {
        return this.bindingObject;
    }

    @Override
    public List<MultiURI> getURIs() {
        LinkedList<MultiURI> list = new LinkedList<MultiURI>();
        list.add(this.uri);
        return list;
    }

    @Override
    public List<Resource> getHosts() {
        LinkedList<Resource> list = new LinkedList<Resource>();
        list.add(this.uri.getHost());
        return list;
    }

    @Override
    public MultiURI getURIInHost(Resource targetHost) {
        if (this.uri.getHost().equals(targetHost)) {
            return this.uri;
        }
        return null;
    }

    @Override
    public boolean isTarget(DataLocation target) {
        if (target.getType() != LocationType.BINDING) {
            return false;
        }
        return this.id.equals(((BindingObjectLocation)target).id);
    }

    @Override
    public SharedDisk getSharedDisk() {
        return null;
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    @Override
    public String getLocationKey() {
        return this.uri.getPath() + ":" + this.uri.getHost().getName();
    }

    @Override
    public int compareTo(DataLocation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o.getClass() != BindingObjectLocation.class) {
            return this.getClass().getName().compareTo(BindingObjectLocation.class.toString());
        }
        return this.uri.compareTo(((BindingObjectLocation)o).uri);
    }

    public String toString() {
        return this.uri.toString();
    }

    @Override
    public void modifyPath(String path) {
        this.id = path;
        this.bindingObject = new BindingObject(path, this.bindingObject.getType(), this.bindingObject.getElements());
        MultiURI olduri = this.uri;
        this.uri = new MultiURI(ProtocolType.BINDING_URI, olduri.getHost(), this.id + "#" + this.bindingObject.getType() + "#" + this.bindingObject.getElements());
    }
}

