/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.types;

import es.bsc.conn.types.Processor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HardwareDescription {
    protected List<Processor> processors;
    protected int totalCPUComputingUnits = 0;
    protected int totalGPUComputingUnits = 0;
    protected int totalFPGAComputingUnits = 0;
    protected float memorySize = -1.0f;
    protected String memoryType = "[unassigned]";
    protected float storageSize = -1.0f;
    protected String storageType = "[unassigned]";
    protected int priceTimeUnit = -1;
    protected float pricePerUnit = -1.0f;
    protected String imageName;
    protected String type;
    protected Map<String, String> imageProperties;

    public HardwareDescription() {
        this.processors = new LinkedList<Processor>();
        this.imageName = null;
        this.type = null;
        this.imageProperties = new HashMap<String, String>();
    }

    public HardwareDescription(List<Processor> processors, int totalCPUComputingUnits, int totalGPUComputingUnits, int totalFPGAComputingUnits, float memorySize, String memoryType, float storageSize, String storageType, int priceTimeUnit, float pricePerUnit, String imageName, String imageType, Map<String, String> imageProperties) {
        this.processors = processors;
        this.totalCPUComputingUnits = totalCPUComputingUnits;
        this.totalGPUComputingUnits = totalGPUComputingUnits;
        this.memorySize = memorySize;
        this.memoryType = memoryType;
        this.storageSize = storageSize;
        this.storageType = storageType;
        this.priceTimeUnit = priceTimeUnit;
        this.pricePerUnit = pricePerUnit;
        this.imageName = imageName;
        this.type = imageType;
        this.imageProperties = imageProperties;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<Processor> proc) {
        this.processors = proc;
    }

    public int getTotalCPUComputingUnits() {
        return this.totalCPUComputingUnits;
    }

    public void setTotalComputingUnits(int tCU) {
        this.totalCPUComputingUnits = tCU;
    }

    public int getTotalGPUComputingUnits() {
        return this.totalGPUComputingUnits;
    }

    public void setTotalGPUComputingUnits(int tCU) {
        this.totalGPUComputingUnits = tCU;
    }

    public int getTotalFPGAComputingUnits() {
        return this.totalFPGAComputingUnits;
    }

    public void setTotalFPGAComputingUnits(int tCU) {
        this.totalFPGAComputingUnits = tCU;
    }

    public float getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(float memS) {
        this.memorySize = memS;
    }

    public String getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(String memT) {
        this.memoryType = memT;
    }

    public float getStorageSize() {
        return this.storageSize;
    }

    public void setStorageSize(float strS) {
        this.storageSize = strS;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String strT) {
        this.storageType = strT;
    }

    public int getPriceTimeUnit() {
        return this.priceTimeUnit;
    }

    public void setPriceTimeUnit(int pTU) {
        this.priceTimeUnit = pTU;
    }

    public float getPricePerUnit() {
        return this.pricePerUnit;
    }

    public void setPricePerUnit(float pPU) {
        this.pricePerUnit = pPU;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getImageProperties() {
        return this.imageProperties;
    }

    public void setImageProperties(Map<String, String> imageProperties) {
        this.imageProperties = imageProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HD-").append(this.hashCode());
        sb.append("[");
        sb.append("totalCPUs = ").append(this.totalCPUComputingUnits).append(",");
        sb.append("totalGPUs = ").append(this.totalGPUComputingUnits).append(",");
        sb.append("totalFPGAs = ").append(this.totalFPGAComputingUnits).append(",");
        sb.append("memorySize = ").append(this.memorySize).append(",");
        sb.append("memoryType = ").append(this.memoryType).append(",");
        sb.append("storageSize = ").append(this.storageSize).append(",");
        sb.append("storageType = ").append(this.storageType).append(",");
        sb.append("priceTimeUnit = ").append(this.priceTimeUnit).append(",");
        sb.append("pricePerUnit = ").append(this.pricePerUnit).append(",");
        sb.append("imageName = ").append(this.imageName).append(",");
        sb.append("type = ").append(this.type);
        sb.append("]");
        return sb.toString();
    }
}

