/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.execution;

import es.bsc.compss.executor.Executor;
import es.bsc.compss.types.execution.ExecutorRequest;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.worker.COMPSsException;

public class InvocationExecutionRequest
extends ExecutorRequest {
    private final Invocation invocation;
    private final Listener listener;

    public InvocationExecutionRequest(Invocation invocation, Listener listener) {
        this.invocation = invocation;
        this.listener = listener == null ? new IgnoreListener() : listener;
    }

    public boolean isIOExecution() {
        return this.invocation.getMethodImplementation().isIO();
    }

    public String getInvocationSignature() {
        return this.invocation.getMethodImplementation().getSignature();
    }

    @Override
    public boolean hasAgePriority() {
        return false;
    }

    @Override
    public void run(Executor executor) {
        try {
            executor.processInvocation(this.invocation, this.listener);
            this.listener.notifyEnd(this.invocation, true, null);
        }
        catch (COMPSsException ce) {
            this.listener.notifyEnd(this.invocation, false, ce);
        }
        catch (Exception e) {
            this.listener.notifyEnd(this.invocation, false, null);
        }
    }

    @Override
    public String toString() {
        return "Invocation for Job " + this.invocation.getJobId();
    }

    public static interface Listener {
        public void onResultAvailable(InvocationParam var1);

        public void notifyEnd(Invocation var1, boolean var2, COMPSsException var3);
    }

    private static class IgnoreListener
    implements Listener {
        @Override
        public void onResultAvailable(InvocationParam param) {
        }

        @Override
        public void notifyEnd(Invocation invocation, boolean success, COMPSsException e) {
        }
    }
}

