/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.ClusterMethodResourceDescription;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterWorker
extends Worker<MethodResourceDescription> {
    private final int limitOfTasks;
    private AtomicInteger sharedRunningTasks;
    private int numNodes = 0;
    private int usedCPUs = 0;
    private int usedGPUs = 0;
    private int usedFPGAs = 0;
    private int usedOthers = 0;
    private final int maxCPUs;
    private final int maxGPUs;
    private final int maxFPGAs;
    private final int maxOthers;

    public ClusterWorker(String hostname, String clusterNode, ClusterMethodResourceDescription md, MethodConfiguration config, Map<String, String> sharedDisks, AtomicInteger sharedLimitTask) {
        super(hostname, md, config, sharedDisks);
        this.numNodes = md.getNumClusters();
        this.limitOfTasks = md.getLimitOfTasks();
        this.sharedRunningTasks = sharedLimitTask;
        this.maxCPUs = this.numNodes * ((MethodResourceDescription)this.description).totalCPUComputingUnits;
        this.maxGPUs = this.numNodes * ((MethodResourceDescription)this.description).totalGPUComputingUnits;
        this.maxFPGAs = this.numNodes * ((MethodResourceDescription)this.description).totalFPGAComputingUnits;
        this.maxOthers = this.numNodes * ((MethodResourceDescription)this.description).totalOtherComputingUnits;
    }

    public ClusterWorker(ClusterWorker cw) {
        super(cw);
        this.limitOfTasks = cw.limitOfTasks;
        this.sharedRunningTasks = cw.sharedRunningTasks;
        this.maxCPUs = cw.maxCPUs;
        this.maxGPUs = cw.maxGPUs;
        this.maxFPGAs = cw.maxFPGAs;
        this.maxOthers = cw.maxOthers;
    }

    @Override
    protected int limitIdealSimultaneousTasks(int ideal) {
        int internalLimit = Math.min(this.maxCPUs * this.numNodes, this.limitOfTasks);
        return Math.min(internalLimit, ideal);
    }

    @Override
    public Integer simultaneousCapacity(Implementation impl) {
        return Math.min(this.limitOfTasks, this.numNodes * this.fitCount(impl));
    }

    @Override
    public ResourceType getType() {
        return ResourceType.WORKER;
    }

    @Override
    public boolean canRun(Implementation implementation) {
        if (this.isLost()) {
            return false;
        }
        if (implementation.getTaskType() == TaskType.METHOD) {
            LOGGER.debug("******* Executiong Can Run in " + this.name);
            LOGGER.debug("******* Description: " + this.description);
            MethodResourceDescription requirements = (MethodResourceDescription)implementation.getRequirements();
            boolean res = ((MethodResourceDescription)this.description).contains(requirements);
            LOGGER.debug("******** Result in Can Run in " + this.name + " is " + res);
            return res;
        }
        return false;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<LimitOfTasks>").append(this.limitOfTasks).append("</LimitOfTasks>").append("\n");
        sb.append(prefix).append("<TotalCPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalCPUComputingUnits()).append("</TotalCPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalGPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalGPUComputingUnits()).append("</TotalGPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalFPGAComputingUnits>").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("</TotalFPGAComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalOTHERComputingUnits>").append(((MethodResourceDescription)this.description).getTotalOTHERComputingUnits()).append("</TotalOTHERComputingUnits>").append("\n");
        sb.append(prefix).append("<Memory>").append(((MethodResourceDescription)this.description).getMemorySize()).append("</Memory>").append("\n");
        sb.append(prefix).append("<Disk>").append(((MethodResourceDescription)this.description).getStorageSize()).append("</Disk>").append("\n");
        return sb.toString();
    }

    @Override
    public Integer fitCount(Implementation impl) {
        if (impl.getTaskType() != TaskType.METHOD) {
            return null;
        }
        MethodResourceDescription mrd = (MethodResourceDescription)impl.getRequirements();
        int res = Math.min(this.limitOfTasks, this.numNodes * ((MethodResourceDescription)this.description).canHostSimultaneously(mrd));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            int nCPUS = consumption.totalCPUComputingUnits;
            int nGPUS = consumption.totalGPUComputingUnits;
            int nFPGAs = consumption.totalFPGAComputingUnits;
            int nOthers = consumption.totalOtherComputingUnits;
            boolean canRun = this.sharedRunningTasks.get() < this.limitOfTasks;
            canRun = canRun && nCPUS <= this.maxCPUs - this.usedCPUs;
            canRun = canRun && nGPUS <= this.maxGPUs - this.usedGPUs;
            canRun = canRun && nFPGAs <= this.maxFPGAs - this.usedFPGAs;
            boolean bl = canRun = canRun && nOthers <= this.maxOthers - this.usedOthers;
            if (consumption.getMethodType().equals((Object)MethodResourceDescription.MethodResourceType.CLUSTER)) {
                ClusterMethodResourceDescription cmrd = (ClusterMethodResourceDescription)consumption;
                canRun = canRun && this.numNodes <= cmrd.getNumClusters();
            }
            return canRun;
        }
    }

    @Override
    public boolean hasAvailableSlots() {
        boolean available = this.sharedRunningTasks.get() < this.limitOfTasks;
        available = available && this.usedCPUs < this.maxCPUs;
        available = available && this.usedGPUs < this.maxGPUs;
        available = available && this.usedFPGAs < this.maxFPGAs;
        available = available && this.usedOthers < this.maxOthers;
        return available;
    }

    private MethodResourceDescription reserveResourceMethod(MethodResourceDescription consumption) {
        this.sharedRunningTasks.incrementAndGet();
        this.usedCPUs += consumption.totalCPUComputingUnits;
        this.usedGPUs += consumption.totalGPUComputingUnits;
        this.usedFPGAs += consumption.totalFPGAComputingUnits;
        this.usedOthers += consumption.totalOtherComputingUnits;
        return consumption;
    }

    private MethodResourceDescription reserveResourceCluster(ClusterMethodResourceDescription consumption) {
        int nNodes = consumption.getNumClusters();
        this.sharedRunningTasks.getAndAdd(nNodes);
        this.usedCPUs += nNodes * consumption.totalCPUComputingUnits;
        this.usedGPUs += nNodes * consumption.totalGPUComputingUnits;
        this.usedFPGAs += nNodes * consumption.totalFPGAComputingUnits;
        this.usedOthers += nNodes * consumption.totalOtherComputingUnits;
        return consumption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodResourceDescription reserveResource(MethodResourceDescription consumption) {
        if (consumption == null || !this.hasAvailable(consumption)) {
            return null;
        }
        ClusterWorker clusterWorker = this;
        synchronized (clusterWorker) {
            if (consumption.getMethodType().equals((Object)MethodResourceDescription.MethodResourceType.CLUSTER)) {
                return this.reserveResourceCluster((ClusterMethodResourceDescription)consumption);
            }
            return this.reserveResourceMethod(consumption);
        }
    }

    private void releaseResourceMethod(MethodResourceDescription consumption) {
        this.sharedRunningTasks.decrementAndGet();
        this.usedCPUs -= consumption.totalCPUComputingUnits;
        this.usedGPUs -= consumption.totalGPUComputingUnits;
        this.usedFPGAs -= consumption.totalFPGAComputingUnits;
        this.usedOthers -= consumption.totalOtherComputingUnits;
    }

    private void releaseResourceCluster(ClusterMethodResourceDescription consumption) {
        int nNodes = consumption.getNumClusters();
        this.sharedRunningTasks.addAndGet(-nNodes);
        this.usedCPUs -= nNodes * consumption.totalCPUComputingUnits;
        this.usedGPUs -= nNodes * consumption.totalGPUComputingUnits;
        this.usedFPGAs -= nNodes * consumption.totalFPGAComputingUnits;
        this.usedOthers -= nNodes * consumption.totalOtherComputingUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResource(MethodResourceDescription consumption) {
        if (consumption == null) {
            return;
        }
        ClusterWorker clusterWorker = this;
        synchronized (clusterWorker) {
            if (consumption.getMethodType().equals((Object)MethodResourceDescription.MethodResourceType.CLUSTER)) {
                this.releaseResourceCluster((ClusterMethodResourceDescription)consumption);
            } else {
                this.releaseResourceMethod(consumption);
            }
        }
    }

    @Override
    public void releaseAllResources() {
        super.resetUsedTaskCounts();
        this.usedCPUs = 0;
        this.usedGPUs = 0;
        this.usedFPGAs = 0;
        this.usedOthers = 0;
    }

    public ClusterWorker getSchedulingCopy() {
        return new ClusterWorker(this);
    }

    private Float getValue() {
        return ((MethodResourceDescription)this.description).value;
    }

    @Override
    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case HTTP: 
            case WORKER: {
                ClusterWorker w = (ClusterWorker)t;
                if (((MethodResourceDescription)this.description).getValue() == null) {
                    if (w.getValue() == null) {
                        return w.getName().compareTo(this.getName());
                    }
                    return 1;
                }
                if (w.getValue() == null) {
                    return -1;
                }
                float dif = w.getValue().floatValue() - ((MethodResourceDescription)this.description).getValue().floatValue();
                if (dif > 0.0f) {
                    return -1;
                }
                if (dif < 0.0f) {
                    return 1;
                }
                return this.getName().compareTo(w.getName());
            }
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }
}

