/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.jar.JarFile;
import org.apache.logging.log4j.Logger;

public class Classpath {
    private static Instrumentation instr;

    private Classpath() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        if (instrumentation == null) {
            throw new NullPointerException("Instrumentation");
        }
        instr = instrumentation;
    }

    public static synchronized boolean isSupported() {
        return instr != null;
    }

    public static void loadJarsInPath(String jarsPath, Logger logger) {
        if (jarsPath == null) {
            logger.error("ERROR: Skipping JAR addition because provided jar is null");
            return;
        }
        File jarsFileOrDirectory = new File(jarsPath);
        if (!jarsFileOrDirectory.exists()) {
            logger.error("ERROR: Skipping JAR addition because jar path was not found at " + jarsFileOrDirectory.getAbsolutePath());
            return;
        }
        Classpath.scanFolder(jarsFileOrDirectory, logger);
    }

    private static void scanFolder(File file, Logger logger) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                Classpath.scanFolder(child, logger);
            }
            return;
        }
        try {
            Classpath.addToClasspath(file);
        }
        catch (IOException ioe) {
            logger.error("COULD NOT LOAD JAR AT " + file.getAbsolutePath(), (Throwable)ioe);
        }
    }

    private static synchronized void addToClasspath(File jarFile) throws IOException {
        if (jarFile == null) {
            throw new NullPointerException("ERROR: Provided jar file is null");
        }
        if (!jarFile.exists()) {
            throw new FileNotFoundException("ERROR: jar file not found at " + jarFile.getAbsolutePath());
        }
        if (!jarFile.canRead()) {
            throw new IOException("ERROR: Can't read jar file at " + jarFile.getAbsolutePath());
        }
        if (!jarFile.isFile()) {
            throw new IOException("ERROR: jar file is not a file at " + jarFile.getAbsolutePath());
        }
        instr.appendToSystemClassLoaderSearch(new JarFile(jarFile));
    }
}

