/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.invokers.JavaInvoker;
import es.bsc.compss.invokers.util.ClassUtils;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.loader.total.ITAppModifier;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.util.parsers.ITFParser;
import es.bsc.compss.worker.COMPSsException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JavaNestedInvoker
extends JavaInvoker {
    private static final String ENGINE_PATH;
    private String ceiName;
    private Class<?> ceiClass;
    private final COMPSsRuntime runtimeAPI;
    private final LoaderAPI loaderAPI;

    public JavaNestedInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandbox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandbox, assignedResources);
        this.runtimeAPI = context.getRuntimeAPI();
        this.loaderAPI = context.getLoaderAPI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Method findMethod() throws JobExecutionException {
        Method method;
        Class<?> ceiClass;
        this.ceiName = this.invocation.getParallelismSource();
        if (this.ceiName != null) {
            try {
                ceiClass = Class.forName(this.ceiName);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.warn("Requesting a Nested Invoker with not found CEI " + this.ceiName + " for Job " + this.invocation.getJobId() + ". Proxying invoker to a regular Java Invoker.");
                ceiClass = null;
            }
        } else {
            LOGGER.warn("Requesting a Nested Invoker with no CEI for Job " + this.invocation.getJobId() + ". Proxying invoker to a regular Java Invoker.");
            ceiClass = null;
        }
        this.ceiClass = ceiClass;
        if (ceiClass == null) {
            method = super.findMethod();
        } else {
            if (Tracer.isActivated()) {
                Tracer.emitEvent(TraceEvent.INSTRUMENTING_CLASS);
            }
            try {
                URLClassLoader myLoader = new URLClassLoader(new URL[]{new URL(ENGINE_PATH)});
                Thread.currentThread().setContextClassLoader(myLoader);
                LOGGER.debug("Modifying application " + this.className);
                this.methodClass = ITAppModifier.modifyToMemory(this.className, this.className, ceiClass, false, true, true, false);
                method = ClassUtils.findMethod(this.methodClass, this.methodName, this.invocation.getParams());
            }
            catch (Exception e) {
                LOGGER.warn("Could not instrument the method to detect nested tasks.", (Throwable)e);
                method = super.findMethod();
            }
            finally {
                if (Tracer.isActivated()) {
                    Tracer.emitEventEnd(TraceEvent.INSTRUMENTING_CLASS);
                }
            }
        }
        return method;
    }

    @Override
    protected void runMethod() throws JobExecutionException, COMPSsException {
        if (this.ceiClass == null) {
            super.runMethod();
        } else {
            Method setter;
            long appId = this.becomesNestedApplication(this.ceiName);
            List<CoreElementDefinition> ceds = ITFParser.parseITFMethods(this.ceiClass);
            for (CoreElementDefinition ced : ceds) {
                this.runtimeAPI.registerCoreElement(ced);
            }
            try {
                setter = this.methodClass.getDeclaredMethod("setCOMPSsVariables", Class.forName(LoaderConstants.CLASS_COMPSSRUNTIME_API), Class.forName(LoaderConstants.CLASS_LOADERAPI), Class.forName(LoaderConstants.CLASS_APP_ID));
            }
            catch (Exception e) {
                throw new JobExecutionException("Class not properly instrumented. Method setCOMPSsVariables not found!", e);
            }
            try {
                Object[] values = new Object[]{this.runtimeAPI, this.loaderAPI, appId};
                setter.invoke(null, values);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new JobExecutionException("Error setting Nested COMPSs variables", e);
            }
            try {
                super.runMethod();
            }
            catch (Throwable e) {
                throw new JobExecutionException("Error executing the instrumented method!", e);
            }
            finally {
                this.completeNestedApplication(appId);
            }
        }
    }

    static {
        String compssHome = System.getenv("COMPSS_HOME");
        ENGINE_PATH = "file:" + compssHome + LoaderConstants.ENGINE_JAR_WITH_REL_PATH;
    }
}

