/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.resources.Validator;
import es.bsc.compss.types.resources.exceptions.InvalidElementException;
import es.bsc.compss.types.resources.exceptions.ResourcesFileValidationException;
import es.bsc.compss.types.resources.jaxb.AdaptorType;
import es.bsc.compss.types.resources.jaxb.AdaptorsListType;
import es.bsc.compss.types.resources.jaxb.AttachedDiskType;
import es.bsc.compss.types.resources.jaxb.AttachedDisksListType;
import es.bsc.compss.types.resources.jaxb.BatchType;
import es.bsc.compss.types.resources.jaxb.CloudProviderType;
import es.bsc.compss.types.resources.jaxb.ClusterNodeType;
import es.bsc.compss.types.resources.jaxb.ComputeNodeType;
import es.bsc.compss.types.resources.jaxb.ComputingClusterType;
import es.bsc.compss.types.resources.jaxb.DataNodeType;
import es.bsc.compss.types.resources.jaxb.EndpointType;
import es.bsc.compss.types.resources.jaxb.HttpType;
import es.bsc.compss.types.resources.jaxb.ImageType;
import es.bsc.compss.types.resources.jaxb.ImagesType;
import es.bsc.compss.types.resources.jaxb.InstanceTypeType;
import es.bsc.compss.types.resources.jaxb.InstanceTypesType;
import es.bsc.compss.types.resources.jaxb.InteractiveType;
import es.bsc.compss.types.resources.jaxb.MemoryType;
import es.bsc.compss.types.resources.jaxb.OSType;
import es.bsc.compss.types.resources.jaxb.OSTypeType;
import es.bsc.compss.types.resources.jaxb.ObjectFactory;
import es.bsc.compss.types.resources.jaxb.PriceType;
import es.bsc.compss.types.resources.jaxb.ProcessorPropertyType;
import es.bsc.compss.types.resources.jaxb.ProcessorType;
import es.bsc.compss.types.resources.jaxb.ResourcesExternalAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ResourcesListType;
import es.bsc.compss.types.resources.jaxb.ResourcesNIOAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ResourcesPropertyAdaptorType;
import es.bsc.compss.types.resources.jaxb.ServiceType;
import es.bsc.compss.types.resources.jaxb.SharedDiskType;
import es.bsc.compss.types.resources.jaxb.SoftwareListType;
import es.bsc.compss.types.resources.jaxb.StorageType;
import es.bsc.compss.types.resources.jaxb.SubmissionSystemType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ResourcesFile {
    private JAXBContext context;
    private Schema xsd;
    private ResourcesListType resources;
    private Validator validator;
    private Logger logger;

    public ResourcesFile(File xml, Schema xsd, Logger logger) throws JAXBException, ResourcesFileValidationException {
        this.logger = logger;
        this.logger.info("Init Resources.xml parsing");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("XML Path: " + xml.getAbsolutePath());
            this.logger.debug("XSD Schema");
        }
        this.context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        this.xsd = xsd;
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal(xml);
        this.resources = (ResourcesListType)jaxbElem.getValue();
        this.logger.info("Init Resources.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Resources.xml finished");
    }

    public ResourcesFile(Logger logger) throws JAXBException {
        this.logger = logger;
        this.context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        this.validator = new Validator(this, this.logger);
        this.resources = new ResourcesListType();
    }

    public ResourcesFile(String xmlString, Schema xsd, Logger logger) throws JAXBException, ResourcesFileValidationException {
        this.logger = logger;
        this.logger.info("Init Resources.xml parsing");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("XML String");
            this.logger.debug("XSD Schema");
        }
        this.context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        this.xsd = xsd;
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal((Reader)new StringReader(xmlString));
        this.resources = (ResourcesListType)jaxbElem.getValue();
        this.logger.info("Init Resources.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Resources.xml finished");
    }

    public ResourcesFile(File xml, String xsdPath, Logger logger) throws SAXException, JAXBException, ResourcesFileValidationException {
        this.logger = logger;
        this.logger.info("Init Resources.xml parsing");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("XML Path: " + xml.getAbsolutePath());
            this.logger.debug("XSD Path: " + xsdPath);
        }
        this.context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.xsd = sf.newSchema(new File(xsdPath));
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal(xml);
        this.resources = (ResourcesListType)jaxbElem.getValue();
        this.logger.info("Init Resources.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Resources.xml finished");
    }

    public ResourcesFile(String xmlString, String xsdPath, Logger logger) throws SAXException, JAXBException, ResourcesFileValidationException {
        this.logger = logger;
        this.logger.info("Init Resources.xml parsing");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("XML String");
            this.logger.debug("XSD Path: " + xsdPath);
        }
        this.context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.xsd = sf.newSchema(new File(xsdPath));
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal((Reader)new StringReader(xmlString));
        this.resources = (ResourcesListType)jaxbElem.getValue();
        this.logger.info("Init Resources.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Resources.xml finished");
    }

    public ResourcesFile(String xsdPath, Logger logger) throws SAXException, JAXBException, ResourcesFileValidationException {
        this.logger = logger;
        this.logger.info("Init Resources.xml parsing");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("XML String");
            this.logger.debug("XSD Path: " + xsdPath);
        }
        this.context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.xsd = sf.newSchema(new File(xsdPath));
        this.resources = new ResourcesListType();
        this.validator = new Validator(this, this.logger);
    }

    public void toFile(File file) throws JAXBException {
        this.logger.info("Resources.xml to file");
        Marshaller m = this.context.createMarshaller();
        ObjectFactory objFact = new ObjectFactory();
        m.setSchema(this.xsd);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal(objFact.createResourcesList(this.resources), file);
    }

    public String getString() throws JAXBException {
        this.logger.info("Resources.xml to string");
        Marshaller m = this.context.createMarshaller();
        ObjectFactory objFact = new ObjectFactory();
        m.setSchema(this.xsd);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        m.marshal(objFact.createResourcesList(this.resources), (Writer)sw);
        return sw.getBuffer().toString();
    }

    public ResourcesListType getResources() {
        return this.resources;
    }

    public List<SharedDiskType> getSharedDisks_list() {
        ArrayList<SharedDiskType> list = new ArrayList<SharedDiskType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof SharedDiskType)) continue;
                list.add((SharedDiskType)obj);
            }
        }
        return list;
    }

    public List<DataNodeType> getDataNodes_list() {
        ArrayList<DataNodeType> list = new ArrayList<DataNodeType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof DataNodeType)) continue;
                list.add((DataNodeType)obj);
            }
        }
        return list;
    }

    public List<ComputeNodeType> getComputeNodes_list() {
        ArrayList<ComputeNodeType> list = new ArrayList<ComputeNodeType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ComputeNodeType)) continue;
                list.add((ComputeNodeType)obj);
            }
        }
        return list;
    }

    public List<ServiceType> getServices_list() {
        ArrayList<ServiceType> list = new ArrayList<ServiceType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ServiceType)) continue;
                list.add((ServiceType)obj);
            }
        }
        return list;
    }

    public List<CloudProviderType> getCloudProviders_list() {
        ArrayList<CloudProviderType> list = new ArrayList<CloudProviderType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudProviderType)) continue;
                list.add((CloudProviderType)obj);
            }
        }
        return list;
    }

    public HashMap<String, SharedDiskType> getSharedDisks_hashMap() {
        HashMap<String, SharedDiskType> res = new HashMap<String, SharedDiskType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof SharedDiskType)) continue;
                String diskName = ((SharedDiskType)obj).getName();
                res.put(diskName, (SharedDiskType)obj);
            }
        }
        return res;
    }

    public HashMap<String, DataNodeType> getDataNodes_hashMap() {
        HashMap<String, DataNodeType> res = new HashMap<String, DataNodeType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof DataNodeType)) continue;
                String dataNodeName = ((DataNodeType)obj).getName();
                res.put(dataNodeName, (DataNodeType)obj);
            }
        }
        return res;
    }

    public HashMap<String, ComputeNodeType> getComputeNodes_hashMap() {
        HashMap<String, ComputeNodeType> res = new HashMap<String, ComputeNodeType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ComputeNodeType)) continue;
                String computeNodeName = ((ComputeNodeType)obj).getName();
                res.put(computeNodeName, (ComputeNodeType)obj);
            }
        }
        return res;
    }

    public HashMap<String, String> getDiskMountPointsInComputeNodes(String diskName) {
        HashMap<String, String> mountPoints = new HashMap<String, String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                ComputeNodeType cn;
                HashMap<String, String> disks;
                if (!(obj instanceof ComputeNodeType) || (disks = this.getSharedDisks(cn = (ComputeNodeType)obj)) == null || !disks.containsKey(diskName)) continue;
                mountPoints.put(cn.getName(), disks.get(diskName));
            }
        }
        return mountPoints;
    }

    public HashMap<String, ServiceType> getServices_hashMap() {
        HashMap<String, ServiceType> res = new HashMap<String, ServiceType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ServiceType)) continue;
                String serviceWSDL = ((ServiceType)obj).getWsdl();
                res.put(serviceWSDL, (ServiceType)obj);
            }
        }
        return res;
    }

    public HashMap<String, List<ServiceType>> getServices_byName() {
        HashMap<String, List<ServiceType>> res = new HashMap<String, List<ServiceType>>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ServiceType)) continue;
                String serviceName = ((ServiceType)obj).getName();
                List<Object> auxServicesList = null;
                if (res.containsKey(serviceName)) {
                    auxServicesList = res.get(serviceName);
                    auxServicesList.add((ServiceType)obj);
                } else {
                    auxServicesList = new ArrayList();
                }
                res.put(serviceName, auxServicesList);
            }
        }
        return res;
    }

    public HashMap<String, CloudProviderType> getCloudProviders_hashMap() {
        HashMap<String, CloudProviderType> res = new HashMap<String, CloudProviderType>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudProviderType)) continue;
                String cloudProviderName = ((CloudProviderType)obj).getName();
                res.put(cloudProviderName, (CloudProviderType)obj);
            }
        }
        return res;
    }

    public List<String> getSharedDisks_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof SharedDiskType)) continue;
                list.add(((SharedDiskType)obj).getName());
            }
        }
        return list;
    }

    public List<String> getDataNodes_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof DataNodeType)) continue;
                list.add(((DataNodeType)obj).getName());
            }
        }
        return list;
    }

    public List<String> getComputeNodes_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ComputeNodeType)) continue;
                list.add(((ComputeNodeType)obj).getName());
            }
        }
        return list;
    }

    public List<String> getComputingCluster_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ComputingClusterType)) continue;
                list.add(((ComputingClusterType)obj).getName());
            }
        }
        return list;
    }

    public List<String> getServices_wsdls() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ServiceType)) continue;
                list.add(((ServiceType)obj).getWsdl());
            }
        }
        return list;
    }

    public List<String> getHttp_urls() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof HttpType)) continue;
                list.add(((HttpType)obj).getBaseUrl());
            }
        }
        return list;
    }

    public List<String> getServices_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                String serviceName;
                if (!(obj instanceof ServiceType) || list.contains(serviceName = ((ServiceType)obj).getName())) continue;
                list.add(((ServiceType)obj).getName());
            }
        }
        return list;
    }

    public List<String> getCloudProviders_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudProviderType)) continue;
                list.add(((CloudProviderType)obj).getName());
            }
        }
        return list;
    }

    public SharedDiskType getSharedDisk(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                SharedDiskType sd;
                if (!(obj instanceof SharedDiskType) || !(sd = (SharedDiskType)obj).getName().equals(name)) continue;
                return sd;
            }
        }
        return null;
    }

    public DataNodeType getDataNode(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                DataNodeType dn;
                if (!(obj instanceof DataNodeType) || !(dn = (DataNodeType)obj).getName().equals(name)) continue;
                return dn;
            }
        }
        return null;
    }

    public String getHost(DataNodeType d) {
        List<JAXBElement<?>> elements = d.getHostOrPathOrAdaptors();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("Host"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public String getPath(DataNodeType d) {
        List<JAXBElement<?>> elements = d.getHostOrPathOrAdaptors();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("Path"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public float getStorageSize(DataNodeType d) {
        List<JAXBElement<?>> elements = d.getHostOrPathOrAdaptors();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("Storage"))) continue;
                StorageType storage = (StorageType)elem.getValue();
                return this.getStorageSize(storage);
            }
        }
        return -1.0f;
    }

    public float getStorageSize(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof StorageType)) continue;
                StorageType storage = (StorageType)obj;
                return this.getStorageSize(storage);
            }
        }
        return -1.0f;
    }

    public float getStorageSize(InstanceTypeType instance) {
        List<Object> objList = instance.getProcessorOrMemoryOrStorage();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof StorageType)) continue;
                StorageType storage = (StorageType)obj;
                return this.getStorageSize(storage);
            }
        }
        return -1.0f;
    }

    public float getStorageSize(ClusterNodeType cluster) {
        StorageType storage = this.getStorage(cluster);
        if (storage != null) {
            return this.getStorageSize(storage);
        }
        return -1.0f;
    }

    private float getStorageSize(StorageType storage) {
        List<Serializable> storageProps = storage.getSizeOrTypeOrBandwidth();
        if (storageProps != null) {
            for (Serializable prop : storageProps) {
                if (!(prop instanceof Float)) continue;
                return ((Float)prop).floatValue();
            }
        }
        return -1.0f;
    }

    private StorageType getStorage(ClusterNodeType c) {
        List<Object> objList = c.getMaxNumNodesOrProcessorOrOperatingSystem();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof StorageType)) continue;
                return (StorageType)obj;
            }
        }
        return null;
    }

    public String getStorageType(DataNodeType d) {
        List<JAXBElement<?>> elements = d.getHostOrPathOrAdaptors();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("Storage"))) continue;
                StorageType storage = (StorageType)elem.getValue();
                return this.getStorageType(storage);
            }
        }
        return null;
    }

    public String getStorageType(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof StorageType)) continue;
                StorageType storage = (StorageType)obj;
                return this.getStorageType(storage);
            }
        }
        return null;
    }

    public String getStorageType(ClusterNodeType c) {
        StorageType storage = this.getStorage(c);
        if (storage != null) {
            return this.getStorageType(storage);
        }
        return null;
    }

    public String getStorageType(InstanceTypeType instance) {
        List<Object> objList = instance.getProcessorOrMemoryOrStorage();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof StorageType)) continue;
                StorageType storage = (StorageType)obj;
                return this.getStorageType(storage);
            }
        }
        return null;
    }

    private String getStorageType(StorageType storage) {
        List<Serializable> storageProps = storage.getSizeOrTypeOrBandwidth();
        if (storageProps != null) {
            for (Serializable prop : storageProps) {
                if (!(prop instanceof String)) continue;
                return (String)((Object)prop);
            }
        }
        return null;
    }

    public int getStorageBW(DataNodeType d) {
        List<JAXBElement<?>> elements = d.getHostOrPathOrAdaptors();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("Storage"))) continue;
                StorageType storage = (StorageType)elem.getValue();
                return this.getStorageBW(storage);
            }
        }
        return -1;
    }

    public int getStorageBW(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof StorageType)) continue;
                StorageType storage = (StorageType)obj;
                return this.getStorageBW(storage);
            }
        }
        return -1;
    }

    public int getStorageBW(ClusterNodeType c) {
        StorageType storage = this.getStorage(c);
        if (storage != null) {
            return this.getStorageBW(storage);
        }
        return -1;
    }

    public int getStorageBW(InstanceTypeType instance) {
        List<Object> objList = instance.getProcessorOrMemoryOrStorage();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof StorageType)) continue;
                StorageType storage = (StorageType)obj;
                return this.getStorageBW(storage);
            }
        }
        return -1;
    }

    private int getStorageBW(StorageType storage) {
        List<Serializable> storageProps = storage.getSizeOrTypeOrBandwidth();
        if (storageProps != null) {
            for (Serializable prop : storageProps) {
                if (!(prop instanceof Integer)) continue;
                return (Integer)prop;
            }
        }
        return -1;
    }

    public ComputeNodeType getComputeNode(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                ComputeNodeType cn;
                if (!(obj instanceof ComputeNodeType) || !(cn = (ComputeNodeType)obj).getName().equals(name)) continue;
                return cn;
            }
        }
        return null;
    }

    public ComputingClusterType getComputingCluster(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                ComputingClusterType cl;
                if (!(obj instanceof ComputingClusterType) || !(cl = (ComputingClusterType)obj).getName().equals(name)) continue;
                return cl;
            }
        }
        return null;
    }

    public ClusterNodeType getClusterNode(ComputingClusterType cluster, String name) {
        List<ClusterNodeType> list = cluster.getClusterNode();
        if (list == null) {
            return null;
        }
        for (ClusterNodeType node : list) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public Map<String, List<ProcessorType>> getMapProcessors(ComputingClusterType c) {
        HashMap<String, List<ProcessorType>> map = new HashMap<String, List<ProcessorType>>();
        List<ClusterNodeType> objList = c.getClusterNode();
        if (objList != null) {
            for (ClusterNodeType node : objList) {
                String clusterName = node.getName();
                map.put(clusterName, this.getProcessors(node));
            }
        }
        return map;
    }

    public List<ProcessorType> getProcessors(ComputeNodeType c) {
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ProcessorType)) continue;
                processors.add((ProcessorType)obj);
            }
        }
        return processors;
    }

    public List<ProcessorType> getProcessors(ComputingClusterType c) {
        List<ClusterNodeType> objList = c.getClusterNode();
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        if (objList != null) {
            for (ClusterNodeType node : objList) {
                processors.addAll(this.getProcessors(node));
            }
        }
        return processors;
    }

    private List<ProcessorType> getProcessors(ClusterNodeType node) {
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        List<Object> objList = node.getMaxNumNodesOrProcessorOrOperatingSystem();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ProcessorType)) continue;
                processors.add((ProcessorType)obj);
            }
        }
        return processors;
    }

    public List<ProcessorType> getProcessors(InstanceTypeType instance) {
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        List<Object> objList = instance.getProcessorOrMemoryOrStorage();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ProcessorType)) continue;
                processors.add((ProcessorType)obj);
            }
        }
        return processors;
    }

    public float getMemorySize(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof MemoryType)) continue;
                MemoryType mem = (MemoryType)obj;
                List<Serializable> memProps = mem.getSizeOrType();
                if (memProps != null) {
                    for (Serializable prop : memProps) {
                        if (!(prop instanceof Float)) continue;
                        return ((Float)prop).floatValue();
                    }
                    continue;
                }
                return -1.0f;
            }
        }
        return -1.0f;
    }

    public float getMemorySize(InstanceTypeType instance) {
        List<Object> objList = instance.getProcessorOrMemoryOrStorage();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof MemoryType)) continue;
                MemoryType mem = (MemoryType)obj;
                List<Serializable> memProps = mem.getSizeOrType();
                if (memProps != null) {
                    for (Serializable prop : memProps) {
                        if (!(prop instanceof Float)) continue;
                        return ((Float)prop).floatValue();
                    }
                    continue;
                }
                return -1.0f;
            }
        }
        return -1.0f;
    }

    public float getMemorySize(ClusterNodeType cluster) {
        List<Serializable> memProps;
        MemoryType mem = this.getMemory(cluster);
        if (mem != null && (memProps = mem.getSizeOrType()) != null) {
            for (Serializable prop : memProps) {
                if (!(prop instanceof Float)) continue;
                return ((Float)prop).floatValue();
            }
        }
        return -1.0f;
    }

    private MemoryType getMemory(ClusterNodeType cluster) {
        List<Object> objList = cluster.getMaxNumNodesOrProcessorOrOperatingSystem();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof MemoryType)) continue;
                return (MemoryType)obj;
            }
        }
        return null;
    }

    public String getMemoryType(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof MemoryType)) continue;
                MemoryType mem = (MemoryType)obj;
                List<Serializable> memProps = mem.getSizeOrType();
                if (memProps != null) {
                    for (Serializable prop : memProps) {
                        if (!(prop instanceof String)) continue;
                        return (String)((Object)prop);
                    }
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public String getMemoryType(ClusterNodeType c) {
        List<Serializable> memProps;
        MemoryType mem = this.getMemory(c);
        if (mem != null && (memProps = mem.getSizeOrType()) != null) {
            for (Serializable prop : memProps) {
                if (!(prop instanceof String)) continue;
                return (String)((Object)prop);
            }
        }
        return null;
    }

    public String getMemoryType(InstanceTypeType instance) {
        List<Object> objList = instance.getProcessorOrMemoryOrStorage();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof MemoryType)) continue;
                MemoryType mem = (MemoryType)obj;
                List<Serializable> memProps = mem.getSizeOrType();
                if (memProps != null) {
                    for (Serializable prop : memProps) {
                        if (!(prop instanceof String)) continue;
                        return (String)((Object)prop);
                    }
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public OSType getOperatingSystem(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        return this.getOperatingSystem(objList);
    }

    private OSType getOperatingSystem(List<Object> objList) {
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof OSType)) continue;
                return (OSType)obj;
            }
        }
        return null;
    }

    public OSType getOperatingSystem(ClusterNodeType c) {
        List<Object> objList = c.getMaxNumNodesOrProcessorOrOperatingSystem();
        return this.getOperatingSystem(objList);
    }

    public String getOperatingSystemType(ComputeNodeType c) {
        OSType os = this.getOperatingSystem(c);
        if (os != null) {
            return this.getOperatingSystemType(os);
        }
        return null;
    }

    public String getOperatingSystemType(ImageType image) {
        List<Object> objList = image.getAdaptorsOrOperatingSystemOrSoftware();
        OSType os = this.getOperatingSystem(objList);
        if (os != null) {
            return this.getOperatingSystemType(os);
        }
        return null;
    }

    public String getOperatingSystemType(OSType os) {
        List<JAXBElement<?>> innerElements = os.getTypeOrDistributionOrVersion();
        if (innerElements != null) {
            for (JAXBElement<?> elem : innerElements) {
                if (!elem.getName().equals(new QName("Type"))) continue;
                OSTypeType osType = (OSTypeType)((Object)elem.getValue());
                return osType.value();
            }
        }
        return null;
    }

    public String getOperatingSystemDistribution(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        OSType os = this.getOperatingSystem(objList);
        if (os != null) {
            return this.getOperatingSystemDistribution(os);
        }
        return null;
    }

    public String getOperatingSystemDistribution(ImageType image) {
        List<Object> objList = image.getAdaptorsOrOperatingSystemOrSoftware();
        OSType os = this.getOperatingSystem(objList);
        if (os != null) {
            return this.getOperatingSystemDistribution(os);
        }
        return null;
    }

    public String getOperatingSystemDistribution(OSType os) {
        List<JAXBElement<?>> innerElements = os.getTypeOrDistributionOrVersion();
        if (innerElements != null) {
            for (JAXBElement<?> elem : innerElements) {
                if (!elem.getName().equals(new QName("Distribution"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public String getOperatingSystemVersion(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        OSType os = this.getOperatingSystem(objList);
        if (os != null) {
            return this.getOperatingSystemVersion(os);
        }
        return null;
    }

    public String getOperatingSystemVersion(ClusterNodeType c) {
        OSType os = this.getOperatingSystem(c);
        if (os != null) {
            return this.getOperatingSystemVersion(os);
        }
        return null;
    }

    public String getOperatingSystemVersion(ImageType image) {
        List<Object> objList = image.getAdaptorsOrOperatingSystemOrSoftware();
        OSType os = this.getOperatingSystem(objList);
        if (os != null) {
            return this.getOperatingSystemVersion(os);
        }
        return null;
    }

    public String getOperatingSystemVersion(OSType os) {
        List<JAXBElement<?>> innerElements = os.getTypeOrDistributionOrVersion();
        if (innerElements != null) {
            for (JAXBElement<?> elem : innerElements) {
                if (!elem.getName().equals(new QName("Version"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public List<String> getApplications(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        return this.getApplications(objList);
    }

    public List<String> getApplications(ClusterNodeType c) {
        List<Object> objList = c.getMaxNumNodesOrProcessorOrOperatingSystem();
        return this.getApplications(objList);
    }

    private List<String> getApplications(List<Object> objList) {
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof SoftwareListType)) continue;
                return ((SoftwareListType)obj).getApplication();
            }
        }
        return null;
    }

    public List<String> getApplications(ImageType image) {
        List<Object> objList = image.getAdaptorsOrOperatingSystemOrSoftware();
        return this.getApplications(objList);
    }

    public PriceType getPrice(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof PriceType)) continue;
                return (PriceType)obj;
            }
        }
        return null;
    }

    public PriceType getPrice(ImageType image) {
        List<Object> objList = image.getAdaptorsOrOperatingSystemOrSoftware();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof PriceType)) continue;
                return (PriceType)obj;
            }
        }
        return null;
    }

    public PriceType getPrice(InstanceTypeType instance) {
        List<Object> objList = instance.getProcessorOrMemoryOrStorage();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof PriceType)) continue;
                return (PriceType)obj;
            }
        }
        return null;
    }

    private static AttachedDisksListType getAttachedSharedDisks(ComputeNodeType c) {
        List<Object> objList = c.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof AttachedDisksListType)) continue;
                return (AttachedDisksListType)obj;
            }
        }
        return null;
    }

    public HashMap<String, String> getSharedDisks(ComputeNodeType c) {
        AttachedDisksListType disks = ResourcesFile.getAttachedSharedDisks(c);
        if (disks != null) {
            HashMap<String, String> disksInformation = new HashMap<String, String>();
            for (AttachedDiskType disk : disks.getAttachedDisk()) {
                disksInformation.put(disk.getName(), disk.getMountPoint());
            }
            return disksInformation;
        }
        return null;
    }

    public HashMap<String, String> getSharedDisks(ComputingClusterType c) {
        HashMap<String, String> disksInformation = new HashMap<String, String>();
        AttachedDisksListType disks = c.getSharedDisks();
        if (disks != null) {
            for (AttachedDiskType disk : disks.getAttachedDisk()) {
                disksInformation.put(disk.getName(), disk.getMountPoint());
            }
        }
        if (disksInformation.isEmpty()) {
            return null;
        }
        return disksInformation;
    }

    public HashMap<String, String> getSharedDisks(ImageType image) {
        List<Object> objList = image.getAdaptorsOrOperatingSystemOrSoftware();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof AttachedDisksListType)) continue;
                List<AttachedDiskType> disks = ((AttachedDisksListType)obj).getAttachedDisk();
                if (disks != null) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    for (AttachedDiskType disk : disks) {
                        result.put(disk.getName(), disk.getMountPoint());
                    }
                    return result;
                }
                return null;
            }
        }
        return null;
    }

    public List<String> getAdaptorQueues(ComputeNodeType cn, String adaptorName) {
        ArrayList<String> adatorQueues = new ArrayList<String>();
        List<Object> objList = cn.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof AdaptorsListType)) continue;
                List<AdaptorType> adaptors = ((AdaptorsListType)obj).getAdaptor();
                if (adaptors != null) {
                    for (AdaptorType adaptor : adaptors) {
                        if (!adaptor.getName().equals(adaptorName)) continue;
                        return this.getAdaptorQueues(adaptor);
                    }
                    continue;
                }
                return adatorQueues;
            }
        }
        return adatorQueues;
    }

    public List<String> getAdaptorQueues(ImageType image, String adaptorName) {
        ArrayList<String> adaptorQueues = new ArrayList<String>();
        AdaptorType adaptor = this.getAdaptor(image, adaptorName);
        if (adaptor != null) {
            return this.getAdaptorQueues(adaptor);
        }
        return adaptorQueues;
    }

    public List<String> getAdaptorQueues(AdaptorType adaptor) {
        ArrayList<String> adaptorQueues = new ArrayList<String>();
        List<JAXBElement<?>> innerElements = adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor();
        if (innerElements != null) {
            for (JAXBElement<?> adaptorElement : innerElements) {
                if (!adaptorElement.getName().equals(new QName("SubmissionSystem"))) continue;
                SubmissionSystemType subSys = (SubmissionSystemType)adaptorElement.getValue();
                List<Object> subSysTypes = subSys.getBatchOrInteractive();
                if (subSysTypes != null) {
                    for (Object subSysType : subSysTypes) {
                        if (!(subSysType instanceof BatchType)) continue;
                        List<String> queues = ((BatchType)subSysType).getQueue();
                        if (queues != null) {
                            return queues;
                        }
                        return adaptorQueues;
                    }
                    continue;
                }
                return adaptorQueues;
            }
        }
        return adaptorQueues;
    }

    public AdaptorType getAdaptor(ComputeNodeType cn, String adaptorName) {
        List<Object> objList = cn.getProcessorOrAdaptorsOrMemory();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof AdaptorsListType)) continue;
                List<AdaptorType> adaptors = ((AdaptorsListType)obj).getAdaptor();
                if (adaptors != null) {
                    for (AdaptorType adaptor : adaptors) {
                        if (!adaptor.getName().equals(adaptorName)) continue;
                        return adaptor;
                    }
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public AdaptorType getAdaptor(ImageType im, String adaptorName) {
        List<Object> objList = im.getAdaptorsOrOperatingSystemOrSoftware();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof AdaptorsListType)) continue;
                List<AdaptorType> adaptors = ((AdaptorsListType)obj).getAdaptor();
                if (adaptors != null) {
                    for (AdaptorType adaptor : adaptors) {
                        if (!adaptor.getName().equals(adaptorName)) continue;
                        return adaptor;
                    }
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public Map<String, Object> getAdaptorProperties(ComputeNodeType cn, String adaptorName) {
        AdaptorType adaptor = this.getAdaptor(cn, adaptorName);
        if (adaptor != null) {
            return this.getAdaptorProperties(adaptor);
        }
        return null;
    }

    public Map<String, Object> getAdaptorProperties(ComputingClusterType cluster, String adaptorName) {
        if (cluster.getAdaptors() == null) {
            return null;
        }
        for (AdaptorType adaptor : cluster.getAdaptors().getAdaptor()) {
            if (!adaptor.getName().equals(adaptorName)) continue;
            return this.getAdaptorProperties(adaptor);
        }
        return null;
    }

    public Map<String, Object> getAdaptorProperties(ImageType image, String adaptorName) {
        AdaptorType adaptor = this.getAdaptor(image, adaptorName);
        if (adaptor != null) {
            return this.getAdaptorProperties(adaptor);
        }
        return null;
    }

    public Map<String, Object> getAdaptorProperties(AdaptorType adaptor) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        List<JAXBElement<?>> innerElements = adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor();
        if (innerElements != null) {
            for (JAXBElement<?> adaptorElement : innerElements) {
                if (!adaptorElement.getName().equals(new QName("Ports")) && !adaptorElement.getName().equals(new QName("BrokerAdaptor")) && !adaptorElement.getName().equals(new QName("Properties"))) continue;
                properties.put(adaptorElement.getName().getLocalPart(), adaptorElement.getValue());
            }
        }
        return properties;
    }

    public ServiceType getService(String wsdl) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                ServiceType s;
                if (!(obj instanceof ServiceType) || !(s = (ServiceType)obj).getWsdl().equals(wsdl)) continue;
                return s;
            }
        }
        return null;
    }

    public HttpType getHttpService(String baseUrl) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                HttpType s;
                if (!(obj instanceof HttpType) || !(s = (HttpType)obj).getBaseUrl().equals(baseUrl)) continue;
                return s;
            }
        }
        return null;
    }

    public CloudProviderType getCloudProvider(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                CloudProviderType cp;
                if (!(obj instanceof CloudProviderType) || !(cp = (CloudProviderType)obj).getName().equals(name)) continue;
                return cp;
            }
        }
        return null;
    }

    public InstanceTypeType getInstance(CloudProviderType cp, String instanceName) {
        InstanceTypesType instances = cp.getInstanceTypes();
        if (instances != null) {
            for (InstanceTypeType instance : instances.getInstanceType()) {
                if (!instance.getName().equals(instanceName)) continue;
                return instance;
            }
        }
        return null;
    }

    public ImageType getImage(CloudProviderType cp, String imageName) {
        ImagesType images = cp.getImages();
        if (images != null) {
            for (ImageType image : images.getImage()) {
                if (!image.getName().equals(imageName)) continue;
                return image;
            }
        }
        return null;
    }

    public String getConnectorMainClass(EndpointType endpoint) {
        List<JAXBElement<String>> elements = endpoint.getServerOrConnectorJarOrConnectorClass();
        if (elements != null) {
            for (JAXBElement<String> elem : elements) {
                if (!elem.getName().equals(new QName("ConnectorClass"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public String getConnectorJarPath(EndpointType endpoint) {
        List<JAXBElement<String>> elements = endpoint.getServerOrConnectorJarOrConnectorClass();
        if (elements != null) {
            for (JAXBElement<String> elem : elements) {
                if (!elem.getName().equals(new QName("ConnectorJar"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public String getServer(EndpointType endpoint) {
        List<JAXBElement<String>> elements = endpoint.getServerOrConnectorJarOrConnectorClass();
        if (elements != null) {
            for (JAXBElement<String> elem : elements) {
                if (!elem.getName().equals(new QName("Server"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public String getPort(EndpointType endpoint) {
        List<JAXBElement<String>> elements = endpoint.getServerOrConnectorJarOrConnectorClass();
        if (elements != null) {
            for (JAXBElement<String> elem : elements) {
                if (!elem.getName().equals(new QName("Port"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public int getCreationTime(ImageType image) {
        List<Object> objList = image.getAdaptorsOrOperatingSystemOrSoftware();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof Integer)) continue;
                return (Integer)obj;
            }
        }
        return -1;
    }

    public SharedDiskType addSharedDisk(SharedDiskType sd) throws InvalidElementException {
        this.validator.validateSharedDisk(sd);
        this.resources.getSharedDiskOrDataNodeOrComputeNode().add(sd);
        return sd;
    }

    public SharedDiskType addSharedDisk(String name) throws InvalidElementException {
        SharedDiskType sd = new SharedDiskType();
        sd.setName(name);
        sd.setStorage(null);
        return this.addSharedDisk(sd);
    }

    public SharedDiskType addSharedDisk(String name, StorageType storage) throws InvalidElementException {
        SharedDiskType sd = new SharedDiskType();
        sd.setName(name);
        sd.setStorage(storage);
        return this.addSharedDisk(sd);
    }

    public DataNodeType addDataNode(DataNodeType dn) throws InvalidElementException {
        this.validator.validateDataNode(dn);
        this.resources.getSharedDiskOrDataNodeOrComputeNode().add(dn);
        return dn;
    }

    public DataNodeType addDataNode(String name, String host, String path, AdaptorsListType adaptors) throws InvalidElementException {
        return this.addDataNode(name, host, path, adaptors, null, (AttachedDisksListType)null);
    }

    public DataNodeType addDataNode(String name, String host, String path, List<AdaptorType> adaptors) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        return this.addDataNode(name, host, path, adaptorsList, null, (AttachedDisksListType)null);
    }

    public DataNodeType addDataNode(String name, String host, String path, List<AdaptorType> adaptors, StorageType storage, AttachedDisksListType sharedDisks) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        return this.addDataNode(name, host, path, adaptorsList, storage, sharedDisks);
    }

    public DataNodeType addDataNode(String name, String host, String path, AdaptorsListType adaptors, StorageType storage, List<AttachedDiskType> sharedDisks) throws InvalidElementException {
        AttachedDisksListType sharedDisksList = new AttachedDisksListType();
        if (sharedDisks != null) {
            for (AttachedDiskType d : sharedDisks) {
                sharedDisksList.getAttachedDisk().add(d);
            }
        }
        return this.addDataNode(name, host, path, adaptors, storage, sharedDisksList);
    }

    public DataNodeType addDataNode(String name, String host, String path, List<AdaptorType> adaptors, StorageType storage, List<AttachedDiskType> sharedDisks) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        AttachedDisksListType sharedDisksList = new AttachedDisksListType();
        if (sharedDisks != null) {
            for (AttachedDiskType d : sharedDisks) {
                sharedDisksList.getAttachedDisk().add(d);
            }
        }
        return this.addDataNode(name, host, path, adaptorsList, storage, sharedDisksList);
    }

    public DataNodeType addDataNode(String name, String host, String path, AdaptorsListType adaptors, StorageType storage, AttachedDisksListType sharedDisks) throws InvalidElementException {
        DataNodeType dn = new DataNodeType();
        dn.setName(name);
        JAXBElement hostElement = new JAXBElement(new QName("Host"), String.class, (Object)host);
        dn.getHostOrPathOrAdaptors().add(hostElement);
        JAXBElement pathElement = new JAXBElement(new QName("Path"), String.class, (Object)path);
        dn.getHostOrPathOrAdaptors().add(pathElement);
        JAXBElement adaptorsElement = new JAXBElement(new QName("Adaptors"), AdaptorsListType.class, (Object)adaptors);
        dn.getHostOrPathOrAdaptors().add(adaptorsElement);
        if (storage != null) {
            JAXBElement storageElement = new JAXBElement(new QName("Storage"), StorageType.class, (Object)storage);
            dn.getHostOrPathOrAdaptors().add(storageElement);
        }
        if (sharedDisks != null) {
            JAXBElement sdsElement = new JAXBElement(new QName("SharedDisks"), AttachedDisksListType.class, (Object)sharedDisks);
            dn.getHostOrPathOrAdaptors().add(sdsElement);
        }
        return this.addDataNode(dn);
    }

    public ComputeNodeType addComputeNode(ComputeNodeType cn) throws InvalidElementException {
        this.validator.validateComputeNode(cn);
        this.resources.getSharedDiskOrDataNodeOrComputeNode().add(cn);
        return cn;
    }

    public ComputeNodeType addComputeNode(String name, List<ProcessorType> processors, AdaptorsListType adaptors) throws InvalidElementException {
        return this.addComputeNode(name, processors, adaptors, null, null, null, (SoftwareListType)null, (AttachedDisksListType)null, null);
    }

    public ComputeNodeType addComputeNode(String name, List<ProcessorType> processors, List<AdaptorType> adaptors) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        return this.addComputeNode(name, processors, adaptorsList, null, null, null, (SoftwareListType)null, (AttachedDisksListType)null, null);
    }

    public ComputeNodeType addComputeNode(String name, ProcessorType processor, AdaptorType adaptor) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        adaptorsList.getAdaptor().add(adaptor);
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        processors.add(processor);
        return this.addComputeNode(name, processors, adaptorsList, null, null, null, (SoftwareListType)null, (AttachedDisksListType)null, null);
    }

    public ComputeNodeType addComputeNode(String name, List<ProcessorType> processors, AdaptorsListType adaptors, MemoryType memory, StorageType storage, OSType os, List<String> applications, AttachedDisksListType sharedDisks, PriceType price) throws InvalidElementException {
        SoftwareListType software = new SoftwareListType();
        if (applications != null) {
            for (String app : applications) {
                software.getApplication().add(app);
            }
        }
        return this.addComputeNode(name, processors, adaptors, memory, storage, os, software, sharedDisks, price);
    }

    public ComputeNodeType addComputeNode(String name, List<ProcessorType> processors, AdaptorsListType adaptors, MemoryType memory, StorageType storage, OSType os, SoftwareListType software, List<AttachedDiskType> sharedDisks, PriceType price) throws InvalidElementException {
        AttachedDisksListType sharedDisksList = new AttachedDisksListType();
        if (sharedDisks != null) {
            for (AttachedDiskType d : sharedDisks) {
                sharedDisksList.getAttachedDisk().add(d);
            }
        }
        return this.addComputeNode(name, processors, adaptors, memory, storage, os, software, sharedDisksList, price);
    }

    /*
     * WARNING - void declaration
     */
    public ComputeNodeType addComputeNode(String name, List<ProcessorType> processors, List<AdaptorType> adaptors, MemoryType memory, StorageType storage, OSType os, List<String> applications, List<AttachedDiskType> sharedDisks, PriceType price) throws InvalidElementException {
        void var12_17;
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType adaptorType : adaptors) {
                adaptorsList.getAdaptor().add(adaptorType);
            }
        }
        SoftwareListType software = null;
        if (applications != null) {
            software = new SoftwareListType();
            for (String app : applications) {
                software.getApplication().add(app);
            }
        }
        Object var12_15 = null;
        if (sharedDisks != null) {
            AttachedDisksListType attachedDisksListType = new AttachedDisksListType();
            for (AttachedDiskType d : sharedDisks) {
                attachedDisksListType.getAttachedDisk().add(d);
            }
        }
        return this.addComputeNode(name, processors, adaptorsList, memory, storage, os, software, (AttachedDisksListType)var12_17, price);
    }

    public ComputeNodeType addComputeNode(String name, List<ProcessorType> processors, AdaptorsListType adaptors, MemoryType memory, StorageType storage, OSType os, SoftwareListType software, AttachedDisksListType sharedDisks, PriceType price) throws InvalidElementException {
        ComputeNodeType cn = new ComputeNodeType();
        cn.setName(name);
        if (processors != null) {
            for (ProcessorType p : processors) {
                cn.getProcessorOrAdaptorsOrMemory().add(p);
            }
        }
        cn.getProcessorOrAdaptorsOrMemory().add(adaptors);
        if (memory != null) {
            cn.getProcessorOrAdaptorsOrMemory().add(memory);
        }
        if (storage != null) {
            cn.getProcessorOrAdaptorsOrMemory().add(storage);
        }
        if (os != null) {
            cn.getProcessorOrAdaptorsOrMemory().add(os);
        }
        if (software != null) {
            cn.getProcessorOrAdaptorsOrMemory().add(software);
        }
        if (sharedDisks != null) {
            cn.getProcessorOrAdaptorsOrMemory().add(sharedDisks);
        }
        if (price != null) {
            cn.getProcessorOrAdaptorsOrMemory().add(price);
        }
        return this.addComputeNode(cn);
    }

    public ComputeNodeType addComputeNode(String name, List<ProcessorType> processors, List<AdaptorType> adaptors, float memorySize, float diskSize, String osName) throws InvalidElementException {
        ComputeNodeType cn = new ComputeNodeType();
        cn.setName(name);
        if (processors != null) {
            for (ProcessorType processorType : processors) {
                cn.getProcessorOrAdaptorsOrMemory().add(processorType);
            }
        }
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        cn.getProcessorOrAdaptorsOrMemory().add(adaptorsList);
        if (memorySize > 0.0f) {
            MemoryType memoryType = ResourcesFile.createMemory(memorySize, null);
            cn.getProcessorOrAdaptorsOrMemory().add(memoryType);
        }
        if (diskSize > 0.0f) {
            StorageType storageType = ResourcesFile.createStorage(diskSize, null, -1);
            cn.getProcessorOrAdaptorsOrMemory().add(storageType);
        }
        if (osName != null && !osName.isEmpty()) {
            OSType oSType = ResourcesFile.createOperatingSystem(osName, null, null);
            cn.getProcessorOrAdaptorsOrMemory().add(oSType);
        }
        return this.addComputeNode(cn);
    }

    public ComputeNodeType addComputeNode(String name, String procName, int procCU, String procArch, float procSpeed, String procType, float procMemSize, ProcessorPropertyType procProp, String adaptorName, int maxPort, int minPort, String executor, String user, float memorySize, String memoryType, float storageSize, String storageType, int storageBW, String osType, String osDistribution, String osVersion) throws InvalidElementException {
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        ProcessorType pr = ResourcesFile.createProcessor(procName, procCU, procArch, procSpeed, procType, procMemSize, procProp);
        processors.add(pr);
        ResourcesNIOAdaptorProperties nioProp = new ResourcesNIOAdaptorProperties();
        nioProp.setMaxPort(maxPort);
        nioProp.setMinPort(minPort);
        nioProp.setRemoteExecutionCommand(executor);
        ArrayList<AdaptorType> adaptors = new ArrayList<AdaptorType>();
        AdaptorType adaptor = ResourcesFile.createAdaptor(adaptorName, false, null, true, nioProp, user);
        adaptors.add(adaptor);
        MemoryType mem = ResourcesFile.createMemory(memorySize, memoryType);
        StorageType storage = ResourcesFile.createStorage(storageSize, storageType, storageBW);
        OSType os = ResourcesFile.createOperatingSystem(osType, osDistribution, osVersion);
        return this.addComputeNode(name, processors, adaptors, mem, storage, os, null, null, null);
    }

    public ComputeNodeType addComputeNode(String name, String procName, int procCU, String adaptorName, int maxPort, int minPort) throws InvalidElementException {
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        ProcessorType pr = ResourcesFile.createProcessor(procName, procCU);
        processors.add(pr);
        ArrayList<AdaptorType> adaptors = new ArrayList<AdaptorType>();
        ResourcesNIOAdaptorProperties nioProp = new ResourcesNIOAdaptorProperties();
        nioProp.setMaxPort(maxPort);
        nioProp.setMinPort(minPort);
        AdaptorType adaptor = ResourcesFile.createAdaptor(adaptorName, false, null, true, nioProp, null);
        adaptors.add(adaptor);
        return this.addComputeNode(name, processors, adaptors, null, null, null, null, null, null);
    }

    public ComputeNodeType addComputeNode(String name, String procName, int procCU, String procArch, float procSpeed, String procType, float procMemSize, ProcessorPropertyType procProp, String adaptorName, boolean batch, List<String> queues, boolean interactive, String brokerAdaptor, String user, float memorySize, String memoryType, float storageSize, String storageType, int storageBW, String osType, String osDistribution, String osVersion) throws InvalidElementException {
        ArrayList<ProcessorType> processors = new ArrayList<ProcessorType>();
        ProcessorType pr = ResourcesFile.createProcessor(procName, procCU, procArch, procSpeed, procType, procMemSize, procProp);
        processors.add(pr);
        MemoryType mem = ResourcesFile.createMemory(memorySize, memoryType);
        StorageType storage = ResourcesFile.createStorage(storageSize, storageType, storageBW);
        OSType os = ResourcesFile.createOperatingSystem(osType, osDistribution, osVersion);
        ArrayList<AdaptorType> adaptors = new ArrayList<AdaptorType>();
        AdaptorType adaptor = ResourcesFile.createAdaptor(adaptorName, batch, queues, interactive, brokerAdaptor, user);
        adaptors.add(adaptor);
        return this.addComputeNode(name, processors, adaptors, mem, storage, os, null, null, null);
    }

    public ServiceType addService(ServiceType s) throws InvalidElementException {
        this.validator.validateService(s);
        this.resources.getSharedDiskOrDataNodeOrComputeNode().add(s);
        return s;
    }

    public ServiceType addService(String wsdl, String name, String namespace, String port) throws InvalidElementException {
        return this.addService(wsdl, name, namespace, port, null);
    }

    public ServiceType addService(String wsdl, String name, String namespace, String port, PriceType price) throws InvalidElementException {
        ServiceType s = new ServiceType();
        s.setWsdl(wsdl);
        s.setName(name);
        s.setNamespace(namespace);
        s.setPort(port);
        if (price != null) {
            s.setPrice(price);
        }
        return this.addService(s);
    }

    public CloudProviderType addCloudProvider(CloudProviderType cp) throws InvalidElementException {
        this.validator.validateCloudProvider(cp);
        this.resources.getSharedDiskOrDataNodeOrComputeNode().add(cp);
        return cp;
    }

    public CloudProviderType addCloudProvider(String name, EndpointType endpoint, ImagesType images, InstanceTypesType instances) throws InvalidElementException {
        CloudProviderType cp = new CloudProviderType();
        cp.setName(name);
        cp.setEndpoint(endpoint);
        cp.setImages(images);
        cp.setInstanceTypes(instances);
        return this.addCloudProvider(cp);
    }

    public CloudProviderType addCloudProvider(String name, EndpointType endpoint, List<ImageType> images, List<InstanceTypeType> instances) throws InvalidElementException {
        ImagesType imagesList = new ImagesType();
        if (images != null) {
            for (ImageType im : images) {
                imagesList.getImage().add(im);
            }
        }
        InstanceTypesType instancesList = new InstanceTypesType();
        if (instances != null) {
            for (InstanceTypeType ins : instances) {
                instancesList.getInstanceType().add(ins);
            }
        }
        return this.addCloudProvider(name, endpoint, imagesList, instancesList);
    }

    public CloudProviderType addCloudProvider(String name, String server, String connectorJar, String connectorClass, List<ImageType> images, List<InstanceTypeType> instances) throws InvalidElementException {
        EndpointType endpoint = new EndpointType();
        JAXBElement serverElement = new JAXBElement(new QName("Server"), String.class, (Object)server);
        endpoint.getServerOrConnectorJarOrConnectorClass().add((JAXBElement<String>)serverElement);
        JAXBElement connectorClassElement = new JAXBElement(new QName("ConnectorClass"), String.class, (Object)connectorClass);
        JAXBElement connectorJarElement = new JAXBElement(new QName("ConnectorJar"), String.class, (Object)connectorJar);
        endpoint.getServerOrConnectorJarOrConnectorClass().add((JAXBElement<String>)connectorClassElement);
        endpoint.getServerOrConnectorJarOrConnectorClass().add((JAXBElement<String>)connectorJarElement);
        ImagesType imagesList = new ImagesType();
        if (images != null) {
            for (ImageType im : images) {
                imagesList.getImage().add(im);
            }
        }
        InstanceTypesType instancesList = new InstanceTypesType();
        if (instances != null) {
            for (InstanceTypeType ins : instances) {
                instancesList.getInstanceType().add(ins);
            }
        }
        return this.addCloudProvider(name, endpoint, imagesList, instancesList);
    }

    public static ProcessorType createProcessor(String name, int cu, String procArchitecture, float procSpeed, String type, float internalMemory, ProcessorPropertyType procProperties) {
        JAXBElement typeElement;
        ProcessorType processor = new ProcessorType();
        processor.setName(name);
        JAXBElement cuElement = new JAXBElement(new QName("ComputingUnits"), Integer.class, (Object)cu);
        processor.getComputingUnitsOrArchitectureOrSpeed().add(cuElement);
        if (procArchitecture != null) {
            JAXBElement archElement = new JAXBElement(new QName("Architecture"), String.class, (Object)procArchitecture);
            processor.getComputingUnitsOrArchitectureOrSpeed().add(archElement);
        }
        if (procSpeed > 0.0f) {
            JAXBElement speedElement = new JAXBElement(new QName("Speed"), Float.class, (Object)Float.valueOf(procSpeed));
            processor.getComputingUnitsOrArchitectureOrSpeed().add(speedElement);
        }
        if (type != null) {
            typeElement = new JAXBElement(new QName("Type"), String.class, (Object)type);
            processor.getComputingUnitsOrArchitectureOrSpeed().add(typeElement);
        } else {
            typeElement = new JAXBElement(new QName("Type"), String.class, (Object)"CPU");
            processor.getComputingUnitsOrArchitectureOrSpeed().add(typeElement);
        }
        if (internalMemory > 0.0f) {
            JAXBElement memElement = new JAXBElement(new QName("InternalMemorySize"), Float.class, (Object)Float.valueOf(internalMemory));
            processor.getComputingUnitsOrArchitectureOrSpeed().add(memElement);
        }
        if (procProperties != null) {
            JAXBElement propElement = new JAXBElement(new QName("ProcessorProperty"), ProcessorPropertyType.class, (Object)procProperties);
            processor.getComputingUnitsOrArchitectureOrSpeed().add(propElement);
        }
        return processor;
    }

    public static ProcessorType createProcessor(String name, int cu) {
        return ResourcesFile.createProcessor(name, cu, null, 0.0f, null, 0.0f, null);
    }

    public static ProcessorPropertyType createProcessorProperty(String key, String value) {
        ProcessorPropertyType prop = new ProcessorPropertyType();
        prop.setKey(key);
        prop.setValue(value);
        return prop;
    }

    public static MemoryType createMemory(float memorySize, String type) {
        MemoryType mem = new MemoryType();
        mem.getSizeOrType().add(new Float(memorySize));
        if (type != null) {
            mem.getSizeOrType().add((Serializable)((Object)type));
        }
        return mem;
    }

    public static StorageType createStorage(float storageSize, String type, int storageBW) {
        StorageType storage = new StorageType();
        storage.getSizeOrTypeOrBandwidth().add(new Float(storageSize));
        if (type != null) {
            storage.getSizeOrTypeOrBandwidth().add((Serializable)((Object)type));
        }
        if (storageBW != -1) {
            storage.getSizeOrTypeOrBandwidth().add(Integer.valueOf(storageBW));
        }
        return storage;
    }

    public static OSType createOperatingSystem(String osType, String osDistribution, String osVersion) {
        OSType os = new OSType();
        OSTypeType osTypeType = OSTypeType.fromValue(osType);
        JAXBElement typeElement = new JAXBElement(new QName("Type"), OSTypeType.class, (Object)osTypeType);
        os.getTypeOrDistributionOrVersion().add(typeElement);
        if (osDistribution != null) {
            JAXBElement distElement = new JAXBElement(new QName("Distribution"), String.class, (Object)osDistribution);
            os.getTypeOrDistributionOrVersion().add(distElement);
        }
        if (osVersion != null) {
            JAXBElement verElement = new JAXBElement(new QName("Version"), String.class, (Object)osVersion);
            os.getTypeOrDistributionOrVersion().add(verElement);
        }
        return os;
    }

    public static ImageType createImage(String name, String adaptorName, boolean batch, List<String> queues, boolean interactive, String brokerAdaptor, String user, String osType, String osDistribution, String osVersion) {
        ImageType image = new ImageType();
        image.setName(name);
        AdaptorsListType adaptorsList = new AdaptorsListType();
        AdaptorType adaptor = ResourcesFile.createAdaptor(adaptorName, batch, queues, interactive, brokerAdaptor, user);
        adaptorsList.getAdaptor().add(adaptor);
        image.getAdaptorsOrOperatingSystemOrSoftware().add(adaptorsList);
        OSType os = ResourcesFile.createOperatingSystem(osType, osDistribution, osVersion);
        image.getAdaptorsOrOperatingSystemOrSoftware().add(os);
        return image;
    }

    public static ImageType createImage(String name, String adaptorName, int maxPort, int minPort, String executor, String user, String osType, String osDistribution, String osVersion) {
        ImageType image = new ImageType();
        image.setName(name);
        ResourcesNIOAdaptorProperties nioProp = new ResourcesNIOAdaptorProperties();
        nioProp.setMaxPort(maxPort);
        nioProp.setMinPort(minPort);
        nioProp.setRemoteExecutionCommand(executor);
        AdaptorsListType adaptorsList = new AdaptorsListType();
        AdaptorType adaptor = ResourcesFile.createAdaptor(adaptorName, false, null, true, nioProp, user);
        adaptorsList.getAdaptor().add(adaptor);
        image.getAdaptorsOrOperatingSystemOrSoftware().add(adaptorsList);
        OSType os = ResourcesFile.createOperatingSystem(osType, osDistribution, osVersion);
        image.getAdaptorsOrOperatingSystemOrSoftware().add(os);
        return image;
    }

    public static ImageType createImage(String name, String adaptorName, int maxPort, int minPort) {
        ImageType image = new ImageType();
        image.setName(name);
        AdaptorsListType adaptorsList = new AdaptorsListType();
        ResourcesNIOAdaptorProperties nioProp = new ResourcesNIOAdaptorProperties();
        nioProp.setMaxPort(maxPort);
        nioProp.setMinPort(minPort);
        AdaptorType adaptor = ResourcesFile.createAdaptor(adaptorName, false, null, true, nioProp, null);
        adaptorsList.getAdaptor().add(adaptor);
        image.getAdaptorsOrOperatingSystemOrSoftware().add(adaptorsList);
        return image;
    }

    public static InstanceTypeType createInstance(String name, String procName, int procCU, float memorySize, float storageSize) {
        return ResourcesFile.createInstance(name, procName, procCU, null, 0.0f, null, 0.0f, null, memorySize, null, storageSize, null, -1);
    }

    public static InstanceTypeType createInstance(String name, String procName, int procCU, String procArch, float procSpeed, String procType, float procMemSize, ProcessorPropertyType procProp, float memorySize, String memoryType, float storageSize, String storageType, int storageBW) {
        InstanceTypeType instance = new InstanceTypeType();
        instance.setName(name);
        ProcessorType pr = ResourcesFile.createProcessor(procName, procCU, procArch, procSpeed, procType, procMemSize, procProp);
        instance.getProcessorOrMemoryOrStorage().add(pr);
        MemoryType mem = ResourcesFile.createMemory(memorySize, memoryType);
        instance.getProcessorOrMemoryOrStorage().add(mem);
        StorageType storage = ResourcesFile.createStorage(storageSize, storageType, storageBW);
        instance.getProcessorOrMemoryOrStorage().add(storage);
        return instance;
    }

    public static EndpointType createEndpoint(String server, String connectorClass, String connectorJar, String port) {
        EndpointType endPoint = new EndpointType();
        JAXBElement serverElement = new JAXBElement(new QName("Server"), String.class, (Object)server);
        endPoint.getServerOrConnectorJarOrConnectorClass().add((JAXBElement<String>)serverElement);
        JAXBElement connectorClassElement = new JAXBElement(new QName("ConnectorClass"), String.class, (Object)connectorClass);
        endPoint.getServerOrConnectorJarOrConnectorClass().add((JAXBElement<String>)connectorClassElement);
        JAXBElement connectorJarElement = new JAXBElement(new QName("ConnectorJar"), String.class, (Object)connectorJar);
        endPoint.getServerOrConnectorJarOrConnectorClass().add((JAXBElement<String>)connectorJarElement);
        if (port != null) {
            JAXBElement portElement = new JAXBElement(new QName("Port"), String.class, (Object)port);
            endPoint.getServerOrConnectorJarOrConnectorClass().add((JAXBElement<String>)portElement);
        }
        return endPoint;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, ResourcesNIOAdaptorProperties nioproperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement subsysElement = new JAXBElement(new QName("SubmissionSystem"), SubmissionSystemType.class, (Object)subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        JAXBElement propertiesElement = new JAXBElement(new QName("Ports"), ResourcesNIOAdaptorProperties.class, (Object)nioproperties);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement userElement = new JAXBElement(new QName("User"), String.class, (Object)user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, String gatproperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement subsysElement = new JAXBElement(new QName("SubmissionSystem"), SubmissionSystemType.class, (Object)subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        JAXBElement propertiesElement = new JAXBElement(new QName("BrokerAdaptor"), String.class, (Object)gatproperties);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement userElement = new JAXBElement(new QName("User"), String.class, (Object)user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, ResourcesExternalAdaptorProperties externalproperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement subsysElement = new JAXBElement(new QName("SubmissionSystem"), SubmissionSystemType.class, (Object)subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        JAXBElement propertiesElement = new JAXBElement(new QName("Properties"), ResourcesExternalAdaptorProperties.class, (Object)externalproperties);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement userElement = new JAXBElement(new QName("User"), String.class, (Object)user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, List<ResourcesPropertyAdaptorType> externalProperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement subsysElement = new JAXBElement(new QName("SubmissionSystem"), SubmissionSystemType.class, (Object)subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        ResourcesExternalAdaptorProperties externalpropertiesList = new ResourcesExternalAdaptorProperties();
        if (externalProperties != null) {
            for (ResourcesPropertyAdaptorType pa : externalProperties) {
                externalpropertiesList.getProperty().add(pa);
            }
        }
        JAXBElement propertiesElement = new JAXBElement(new QName("Properties"), ResourcesExternalAdaptorProperties.class, (Object)externalpropertiesList);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement userElement = new JAXBElement(new QName("User"), String.class, (Object)user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, ResourcesNIOAdaptorProperties nioproperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            subsys.getBatchOrInteractive().add(b);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            subsys.getBatchOrInteractive().add(i);
        }
        return ResourcesFile.createAdaptor(name, subsys, nioproperties, user);
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, String gatproperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            subsys.getBatchOrInteractive().add(b);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            subsys.getBatchOrInteractive().add(i);
        }
        return ResourcesFile.createAdaptor(name, subsys, gatproperties, user);
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, ResourcesExternalAdaptorProperties externalProperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            subsys.getBatchOrInteractive().add(b);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            subsys.getBatchOrInteractive().add(i);
        }
        return ResourcesFile.createAdaptor(name, subsys, externalProperties, user);
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, List<ResourcesPropertyAdaptorType> externalProperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            subsys.getBatchOrInteractive().add(b);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            subsys.getBatchOrInteractive().add(i);
        }
        return ResourcesFile.createAdaptor(name, subsys, externalProperties, user);
    }

    public boolean addImageToCloudProvider(String cloudProviderName, ImageType image) {
        CloudProviderType cp = this.getCloudProvider(cloudProviderName);
        if (cp != null) {
            cp.getImages().getImage().add(image);
            return true;
        }
        return false;
    }

    public boolean addInstanceToCloudProvider(String cloudProviderName, InstanceTypeType instance) {
        CloudProviderType cp = this.getCloudProvider(cloudProviderName);
        if (cp != null) {
            cp.getInstanceTypes().getInstanceType().add(instance);
            return true;
        }
        return false;
    }

    public void attachSharedDiskToComputeNode(String diskName, String cnName, String mountPoint) throws InvalidElementException {
        AttachedDisksListType disks;
        ComputeNodeType cn = this.getComputeNode(cnName);
        if (cn != null) {
            disks = ResourcesFile.getAttachedSharedDisks(cn);
            if (disks == null) {
                disks = new AttachedDisksListType();
                cn.getProcessorOrAdaptorsOrMemory().add(disks);
            }
        } else {
            throw new InvalidElementException("ComputeNodeType", cnName, "Not found");
        }
        AttachedDiskType d = new AttachedDiskType();
        d.setName(diskName);
        d.setMountPoint(mountPoint);
        disks.getAttachedDisk().add(d);
    }

    public void detachSharedDiskToComputeNode(String diskName, String cnName) throws InvalidElementException {
        ComputeNodeType cn = this.getComputeNode(cnName);
        if (cn != null) {
            AttachedDisksListType disks = ResourcesFile.getAttachedSharedDisks(cn);
            if (disks != null) {
                for (int i = 0; i < disks.getAttachedDisk().size(); ++i) {
                    if (!disks.getAttachedDisk().get(i).getName().equals(diskName)) continue;
                    disks.getAttachedDisk().remove(i);
                    return;
                }
                throw new InvalidElementException("AttachedDisksType", diskName, "Not found");
            }
            throw new InvalidElementException("AttachedDisksListType", "none", "Not found");
        }
        throw new InvalidElementException("ComputeNodeType", cnName, "Not found");
    }

    public int getProcessorComputingUnits(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("ComputingUnits"))) continue;
                return (Integer)obj.getValue();
            }
        }
        return -1;
    }

    public String getProcessorArchitecture(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Architecture"))) continue;
                return (String)obj.getValue();
            }
        }
        return null;
    }

    public float getProcessorSpeed(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Speed"))) continue;
                return ((Float)obj.getValue()).floatValue();
            }
        }
        return -1.0f;
    }

    public String getProcessorType(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Type"))) continue;
                return (String)obj.getValue();
            }
        }
        return null;
    }

    public float getProcessorMemorySize(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("InternalMemorySize"))) continue;
                return ((Float)obj.getValue()).floatValue();
            }
        }
        return -1.0f;
    }

    public ProcessorPropertyType getProcessorProperty(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("ProcessorProperty"))) continue;
                return (ProcessorPropertyType)obj.getValue();
            }
        }
        return null;
    }

    public boolean deleteSharedDisk(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                SharedDiskType sd;
                Object obj = objList.get(i);
                if (!(obj instanceof SharedDiskType) || !(sd = (SharedDiskType)obj).getName().equals(name)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteDataNode(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                DataNodeType dn;
                Object obj = objList.get(i);
                if (!(obj instanceof DataNodeType) || !(dn = (DataNodeType)obj).getName().equals(name)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteComputeNode(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                ComputeNodeType cn;
                Object obj = objList.get(i);
                if (!(obj instanceof ComputeNodeType) || !(cn = (ComputeNodeType)obj).getName().equals(name)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteService(String wsdl) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                ServiceType s;
                Object obj = objList.get(i);
                if (!(obj instanceof ServiceType) || !(s = (ServiceType)obj).getWsdl().equals(wsdl)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteCloudProvider(String name) {
        List<Object> objList = this.resources.getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                CloudProviderType cp;
                Object obj = objList.get(i);
                if (!(obj instanceof CloudProviderType) || !(cp = (CloudProviderType)obj).getName().equals(name)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }
}

