/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.allocatableactions;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.HTTPImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class StartWorkerAction<T extends WorkerResourceDescription>
extends AllocatableAction {
    private final ResourceScheduler<T> worker;
    private final Implementation impl;
    private final TaskScheduler ts;
    private static final boolean STOP_EXEC_IN_NODE_FAIL = Boolean.parseBoolean(System.getProperty("compss.shutdown_in_node_failure"));

    public StartWorkerAction(SchedulingInformation schedulingInformation, ResourceScheduler<T> worker, TaskScheduler ts) {
        super(schedulingInformation, ts.getOrchestrator());
        this.ts = ts;
        this.worker = worker;
        this.worker.getResource().startingNode();
        switch (worker.getResource().getType()) {
            case WORKER: 
            case MASTER: {
                Worker<T> mw = worker.getResource();
                this.impl = AbstractMethodImplementation.generateDummy((MethodResourceDescription)((MethodResourceDescription)mw.getDescription()));
                break;
            }
            case HTTP: {
                this.impl = HTTPImplementation.generateDummy();
                break;
            }
            default: {
                this.impl = ServiceImplementation.generateDummy();
            }
        }
    }

    @Override
    public boolean isToReserveResources() {
        return true;
    }

    @Override
    public boolean isToReleaseResources() {
        return true;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        new Thread(){

            @Override
            public void run() {
                Worker workerResource = StartWorkerAction.this.worker.getResource();
                Thread.currentThread().setName(workerResource.getName() + " starter");
                try {
                    workerResource.start();
                    StartWorkerAction.this.notifyCompleted();
                }
                catch (InitNodeException e) {
                    LOGGER.error("Error starting resource", (Throwable)e);
                    ErrorManager.warn((String)"Exception creating worker. Check runtime.log for more details", (Exception)((Object)e));
                    StartWorkerAction.this.notifyError();
                }
            }
        }.start();
    }

    @Override
    protected void doAbort() {
    }

    @Override
    protected void doCompleted() {
        LOGGER.info("Worker " + this.worker.getName() + " is ready to execute tasks.");
    }

    @Override
    protected void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    @Override
    protected void doFailed() {
        LOGGER.error("Worker " + this.worker.getName() + " could not be started.");
        if (STOP_EXEC_IN_NODE_FAIL) {
            ErrorManager.fatal((String)(" Execution stopped due to node: " + this.worker.getName() + " failure."));
        }
        this.ts.removeResource(this.worker);
        WorkerResourceDescription rd = this.worker.getResource().getDescription();
        rd.reduce((ResourceDescription)rd);
        SchedulingInformation.changesOnWorker(this.worker);
        Worker<T> wNode = this.worker.getResource();
        ResourceManager.removeWorker(wNode);
    }

    @Override
    protected void doCanceled() {
    }

    @Override
    protected void doFailIgnored() {
    }

    @Override
    protected void doException(COMPSsException e) {
    }

    @Override
    public Integer getCoreId() {
        return null;
    }

    public LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> workers = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        workers.add(this.worker);
        return workers;
    }

    @Override
    public Implementation[] getImplementations() {
        Implementation[] impls = new Implementation[]{this.impl};
        return impls;
    }

    @Override
    public <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> r) {
        return r == this.worker.getResource();
    }

    public <R extends WorkerResourceDescription> LinkedList<Implementation> getCompatibleImplementations(ResourceScheduler<R> r) {
        LinkedList<Implementation> impls = new LinkedList<Implementation>();
        if (r == this.worker) {
            impls.add(this.impl);
        }
        return impls;
    }

    public <R extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<R> targetWorker, Score actionScore) {
        return null;
    }

    @Override
    public void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule((ResourceScheduler<R>)this.worker, this.impl);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(targetWorker, this.impl);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Implementation impl) throws BlockedActionException, UnassignedActionException {
        if (targetWorker != this.getEnforcedTargetResource()) {
            throw new UnassignedActionException();
        }
        this.assignResource(targetWorker);
        this.assignImplementation(this.impl);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "StartWorkerAction (Worker " + this.worker.getName() + ")";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getGroupPriority() {
        return -1L;
    }

    @Override
    public OnFailure getOnFailure() {
        return OnFailure.RETRY;
    }

    @Override
    public boolean taskIsReadyForExecution() {
        return true;
    }

    @Override
    protected void treatDependencyFreeAction(List<AllocatableAction> freeTasks) {
    }

    @Override
    public boolean checkIfCanceled(AllocatableAction aa) {
        return false;
    }

    @Override
    protected void stopAction() throws Exception {
    }

    public List<ResourceScheduler<?>> tryToSchedule(Score actionScore, Set<ResourceScheduler<? extends WorkerResourceDescription>> availableResources) throws BlockedActionException, UnassignedActionException {
        this.schedule(actionScore);
        LinkedList uselessWorkers = new LinkedList();
        if (!this.worker.canRunSomething()) {
            uselessWorkers.add(this.worker);
        }
        return uselessWorkers;
    }
}

