/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.ActionNotFoundException;
import es.bsc.compss.scheduler.exceptions.ActionNotWaitingException;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.InvalidSchedulingException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.worker.COMPSsException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AllocatableAction {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final String DBG_PREFIX = "[AllocatableAction] ";
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    protected static final long ACTION_SINGLE = Long.MAX_VALUE;
    protected static final long ACTION_GROUP_RUNNING = 0L;
    protected static final long ACTION_GROUP_IDLE = 1L;
    protected static final long ACTION_VALUE_TRANSFER = -1L;
    protected static final long ACTION_START_WORKER = -1L;
    protected static final long ACTION_STOP_WORKER = -1L;
    protected static final long ACTION_REDUCE_WORKER = -1L;
    protected static final long ACTION_OPTIMIZE = -1L;
    protected final ActionOrchestrator orchestrator;
    private final long id;
    private final List<AllocatableAction> dataPredecessors;
    private final List<AllocatableAction> dataSuccessors;
    private final List<AllocatableAction> streamDataProducers;
    private final List<AllocatableAction> streamDataConsumers;
    private final List<AllocatableAction> groupMembers;
    private State state;
    private ResourceScheduler<? extends WorkerResourceDescription> selectedResource;
    private Implementation selectedImpl;
    private WorkerResourceDescription resourceConsumption;
    private final List<ResourceScheduler<? extends WorkerResourceDescription>> executingResources;
    private final SchedulingInformation schedulingInfo;
    protected Profile profile;
    private final ReentrantLock lock = new ReentrantLock();

    public AllocatableAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator) {
        this.id = NEXT_ID.getAndIncrement();
        this.orchestrator = orchestrator;
        this.dataPredecessors = new LinkedList<AllocatableAction>();
        this.dataSuccessors = new LinkedList<AllocatableAction>();
        this.streamDataProducers = new LinkedList<AllocatableAction>();
        this.streamDataConsumers = new LinkedList<AllocatableAction>();
        this.groupMembers = new LinkedList<AllocatableAction>();
        this.state = State.RUNNABLE;
        this.selectedResource = null;
        this.selectedImpl = null;
        this.executingResources = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        this.schedulingInfo = schedulingInformation;
        this.profile = null;
    }

    protected void notifyRunning() {
        if (DEBUG) {
            LOGGER.debug("Notify running " + this + " to orchestrator " + this.orchestrator);
        }
        this.orchestrator.actionRunning(this);
    }

    protected void notifyCompleted() {
        if (DEBUG) {
            LOGGER.debug("Notify completed of " + this + " to orchestrator " + this.orchestrator);
        }
        this.orchestrator.actionCompletion(this);
    }

    protected void notifyError() {
        LOGGER.warn("Notify error of " + this + " to orchestrator " + this.orchestrator);
        this.orchestrator.actionError(this);
    }

    protected void notifyException(COMPSsException e) {
        LOGGER.warn("Notify COMPSs exception of " + this + " to orchestrator " + this.orchestrator);
        this.orchestrator.actionException(this, e);
    }

    public final long getId() {
        return this.id;
    }

    public final List<AllocatableAction> getDataPredecessors() {
        return this.dataPredecessors;
    }

    public final List<AllocatableAction> getDataSuccessors() {
        return this.dataSuccessors;
    }

    public final List<AllocatableAction> getStreamDataProducers() {
        return this.streamDataProducers;
    }

    public final List<AllocatableAction> getStreamDataConsumers() {
        return this.streamDataProducers;
    }

    public final boolean hasDataPredecessors() {
        boolean canceled = false;
        LinkedList<AllocatableAction> cancelled = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : this.dataPredecessors) {
            canceled = this.checkIfCanceled(aa);
            if (!canceled) continue;
            cancelled.add(aa);
        }
        for (AllocatableAction aa : cancelled) {
            this.dataPredecessors.remove(aa);
        }
        return !this.dataPredecessors.isEmpty();
    }

    public abstract boolean checkIfCanceled(AllocatableAction var1);

    public final boolean hasStreamProducers() {
        return !this.streamDataProducers.isEmpty();
    }

    public abstract boolean taskIsReadyForExecution();

    public final void addDataPredecessor(AllocatableAction predecessor) {
        if (predecessor.isPending()) {
            if (!this.dataPredecessors.contains(predecessor)) {
                this.dataPredecessors.add(predecessor);
            }
            if (!predecessor.dataSuccessors.contains(this)) {
                predecessor.dataSuccessors.add(this);
            }
        }
    }

    public final void addStreamProducer(AllocatableAction predecessor) {
        if (predecessor.state.equals((Object)State.RUNNABLE) || predecessor.state.equals((Object)State.WAITING)) {
            if (!this.streamDataProducers.contains(predecessor)) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream producer " + predecessor.getId() + " to " + this.getId());
                }
                this.streamDataProducers.add(predecessor);
            }
            if (!predecessor.streamDataConsumers.contains(this)) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream consumer " + this.getId() + " to " + predecessor.getId());
                }
                predecessor.streamDataConsumers.add(this);
            }
        }
    }

    public final void addGroupMember(AllocatableAction member) {
        if (!this.groupMembers.contains(member)) {
            if (DEBUG) {
                LOGGER.debug("Adding group member " + member.getId() + " to same group of " + this.getId());
            }
            this.groupMembers.add(member);
        }
    }

    private void dataPredecessorDone(AllocatableAction finishedAction) {
        Iterator<AllocatableAction> it = this.dataPredecessors.iterator();
        while (it.hasNext()) {
            AllocatableAction aa = it.next();
            if (aa != finishedAction) continue;
            it.remove();
            break;
        }
    }

    private void streamDataProducerDone(AllocatableAction finishedAction) {
        Iterator<AllocatableAction> it = this.streamDataProducers.iterator();
        while (it.hasNext()) {
            AllocatableAction aa = it.next();
            if (aa != finishedAction) continue;
            if (DEBUG) {
                LOGGER.debug("Removing stream poducer " + aa.getId() + " from " + this.getId());
            }
            it.remove();
            break;
        }
    }

    public final boolean isTargetResourceEnforced() {
        return this.schedulingInfo.getEnforcedTargetResource() != null;
    }

    public final ResourceScheduler<? extends WorkerResourceDescription> getEnforcedTargetResource() {
        return this.schedulingInfo.getEnforcedTargetResource();
    }

    public final boolean isSchedulingConstrained() {
        return !this.schedulingInfo.getConstrainingPredecessors().isEmpty();
    }

    public final void addResourceConstraint(AllocatableAction predecessor) {
        this.schedulingInfo.addResourceConstraint(predecessor);
    }

    public final boolean unrequiredResource() {
        for (AllocatableAction a : this.getConstrainingPredecessors()) {
            if (a.getAssignedResource() != this.selectedResource) continue;
            return false;
        }
        return true;
    }

    public final List<AllocatableAction> getConstrainingPredecessors() {
        return this.schedulingInfo.getConstrainingPredecessors();
    }

    protected final List<ResourceScheduler<? extends WorkerResourceDescription>> getCoreElementExecutors(int coreId) {
        return SchedulingInformation.getCoreElementExecutors(coreId);
    }

    public final SchedulingInformation getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public final boolean isPending() {
        return this.state != State.FAILED && this.state != State.FINISHED;
    }

    public final boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public final boolean isCancelling() {
        return this.state == State.CANCELLING;
    }

    public final boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    public final boolean isRunnable() {
        return this.state == State.RUNNABLE;
    }

    public final boolean isLocked() {
        return this.lock.isLocked();
    }

    public final boolean isNotScheduling() {
        return !this.isLocked() && !this.isRunning() && this.selectedResource == null && this.state == State.RUNNABLE;
    }

    public final Long getStartTime() {
        if (this.profile == null) {
            return null;
        }
        return this.profile.getStartTime();
    }

    public final void assignImplementation(Implementation impl) {
        if (this.state == State.RUNNABLE) {
            this.selectedImpl = impl;
        }
    }

    public final Implementation getAssignedImplementation() {
        return this.selectedImpl;
    }

    public final <T extends WorkerResourceDescription> void assignResource(ResourceScheduler<T> resource) {
        if (this.state == State.RUNNABLE) {
            this.selectedResource = resource;
        }
    }

    public final ResourceScheduler<? extends WorkerResourceDescription> getAssignedResource() {
        return this.selectedResource;
    }

    public void tryToLaunch() throws InvalidSchedulingException {
        this.lock.lock();
        boolean readyForExecution = this.taskIsReadyForExecution();
        if (this.selectedResource != null && this.state == State.RUNNABLE && !this.hasDataPredecessors() && this.schedulingInfo.isExecutable() && readyForExecution) {
            if (this.selectedResource.isRemoved() && !this.isToStopResource() || this.isSchedulingConstrained() && this.unrequiredResource() || this.isTargetResourceEnforced() && this.selectedResource != this.schedulingInfo.getEnforcedTargetResource()) {
                this.lock.unlock();
                LOGGER.debug("Action " + this + " incorrectly scheduled. Throwing exception.");
                throw new InvalidSchedulingException();
            }
            this.execute();
        } else {
            if (this.hasDataPredecessors() && DEBUG) {
                LOGGER.debug("[AllocatableAction] Action " + this + " not executed because data predecessors");
                for (AllocatableAction aa : this.getDataPredecessors()) {
                    LOGGER.debug("\n Predecessor: " + aa);
                }
            }
            this.lock.unlock();
        }
    }

    private void execute() {
        boolean reserve = this.isToReserveResources();
        boolean blocked = false;
        boolean enoughResources = false;
        if (reserve) {
            blocked = this.selectedResource.hasBlockedActions();
            enoughResources = this.areEnoughResources();
        }
        if (!reserve || !blocked && enoughResources) {
            this.executingResources.add(this.selectedResource);
            this.run();
        } else {
            LOGGER.info(this + " execution paused due to lack of resources on worker " + this.selectedResource.getName());
            this.state = State.WAITING;
            this.selectedResource.waitOnResource(this);
            this.lock.unlock();
        }
    }

    public final void resumeExecution() throws ActionNotWaitingException {
        this.lock.lock();
        if (this.state != State.WAITING) {
            this.lock.unlock();
            throw new ActionNotWaitingException();
        }
        LOGGER.info(this + " execution resumed on worker " + this.selectedResource.getName());
        this.run();
    }

    private void run() {
        this.state = State.RUNNING;
        this.lock.unlock();
        this.reserveResources();
        this.profile = this.selectedResource.generateProfileForRun(this);
        this.selectedResource.hostAction(this);
        this.doAction();
        this.notifyRunning();
    }

    public abstract boolean isToStopResource();

    public abstract boolean isToReserveResources();

    protected boolean areEnoughResources() {
        Worker<? extends WorkerResourceDescription> w = this.selectedResource.getResource();
        return w.canRunNow(this.selectedImpl.getRequirements());
    }

    public abstract boolean isToReleaseResources();

    protected void reserveResources() {
        if (this.isToReserveResources()) {
            Worker<? extends WorkerResourceDescription> w = this.selectedResource.getResource();
            this.resourceConsumption = w.runTask(this.selectedImpl.getRequirements());
        }
    }

    protected final WorkerResourceDescription getResourceConsumption() {
        return this.resourceConsumption;
    }

    protected void releaseResources() {
        if (this.isToReleaseResources()) {
            Worker<? extends WorkerResourceDescription> w = this.selectedResource.getResource();
            w.endTask(this.resourceConsumption);
        }
    }

    public final List<ResourceScheduler<? extends WorkerResourceDescription>> getExecutingResources() {
        return this.executingResources;
    }

    protected abstract void doAction();

    public final void abortExecution() {
        switch (this.state) {
            case RUNNING: {
                this.releaseResources();
                this.selectedResource.unhostAction(this);
                this.selectedResource.tryToLaunchBlockedActions();
                this.state = State.RUNNABLE;
                this.doAbort();
                break;
            }
            case WAITING: {
                this.state = State.RUNNABLE;
                this.doAbort();
                break;
            }
        }
    }

    private List<AllocatableAction> releaseDataSuccessors() {
        LinkedList<AllocatableAction> freeTasks = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : this.dataSuccessors) {
            aa.dataPredecessorDone(this);
            if (!aa.hasDataPredecessors() && !aa.hasStreamProducers()) {
                freeTasks.add(aa);
            }
            this.treatDependencyFreeAction(freeTasks);
        }
        if (this.dataSuccessors.isEmpty()) {
            this.treatDependencyFreeAction(freeTasks);
        }
        this.dataSuccessors.clear();
        return freeTasks;
    }

    public final List<AllocatableAction> executionStarted() {
        LinkedList<AllocatableAction> freeActions = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : this.streamDataConsumers) {
            aa.streamDataProducerDone(this);
            if (aa.hasStreamProducers() || aa.hasDataPredecessors()) continue;
            freeActions.add(aa);
        }
        return freeActions;
    }

    public final List<AllocatableAction> completed() {
        this.state = State.FINISHED;
        if (this.getAssignedResource() != null) {
            this.releaseResources();
            this.selectedResource.unhostAction(this);
            this.selectedResource.tryToLaunchBlockedActions();
        }
        this.doCompleted();
        return this.releaseDataSuccessors();
    }

    protected abstract void treatDependencyFreeAction(List<AllocatableAction> var1);

    public abstract List<ResourceScheduler<?>> tryToSchedule(Score var1, Set<ResourceScheduler<?>> var2) throws BlockedActionException, UnassignedActionException;

    public final void error() throws FailedActionException {
        this.state = State.RUNNABLE;
        this.releaseResources();
        this.selectedResource.unhostAction(this);
        this.selectedResource.tryToLaunchBlockedActions();
        this.doError();
    }

    public final List<AllocatableAction> exception(COMPSsException e) {
        this.state = State.FAILED;
        if (this.getAssignedResource() != null) {
            this.releaseResources();
            this.selectedResource.unhostAction(this);
            this.selectedResource.tryToLaunchBlockedActions();
        }
        this.cancelAction();
        this.doException(e);
        LinkedList<AllocatableAction> groupActions = new LinkedList<AllocatableAction>();
        groupActions.addAll(this.groupMembers);
        LinkedList<AllocatableAction> cancel = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : groupActions) {
            if (aa.state != State.RUNNING && aa.state != State.WAITING && aa.state != State.RUNNABLE) continue;
            cancel.addAll(aa.canceled());
        }
        this.dataPredecessors.clear();
        this.dataSuccessors.clear();
        return cancel;
    }

    public final List<AllocatableAction> failed() {
        this.state = State.FAILED;
        this.cancelAction();
        LinkedList<AllocatableAction> failed = new LinkedList<AllocatableAction>();
        LinkedList<AllocatableAction> successors = new LinkedList<AllocatableAction>();
        successors.addAll(this.dataSuccessors);
        this.doFailed();
        for (AllocatableAction succ : successors) {
            failed.addAll(succ.canceled());
        }
        this.dataPredecessors.clear();
        this.dataSuccessors.clear();
        return failed;
    }

    public final List<AllocatableAction> ignoredFailure() {
        this.state = State.FAILED;
        this.cancelAction();
        this.doFailIgnored();
        List<AllocatableAction> releasedSuccessors = this.releaseDataSuccessors();
        this.dataPredecessors.clear();
        return releasedSuccessors;
    }

    public final List<AllocatableAction> canceled() {
        LinkedList<AllocatableAction> cancel = new LinkedList<AllocatableAction>();
        if (this.state == State.RUNNING) {
            try {
                this.state = State.CANCELLING;
                this.stopAction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (this.state == State.CANCELLING) {
                this.releaseResources();
                this.selectedResource.unhostAction(this);
                this.selectedResource.tryToLaunchBlockedActions();
            }
            if (this.state != State.CANCELLED) {
                this.state = State.CANCELLED;
                this.cancelAction();
                LinkedList<AllocatableAction> successors = new LinkedList<AllocatableAction>();
                successors.addAll(this.dataSuccessors);
                this.doCanceled();
                for (AllocatableAction succ : successors) {
                    cancel.addAll(succ.canceled());
                }
                this.dataPredecessors.clear();
                this.dataSuccessors.clear();
            }
        }
        return cancel;
    }

    private void cancelAction() {
        boolean canceled = false;
        if (this.selectedResource != null) {
            while (!canceled) {
                try {
                    this.selectedResource.cancelAction(this);
                    canceled = true;
                }
                catch (ActionNotFoundException anfe) {
                    LOGGER.warn("[Allocatable Action] Action not found exception when canceling " + this);
                    while (this.selectedResource == null) {
                    }
                }
            }
        }
        for (AllocatableAction pred : this.dataPredecessors) {
            pred.dataSuccessors.remove(this);
        }
    }

    protected abstract void stopAction() throws Exception;

    protected abstract void doAbort();

    protected abstract void doCompleted();

    protected abstract void doError() throws FailedActionException;

    protected abstract void doException(COMPSsException var1);

    protected abstract void doFailed();

    protected abstract void doCanceled();

    protected abstract void doFailIgnored();

    public abstract Integer getCoreId();

    public abstract List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers();

    public abstract Implementation[] getImplementations();

    public abstract <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> var1);

    public abstract <T extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<T> var1);

    public abstract int getPriority();

    public abstract long getGroupPriority();

    public abstract OnFailure getOnFailure();

    public abstract <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> var1, Score var2);

    public abstract void schedule(Score var1) throws BlockedActionException, UnassignedActionException;

    public abstract <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> var1, Score var2) throws BlockedActionException, UnassignedActionException;

    public abstract <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> var1, Implementation var2) throws BlockedActionException, UnassignedActionException;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HashCode ").append(this.hashCode()).append("\n");
        sb.append("\tdataPredecessors:");
        for (AllocatableAction aa : this.dataPredecessors) {
            sb.append(" ").append(aa.hashCode());
        }
        sb.append("\n");
        sb.append("\tdataSuccessors: ");
        for (AllocatableAction aa : this.dataSuccessors) {
            sb.append(" ").append(aa.hashCode());
        }
        sb.append("\n");
        sb.append(this.schedulingInfo);
        sb.append("\n");
        return sb.toString();
    }

    private static enum State {
        RUNNABLE,
        WAITING,
        RUNNING,
        FINISHED,
        FAILED,
        CANCELLED,
        CANCELLING;

    }
}

