/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.allocatableactions;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.HTTPImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.types.resources.updates.PerformedReduction;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.worker.COMPSsException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class StopWorkerAction
extends AllocatableAction {
    private final ResourceScheduler<? extends WorkerResourceDescription> worker;
    private final Implementation impl;
    private final PerformedReduction<WorkerResourceDescription> ru;

    public StopWorkerAction(SchedulingInformation schedulingInformation, ResourceScheduler<? extends WorkerResourceDescription> worker, TaskScheduler ts, PerformedReduction<? extends WorkerResourceDescription> modification) {
        super(schedulingInformation, ts.getOrchestrator());
        this.worker = worker;
        this.ru = modification;
        this.impl = worker.getResource().getType() == ResourceType.WORKER ? AbstractMethodImplementation.generateDummy((MethodResourceDescription)new MethodResourceDescription()) : HTTPImplementation.generateDummy();
    }

    @Override
    public boolean isToReserveResources() {
        return false;
    }

    @Override
    public boolean isToReleaseResources() {
        return false;
    }

    @Override
    public boolean isToStopResource() {
        return true;
    }

    @Override
    protected void doAction() {
        new Thread(){

            @Override
            public void run() {
                Worker wResource = StopWorkerAction.this.worker.getResource();
                Thread.currentThread().setName(wResource.getName() + " stopper");
                wResource.retrieveUniqueDataValues();
                wResource.disableExecution();
                wResource.retrieveTracingAndDebugData();
                Semaphore sem = new Semaphore(0);
                ShutdownListener sl = new ShutdownListener(sem);
                wResource.stop(sl);
                sl.enable();
                try {
                    sem.acquire();
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: Exception raised on worker shutdown", (Throwable)e);
                    ErrorManager.warn((String)"Exception stopping worker. Check runtime.log for more details", (Exception)e);
                    StopWorkerAction.this.notifyError();
                }
                StopWorkerAction.this.notifyCompleted();
            }
        }.start();
    }

    @Override
    protected void doAbort() {
    }

    @Override
    protected void doCompleted() {
        this.removeResource();
    }

    private void removeResource() {
        Worker<? extends WorkerResourceDescription> w = this.worker.getResource();
        if (w instanceof CloudMethodWorker) {
            CloudMethodWorker cmw = (CloudMethodWorker)w;
            ResourceManager.terminateCloudResource((CloudMethodWorker)cmw, (CloudMethodResourceDescription)((CloudMethodResourceDescription)this.ru.getModification()));
        }
        ResourceManager.removeWorker(w);
    }

    @Override
    protected void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    @Override
    protected void doFailed() {
        this.removeResource();
    }

    @Override
    protected void doCanceled() {
        this.removeResource();
    }

    @Override
    protected void doFailIgnored() {
    }

    @Override
    protected Collection<AllocatableAction> doException(COMPSsException e) {
        return new LinkedList<AllocatableAction>();
    }

    @Override
    public Integer getCoreId() {
        return null;
    }

    public LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> workers = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        workers.add(this.worker);
        return workers;
    }

    @Override
    public Implementation[] getImplementations() {
        Implementation[] impls = new Implementation[]{this.impl};
        return impls;
    }

    @Override
    public <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> r) {
        return r == this.worker.getResource();
    }

    public <T extends WorkerResourceDescription> LinkedList<Implementation> getCompatibleImplementations(ResourceScheduler<T> r) {
        LinkedList<Implementation> impls = new LinkedList<Implementation>();
        if (r == this.worker) {
            impls.add(this.impl);
        }
        return impls;
    }

    @Override
    public <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> targetWorker, Score actionScore) {
        return null;
    }

    @Override
    public void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(this.worker, this.impl);
    }

    @Override
    public void schedule(Collection<ResourceScheduler<? extends WorkerResourceDescription>> candidates, Score actionScore) throws UnassignedActionException {
        if (!candidates.contains(this.worker)) {
            throw new UnassignedActionException();
        }
        this.schedule(this.worker, this.impl);
    }

    @Override
    public void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Score actionScore) throws UnassignedActionException {
        if (targetWorker != this.worker) {
            throw new UnassignedActionException();
        }
        this.schedule(targetWorker, this.impl);
    }

    @Override
    public void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Implementation impl) throws UnassignedActionException {
        if (targetWorker != this.worker) {
            throw new UnassignedActionException();
        }
        this.assignResource(targetWorker);
        this.assignImplementation(impl);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "StopWorkerAction (Worker " + this.worker.getName() + ")";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getGroupPriority() {
        return -1L;
    }

    @Override
    public OnFailure getOnFailure() {
        return OnFailure.RETRY;
    }

    @Override
    public boolean checkIfCanceled(AllocatableAction aa) {
        return false;
    }

    @Override
    protected void stopAction() throws Exception {
    }
}

