/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.schedulinginformation;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.types.LocationScoreMonitor;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LocationMonitor;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.parameter.CollectiveParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import java.util.Set;

public class DataLocality
extends SchedulingInformation {
    public <T extends WorkerResourceDescription> DataLocality(ResourceScheduler<T> enforcedTargetResource, List<? extends Parameter> params, Integer coreId) {
        super(enforcedTargetResource);
        if (enforcedTargetResource == null && coreId != null && params != null) {
            this.registerLocalityScoreMonitoring(params);
        }
    }

    private void registerLocalityScoreMonitoring(List<? extends Parameter> params) {
        for (Parameter parameter : params) {
            this.registerLocalityScoreMonitoring(parameter);
        }
    }

    private void registerLocalityScoreMonitoring(Parameter p) {
        if (p.isPotentialDependency() && p.getDirection() != Direction.OUT) {
            if (p.isCollective()) {
                CollectiveParameter cp = (CollectiveParameter)p;
                this.registerLocalityScoreMonitoring(cp.getElements());
            } else {
                LogicalData dataLD;
                DependencyParameter dp = (DependencyParameter)p;
                DataInstanceId dId = null;
                DataAccessId access = dp.getDataAccessId();
                if (access != null && access.isRead()) {
                    DataAccessId.ReadingDataAccessId raId = (DataAccessId.ReadingDataAccessId)access;
                    dId = raId.getReadDataInstance();
                }
                if (dId != null && (dataLD = dId.getData()) != null) {
                    Set hosts = dataLD.getAllHosts();
                    this.increasePreregisteredScores(hosts, p.getWeight());
                    LocationScoreMonitor monitor = new LocationScoreMonitor(this, p.getWeight());
                    dataLD.registerLocationMonitor((LocationMonitor)monitor);
                }
            }
        }
    }
}

