/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStateManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private final JSONObject jsonRepresentation;

    public JSONStateManager() {
        String objectStr = "{}";
        String inputProfile = System.getProperty("compss.profile.input");
        if (inputProfile != null && !inputProfile.isEmpty()) {
            LOGGER.debug("Input profile detected. Reading from file " + inputProfile);
            objectStr = this.manageInputProfile(inputProfile);
        }
        this.jsonRepresentation = new JSONObject(objectStr);
        this.init();
    }

    private String manageInputProfile(String inputProfile) {
        File f = new File(inputProfile);
        try {
            byte[] bytes = Files.readAllBytes(f.toPath());
            return new String(bytes, "UTF-8");
        }
        catch (FileNotFoundException e) {
            ErrorManager.warn((String)("Error loading profile. File " + f.getAbsolutePath() + " not found. Using default values"));
            return "{}";
        }
        catch (IOException e) {
            ErrorManager.warn((String)("Error loading profile. Exception reading " + f.getAbsolutePath() + ". Using default values"), (Exception)e);
            return "{}";
        }
    }

    private void init() {
        JSONObject cloud;
        JSONObject implementations;
        JSONObject resources = this.getJSONForResources();
        if (resources == null) {
            this.addResources();
        }
        if ((implementations = this.getJSONForImplementations()) == null) {
            this.addImplementations();
        }
        if ((cloud = this.getJSONForCloud()) == null) {
            this.addCloud();
        }
    }

    private JSONObject addResources() {
        JSONObject resources = new JSONObject();
        this.jsonRepresentation.put("resources", (Object)resources);
        return resources;
    }

    private JSONObject addImplementations() {
        JSONObject implementations = new JSONObject();
        this.jsonRepresentation.put("implementations", (Object)implementations);
        return implementations;
    }

    private JSONObject addCloud() {
        JSONObject cloud = new JSONObject();
        this.jsonRepresentation.put("cloud", (Object)cloud);
        return cloud;
    }

    public JSONObject getJSONForImplementations() {
        try {
            return this.jsonRepresentation.getJSONObject("implementations");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public JSONObject getJSONForImplementation(Implementation impl) {
        try {
            JSONObject implsJSON = this.jsonRepresentation.getJSONObject("implementations");
            String signature = impl.getSignature();
            return implsJSON.getJSONObject(signature);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public JSONObject getJSONForImplementation(CloudProvider cp, CloudInstanceTypeDescription citd, Implementation impl) {
        try {
            JSONObject citdJSON = this.getJSONForCloudInstanceTypeDescription(cp, citd);
            if (citdJSON != null) {
                String signature = impl.getSignature();
                return citdJSON.getJSONObject(signature);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public <T extends WorkerResourceDescription> JSONObject getJSONForResources() {
        try {
            return this.jsonRepresentation.getJSONObject("resources");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public <T extends WorkerResourceDescription> JSONObject getJSONForResource(Worker<T> resource) {
        block3: {
            JSONObject resourcesJSON = this.getJSONForResources();
            if (resourcesJSON != null) {
                try {
                    return resourcesJSON.getJSONObject(resource.getName());
                }
                catch (JSONException je) {
                    CloudMethodWorker cmw;
                    if (!(resource instanceof CloudMethodWorker) || (cmw = (CloudMethodWorker)resource).getDescription().getTypeComposition().isEmpty()) break block3;
                    return this.getJSONForCloudInstanceTypeDescription(cmw.getProvider(), (CloudInstanceTypeDescription)cmw.getDescription().getTypeComposition().keySet().iterator().next());
                }
            }
        }
        return null;
    }

    public JSONObject getJSONForCloud() {
        try {
            return this.jsonRepresentation.getJSONObject("cloud");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public JSONObject getJSONForCloudProvider(CloudProvider cp) {
        try {
            JSONObject cloudJSON = this.getJSONForCloud();
            if (cloudJSON != null) {
                return cloudJSON.getJSONObject(cp.getName());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public JSONObject getJSONForCloudInstanceTypeDescription(CloudProvider cp, CloudInstanceTypeDescription citd) {
        try {
            JSONObject cpJSON = this.getJSONForCloudProvider(cp);
            if (cpJSON != null) {
                return cpJSON.getJSONObject(citd.getName());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public void addResourceJSON(ResourceScheduler<? extends WorkerResourceDescription> rs) {
        for (CoreElement ce : CoreManager.getAllCores()) {
            for (Implementation impl : ce.getImplementations()) {
                JSONObject implJSON = this.getJSONForImplementation(impl);
                Profile p = rs.getProfile(impl);
                if (implJSON == null) {
                    this.addImplementationJSON(impl, p);
                    continue;
                }
                this.accumulateImplementationJSON(impl, p);
            }
        }
        JSONObject resources = this.getJSONForResources();
        resources.put(rs.getName(), (Object)rs.toJSONObject());
    }

    public JSONObject updateResourceJSON(ResourceScheduler<? extends WorkerResourceDescription> rs) {
        JSONObject oldResource = this.getJSONForResource(rs.getResource());
        return rs.updateJSON(oldResource);
    }

    public void addImplementationJSON(Implementation impl, Profile profile) {
        String signature = impl.getSignature();
        JSONObject implsJSON = this.getJSONForImplementations();
        implsJSON.put(signature, (Object)profile.toJSONObject());
    }

    public void accumulateImplementationJSON(Implementation impl, Profile profile) {
        JSONObject oldImplJSON = this.getJSONForImplementation(impl);
        profile.accumulateJSON(oldImplJSON);
    }

    public String getString() {
        return this.jsonRepresentation.toString();
    }

    public void write() {
        String outputProfile = System.getProperty("compss.profile.output");
        if (outputProfile != null && !outputProfile.isEmpty()) {
            LOGGER.debug("Output profile detected. Writting to file " + outputProfile);
            this.writeOutputProfile(outputProfile);
        }
    }

    public void writeOutputProfile(String filename) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            writer.write(this.jsonRepresentation.toString());
        }
        catch (IOException e) {
            ErrorManager.warn((String)("Error loading profile. Exception reading " + filename + "."), (Exception)e);
        }
    }
}

