/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.ActionNotFoundException;
import es.bsc.compss.scheduler.exceptions.ActionNotWaitingException;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.InvalidSchedulingException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionGroup;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.worker.COMPSsException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AllocatableAction {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final String DBG_PREFIX = "[AllocatableAction] ";
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    protected static final long ACTION_SINGLE = Long.MAX_VALUE;
    protected static final long ACTION_GROUP_RUNNING = 0L;
    protected static final long ACTION_GROUP_IDLE = 1L;
    protected static final long ACTION_VALUE_TRANSFER = -1L;
    protected static final long ACTION_START_WORKER = -1L;
    protected static final long ACTION_STOP_WORKER = -1L;
    protected static final long ACTION_REDUCE_WORKER = -1L;
    protected static final long ACTION_OPTIMIZE = -1L;
    protected final ActionOrchestrator orchestrator;
    private final long id;
    private final List<AllocatableAction> dataPredecessors;
    private final List<AllocatableAction> dataSuccessors;
    private final List<AllocatableAction> streamDataProducers;
    private final List<AllocatableAction> streamDataConsumers;
    private final List<ActionGroup.MutexGroup> mutexGroups;
    private State state;
    private ResourceScheduler<? extends WorkerResourceDescription> selectedResource;
    private Implementation selectedImpl;
    private WorkerResourceDescription resourceConsumption;
    private final List<ResourceScheduler<? extends WorkerResourceDescription>> executingResources;
    private final SchedulingInformation schedulingInfo;
    protected Profile profile;
    private final ReentrantLock lock = new ReentrantLock();

    public AllocatableAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator) {
        this.id = NEXT_ID.getAndIncrement();
        this.orchestrator = orchestrator;
        this.dataPredecessors = new LinkedList<AllocatableAction>();
        this.dataSuccessors = new LinkedList<AllocatableAction>();
        this.streamDataProducers = new LinkedList<AllocatableAction>();
        this.streamDataConsumers = new LinkedList<AllocatableAction>();
        this.state = State.RUNNABLE;
        this.selectedResource = null;
        this.selectedImpl = null;
        this.executingResources = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        this.schedulingInfo = schedulingInformation;
        this.profile = null;
        this.mutexGroups = new LinkedList<ActionGroup.MutexGroup>();
    }

    protected void notifyRunning() {
        if (DEBUG) {
            LOGGER.debug("Notify running " + this + " to orchestrator " + this.orchestrator);
        }
        this.orchestrator.actionRunning(this);
    }

    protected void notifyCompleted() {
        if (DEBUG) {
            LOGGER.debug("Notify completed of " + this + " to orchestrator " + this.orchestrator);
        }
        this.orchestrator.actionCompletion(this);
    }

    protected void notifyError() {
        LOGGER.warn("Notify error of " + this + " to orchestrator " + this.orchestrator);
        this.orchestrator.actionError(this);
    }

    protected void notifyException(COMPSsException e) {
        LOGGER.warn("Notify COMPSs exception of " + this + " to orchestrator " + this.orchestrator);
        this.orchestrator.actionException(this, e);
    }

    public final long getId() {
        return this.id;
    }

    public final List<AllocatableAction> getDataPredecessors() {
        return this.dataPredecessors;
    }

    public final List<AllocatableAction> getDataSuccessors() {
        return this.dataSuccessors;
    }

    public final List<AllocatableAction> getStreamDataProducers() {
        return this.streamDataProducers;
    }

    public final List<AllocatableAction> getStreamDataConsumers() {
        return this.streamDataConsumers;
    }

    public final boolean hasDataPredecessors() {
        Iterator<AllocatableAction> producers = this.dataPredecessors.iterator();
        while (producers.hasNext()) {
            AllocatableAction aa = producers.next();
            if (!this.checkIfCanceled(aa)) continue;
            producers.remove();
        }
        return !this.dataPredecessors.isEmpty();
    }

    public final boolean hasStreamProducers() {
        Iterator<AllocatableAction> producers = this.streamDataProducers.iterator();
        while (producers.hasNext()) {
            AllocatableAction aa = producers.next();
            if (!this.checkIfCanceled(aa)) continue;
            producers.remove();
        }
        return !this.streamDataProducers.isEmpty();
    }

    public abstract boolean checkIfCanceled(AllocatableAction var1);

    public final void addDataPredecessor(AllocatableAction predecessor) {
        if (predecessor.isPending()) {
            if (!this.dataPredecessors.contains(predecessor)) {
                this.dataPredecessors.add(predecessor);
            }
            if (!predecessor.dataSuccessors.contains(this)) {
                predecessor.dataSuccessors.add(this);
            }
        }
    }

    public void addAlreadyDoneAction(AllocatableAction predecessor) {
    }

    public final void addStreamProducer(AllocatableAction predecessor) {
        if (predecessor.state.equals((Object)State.RUNNABLE) || predecessor.state.equals((Object)State.WAITING)) {
            if (!this.streamDataProducers.contains(predecessor)) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream producer action " + predecessor.getId() + " to action " + this.getId());
                }
                this.streamDataProducers.add(predecessor);
            }
            if (!predecessor.streamDataConsumers.contains(this)) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream consumer action " + this.getId() + " to action " + predecessor.getId());
                }
                predecessor.streamDataConsumers.add(this);
            }
        }
    }

    protected void dataPredecessorDone(AllocatableAction finishedAction) {
        Iterator<AllocatableAction> it = this.dataPredecessors.iterator();
        while (it.hasNext()) {
            AllocatableAction aa = it.next();
            if (aa != finishedAction) continue;
            it.remove();
            break;
        }
    }

    private void streamDataProducerStarted(AllocatableAction finishedAction) {
        Iterator<AllocatableAction> it = this.streamDataProducers.iterator();
        while (it.hasNext()) {
            AllocatableAction aa = it.next();
            if (aa != finishedAction) continue;
            if (DEBUG) {
                LOGGER.debug("Removing stream producer action " + aa.getId() + " from action " + this.getId());
            }
            it.remove();
            break;
        }
    }

    private List<AllocatableAction> releaseDataSuccessors() {
        LinkedList<AllocatableAction> freeTasks = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : this.dataSuccessors) {
            aa.dataPredecessorDone(this);
            if (aa.hasDataPredecessors() || aa.hasStreamProducers()) continue;
            freeTasks.add(aa);
        }
        this.dataSuccessors.clear();
        return freeTasks;
    }

    private List<AllocatableAction> releaseStreamDataConsumers() {
        LinkedList<AllocatableAction> freeActions = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : this.streamDataConsumers) {
            aa.streamDataProducerStarted(this);
            if (aa.hasStreamProducers() || aa.hasDataPredecessors()) continue;
            freeActions.add(aa);
        }
        return freeActions;
    }

    protected final void addToMutexGroup(ActionGroup.MutexGroup group) {
        if (!this.mutexGroups.contains(group)) {
            this.mutexGroups.add(group);
        }
        group.addMember(this);
    }

    private boolean areMutexLocksAvailable() {
        for (ActionGroup.MutexGroup group : this.mutexGroups) {
            if (group.testLock(this)) continue;
            return false;
        }
        return true;
    }

    private void acquireMutexLocks() {
        for (ActionGroup.MutexGroup group : this.mutexGroups) {
            group.acquireLock(this);
        }
    }

    private void releaseMutexLocks(List<AllocatableAction> released) {
        for (ActionGroup.MutexGroup group : this.mutexGroups) {
            group.removeMember(this);
            for (AllocatableAction aa : group.getMembers()) {
                if (aa.hasDataPredecessors() || released.contains(aa)) continue;
                released.add(aa);
            }
            group.releaseLock();
        }
    }

    public final boolean isTargetResourceEnforced() {
        return this.schedulingInfo.getEnforcedTargetResource() != null;
    }

    public final ResourceScheduler<? extends WorkerResourceDescription> getEnforcedTargetResource() {
        return this.schedulingInfo.getEnforcedTargetResource();
    }

    public final boolean isSchedulingConstrained() {
        return !this.schedulingInfo.getConstrainingPredecessors().isEmpty();
    }

    public final void addResourceConstraint(AllocatableAction predecessor) {
        this.schedulingInfo.addResourceConstraint(predecessor);
    }

    public final boolean unrequiredResource() {
        for (AllocatableAction a : this.getConstrainingPredecessors()) {
            if (a.getAssignedResource() != this.selectedResource) continue;
            return false;
        }
        return true;
    }

    public final List<AllocatableAction> getConstrainingPredecessors() {
        return this.schedulingInfo.getConstrainingPredecessors();
    }

    protected final List<ResourceScheduler<? extends WorkerResourceDescription>> getCoreElementExecutors(int coreId) {
        return SchedulingInformation.getCoreElementExecutors(coreId);
    }

    public final SchedulingInformation getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public final boolean isPending() {
        return this.state != State.FAILED && this.state != State.FINISHED;
    }

    public final boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public final boolean isCancelling() {
        return this.state == State.CANCELLING;
    }

    public final boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    public final boolean isRunnable() {
        return this.state == State.RUNNABLE;
    }

    public final boolean isFinished() {
        return this.state == State.FINISHED;
    }

    public final boolean isLocked() {
        return this.lock.isLocked();
    }

    public final boolean isNotScheduling() {
        return !this.isLocked() && !this.isRunning() && this.selectedResource == null && this.state == State.RUNNABLE;
    }

    public final Long getStartTime() {
        if (this.profile == null) {
            return null;
        }
        return this.profile.getStartTime();
    }

    public final void assignImplementation(Implementation impl) {
        if (this.state == State.RUNNABLE) {
            this.selectedImpl = impl;
        }
    }

    public final Implementation getAssignedImplementation() {
        return this.selectedImpl;
    }

    public final <T extends WorkerResourceDescription> void assignResource(ResourceScheduler<T> resource) {
        if (this.state == State.RUNNABLE) {
            this.selectedResource = resource;
        }
    }

    public final ResourceScheduler<? extends WorkerResourceDescription> getAssignedResource() {
        return this.selectedResource;
    }

    public final void tryToLaunch() throws InvalidSchedulingException {
        this.lock.lock();
        if (this.selectedResource != null && this.state == State.RUNNABLE && !this.hasDataPredecessors() && !this.hasStreamProducers() && this.schedulingInfo.isExecutable() && this.areMutexLocksAvailable()) {
            if (this.selectedResource.isRemoved() && !this.isToStopResource() || this.isSchedulingConstrained() && this.unrequiredResource() || this.isTargetResourceEnforced() && this.selectedResource != this.schedulingInfo.getEnforcedTargetResource()) {
                this.lock.unlock();
                LOGGER.debug("Action " + this + " incorrectly scheduled. Throwing exception.");
                throw new InvalidSchedulingException();
            }
            this.acquireMutexLocks();
            try {
                WorkerResourceDescription consumption = this.selectedResource.hostAction(this);
                this.run(consumption);
            }
            catch (BlockedActionException e) {
                this.state = State.WAITING;
                this.lock.unlock();
            }
            catch (InvalidSchedulingException ise) {
                this.lock.unlock();
                throw ise;
            }
        } else {
            if (this.hasDataPredecessors() && DEBUG) {
                LOGGER.debug("[AllocatableAction] Action " + this + " not executed because data dependencies");
                for (AllocatableAction aa : this.getDataPredecessors()) {
                    LOGGER.debug("\n Predecessor: " + aa);
                }
                for (AllocatableAction aa : this.getStreamDataProducers()) {
                    LOGGER.debug("\n Producer: " + aa);
                }
            }
            this.lock.unlock();
        }
    }

    public final void resumeExecution(WorkerResourceDescription consumption) throws ActionNotWaitingException {
        this.lock.lock();
        if (this.state != State.WAITING) {
            this.lock.unlock();
            throw new ActionNotWaitingException();
        }
        LOGGER.info(this + " execution resumed on worker " + this.selectedResource.getName());
        this.run(consumption);
    }

    private void run(WorkerResourceDescription consumption) {
        this.executingResources.add(this.selectedResource);
        this.resourceConsumption = consumption;
        this.state = State.RUNNING;
        this.lock.unlock();
        this.profile = this.selectedResource.generateProfileForRun(this);
        this.doAction();
        this.notifyRunning();
    }

    public abstract boolean isToStopResource();

    public abstract boolean isToReserveResources();

    public abstract boolean isToReleaseResources();

    public final WorkerResourceDescription getResourceConsumption() {
        return this.resourceConsumption;
    }

    public final List<ResourceScheduler<? extends WorkerResourceDescription>> getExecutingResources() {
        return this.executingResources;
    }

    protected abstract void doAction();

    public final void abortExecution() {
        if (this.state != State.RUNNING && this.state != State.WAITING) {
            return;
        }
        this.selectedResource.unhostAction(this);
        this.state = State.RUNNABLE;
        this.executingResources.remove(this.selectedResource);
        this.selectedResource = null;
        this.doAbort();
    }

    public final List<AllocatableAction> executionStarted() {
        return this.releaseStreamDataConsumers();
    }

    public final List<AllocatableAction> completed() {
        this.state = State.FINISHED;
        List<AllocatableAction> freeActions = this.releaseDataSuccessors();
        this.releaseMutexLocks(freeActions);
        this.doCompleted();
        return freeActions;
    }

    public final void error() throws FailedActionException {
        this.state = State.RUNNABLE;
        this.selectedResource.unhostAction(this);
        this.doError();
    }

    public final List<AllocatableAction> exception(COMPSsException e) {
        this.state = State.FAILED;
        this.cancelAction();
        Collection<AllocatableAction> groupMembers = this.doException(e);
        LinkedList<AllocatableAction> cancel = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : groupMembers) {
            if (aa.state != State.RUNNING && aa.state != State.WAITING && aa.state != State.RUNNABLE) continue;
            LOGGER.debug("[AllocatableAction] Cancelling action " + aa.id + " because in same group");
            cancel.addAll(aa.cancel());
        }
        this.dataPredecessors.clear();
        this.dataSuccessors.clear();
        return cancel;
    }

    public final List<AllocatableAction> failed() {
        this.state = State.FAILED;
        this.cancelAction();
        LinkedList<AllocatableAction> failed = new LinkedList<AllocatableAction>();
        LinkedList<AllocatableAction> successors = new LinkedList<AllocatableAction>();
        successors.addAll(this.dataSuccessors);
        this.doFailed();
        for (AllocatableAction succ : successors) {
            failed.addAll(succ.cancel());
        }
        this.dataPredecessors.clear();
        this.dataSuccessors.clear();
        return failed;
    }

    public final List<AllocatableAction> ignoredFailure() {
        this.state = State.FAILED;
        this.cancelAction();
        this.doFailIgnored();
        List<AllocatableAction> releasedSuccessors = this.releaseDataSuccessors();
        this.releaseMutexLocks(releasedSuccessors);
        this.dataPredecessors.clear();
        return releasedSuccessors;
    }

    public final List<AllocatableAction> cancel() {
        LinkedList<AllocatableAction> cancel = new LinkedList<AllocatableAction>();
        if (this.state == State.RUNNING) {
            try {
                this.state = State.CANCELLING;
                this.stopAction();
            }
            catch (Exception e) {
                LOGGER.error("Exception stoping action.", (Throwable)e);
            }
        } else {
            if (this.state == State.CANCELLING) {
                this.selectedResource.unhostAction(this);
            }
            if (this.state != State.CANCELLED) {
                this.state = State.CANCELLED;
                this.cancelAction();
                LinkedList<AllocatableAction> successors = new LinkedList<AllocatableAction>();
                successors.addAll(this.dataSuccessors);
                boolean cancelSuccessors = this.doCanceled();
                if (cancelSuccessors) {
                    for (AllocatableAction succ : successors) {
                        if (succ.isFinished()) continue;
                        LOGGER.debug("Cancelling action " + succ.getId() + " because of successor of canceled action " + this.getId());
                        cancel.addAll(succ.cancel());
                    }
                }
                this.dataPredecessors.clear();
                this.dataSuccessors.clear();
            }
        }
        return cancel;
    }

    private void cancelAction() {
        boolean canceled = false;
        if (this.selectedResource != null) {
            while (!canceled) {
                try {
                    this.selectedResource.cancelAction(this);
                    canceled = true;
                }
                catch (ActionNotFoundException anfe) {
                    LOGGER.warn("[Allocatable Action] Action not found exception when canceling " + this);
                    while (this.selectedResource == null) {
                    }
                }
            }
        }
        for (AllocatableAction pred : this.dataPredecessors) {
            pred.dataSuccessors.remove(this);
        }
    }

    protected abstract void stopAction() throws Exception;

    protected abstract void doAbort();

    protected abstract void doCompleted();

    protected abstract void doError() throws FailedActionException;

    protected abstract Collection<AllocatableAction> doException(COMPSsException var1);

    protected abstract void doFailed();

    protected abstract boolean doCanceled();

    protected abstract void doFailIgnored();

    public abstract Integer getCoreId();

    public abstract List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers();

    public abstract Implementation[] getImplementations();

    public abstract <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> var1);

    public abstract <T extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<T> var1);

    public abstract int getPriority();

    public abstract long getGroupPriority();

    public abstract OnFailure getOnFailure();

    public abstract <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> var1, Score var2);

    public abstract void schedule(Score var1) throws BlockedActionException, UnassignedActionException;

    public abstract void schedule(Collection<ResourceScheduler<? extends WorkerResourceDescription>> var1, Score var2) throws UnassignedActionException;

    public abstract void schedule(ResourceScheduler<? extends WorkerResourceDescription> var1, Score var2) throws UnassignedActionException;

    public abstract void schedule(ResourceScheduler<? extends WorkerResourceDescription> var1, Implementation var2) throws UnassignedActionException;

    public final List<AllocatableAction> unschedule() throws UnassignedActionException, ActionNotFoundException {
        if (this.selectedResource != null) {
            ResourceScheduler<? extends WorkerResourceDescription> target = this.selectedResource;
            if (this.state == State.RUNNING || this.state == State.WAITING) {
                target.unhostAction(this);
            }
            return target.unscheduleAction(this);
        }
        throw new UnassignedActionException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID: " + this.id).append("\n");
        sb.append("HashCode ").append(this.hashCode()).append("\n");
        sb.append("\tdataPredecessors:");
        for (AllocatableAction aa : this.dataPredecessors) {
            sb.append(" ").append(aa.hashCode());
        }
        sb.append("\n");
        sb.append("\tdataSuccessors: ");
        for (AllocatableAction aa : this.dataSuccessors) {
            sb.append(" ").append(aa.hashCode());
        }
        sb.append("\n");
        sb.append(this.schedulingInfo);
        sb.append("\n");
        return sb.toString();
    }

    private static enum State {
        RUNNABLE,
        WAITING,
        RUNNING,
        FINISHED,
        FAILED,
        CANCELLED,
        CANCELLING;

    }
}

