/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.data;

import es.bsc.compss.scheduler.ready.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONObject;

public class DataResourceScheduler<T extends WorkerResourceDescription>
extends ReadyResourceScheduler<T> {
    public DataResourceScheduler(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long priority = action.getPriority();
        long groupId = action.getGroupPriority();
        long waitingScore = -this.blocked.size();
        long resourceScore = 0L;
        long implementationScore = 0L;
        return new Score(priority, groupId, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long resourceScore = (long)action.getSchedulingInfo().getScore((Resource)this.myWorker);
        long waitingScore = -this.blocked.size();
        return new Score(priority, groupId, resourceScore, waitingScore, 0L);
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        if (this.hasBlockedActions()) {
            return null;
        }
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            long priority = resourceScore.getPriority();
            long groupId = action.getGroupPriority();
            long resource = resourceScore.getResourceScore();
            long waitingScore = resourceScore.getWaitingScore();
            long implScore = -this.getProfile(impl).getAverageExecutionTime();
            return new Score(priority, groupId, resource, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "DataResourceScheduler@" + this.getName();
    }
}

