/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.dependencyconstraintfifo;

import es.bsc.compss.scheduler.readynew.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import org.json.JSONObject;

public class DependencyConstraintFIFOResourceScheduler<T extends WorkerResourceDescription>
extends ReadyResourceScheduler<T> {
    public DependencyConstraintFIFOResourceScheduler(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long priority = action.getPriority();
        long groupId = action.getGroupPriority();
        long resourceScore = 0L;
        long waitingScore = -action.getId();
        long implementationScore = 0L;
        return new Score(priority, groupId, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long resource = this.calculateConstraintScore(params);
        long waitingScore = -action.getId();
        long implementationScore = 0L;
        return new Score(priority, groupId, resource, waitingScore, implementationScore);
    }

    protected long calculateConstraintScore(TaskDescription td) {
        if (td.getType() == TaskType.METHOD) {
            List implementations = td.getCoreElement().getImplementations();
            if (implementations != null && !implementations.isEmpty()) {
                MethodResourceDescription description = (MethodResourceDescription)((Implementation)implementations.get(0)).getRequirements();
                return description.getTotalCPUComputingUnits() * td.getNumNodes();
            }
            return 0L;
        }
        return 0L;
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        if (this.hasBlockedActions()) {
            return null;
        }
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            long priority = resourceScore.getPriority();
            long groupId = action.getGroupPriority();
            long resourcePriority = resourceScore.getResourceScore();
            long waitingScore = resourceScore.getWaitingScore();
            long implScore = 0L;
            return new Score(priority, groupId, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "FIFODataResourceScheduler@" + this.getName();
    }
}

