/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fifo;

import es.bsc.compss.scheduler.ready.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONObject;

public class FIFOResourceScheduler<T extends WorkerResourceDescription>
extends ReadyResourceScheduler<T> {
    public FIFOResourceScheduler(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long actionPriority = action.getPriority();
        long resourceScore = -action.getId();
        long waitingScore = 0L;
        long implementationScore = 0L;
        return new Score(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long actionPriority = actionScore.getActionScore();
        long resourceScore = actionScore.getResourceScore();
        long waitingScore = 0L;
        long implementationScore = 0L;
        return new Score(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        if (this.hasBlockedActions()) {
            return null;
        }
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            long actionPriority = resourceScore.getActionScore();
            long resourcePriority = resourceScore.getResourceScore();
            long waitingScore = 0L;
            long implScore = 0L;
            return new Score(actionPriority, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "FIFOResourceScheduler@" + this.getName();
    }
}

