/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fifodatanew;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.fifodatanew.FIFODataResourceScheduler;
import es.bsc.compss.scheduler.readynew.ReadyScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.json.JSONObject;

public class FIFODataScheduler
extends ReadyScheduler {
    public <T extends WorkerResourceDescription> FIFODataResourceScheduler<T> generateSchedulerForResource(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        return new FIFODataResourceScheduler<T>(w, resJSON, implJSON);
    }

    public Score generateActionScore(AllocatableAction action) {
        return new Score((long)action.getPriority(), -action.getId(), 0L, 0L);
    }

    public <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        AllocatableAction freeAction;
        ObjectValue obj;
        LOGGER.debug("[FIFOData Scheduler] Treating dependency free actions");
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction action : dataFreeActions) {
            Score actionScore = this.generateActionScore(action);
            Score fullScore = action.schedulingScore(resource, actionScore);
            ObjectValue obj2 = new ObjectValue((Object)action, fullScore);
            executableActions.add(obj2);
        }
        dataFreeActions.clear();
        while (!executableActions.isEmpty() && !this.availableWorkers.isEmpty()) {
            obj = (ObjectValue)executableActions.poll();
            freeAction = (AllocatableAction)obj.getObject();
            try {
                List uselessWorkers = freeAction.tryToSchedule(obj.getScore(), (Set)this.availableWorkers);
                for (ResourceScheduler worker : uselessWorkers) {
                    this.availableWorkers.remove(worker);
                }
                ResourceScheduler assignedResource = freeAction.getAssignedResource();
                this.tryToLaunch(freeAction);
                if (assignedResource.canRunSomething()) continue;
                this.availableWorkers.remove(assignedResource);
            }
            catch (BlockedActionException e) {
                this.removeFromReady(freeAction);
                this.addToBlocked(freeAction);
            }
            catch (UnassignedActionException e) {
                dataFreeActions.add(freeAction);
            }
        }
        while (!executableActions.isEmpty()) {
            obj = (ObjectValue)executableActions.poll();
            freeAction = (AllocatableAction)obj.getObject();
            dataFreeActions.add(freeAction);
        }
        super.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }
}

