/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fifodata;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.fifodata.FIFODataResourceScheduler;
import es.bsc.compss.scheduler.ready.ReadyScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import java.util.PriorityQueue;
import org.json.JSONObject;

public class FIFODataScheduler
extends ReadyScheduler {
    public <T extends WorkerResourceDescription> FIFODataResourceScheduler<T> generateSchedulerForResource(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        return new FIFODataResourceScheduler<T>(w, resJSON, implJSON);
    }

    public Score generateActionScore(AllocatableAction action) {
        return new Score((long)action.getPriority(), -action.getId(), 0L, 0L);
    }

    public <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        LOGGER.debug("[DataScheduler] Treating dependency free actions");
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction action : dataFreeActions) {
            Score actionScore = this.generateActionScore(action);
            Score fullScore = action.schedulingScore(resource, actionScore);
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            executableActions.add(obj);
        }
        dataFreeActions.clear();
        while (!executableActions.isEmpty()) {
            ObjectValue obj = (ObjectValue)executableActions.poll();
            AllocatableAction freeAction = (AllocatableAction)obj.getObject();
            try {
                this.scheduleAction(freeAction, resource, obj.getScore());
                this.tryToLaunch(freeAction);
            }
            catch (BlockedActionException e) {
                blockedCandidates.add(freeAction);
            }
            catch (UnassignedActionException e) {
                dataFreeActions.add(freeAction);
            }
        }
        List unassignedReadyActions = this.unassignedReadyActions.removeAllActions();
        dataFreeActions.addAll(unassignedReadyActions);
    }
}

