/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fifodatalocation;

import es.bsc.compss.scheduler.readynew.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import org.json.JSONObject;

public class FIFODataLocationResourceScheduler<T extends WorkerResourceDescription>
extends ReadyResourceScheduler<T> {
    public FIFODataLocationResourceScheduler(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long priority = action.getPriority();
        long groupId = action.getGroupPriority();
        long resourceScore = 0L;
        long waitingScore = -action.getId();
        long implementationScore = 0L;
        return new Score(priority, groupId, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long resource = this.calculateResourceScore(params, action);
        long waitingScore = -action.getId();
        long implementationScore = 0L;
        return new Score(priority, groupId, resource, waitingScore, implementationScore);
    }

    private long calculateResourceScore(TaskDescription params, AllocatableAction action) {
        long resourceScore = 0L;
        if (params != null) {
            List parameters = params.getParameters();
            if (parameters.size() == 0) {
                return 1L;
            }
            resourceScore = (long)action.getSchedulingInfo().getScore((Resource)this.myWorker);
        }
        return resourceScore;
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        if (this.hasBlockedActions()) {
            return null;
        }
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            long priority = resourceScore.getPriority();
            long groupId = action.getGroupPriority();
            long resourcePriority = resourceScore.getResourceScore();
            long waitingScore = resourceScore.getWaitingScore();
            long implScore = -this.getProfile(impl).getAverageExecutionTime();
            return new Score(priority, groupId, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "FIFODataResourceScheduler@" + this.getName();
    }
}

