/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.ActionNotFoundException;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.InvalidSchedulingException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.multiobjective.types.Gap;
import es.bsc.compss.scheduler.multiobjective.types.LocalOptimizationState;
import es.bsc.compss.scheduler.multiobjective.types.MOProfile;
import es.bsc.compss.scheduler.multiobjective.types.MOScore;
import es.bsc.compss.scheduler.multiobjective.types.OptimizationAction;
import es.bsc.compss.scheduler.multiobjective.types.SchedulingEvent;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.CoreManager;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class MOResourceScheduler<T extends WorkerResourceDescription>
extends ResourceScheduler<T> {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    protected static final String LOG_PREFIX = "[MOResourceScheduler] ";
    private final LinkedList<Gap> gaps;
    private double pendingActionsEnergy = 0.0;
    private double pendingActionsCost = 0.0;
    private int[][] implementationsCount;
    private int[][] runningImplementationsCount;
    private double runningActionsEnergy = 0.0;
    private double runningActionsCost = 0.0;
    private double runActionsEnergy = 0.0;
    private double runActionsCost = 0.0;
    private OptimizationAction opAction;
    private final Set<AllocatableAction> pendingUnschedulings = new HashSet<AllocatableAction>();
    private AllocatableAction resourceBlockingAction = new OptimizationAction();
    private AllocatableAction dataBlockingAction = new OptimizationAction();
    private long expectedEndTimeRunning;
    private final double idlePower;
    private final double idlePrice;

    public MOResourceScheduler(Worker<T> w, JSONObject resourceJSON, JSONObject implsJSON) {
        super(w, resourceJSON, implsJSON);
        double idlePrice;
        double idlePower;
        this.gaps = new LinkedList();
        this.addGap(new Gap(Long.MIN_VALUE, Long.MAX_VALUE, null, this.myWorker.getDescription().copy(), 0));
        this.implementationsCount = new int[CoreManager.getCoreCount()][];
        this.runningImplementationsCount = new int[CoreManager.getCoreCount()][];
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            this.implementationsCount[coreId] = new int[CoreManager.getCoreImplementations((int)coreId).size()];
            this.runningImplementationsCount[coreId] = new int[CoreManager.getCoreImplementations((int)coreId).size()];
        }
        this.expectedEndTimeRunning = 0L;
        if (resourceJSON != null) {
            try {
                idlePower = resourceJSON.getDouble("idlePower");
            }
            catch (JSONException je) {
                idlePower = 1.0;
            }
            try {
                idlePrice = resourceJSON.getDouble("idlePrice");
            }
            catch (JSONException je) {
                idlePrice = 0.0;
            }
        } else {
            idlePower = 1.0;
            idlePrice = 0.0;
        }
        this.idlePower = idlePower;
        this.idlePrice = idlePrice;
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long resScore = (long)action.getSchedulingInfo().getPreregisteredScore((Resource)this.myWorker);
        for (AllocatableAction pred : action.getDataPredecessors()) {
            if (!pred.isPending() || pred.getAssignedResource() != this) continue;
            ++resScore;
        }
        resScore = (long)params.getParameters().size() - resScore;
        long lessTimeStamp = Long.MAX_VALUE;
        Gap g = this.gaps.peekFirst();
        if (g != null && (lessTimeStamp = g.getInitialTime()) < 0L) {
            lessTimeStamp = 0L;
        }
        long actionPriority = actionScore.getPriority();
        long actionGroupId = action.getGroupPriority();
        long expectedDataAvailable = ((MOScore)actionScore).getExpectedDataAvailable() + resScore * 10L;
        return new MOScore(actionPriority, actionGroupId, lessTimeStamp, expectedDataAvailable, 0L, 0.0, 0.0);
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        long resourceFreeTime = this.getResourceFreeTime(impl);
        long expectedDataAvailable = ((MOScore)resourceScore).getExpectedDataAvailable();
        long actionPriority = resourceScore.getPriority();
        long actionGroupId = action.getGroupPriority();
        return this.generateMOScore(resourceFreeTime, expectedDataAvailable, actionPriority, actionGroupId, impl);
    }

    public MOScore generateMoveImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore, long moveTime) {
        long resourceFreeTime = this.getResourceFreeTime(impl) + moveTime;
        long expectedDataAvailable = ((MOScore)resourceScore).getExpectedDataAvailable() + moveTime;
        long actionPriority = resourceScore.getPriority();
        long actionGroupId = action.getGroupPriority();
        return this.generateMOScore(resourceFreeTime, expectedDataAvailable, actionPriority, actionGroupId, impl);
    }

    private long getResourceFreeTime(Implementation impl) {
        ResourceDescription rd = impl.getRequirements().copy();
        long resourceFreeTime = 0L;
        try {
            for (Gap g : this.gaps) {
                rd.reduceDynamic(g.getResources());
                if (!rd.isDynamicUseless()) continue;
                resourceFreeTime = g.getInitialTime();
                break;
            }
        }
        catch (ConcurrentModificationException cme) {
            resourceFreeTime = 0L;
        }
        if (resourceFreeTime < 0L) {
            resourceFreeTime = 0L;
        }
        return resourceFreeTime;
    }

    public MOScore generateCurrentImplementationScore(AllocatableAction action, Implementation impl, Score resourceScore) {
        long resourceFreeTime = Long.MAX_VALUE;
        Gap g = this.gaps.peekFirst();
        if (g != null) {
            resourceFreeTime = ((MOSchedulingInformation)action.getSchedulingInfo()).getExpectedStart();
        }
        long expectedDataAvailable = ((MOScore)resourceScore).getExpectedDataAvailable();
        long actionPriority = resourceScore.getPriority();
        long actionGroupId = action.getGroupPriority();
        return this.generateMOScore(resourceFreeTime, expectedDataAvailable, actionPriority, actionGroupId, impl);
    }

    public MOScore generateMOScore(long resourceFreeTime, long expectedDataAvailable, long actionPriority, long actionGroupId, Implementation impl) {
        long implScore = 0L;
        double energy = 0.0;
        double cost = 0.0;
        MOProfile p = (MOProfile)this.getProfile(impl);
        if (p != null) {
            implScore = p.getAverageExecutionTime();
            long waitingTime = Math.max(resourceFreeTime, expectedDataAvailable);
            if (waitingTime < Long.MAX_VALUE) {
                energy = (double)(waitingTime + implScore) * this.getIdlePower() + p.getPower() * (double)implScore;
                cost = (double)(waitingTime + implScore) * this.getIdlePrice() + p.getPrice() * (double)implScore;
            } else {
                energy = Double.MAX_VALUE;
                cost = Double.MAX_VALUE;
            }
        }
        return new MOScore(actionPriority, actionGroupId, resourceFreeTime, expectedDataAvailable, implScore, energy, cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAction(AllocatableAction action) {
        LinkedList<Gap> linkedList = this.gaps;
        synchronized (linkedList) {
            if (this.opAction != null) {
                ((MOSchedulingInformation)this.opAction.getSchedulingInfo()).addSuccessor(action);
                Gap opActionGap = new Gap(0L, 0L, this.opAction, action.getAssignedImplementation().getRequirements().copy(), 0);
                ((MOSchedulingInformation)action.getSchedulingInfo()).addPredecessor(opActionGap);
            } else {
                this.scheduleUsingGaps(action, this.gaps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AllocatableAction> unscheduleAction(AllocatableAction action) throws ActionNotFoundException {
        MOSchedulingInformation succDSI;
        MOSchedulingInformation predDSI;
        super.unscheduleAction(action);
        LinkedList<AllocatableAction> freeActions = new LinkedList<AllocatableAction>();
        MOSchedulingInformation actionDSI = (MOSchedulingInformation)action.getSchedulingInfo();
        LinkedList<Gap> resources = new LinkedList<Gap>();
        for (Gap gap : actionDSI.getPredecessors()) {
            AllocatableAction allocatableAction = gap.getOrigin();
            if (allocatableAction == null) continue;
            predDSI = (MOSchedulingInformation)allocatableAction.getSchedulingInfo();
            predDSI.lock();
        }
        actionDSI.lock();
        if (!actionDSI.isScheduled() || action.getAssignedResource() != this) {
            for (Gap gap : actionDSI.getPredecessors()) {
                AllocatableAction allocatableAction = gap.getOrigin();
                if (allocatableAction == null) continue;
                predDSI = (MOSchedulingInformation)allocatableAction.getSchedulingInfo();
                predDSI.unlock();
            }
            actionDSI.unscheduled();
            actionDSI.unlock();
            throw new ActionNotFoundException();
        }
        LOGGER.debug("[MOResourceScheduler] Looking for dependency free successors");
        ResourceDescription unassignedResources = action.getAssignedImplementation().getRequirements().copy();
        for (Gap gap : actionDSI.getPredecessors()) {
            AllocatableAction pred2 = gap.getOrigin();
            if (pred2 == null) continue;
            if (!(pred2 instanceof OptimizationAction)) {
                resources.add(new Gap(gap.getInitialTime(), Long.MAX_VALUE, pred2, gap.getResources().copy(), 0));
                unassignedResources.reduceDynamic(gap.getResources());
            }
            MOSchedulingInformation predDSI2 = (MOSchedulingInformation)pred2.getSchedulingInfo();
            predDSI2.removeSuccessor(action);
        }
        resources.add(new Gap(Long.MIN_VALUE, Long.MAX_VALUE, null, unassignedResources, 0));
        actionDSI.clearPredecessors();
        LinkedList<MOSchedulingInformation> linkedList = new LinkedList<MOSchedulingInformation>();
        for (AllocatableAction successor : actionDSI.getSuccessors()) {
            succDSI = (MOSchedulingInformation)successor.getSchedulingInfo();
            succDSI.lock();
            linkedList.add(succDSI);
        }
        for (AllocatableAction successor : actionDSI.getSuccessors()) {
            LOGGER.debug("[MOResourceScheduler] Treating successor: " + successor);
            succDSI = (MOSchedulingInformation)successor.getSchedulingInfo();
            Gap toCover = succDSI.removePredecessor(action);
            if (toCover != null) {
                ResourceDescription resToCover = toCover.getResources();
                Iterator gIt = resources.iterator();
                while (gIt.hasNext()) {
                    Gap availableGap = (Gap)gIt.next();
                    ResourceDescription availableDesc = availableGap.getResources();
                    ResourceDescription usedResources = ResourceDescription.reduceCommonDynamics((ResourceDescription)availableDesc, (ResourceDescription)resToCover);
                    if (usedResources.isDynamicUseless()) continue;
                    AllocatableAction availableOrigin = availableGap.getOrigin();
                    MOSchedulingInformation availableDSI = null;
                    if (availableOrigin != null) {
                        availableDSI = (MOSchedulingInformation)availableOrigin.getSchedulingInfo();
                        availableDSI.addSuccessor(successor);
                        succDSI.addPredecessor(new Gap(availableGap.getInitialTime(), Long.MAX_VALUE, availableOrigin, usedResources, 0));
                    }
                    if (availableDesc.isDynamicUseless()) {
                        gIt.remove();
                        if (availableDSI != null) {
                            availableDSI.unlock();
                        }
                    }
                    if (!resToCover.isDynamicUseless()) continue;
                    break;
                }
            }
            if (!succDSI.isExecutable()) continue;
            freeActions.add(successor);
        }
        actionDSI.clearSuccessors();
        actionDSI.unscheduled();
        LinkedList<Gap> linkedList2 = this.gaps;
        synchronized (linkedList2) {
            if (actionDSI.isOnOptimization()) {
                this.pendingUnschedulings.add(action);
            }
            Iterator gIt = this.gaps.iterator();
            while (gIt.hasNext()) {
                Gap g = (Gap)gIt.next();
                if (g.getOrigin() != action) continue;
                gIt.remove();
            }
            for (Gap newGap : resources) {
                AllocatableAction gapAction = newGap.getOrigin();
                this.addGap(newGap);
                if (gapAction == null) continue;
                ((MOSchedulingInformation)gapAction.getSchedulingInfo()).unlock();
            }
        }
        Implementation implementation = action.getAssignedImplementation();
        MOProfile p = (MOProfile)this.getProfile(implementation);
        if (p != null) {
            long length = actionDSI.getExpectedEnd() - (actionDSI.getExpectedStart() < 0L ? 0L : actionDSI.getExpectedStart());
            this.pendingActionsCost -= p.getPrice() * (double)length;
            this.pendingActionsEnergy -= p.getPower() * (double)length;
        }
        actionDSI.unlock();
        for (MOSchedulingInformation successorsDSI : linkedList) {
            successorsDSI.unlock();
        }
        LOGGER.debug("[MOResourceScheduler] Returning " + freeActions.size() + " free actions.");
        return freeActions;
    }

    public void clear() {
        super.clear();
        this.gaps.clear();
        this.addGap(new Gap(Long.MIN_VALUE, Long.MAX_VALUE, null, this.myWorker.getDescription().copy(), 0));
    }

    private void scheduleUsingGaps(AllocatableAction action, List<Gap> gaps) {
        Object gap;
        long expectedStart = 0L;
        for (AllocatableAction predecessor : action.getDataPredecessors()) {
            MOSchedulingInformation predDSI = (MOSchedulingInformation)predecessor.getSchedulingInfo();
            if (!predDSI.isScheduled()) continue;
            long predEnd = predDSI.getExpectedEnd();
            expectedStart = Math.max(expectedStart, predEnd);
        }
        MOSchedulingInformation schedInfo = (MOSchedulingInformation)action.getSchedulingInfo();
        if (expectedStart == Long.MAX_VALUE) {
            Gap opActionGap = new Gap(0L, 0L, this.dataBlockingAction, action.getAssignedImplementation().getRequirements().copy(), 0);
            MOSchedulingInformation dbaDSI = (MOSchedulingInformation)this.dataBlockingAction.getSchedulingInfo();
            dbaDSI.lock();
            schedInfo.lock();
            dbaDSI.addSuccessor(action);
            schedInfo.addPredecessor(opActionGap);
            schedInfo.setExpectedStart(Long.MAX_VALUE);
            schedInfo.setExpectedEnd(Long.MAX_VALUE);
            schedInfo.scheduled();
            dbaDSI.unlock();
            schedInfo.unlock();
            return;
        }
        Implementation impl = action.getAssignedImplementation();
        MOProfile p = (MOProfile)this.getProfile(impl);
        ResourceDescription constraints = impl.getRequirements().copy();
        LinkedList<Gap> predecessors = new LinkedList<Gap>();
        Iterator<Object> gapIt = ((LinkedList)gaps).descendingIterator();
        boolean fullyCoveredReqs = false;
        while (gapIt.hasNext() && !fullyCoveredReqs) {
            gap = (Gap)gapIt.next();
            if (((Gap)gap).getInitialTime() > expectedStart) continue;
            this.useGap((Gap)gap, constraints, predecessors);
            fullyCoveredReqs = constraints.isDynamicUseless();
            if (!((Gap)gap).getResources().isDynamicUseless()) continue;
            gapIt.remove();
        }
        gapIt = gaps.iterator();
        while (gapIt.hasNext() && !fullyCoveredReqs) {
            gap = (Gap)gapIt.next();
            if (((Gap)gap).getInitialTime() <= expectedStart || ((Gap)gap).getInitialTime() >= Long.MAX_VALUE) continue;
            this.useGap((Gap)gap, constraints, predecessors);
            fullyCoveredReqs = constraints.isDynamicUseless();
            if (!((Gap)gap).getResources().isDynamicUseless()) continue;
            gapIt.remove();
        }
        if (!fullyCoveredReqs) {
            for (Gap pGap : predecessors) {
                this.addGap(pGap);
                AllocatableAction predecessor = pGap.getOrigin();
                if (predecessor == null) continue;
                MOSchedulingInformation predDSI = (MOSchedulingInformation)predecessor.getSchedulingInfo();
                predDSI.unlock();
            }
            Gap opActionGap = new Gap(0L, 0L, this.resourceBlockingAction, (ResourceDescription)action.getAssignedImplementation().getRequirements(), 0);
            MOSchedulingInformation rbaDSI = (MOSchedulingInformation)this.resourceBlockingAction.getSchedulingInfo();
            rbaDSI.lock();
            schedInfo.lock();
            rbaDSI.addSuccessor(action);
            schedInfo.addPredecessor(opActionGap);
            schedInfo.scheduled();
            schedInfo.setExpectedStart(Long.MAX_VALUE);
            schedInfo.setExpectedEnd(Long.MAX_VALUE);
            rbaDSI.unlock();
            schedInfo.unlock();
            return;
        }
        schedInfo.lock();
        schedInfo.scheduled();
        StringBuilder sb = null;
        if (IS_DEBUG) {
            sb = new StringBuilder("Predecessors: ");
        }
        for (Gap pGap : predecessors) {
            AllocatableAction predecessor = pGap.getOrigin();
            if (predecessor != null) {
                MOSchedulingInformation predDSI = (MOSchedulingInformation)predecessor.getSchedulingInfo();
                if (predDSI.isScheduled()) {
                    long predEnd = predDSI.getExpectedEnd();
                    expectedStart = Math.max(expectedStart, predEnd);
                    predDSI.addSuccessor(action);
                }
                predDSI.unlock();
            }
            schedInfo.addPredecessor(pGap);
            if (!IS_DEBUG) continue;
            sb.append(pGap.getOrigin()).append(" with ").append(pGap.getResources().getDynamicDescription()).append(", ");
        }
        schedInfo.setExpectedStart(expectedStart);
        long expectedEnd = expectedStart;
        if (p != null) {
            expectedEnd += p.getAverageExecutionTime();
            this.pendingActionsCost += p.getPrice() * (double)p.getAverageExecutionTime();
            this.pendingActionsEnergy += p.getPower() * (double)p.getAverageExecutionTime();
        }
        schedInfo.setExpectedEnd(expectedEnd);
        schedInfo.unlock();
        if (action.isToReleaseResources()) {
            this.addGap(new Gap(expectedEnd, Long.MAX_VALUE, action, impl.getRequirements().copy(), 0));
        } else {
            this.addGap(new Gap(Long.MAX_VALUE, Long.MAX_VALUE, action, impl.getRequirements().copy(), 0));
        }
        if (IS_DEBUG) {
            LOGGER.debug("[MOResourceScheduler] Scheduled " + action.toString() + ". Interval [ " + expectedStart + " - " + expectedEnd + "] " + sb.toString());
        }
    }

    private void useGap(Gap gap, ResourceDescription resources, List<Gap> predecessors) {
        AllocatableAction predecessor = gap.getOrigin();
        ResourceDescription gapResource = gap.getResources();
        ResourceDescription usedResources = ResourceDescription.reduceCommonDynamics((ResourceDescription)gapResource, (ResourceDescription)resources);
        if (usedResources.isDynamicConsuming()) {
            if (predecessor != null) {
                MOSchedulingInformation predDSI = (MOSchedulingInformation)predecessor.getSchedulingInfo();
                predDSI.lock();
            }
            Gap g = new Gap(gap.getInitialTime(), Long.MAX_VALUE, predecessor, usedResources, 0);
            predecessors.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PriorityQueue<AllocatableAction> localOptimization(long updateId, Comparator<AllocatableAction> selectionComparator, Comparator<AllocatableAction> donorComparator) {
        List<AllocatableAction> pendingSchedulings;
        LocalOptimizationState state = new LocalOptimizationState(updateId, this, MOResourceScheduler.getReadyComparator(), selectionComparator);
        PriorityQueue<AllocatableAction> actions = new PriorityQueue<AllocatableAction>(1, donorComparator);
        LinkedList<Gap> linkedList = this.gaps;
        synchronized (linkedList) {
            this.opAction = new OptimizationAction();
        }
        LOGGER.debug("[MOResourceScheduler] Scanning current actions");
        List<AllocatableAction> lockedActions = this.scanActions(state);
        LinkedList<AllocatableAction> newPendingSchedulings = new LinkedList<AllocatableAction>();
        LinkedList<Gap> linkedList2 = this.gaps;
        synchronized (linkedList2) {
            MOSchedulingInformation opDSI = (MOSchedulingInformation)this.opAction.getSchedulingInfo();
            pendingSchedulings = opDSI.replaceSuccessors(newPendingSchedulings);
        }
        LOGGER.debug("[MOResourceScheduler] Classify Pending Scheduling/Unscheduling actions");
        this.classifyPendingSchedulings(pendingSchedulings, state);
        this.classifyPendingUnschedulings(state);
        LOGGER.debug("[MOResourceScheduler] Reschedule pending actions");
        List<Gap> newGaps = this.rescheduleTasks(state, actions);
        for (AllocatableAction action : lockedActions) {
            MOSchedulingInformation actionDSI = (MOSchedulingInformation)action.getSchedulingInfo();
            try {
                actionDSI.unlock();
            }
            catch (IllegalMonitorStateException e) {
                LOGGER.debug("[MOResourceScheduler] Illegal Monitor Exception when releasing locked actions. Ignoring...");
            }
        }
        LOGGER.debug("[MOResourceScheduler] Manage new gaps");
        LinkedList<Gap> linkedList3 = this.gaps;
        synchronized (linkedList3) {
            this.gaps.clear();
            this.gaps.addAll(newGaps);
            MOSchedulingInformation opDSI = (MOSchedulingInformation)this.opAction.getSchedulingInfo();
            List<AllocatableAction> successors = opDSI.getSuccessors();
            for (AllocatableAction action : successors) {
                actions.add(action);
                MOSchedulingInformation actionDSI = (MOSchedulingInformation)action.getSchedulingInfo();
                actionDSI.lock();
                actionDSI.removePredecessor(this.opAction);
                this.scheduleUsingGaps(action, this.gaps);
                actionDSI.unlock();
            }
            opDSI.clearSuccessors();
            this.opAction = null;
        }
        return actions;
    }

    public List<AllocatableAction> scanActions(LocalOptimizationState state) {
        AllocatableAction allocatableAction;
        LinkedList<AllocatableAction> pendingToUnlockActions = new LinkedList<AllocatableAction>();
        PriorityQueue<AllocatableAction> actions = new PriorityQueue<AllocatableAction>(1, MOResourceScheduler.getScanComparator());
        MOSchedulingInformation blockSI = (MOSchedulingInformation)this.dataBlockingAction.getSchedulingInfo();
        List<AllocatableAction> blockActions = blockSI.getSuccessors();
        for (AllocatableAction allocatableAction2 : blockActions) {
            MOSchedulingInformation mOSchedulingInformation = (MOSchedulingInformation)allocatableAction2.getSchedulingInfo();
            mOSchedulingInformation.lock();
            mOSchedulingInformation.setOnOptimization(true);
            actions.add(allocatableAction2);
        }
        blockSI = (MOSchedulingInformation)this.resourceBlockingAction.getSchedulingInfo();
        blockActions = blockSI.getSuccessors();
        for (AllocatableAction allocatableAction3 : blockActions) {
            MOSchedulingInformation mOSchedulingInformation = (MOSchedulingInformation)allocatableAction3.getSchedulingInfo();
            mOSchedulingInformation.lock();
            mOSchedulingInformation.setOnOptimization(true);
            actions.add(allocatableAction3);
        }
        LinkedList<AllocatableAction> modified = new LinkedList<AllocatableAction>();
        while (true) {
            try {
                for (Gap gap : this.gaps) {
                    AllocatableAction gapAction = gap.getOrigin();
                    if (gapAction == null) continue;
                    MOSchedulingInformation dsi = (MOSchedulingInformation)gapAction.getSchedulingInfo();
                    dsi.lock();
                    dsi.setOnOptimization(true);
                    modified.add(gapAction);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                for (AllocatableAction action2 : modified) {
                    MOSchedulingInformation dsi2 = (MOSchedulingInformation)action2.getSchedulingInfo();
                    dsi2.setOnOptimization(false);
                    dsi2.unlock();
                }
                modified.clear();
                continue;
            }
            break;
        }
        actions.addAll(modified);
        while ((allocatableAction = actions.poll()) != null) {
            MOSchedulingInformation mOSchedulingInformation = (MOSchedulingInformation)allocatableAction.getSchedulingInfo();
            if (!mOSchedulingInformation.isScheduled()) {
                try {
                    mOSchedulingInformation.unlock();
                }
                catch (IllegalMonitorStateException e) {
                    LOGGER.debug("[MOResourceScheduler] Illegal Monitor Exception scaning actions. Ignoring...");
                }
                continue;
            }
            boolean hasInternal = false;
            boolean hasExternal = false;
            long startTime = 0L;
            block12: while (true) {
                LinkedList<MOSchedulingInformation> managedDSIs = new LinkedList<MOSchedulingInformation>();
                try {
                    List dPreds = allocatableAction.getDataPredecessors();
                    for (AllocatableAction dPred : dPreds) {
                        MOSchedulingInformation dPredDSI = (MOSchedulingInformation)dPred.getSchedulingInfo();
                        if (dPred.getAssignedResource() == this) {
                            if (!dPredDSI.tryToLock()) continue;
                            if (dPredDSI.isScheduled()) {
                                hasInternal = true;
                                dPredDSI.addOptimizingSuccessor(allocatableAction);
                                managedDSIs.add(dPredDSI);
                            }
                            dPredDSI.unlock();
                            continue;
                        }
                        hasExternal = true;
                        startTime = Math.max(startTime, dPredDSI.getExpectedEnd());
                    }
                }
                catch (ConcurrentModificationException cme) {
                    Iterator<Object> iterator = managedDSIs.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block12;
                        MOSchedulingInformation dsi3 = (MOSchedulingInformation)((Object)iterator.next());
                        dsi3.removeOptimizingSuccessor(allocatableAction);
                    }
                }
                break;
            }
            boolean hasResourcePredecessors = false;
            List<Gap> rPredGaps = mOSchedulingInformation.getPredecessors();
            for (Gap rPredGap : rPredGaps) {
                MOSchedulingInformation rPredDSI;
                AllocatableAction rPred = rPredGap.getOrigin();
                if (rPred == null || !(rPredDSI = (MOSchedulingInformation)rPred.getSchedulingInfo()).tryToLock()) continue;
                if (rPredDSI.isScheduled()) {
                    hasResourcePredecessors = true;
                    if (!rPredDSI.isOnOptimization()) {
                        rPredDSI.setOnOptimization(true);
                        actions.add(rPred);
                        continue;
                    }
                    rPredDSI.unlock();
                    continue;
                }
                rPredDSI.unlock();
            }
            mOSchedulingInformation.setExpectedStart(startTime);
            mOSchedulingInformation.setToReschedule(true);
            state.classifyAction(allocatableAction, hasInternal, hasExternal, hasResourcePredecessors, startTime);
            if (hasResourcePredecessors || hasInternal) {
                mOSchedulingInformation.unlock();
                continue;
            }
            pendingToUnlockActions.add(allocatableAction);
        }
        return pendingToUnlockActions;
    }

    public void classifyPendingSchedulings(List<AllocatableAction> pendingSchedulings, LocalOptimizationState state) {
        for (AllocatableAction action : pendingSchedulings) {
            MOSchedulingInformation actionDSI = (MOSchedulingInformation)action.getSchedulingInfo();
            actionDSI.scheduled();
            actionDSI.setOnOptimization(true);
            actionDSI.setToReschedule(true);
            boolean hasInternal = false;
            boolean hasExternal = false;
            long startTime = 0L;
            try {
                List dPreds = action.getDataPredecessors();
                for (AllocatableAction dPred : dPreds) {
                    MOSchedulingInformation dPredDSI = (MOSchedulingInformation)dPred.getSchedulingInfo();
                    if (dPred.getAssignedResource() == this) {
                        if (!dPredDSI.tryToLock()) continue;
                        if (dPredDSI.isScheduled()) {
                            hasInternal = true;
                            dPredDSI.addOptimizingSuccessor(action);
                        }
                        dPredDSI.unlock();
                        continue;
                    }
                    hasExternal = true;
                    startTime = Math.max(startTime, dPredDSI.getExpectedEnd());
                }
            }
            catch (ConcurrentModificationException cme) {
                hasInternal = false;
                hasExternal = false;
                startTime = 0L;
            }
            actionDSI.setExpectedStart(startTime);
            state.classifyAction(action, hasInternal, hasExternal, true, startTime);
        }
    }

    public void classifyPendingUnschedulings(LocalOptimizationState state) {
        for (AllocatableAction unscheduledAction : this.pendingUnschedulings) {
            MOSchedulingInformation actionDSI = (MOSchedulingInformation)unscheduledAction.getSchedulingInfo();
            List<AllocatableAction> successors = actionDSI.getOptimizingSuccessors();
            for (AllocatableAction successor : successors) {
                boolean hasInternal = false;
                boolean hasExternal = false;
                long startTime = 0L;
                try {
                    List dPreds = successor.getDataPredecessors();
                    for (AllocatableAction dPred : dPreds) {
                        MOSchedulingInformation dPredDSI = (MOSchedulingInformation)dPred.getSchedulingInfo();
                        if (dPred.getAssignedResource() == this) {
                            if (!dPredDSI.tryToLock()) continue;
                            if (dPredDSI.isScheduled()) {
                                hasInternal = true;
                                dPredDSI.addOptimizingSuccessor(successor);
                            }
                            dPredDSI.unlock();
                            continue;
                        }
                        hasExternal = true;
                        startTime = Math.max(startTime, dPredDSI.getExpectedEnd());
                    }
                }
                catch (ConcurrentModificationException cme) {
                    hasInternal = false;
                    hasExternal = false;
                    startTime = 0L;
                }
                actionDSI.setExpectedStart(startTime);
                state.classifyAction(successor, hasInternal, hasExternal, true, startTime);
            }
        }
        this.pendingUnschedulings.clear();
    }

    public List<Gap> rescheduleTasks(LocalOptimizationState state, PriorityQueue<AllocatableAction> rescheduledActions) {
        this.runActionsCost = 0.0;
        this.runActionsEnergy = 0.0;
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            for (int implId = 0; implId < CoreManager.getNumberCoreImplementations((int)coreId); ++implId) {
                MOProfile profile = (MOProfile)this.getProfile(coreId, implId);
                this.runActionsEnergy += profile.getPower() * (double)profile.getExecutionCount() * (double)profile.getAverageExecutionTime();
                this.runActionsCost += profile.getPrice() * (double)profile.getExecutionCount() * (double)profile.getAverageExecutionTime();
            }
        }
        Gap gap = state.peekFirstGap();
        ResourceDescription gapResource = gap.getResources();
        PriorityQueue<SchedulingEvent> schedulingQueue = new PriorityQueue<SchedulingEvent>();
        for (AllocatableAction action : state.getRunningActions()) {
            this.manageRunningAction(action, state);
            MOSchedulingInformation actionDSI = (MOSchedulingInformation)action.getSchedulingInfo();
            schedulingQueue.offer(new SchedulingEvent.End(actionDSI.getExpectedEnd(), action));
        }
        while (state.areRunnableActions() && !gapResource.isDynamicUseless()) {
            AllocatableAction top = state.getMostPrioritaryRunnableAction();
            state.replaceAction(top);
            if (!state.canActionRun()) break;
            state.removeMostPrioritaryRunnableAction();
            MOSchedulingInformation topDSI = (MOSchedulingInformation)top.getSchedulingInfo();
            topDSI.lock();
            topDSI.clearPredecessors();
            this.manageRunningAction(top, state);
            if (!this.tryToLaunch(top)) continue;
            schedulingQueue.offer(new SchedulingEvent.End(topDSI.getExpectedEnd(), top));
        }
        while (!schedulingQueue.isEmpty() || state.areActionsToBeRescheduled()) {
            while (!schedulingQueue.isEmpty()) {
                SchedulingEvent e = (SchedulingEvent)schedulingQueue.poll();
                List<SchedulingEvent> result = e.process(state, this, rescheduledActions);
                for (SchedulingEvent r : result) {
                    schedulingQueue.offer(r);
                }
            }
            if (!state.areActionsToBeRescheduled()) continue;
            AllocatableAction topAction = state.getEarliestActionToBeRescheduled();
            MOSchedulingInformation topActionDSI = (MOSchedulingInformation)topAction.getSchedulingInfo();
            topActionDSI.lock();
            topActionDSI.setToReschedule(false);
            schedulingQueue.offer(new SchedulingEvent.Start(topActionDSI.getExpectedStart(), topAction));
        }
        for (Gap g : state.getGaps()) {
            state.removeTmpGap(g);
        }
        this.pendingActionsCost = state.getTotalCost();
        this.pendingActionsEnergy = state.getTotalEnergy();
        this.implementationsCount = state.getImplementationsCount();
        this.expectedEndTimeRunning = state.getEndRunningTime();
        this.runningImplementationsCount = state.getRunningImplementations();
        this.runningActionsEnergy = state.getRunningEnergy();
        this.runningActionsCost = state.getRunningCost();
        this.resourceBlockingAction = state.getResourceBlockingAction();
        this.dataBlockingAction = state.getDataBlockingAction();
        return state.getGaps();
    }

    private void manageRunningAction(AllocatableAction action, LocalOptimizationState state) {
        Implementation impl = action.getAssignedImplementation();
        MOSchedulingInformation actionDSI = (MOSchedulingInformation)action.getSchedulingInfo();
        Long startTime = action.getStartTime();
        long start = startTime != null ? startTime - state.getId() : 0L;
        actionDSI.setExpectedStart(start);
        MOProfile p = (MOProfile)this.getProfile(impl);
        long endTime = start;
        if (p != null) {
            endTime += p.getAverageExecutionTime();
        }
        if (endTime < 0L) {
            endTime = 0L;
        }
        actionDSI.setExpectedEnd(endTime);
        actionDSI.clearPredecessors();
        actionDSI.clearSuccessors();
        actionDSI.setToReschedule(false);
        state.runningAction(impl, p, endTime);
    }

    private boolean tryToLaunch(AllocatableAction action) {
        boolean launched = false;
        try {
            action.tryToLaunch();
            launched = true;
        }
        catch (InvalidSchedulingException invalidSchedulingException) {
            // empty catch block
        }
        if (!launched) {
            MOScore aScore = new MOScore(action.getPriority(), action.getGroupPriority(), 0L, 0L, 0L, 0.0, 0.0);
            try {
                action.schedule((Score)aScore);
                try {
                    action.tryToLaunch();
                }
                catch (InvalidSchedulingException ise2) {
                    LOGGER.error((Object)ise2);
                }
            }
            catch (BlockedActionException | UnassignedActionException be) {
                LOGGER.error((Object)be);
            }
        }
        return launched;
    }

    public static final Comparator<AllocatableAction> getScanComparator() {
        return new Comparator<AllocatableAction>(){

            @Override
            public int compare(AllocatableAction action1, AllocatableAction action2) {
                MOSchedulingInformation action1DSI = (MOSchedulingInformation)action1.getSchedulingInfo();
                MOSchedulingInformation action2DSI = (MOSchedulingInformation)action2.getSchedulingInfo();
                int compare = Long.compare(action2DSI.getExpectedStart(), action1DSI.getExpectedStart());
                if (compare == 0) {
                    return Long.compare(action2.getId(), action1.getId());
                }
                return compare;
            }
        };
    }

    public static final Comparator<AllocatableAction> getReadyComparator() {
        return new Comparator<AllocatableAction>(){

            @Override
            public int compare(AllocatableAction action1, AllocatableAction action2) {
                MOSchedulingInformation action1DSI = (MOSchedulingInformation)action1.getSchedulingInfo();
                MOSchedulingInformation action2DSI = (MOSchedulingInformation)action2.getSchedulingInfo();
                int compare = Long.compare(action1DSI.getExpectedStart(), action2DSI.getExpectedStart());
                if (compare == 0) {
                    return Long.compare(action1.getId(), action2.getId());
                }
                return compare;
            }
        };
    }

    private void addGap(Gap g) {
        AllocatableAction gapAction = g.getOrigin();
        ResourceDescription releasedResources = g.getResources();
        boolean merged = false;
        for (Gap registeredGap : this.gaps) {
            if (registeredGap.getOrigin() != gapAction) continue;
            ResourceDescription registeredResources = registeredGap.getResources();
            registeredResources.increaseDynamic(releasedResources);
            merged = true;
            break;
        }
        if (!merged) {
            Gap gap;
            Iterator gapIt = this.gaps.iterator();
            int index = 0;
            while (gapIt.hasNext() && (gap = (Gap)gapIt.next()) != null && gap.getInitialTime() <= g.getInitialTime()) {
                ++index;
            }
            this.gaps.add(index, g);
        }
    }

    public long getFirstGapExpectedStart() {
        Gap g = this.gaps.peekFirst();
        if (g == null) {
            return 0L;
        }
        return g.getInitialTime();
    }

    public long getLastGapExpectedStart() {
        Gap g = this.gaps.peekLast();
        if (g == null) {
            return 0L;
        }
        return g.getInitialTime();
    }

    public Profile generateProfileForImplementation(Implementation impl, JSONObject jsonImpl) {
        return new MOProfile(jsonImpl);
    }

    public Profile generateProfileForRun(AllocatableAction action) {
        return new MOProfile(action.getAssignedImplementation(), this.myWorker);
    }

    public double getIdlePower() {
        return this.idlePower;
    }

    public double getRunActionsEnergy() {
        return this.runActionsEnergy;
    }

    public double getRunningActionsEnergy() {
        return this.runningActionsEnergy;
    }

    public double getScheduledActionsEnergy() {
        return this.pendingActionsEnergy;
    }

    public double getIdlePrice() {
        return this.idlePrice;
    }

    public double getRunActionsCost() {
        return this.runActionsCost;
    }

    public double getRunningActionsCost() {
        return this.runningActionsCost;
    }

    public double getScheduledActionsCost() {
        return this.pendingActionsCost;
    }

    public int getSimultaneousCapacity(Implementation impl) {
        return this.myWorker.fitCount(impl);
    }

    public int[][] getImplementationCounts() {
        return this.implementationsCount;
    }

    public long getExpectedEndTimeRunning() {
        return this.expectedEndTimeRunning;
    }

    public int[][] getRunningImplementationCounts() {
        return this.runningImplementationsCount;
    }

    public PriorityQueue<AllocatableAction> getBlockedActions() {
        PriorityQueue<AllocatableAction> blockedActions = new PriorityQueue<AllocatableAction>(20, new Comparator<AllocatableAction>(){

            @Override
            public int compare(AllocatableAction a1, AllocatableAction a2) {
                Score score1 = MOResourceScheduler.this.generateBlockedScore(a1);
                Score score2 = MOResourceScheduler.this.generateBlockedScore(a2);
                return score1.compareTo(score2);
            }
        });
        blockedActions.addAll(super.getBlockedActions());
        MOSchedulingInformation baDSI = (MOSchedulingInformation)this.dataBlockingAction.getSchedulingInfo();
        baDSI.lock();
        blockedActions.addAll(baDSI.getSuccessors());
        baDSI.unlock();
        baDSI = (MOSchedulingInformation)this.resourceBlockingAction.getSchedulingInfo();
        baDSI.lock();
        blockedActions.addAll(baDSI.getSuccessors());
        baDSI.unlock();
        return blockedActions;
    }

    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        json.put("idlePower", this.idlePower);
        json.put("idlePrice", this.idlePrice);
        return json;
    }

    public JSONObject updateJSON(JSONObject oldResource) {
        JSONObject difference = super.updateJSON(oldResource);
        double diff = this.idlePower;
        if (oldResource.has("idlePower")) {
            diff -= oldResource.getDouble("idlePower");
        }
        difference.put("idlePower", diff);
        oldResource.put("idlePower", this.idlePower);
        diff = this.idlePrice;
        if (oldResource.has("idlePrice")) {
            diff -= oldResource.getDouble("idlePrice");
        }
        difference.put("idlePrice", diff);
        oldResource.put("idlePrice", this.idlePrice);
        return difference;
    }
}

