/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective.types;

import es.bsc.compss.scheduler.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.multiobjective.config.MOConfiguration;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import java.util.List;

public class MOScore
extends Score {
    private final long expectedDataAvailable;
    private final double expectedCost;
    private final double expectedEnergy;

    public MOScore(long taskPriority, long dataAvailability, long resourceAvailability, long execTime, double energy, double cost) {
        super(taskPriority, resourceAvailability, Math.max(resourceAvailability, dataAvailability), execTime);
        this.expectedDataAvailable = dataAvailability;
        this.expectedCost = cost;
        this.expectedEnergy = energy;
    }

    public boolean isBetter(Score other) {
        MOScore otherDS = (MOScore)other;
        if (this.actionScore != otherDS.actionScore) {
            return this.actionScore > otherDS.actionScore;
        }
        double diffCost = this.expectedCost - otherDS.expectedCost;
        double diffEnergy = this.expectedEnergy - otherDS.expectedEnergy;
        long ownEnd = this.waitingScore + this.implementationScore;
        long otherEnd = otherDS.waitingScore + otherDS.implementationScore;
        long diffEnd = ownEnd - otherEnd;
        switch (MOConfiguration.getSchedulerOptimization()) {
            case COST: {
                if (diffCost == 0.0) {
                    if (diffEnd == 0L) {
                        return diffEnergy < 0.0;
                    }
                    return diffEnd < 0L;
                }
                return diffCost < 0.0;
            }
            case ENERGY: {
                if (diffEnergy == 0.0) {
                    if (diffEnd == 0L) {
                        return diffCost < 0.0;
                    }
                    return diffEnd < 0L;
                }
                return diffEnergy < 0.0;
            }
        }
        if (diffEnd == 0L) {
            if (diffEnergy == 0.0) {
                return diffCost < 0.0;
            }
            return diffEnergy < 0.0;
        }
        return diffEnd < 0L;
    }

    public static long getActionScore(AllocatableAction action) {
        return action.getPriority();
    }

    public static long getDataPredecessorTime(List<AllocatableAction> predecessors) {
        long dataTime = 0L;
        for (AllocatableAction pred : predecessors) {
            dataTime = Math.max(dataTime, ((MOSchedulingInformation)pred.getSchedulingInfo()).getExpectedEnd());
        }
        return dataTime;
    }

    public long getExpectedDataAvailable() {
        return this.expectedDataAvailable;
    }

    public long getExpectedStart() {
        return this.waitingScore;
    }

    public String toString() {
        return "[MOScore = [Action Priority:" + this.actionScore + ", Resource Availability:" + this.resourceScore + ", Data Availability:" + this.expectedDataAvailable + ", Expected Start Timestamp:" + this.waitingScore + ", Expected Execution Time:" + this.implementationScore + ", Expected Execution Consumption:" + this.expectedEnergy + ", Expected Execution Cost:" + this.expectedCost + "]]";
    }
}

