/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.ActionNotFoundException;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.InvalidSchedulingException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.multiobjective.MOResourceScheduler;
import es.bsc.compss.scheduler.multiobjective.MOScheduler;
import es.bsc.compss.scheduler.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.multiobjective.types.MOScore;
import es.bsc.compss.scheduler.multiobjective.types.OptimizationWorker;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.SchedulingOptimizer;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MOScheduleOptimizer
extends SchedulingOptimizer<MOScheduler> {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected static final String LOG_PREFIX = "[MOScheduleOptimizer] ";
    private static long OPTIMIZATION_THRESHOLD = 1000L;
    private boolean stop = false;
    private Semaphore sem = new Semaphore(0);

    public MOScheduleOptimizer(MOScheduler scheduler) {
        super((TaskScheduler)scheduler);
    }

    public void run() {
        long lastUpdate = System.currentTimeMillis();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (!this.stop) {
            long optimizationTS = System.currentTimeMillis();
            Collection workers = ((MOScheduler)this.scheduler).getWorkers();
            this.globalOptimization(optimizationTS, workers);
            lastUpdate = optimizationTS;
            this.waitForNextIteration(lastUpdate);
        }
        this.sem.release();
    }

    public void shutdown() {
        this.stop = true;
        this.interrupt();
        try {
            this.sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void waitForNextIteration(long lastUpdate) {
        long difference = OPTIMIZATION_THRESHOLD - (System.currentTimeMillis() - lastUpdate);
        if (difference > 0L) {
            try {
                Thread.sleep(difference);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void globalOptimization(long optimizationTS, Collection<ResourceScheduler<? extends WorkerResourceDescription>> workers) {
        LOGGER.debug("[MOScheduleOptimizer]  --- Start Global Optimization ---");
        int workersCount = workers.size();
        if (workersCount == 0) {
            return;
        }
        OptimizationWorker[] optimizedWorkers = new OptimizationWorker[workersCount];
        LinkedList<OptimizationWorker> receivers = new LinkedList<OptimizationWorker>();
        int i = 0;
        for (ResourceScheduler<? extends WorkerResourceDescription> resourceScheduler : workers) {
            optimizedWorkers[i] = new OptimizationWorker((MOResourceScheduler)resourceScheduler);
            ++i;
        }
        boolean hasDonated = true;
        while (hasDonated) {
            optimizationTS = System.currentTimeMillis();
            hasDonated = false;
            LOGGER.debug("[MOScheduleOptimizer]  --- Iteration of global Optimization ---");
            for (OptimizationWorker ow : optimizedWorkers) {
                LOGGER.debug("[MOScheduleOptimizer] Optimizing localy resource " + ow.getName());
                ow.localOptimization(optimizationTS);
                LOGGER.debug("[MOScheduleOptimizer] Resource " + ow.getName() + " will end at " + ow.getDonationIndicator());
            }
            LinkedList<OptimizationWorker> linkedList = MOScheduleOptimizer.determineDonorAndReceivers(optimizedWorkers, receivers);
            while (!hasDonated && !linkedList.isEmpty()) {
                AllocatableAction candidate;
                OptimizationWorker donor = linkedList.remove();
                block4: while (!hasDonated && (candidate = donor.pollDonorAction()) != null) {
                    for (OptimizationWorker receiver : receivers) {
                        if (!this.move(candidate, donor, receiver)) continue;
                        hasDonated = true;
                        continue block4;
                    }
                }
            }
            LOGGER.debug("[MOScheduleOptimizer] --- Optimization Iteration finished ---");
        }
        LOGGER.debug("[MOScheduleOptimizer] --- Global Optimization finished ---");
    }

    public static LinkedList<OptimizationWorker> determineDonorAndReceivers(OptimizationWorker[] workers, LinkedList<OptimizationWorker> receivers) {
        OptimizationWorker ow;
        receivers.clear();
        PriorityQueue<OptimizationWorker> receiversPQ = new PriorityQueue<OptimizationWorker>(1, MOScheduleOptimizer.getReceptionComparator());
        long topIndicator = Long.MIN_VALUE;
        LinkedList<OptimizationWorker> top = new LinkedList<OptimizationWorker>();
        for (OptimizationWorker ow2 : workers) {
            long indicator = ow2.getDonationIndicator();
            if (topIndicator > indicator) {
                receiversPQ.add(ow2);
                continue;
            }
            if (indicator > topIndicator) {
                topIndicator = indicator;
                for (OptimizationWorker extop : top) {
                    receiversPQ.add(extop);
                }
                top.clear();
            }
            top.add(ow2);
        }
        while ((ow = receiversPQ.poll()) != null) {
            receivers.add(ow);
        }
        return top;
    }

    public static Comparator<AllocatableAction> getSelectionComparator() {
        return new Comparator<AllocatableAction>(){

            @Override
            public int compare(AllocatableAction action1, AllocatableAction action2) {
                int priority = Integer.compare(action1.getPriority(), action2.getPriority());
                if (priority == 0) {
                    return Long.compare(action1.getId(), action2.getId());
                }
                return -priority;
            }
        };
    }

    public static Comparator<AllocatableAction> getDonationComparator() {
        return new Comparator<AllocatableAction>(){

            @Override
            public int compare(AllocatableAction action1, AllocatableAction action2) {
                MOSchedulingInformation action1DSI = (MOSchedulingInformation)action1.getSchedulingInfo();
                MOSchedulingInformation action2DSI = (MOSchedulingInformation)action2.getSchedulingInfo();
                int priority = Long.compare(action2DSI.getExpectedEnd(), action1DSI.getExpectedEnd());
                if (priority == 0) {
                    return Long.compare(action1.getId(), action2.getId());
                }
                return priority;
            }
        };
    }

    public static final Comparator<OptimizationWorker> getReceptionComparator() {
        return new Comparator<OptimizationWorker>(){

            @Override
            public int compare(OptimizationWorker worker1, OptimizationWorker worker2) {
                return Long.compare(worker1.getDonationIndicator(), worker2.getDonationIndicator());
            }
        };
    }

    private boolean move(AllocatableAction action, OptimizationWorker donor, OptimizationWorker receiver) {
        LOGGER.debug("[MOScheduleOptimizer] Trying to move " + action + " from " + donor.getName() + " to " + receiver.getName());
        List dataPreds = action.getDataPredecessors();
        long dataAvailable = 0L;
        try {
            for (AllocatableAction dataPred : dataPreds) {
                MOSchedulingInformation dsi = (MOSchedulingInformation)dataPred.getSchedulingInfo();
                dataAvailable = Math.max(dataAvailable, dsi.getExpectedEnd());
            }
        }
        catch (ConcurrentModificationException cme) {
            dataAvailable = 0L;
            dataPreds = action.getDataPredecessors();
        }
        Implementation bestImpl = null;
        List impls = action.getCompatibleImplementations(receiver.getResource());
        MOScore bestScore = null;
        for (Implementation impl : impls) {
            MOScore actionScore = MOScheduler.getActionScore(action);
            MOScore score = receiver.getResource().generateMoveImplementationScore(action, null, impl, actionScore, (long)((double)OPTIMIZATION_THRESHOLD * 2.5));
            if (!Score.isBetter((Score)score, bestScore)) continue;
            bestImpl = impl;
            bestScore = score;
        }
        Implementation currentImpl = action.getAssignedImplementation();
        MOScore actionScore = MOScheduler.getActionScore(action);
        LOGGER.debug("[MOScheduleOptimizer] Calculating score for current execution");
        MOScore currentScore = ((MOResourceScheduler)action.getAssignedResource()).generateCurrentImplementationScore(action, currentImpl, actionScore);
        LOGGER.debug("[MOScheduleOptimizer] Comparing scores: \n\t (New best)" + bestScore + "\n\t (Current" + (Object)((Object)currentScore));
        if (bestImpl != null && Score.isBetter((Score)bestScore, (Score)currentScore)) {
            try {
                LOGGER.debug("[MOScheduleOptimizer] Moving " + action + " from " + donor.getName() + " to " + receiver.getName());
                this.unscheduleFromWorker(action);
                this.scheduleOnWorker(action, bestImpl, receiver);
            }
            catch (ActionNotFoundException actionNotFoundException) {
                // empty catch block
            }
            return true;
        }
        LOGGER.debug("[MOScheduleOptimizer] Action " + action + " not moved because new position is not better than actual");
        return false;
    }

    public void scheduleOnWorker(AllocatableAction action, Implementation impl, OptimizationWorker ow) {
        boolean failedSpecificScheduling = false;
        try {
            action.schedule(ow.getResource(), impl);
            try {
                action.tryToLaunch();
            }
            catch (InvalidSchedulingException ise) {
                failedSpecificScheduling = true;
            }
        }
        catch (BlockedActionException ise) {
        }
        catch (UnassignedActionException be) {
            failedSpecificScheduling = true;
        }
        if (failedSpecificScheduling) {
            try {
                long actionScore = MOScore.getActionScore(action);
                long dataTime = MOScore.getDataPredecessorTime(action.getDataPredecessors());
                MOScore aScore = new MOScore(actionScore, dataTime, 0L, 0L, 0.0, 0.0);
                action.schedule((Score)aScore);
                try {
                    action.tryToLaunch();
                }
                catch (InvalidSchedulingException invalidSchedulingException) {}
            }
            catch (BlockedActionException | UnassignedActionException throwable) {
                // empty catch block
            }
        }
    }

    public void unscheduleFromWorker(AllocatableAction action) throws ActionNotFoundException {
        MOResourceScheduler resource = (MOResourceScheduler)action.getAssignedResource();
        resource.unscheduleAction(action);
    }
}

