/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.multiobjective.MOResourceScheduler;
import es.bsc.compss.scheduler.multiobjective.MOScheduler;
import es.bsc.compss.scheduler.multiobjective.config.MOConfiguration;
import es.bsc.compss.scheduler.multiobjective.types.MOProfile;
import es.bsc.compss.scheduler.multiobjective.types.MOScore;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.scheduler.types.WorkloadState;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.types.resources.updates.ResourceUpdate;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.ResourceOptimizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MOResourceOptimizer
extends ResourceOptimizer {
    private final long initialTimeStamp = System.currentTimeMillis();
    private StringBuilder log = new StringBuilder("-------------------------\n    CHECK SCALABILITY    \n-------------------------\n");

    public MOResourceOptimizer(MOScheduler ts) {
        super((TaskScheduler)ts);
    }

    protected ResourceOptimizer.CloudTypeProfile generateCloudTypeProfile(JSONObject citdJSON, JSONObject implsJSON) {
        return new MOCloudTypeProfile(citdJSON, implsJSON);
    }

    protected void applyPolicies(WorkloadState workload) {
        double timeBoundary = MOConfiguration.getTimeBoundary();
        double energyBoundary = MOConfiguration.getEnergyBoundary();
        double costBoundary = MOConfiguration.getMonetaryBoundary();
        double powerBoundary = MOConfiguration.getPowerBoundary();
        double priceBoundary = MOConfiguration.getPriceBoundary();
        double[] elapsedTime = new double[1];
        double[] elapsedEnergy = new double[1];
        double[] elapsedCost = new double[1];
        double[] elapsedPower = new double[1];
        double[] elapsedPrice = new double[1];
        Collection workers = this.ts.getWorkers();
        List creations = ResourceManager.getPendingCreationRequests();
        Resource[] allResources = new Resource[workers.size() + creations.size()];
        int[] load = new int[workload.getCoreCount()];
        HashMap<CloudInstanceTypeDescription, Integer> pendingCreations = new HashMap<CloudInstanceTypeDescription, Integer>();
        HashMap<CloudInstanceTypeDescription, Integer> pendingReductions = new HashMap<CloudInstanceTypeDescription, Integer>();
        ConfigurationCost actualCost = this.getContext(allResources, load, workers, creations, pendingCreations, pendingReductions, elapsedTime, elapsedEnergy, elapsedCost, elapsedPower, elapsedPrice);
        this.addToLog("Boundaries\n\tTime: " + timeBoundary + "s\n" + "\tEnergy: " + energyBoundary + "Wh\n" + "\tCost: " + costBoundary + "\u20ac\n" + "\tPower: " + powerBoundary + "W\n" + "\tPrice: " + priceBoundary + "\u20ac/h\n");
        this.addToLog("Elapsed\n\tTime: " + elapsedTime[0] + "s\n" + "\tEnergy: " + elapsedEnergy[0] + "Wh\n" + "\tCost: " + elapsedCost[0] + "\u20ac\n" + "\tPower: " + elapsedPower[0] + "W\n" + "\tPrice: " + elapsedPrice[0] + "\u20ac/h\n");
        double timeBudget = timeBoundary - elapsedTime[0];
        double energyBudget = energyBoundary - elapsedEnergy[0];
        double costBudget = costBoundary - elapsedCost[0];
        double powerBudget = powerBoundary - elapsedPower[0];
        double priceBudget = priceBoundary - elapsedPrice[0];
        this.addToLog("Budget\n\tTime: " + timeBudget + "s\n" + "\tEnergy: " + energyBudget + "Wh - " + energyBudget * 3600.0 + "J\n" + "\tCost: " + costBudget + "\u20ac\n" + "\tPower: " + powerBudget + "W\n" + "\tPrice: " + priceBudget + "\u20ac/h\n");
        this.addToLog("Current Resources\n");
        this.addToLog("Workload Info:\n");
        for (int coreId = 0; coreId < workload.getCoreCount(); ++coreId) {
            this.addToLog("\tCore " + coreId + ": " + load[coreId] + "\n");
        }
        Action actualAction = new Action(actualCost);
        this.addToLog("Actual Cost:\n");
        this.addToLog(actualAction.toString());
        ConfigurationCost simCost = this.simulate(load, allResources, 0L, 0.0, 0.0);
        this.addToLog("Actual Simulated:\n");
        Action currentSim = new Action(simCost);
        this.addToLog(currentSim.toString());
        LinkedList<Action> actions = this.generatePossibleActions(allResources, load);
        Action action = this.selectBestAction(currentSim, actions, timeBudget, energyBudget, costBudget, powerBudget, priceBudget);
        this.addToLog("Action to perform: " + action.title + "\n");
        this.printLog();
        action.perform();
    }

    private LinkedList<Action> generatePossibleActions(Resource<?>[] allResources, int[] load) {
        LinkedList<Action> actions = new LinkedList<Action>();
        if (ResourceManager.getCurrentVMCount() < ResourceManager.getMaxCloudVMs()) {
            this.generatePossibleResourceAcquisitions(actions, allResources, load);
        }
        if (ResourceManager.getCurrentVMCount() > ResourceManager.getMinCloudVMs()) {
            this.generatePossibleResourceReleases(actions, allResources, load);
        }
        return actions;
    }

    private void generatePossibleResourceAcquisitions(LinkedList<Action> actions, Resource<?>[] allResources, int[] load) {
        for (CloudProvider cp : ResourceManager.getAvailableCloudProviders()) {
            if (!cp.canHostMoreInstances()) continue;
            for (CloudInstanceTypeDescription citd : cp.getAllTypes()) {
                for (CloudImageDescription cid : cp.getAllImages()) {
                    Resource[] resources = new Resource[allResources.length + 1];
                    System.arraycopy(allResources, 0, resources, 0, allResources.length);
                    resources[allResources.length] = this.createResourceForComponent(citd, cid);
                    ConfigurationCost cc = this.simulate(load, resources, 0L, 0.0, 0.0);
                    ActionAdd a = new ActionAdd(cp, citd, cid, cc);
                    this.addToLog(a.toString());
                    actions.add(a);
                }
            }
        }
    }

    private void generatePossibleResourceReleases(LinkedList<Action> actions, Resource<?>[] allResources, int[] load) {
        for (int i = 0; i < allResources.length; ++i) {
            Resource<?> excludedWorker = allResources[i];
            Worker w = ((Resource)excludedWorker).getResource();
            if (w == null || !(w.getDescription() instanceof CloudMethodResourceDescription)) continue;
            CloudMethodResourceDescription description = (CloudMethodResourceDescription)w.getDescription();
            if (((Resource)excludedWorker).hasPendingModifications()) continue;
            CloudImageDescription image = description.getImage();
            for (CloudInstanceTypeDescription typeReduction : description.getPossibleReductions()) {
                ConfigurationCost cc;
                CloudMethodResourceDescription reductionDescription = new CloudMethodResourceDescription(typeReduction, image);
                CloudMethodResourceDescription reducedDescription = new CloudMethodResourceDescription(description);
                reducedDescription.reduce((ResourceDescription)reductionDescription);
                if (reducedDescription.getTypeComposition().isEmpty()) {
                    Resource[] resources = new Resource[allResources.length - 1];
                    System.arraycopy(allResources, 0, resources, 0, i);
                    System.arraycopy(allResources, i + 1, resources, i, resources.length - i);
                    long time = ((Resource)excludedWorker).startTime;
                    double energy = ((Resource)excludedWorker).idlePower * (double)time + ((Resource)excludedWorker).startEnergy;
                    double cost = ((Resource)excludedWorker).startCost;
                    cc = this.simulate(load, resources, time, energy, cost);
                } else {
                    allResources[i] = this.reduceResourceForComponent(excludedWorker, reducedDescription);
                    long time = ((Resource)excludedWorker).startTime;
                    double energy = ((Resource)excludedWorker).idlePower * (double)time + ((Resource)excludedWorker).startEnergy;
                    double cost = ((Resource)excludedWorker).startCost;
                    cc = this.simulate(load, allResources, time, energy, cost);
                    allResources[i] = excludedWorker;
                }
                ActionRemove a = new ActionRemove(excludedWorker, typeReduction, cc);
                this.addToLog(a.toString());
                actions.add(a);
            }
        }
    }

    private Action selectBestAction(Action currentAction, LinkedList<Action> candidates, double timeBudget, double energyBudget, double costBudget, double powerBudget, double priceBudget) {
        this.addToLog("SELECTING BEST ACTION ACCORDING TO " + (Object)((Object)MOConfiguration.getSchedulerOptimization()) + "\n");
        Action bestAction = currentAction;
        for (Action action : candidates) {
            boolean improves = false;
            if (action.cost.power > powerBudget || action.cost.price > priceBudget) {
                this.addToLog("\t\t Surpasses the power (" + action.cost.power + ">" + powerBudget + ") or price budget (" + action.cost.price + ">" + priceBudget + ")");
            } else {
                this.addToLog("\tChecking " + action.title + "\n");
                switch (MOConfiguration.getSchedulerOptimization()) {
                    case TIME: {
                        improves = this.doesImproveTime(action, bestAction, energyBudget, costBudget);
                        break;
                    }
                    case COST: {
                        improves = this.doesImproveCost(action, bestAction, energyBudget, timeBudget);
                        break;
                    }
                    case ENERGY: {
                        improves = this.doesImproveEnergy(action, bestAction, timeBudget, costBudget);
                        break;
                    }
                }
            }
            if (improves) {
                this.addToLog("\t\t" + action.title + " becomes the preferred option\n");
                bestAction = action;
                continue;
            }
            this.addToLog("\t\t" + action.title + " does not improve " + bestAction.title + "\n");
        }
        return bestAction;
    }

    private static <T extends Comparable<T>> boolean isAcceptable(T candidate, T reference, T budget) {
        if (reference.compareTo(budget) > 0) {
            return candidate.compareTo(reference) <= 0;
        }
        return candidate.compareTo(budget) <= 0;
    }

    private boolean doesImproveTime(Action candidate, Action reference, double energyBudget, double costBudget) {
        ConfigurationCost cCost = candidate.cost;
        ConfigurationCost rCost = reference.cost;
        if (cCost.time < rCost.time) {
            if (!MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, energyBudget)) {
                this.addToLog("\t\t Surpasses the energy budget\n");
            }
            if (!MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget)) {
                this.addToLog("\t\t Surpasses the cost budget\n");
            }
            return MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, energyBudget) && MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget);
        }
        if (cCost.time == rCost.time) {
            if (cCost.energy < rCost.energy) {
                return MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget);
            }
            if (cCost.energy == rCost.energy) {
                return cCost.cost < rCost.cost;
            }
            this.addToLog("\t\t Energy's higher than the currently selected option\n");
        } else {
            if (rCost.energy > energyBudget && cCost.energy < rCost.energy) {
                if (MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget)) {
                    this.addToLog("\t\t Time's higher than the currently selected option. But energy is closer to the boundary\n");
                }
                return MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget);
            }
            if (rCost.cost > costBudget && cCost.cost < rCost.cost) {
                if (MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, costBudget)) {
                    this.addToLog("\t\t Time's higher than the currently selected option. But cost is closer to the boundary\n");
                }
                return MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, costBudget);
            }
            this.addToLog("\t\t Time's higher than the currently selected option\n");
        }
        return false;
    }

    private boolean doesImproveCost(Action candidate, Action reference, double energyBudget, double timeBudget) {
        ConfigurationCost cCost = candidate.cost;
        ConfigurationCost rCost = reference.cost;
        if (cCost.cost < rCost.cost) {
            if (!MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, energyBudget)) {
                this.addToLog("\t\t Surpasses the energy budget " + cCost.energy + " > " + energyBudget + "\n");
            }
            if (!MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget)) {
                this.addToLog("\t\t Surpasses the time budget " + cCost.time + " > " + timeBudget + "\n");
            }
            return MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, energyBudget) && MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget);
        }
        if (cCost.cost == rCost.cost) {
            if (cCost.time < rCost.time) {
                return MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, energyBudget);
            }
            if (cCost.time == rCost.time) {
                return cCost.energy < rCost.energy;
            }
            this.addToLog("\t\t Time's higher than the currently selected option\n");
        } else {
            if (rCost.time > timeBudget && cCost.time < rCost.time) {
                if (MOResourceOptimizer.isAcceptable(cCost.energy, rCost.energy, energyBudget)) {
                    this.addToLog("\t\t Cost's higher than the currently selected option. But time is closer to the boundary\n");
                }
                return MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, energyBudget);
            }
            if (rCost.energy > energyBudget && cCost.energy < rCost.energy) {
                if (MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget)) {
                    this.addToLog("\t\t Energy's higher than the currently selected option. But energy is closer to the boundary\n");
                }
                return MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget);
            }
            this.addToLog("\t\t Cost's higher than the currently selected option\n");
        }
        return false;
    }

    private boolean doesImproveEnergy(Action candidate, Action reference, double timeBudget, double costBudget) {
        ConfigurationCost cCost = candidate.cost;
        ConfigurationCost rCost = reference.cost;
        if (cCost.energy < rCost.energy) {
            if (!MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget)) {
                this.addToLog("\t\t Surpasses the time budget\n");
            }
            if (!MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget)) {
                this.addToLog("\t\t Surpasses the cost budget\n");
            }
            return MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget) && MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget);
        }
        if (cCost.energy == rCost.energy) {
            if (cCost.time < rCost.time) {
                return MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget);
            }
            if (cCost.time == rCost.time) {
                return cCost.cost < rCost.cost;
            }
            this.addToLog("\t\t Time's higher than the currently selected option\n");
        } else {
            if (rCost.time > timeBudget && cCost.time < rCost.time) {
                if (MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget)) {
                    this.addToLog("\t\t Energy's higher than the currently selected option. But time is closer to the boundary\n");
                }
                return MOResourceOptimizer.isAcceptable(cCost.cost, rCost.cost, costBudget);
            }
            if (rCost.cost > costBudget && cCost.cost < rCost.cost) {
                if (MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget)) {
                    this.addToLog("\t\t Energy's higher than the currently selected option. But time is closer to the boundary\n");
                }
                return MOResourceOptimizer.isAcceptable(cCost.time, rCost.time, timeBudget);
            }
            this.addToLog("\t\t Energy's higher than the currently selected option.\n");
        }
        return false;
    }

    private <T extends WorkerResourceDescription> ConfigurationCost getContext(Resource<?>[] allResources, int[] load, Collection<ResourceScheduler<? extends WorkerResourceDescription>> workers, List<ResourceCreationRequest> creations, HashMap<CloudInstanceTypeDescription, Integer> pendingCreations, HashMap<CloudInstanceTypeDescription, Integer> pendingDestructions, double[] elapsedTime, double[] elapsedEnergy, double[] elapsedCost, double[] elapsedPower, double[] elapsedPrice) {
        elapsedTime[0] = 0.0;
        elapsedEnergy[0] = 0.0;
        elapsedCost[0] = 0.0;
        elapsedPower[0] = 0.0;
        elapsedPrice[0] = 0.0;
        double time = 0.0;
        double actionsCost = 0.0;
        double idlePrice = 0.0;
        double actionsEnergy = 0.0;
        double idlePower = 0.0;
        int resourceId = 0;
        for (ResourceScheduler<? extends WorkerResourceDescription> w : workers) {
            int coreId;
            MOResourceScheduler aw = (MOResourceScheduler)w;
            Resource resource = new Resource(aw);
            allResources[resourceId] = resource;
            this.addToLog("\tName:" + aw.getName() + (resource.hasPendingModifications() ? " (IS TO BE DELETED)" : "") + "\n");
            time = Math.max(time, (double)aw.getLastGapExpectedStart());
            this.addToLog("\t\tTime:" + aw.getLastGapExpectedStart() + " ms -> total " + time + "\n");
            elapsedCost[0] = elapsedCost[0] + aw.getRunActionsCost();
            this.addToLog("\t\tExecuted Actions Cost:" + aw.getRunActionsCost() + " \u20ac.ms/h -> total " + elapsedCost[0] + "\u20ac.ms/h\n");
            this.addToLog("\t\tScheduled Actions Cost:" + aw.getScheduledActionsCost() + " \u20ac.ms/h -> total " + (actionsCost += aw.getScheduledActionsCost()) + "\u20ac.ms/h\n");
            resource.idlePrice = aw.getIdlePrice();
            this.addToLog("\t\tIdle Price:" + resource.idlePrice + " \u20ac/h -> total " + (idlePrice += resource.idlePrice) + "\u20ac/h\n");
            elapsedEnergy[0] = elapsedEnergy[0] + aw.getRunActionsEnergy();
            this.addToLog("\t\tExecuted Actions Energy:" + aw.getRunActionsEnergy() + " mJ -> total " + elapsedEnergy[0] + "mJ\n");
            this.addToLog("\t\tScheduled Actions Energy:" + aw.getScheduledActionsEnergy() + " mJ -> total " + (actionsEnergy += aw.getScheduledActionsEnergy()) + "mJ\n");
            resource.idlePower = aw.getIdlePower();
            this.addToLog("\t\tIdle Power:" + resource.idlePower + " W -> total " + (idlePower += resource.idlePower) + "W\n");
            resource.startTime = aw.getExpectedEndTimeRunning();
            resource.startCost = aw.getRunningActionsCost();
            resource.startEnergy = aw.getRunningActionsEnergy();
            int[][] implsCount = aw.getImplementationCounts();
            int[][] runningCounts = aw.getRunningImplementationCounts();
            this.addToLog("\t\tCore Information:\n");
            StringBuilder[] coreInfo = new StringBuilder[CoreManager.getCoreCount()];
            Implementation[] impls = new Implementation[CoreManager.getCoreCount()];
            for (coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                coreInfo[coreId] = new StringBuilder("\t\t\tCore " + coreId + "\n");
                int favId = 0;
                int favCount = implsCount[coreId][0];
                int n = coreId;
                load[n] = load[n] + (implsCount[coreId][0] - runningCounts[coreId][0]);
                coreInfo[coreId].append("\t\t\t\tImplementation 0: " + implsCount[coreId][0] + ", " + runningCounts[coreId][0] + " of'em already running\n");
                for (int implId = 1; implId < CoreManager.getCoreImplementations((int)coreId).size(); ++implId) {
                    coreInfo[coreId].append("\t\t\t\tImplementation " + implId + ": " + implsCount[coreId][implId] + ", " + runningCounts[coreId][implId] + " of'em already running\n");
                    int n2 = coreId;
                    load[n2] = load[n2] + (implsCount[coreId][implId] - runningCounts[coreId][implId]);
                    if (implsCount[coreId][implId] <= favCount) continue;
                    favId = implId;
                }
                if (favCount > 0) {
                    impls[coreId] = (Implementation)CoreManager.getCoreImplementations((int)coreId).get(favId);
                } else {
                    List coreImpls = CoreManager.getCoreImplementations((int)coreId);
                    MOProfile[] profiles = new MOProfile[coreImpls.size()];
                    for (int i = 0; i < profiles.length; ++i) {
                        profiles[i] = (MOProfile)aw.getProfile((Implementation)coreImpls.get(i));
                    }
                    impls[coreId] = this.getBestImplementation(coreImpls, profiles);
                }
                coreInfo[coreId].append("\t\t\t\tFavorite Implementation " + favId + "\n");
            }
            Resource.access$1302(resource, new MOProfile[implsCount.length]);
            Resource.access$1402(resource, new int[implsCount.length]);
            for (coreId = 0; coreId < implsCount.length; ++coreId) {
                resource.profiles[coreId] = (MOProfile)aw.getProfile(impls[coreId]);
                coreInfo[coreId].append("\t\t\t\tProfile " + (Object)((Object)resource.profiles[coreId]) + "\n");
                resource.capacity[coreId] = aw.getSimultaneousCapacity(impls[coreId]);
                coreInfo[coreId].append("\t\t\t\tCapacity " + resource.capacity[coreId] + "\n");
                this.addToLog(coreInfo[coreId].toString());
            }
            if (resource.hasPendingModifications()) {
                for (ResourceUpdate ru : resource.getPendingModifications()) {
                    Map modificationComposition = ((CloudMethodResourceDescription)ru.getModification()).getTypeComposition();
                    for (Map.Entry entry : modificationComposition.entrySet()) {
                        CloudInstanceTypeDescription componentType = (CloudInstanceTypeDescription)entry.getKey();
                        int count = ((int[])entry.getValue())[0];
                        Integer pendingDestruction = pendingDestructions.get(componentType);
                        if (pendingDestruction == null) {
                            pendingDestruction = 0;
                        }
                        pendingDestruction = pendingDestruction + count;
                        pendingDestructions.put(componentType, pendingDestruction);
                    }
                }
            }
            ++resourceId;
        }
        elapsedTime[0] = (double)(System.currentTimeMillis() - this.initialTimeStamp) / 1000.0;
        elapsedEnergy[0] = elapsedEnergy[0] / 3600000.0;
        elapsedCost[0] = elapsedCost[0] / 3600000.0;
        for (ResourceCreationRequest rcr : creations) {
            int coreId;
            for (Map.Entry entry : rcr.getRequested().getTypeComposition().entrySet()) {
                CloudInstanceTypeDescription componentType = (CloudInstanceTypeDescription)entry.getKey();
                int count = ((int[])entry.getValue())[0];
                this.addToLog("\tName: REQUESTED " + componentType.getName() + "\n");
                Integer pendingCreation = pendingCreations.get(componentType);
                if (pendingCreation == null) {
                    pendingCreation = 0;
                }
                pendingCreation = pendingCreation + count;
                pendingCreations.put(componentType, pendingCreation);
            }
            Resource<?> r = this.createResourceForCreationRequest(rcr);
            allResources[resourceId] = r;
            this.addToLog("\t\tTime: 0 ms -> total " + time + "\n");
            this.addToLog("\t\tactions Cost: 0 \u20ac -> total " + actionsCost + "\u20ac\n");
            this.addToLog("\t\tIdle Price:" + ((Resource)r).idlePrice + " \u20ac -> total " + (idlePrice += ((Resource)r).idlePrice) + "\u20ac\n");
            this.addToLog("\t\tactions Energy:0 mJ -> total " + actionsEnergy + "mJ\n");
            this.addToLog("\t\tIdle Power:" + ((Resource)r).idlePower + " W -> total " + (idlePower += ((Resource)r).idlePower) + "W\n");
            ((Resource)r).startCost = 0.0;
            ((Resource)r).startEnergy = 0.0;
            this.addToLog("\t\tCore Information:\n");
            StringBuilder[] stringBuilderArray = new StringBuilder[CoreManager.getCoreCount()];
            for (coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                stringBuilderArray[coreId] = new StringBuilder("\t\t\tCore " + coreId + "\n");
                int n = coreId;
                load[n] = load[n] + 0;
                stringBuilderArray[coreId].append("\t\t\t\tImplementation 0: 0, 0 of'em already running\n");
                for (int implId = 1; implId < CoreManager.getCoreImplementations((int)coreId).size(); ++implId) {
                    stringBuilderArray[coreId].append("\t\t\t\tImplementation " + implId + ": 0, 0 of'em already running\n");
                }
                stringBuilderArray[coreId].append("\t\t\t\tFavorite Implementation 0\n");
            }
            for (coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                stringBuilderArray[coreId].append("\t\t\t\tProfile " + (Object)((Object)((Resource)r).profiles[coreId]) + "\n");
                stringBuilderArray[coreId].append("\t\t\t\tCapacity " + ((Resource)r).capacity[coreId] + "\n");
                this.addToLog(stringBuilderArray[coreId].toString());
            }
            ++resourceId;
        }
        return new ConfigurationCost(time, idlePower, actionsEnergy, idlePrice, actionsCost);
    }

    /*
     * WARNING - void declaration
     */
    private ConfigurationCost simulate(int[] counts, Resource<?>[] resources, long minTime, double minEnergy, double minCost) {
        Resource<?> r;
        void var13_14;
        int[] workingCounts = new int[counts.length];
        System.arraycopy(counts, 0, workingCounts, 0, counts.length);
        LinkedList executable = new LinkedList();
        Resource<?>[] resourceArray = resources;
        int n = resourceArray.length;
        boolean bl = false;
        while (var13_14 < n) {
            r = resourceArray[var13_14];
            r.clear();
            if (((Resource)r).canExecute()) {
                executable.add(r);
            }
            ++var13_14;
        }
        SortedList sl = new SortedList(executable.size());
        for (Resource resource : executable) {
            sl.initialAdd(resource);
        }
        for (int coreId = 0; coreId < workingCounts.length; ++coreId) {
            while (workingCounts[coreId] > 0) {
                Resource<?> resource = sl.peek();
                r = resource;
                ((Resource)r).time = ((Resource)r).time + ((Resource)resource).profiles[coreId].getAverageExecutionTime();
                int[] nArray = ((Resource)resource).counts;
                int n2 = coreId;
                nArray[n2] = nArray[n2] + Math.min(((Resource)resource).capacity[coreId], workingCounts[coreId]);
                int n3 = coreId;
                workingCounts[n3] = workingCounts[n3] - ((Resource)resource).capacity[coreId];
                sl.add(resource);
            }
        }
        long time = minTime;
        double idlePower = 0.0;
        double actionsEnergy = 0.0;
        double idlePrice = 0.0;
        double actionsCost = 0.0;
        for (Resource<?> r2 : resources) {
            double rActionsEnergy = ((Resource)r2).startEnergy;
            double rActionsCost = ((Resource)r2).startCost;
            time = Math.max(time, ((Resource)r2).time);
            idlePower += ((Resource)r2).idlePower;
            idlePrice += ((Resource)r2).idlePrice;
            for (int coreId = 0; coreId < ((Resource)r2).counts.length; ++coreId) {
                rActionsEnergy += (double)((Resource)r2).counts[coreId] * ((Resource)r2).profiles[coreId].getPower() * (double)((Resource)r2).profiles[coreId].getAverageExecutionTime();
                rActionsCost += (double)((Resource)r2).counts[coreId] * ((Resource)r2).profiles[coreId].getPrice() * (double)((Resource)r2).profiles[coreId].getAverageExecutionTime();
            }
            actionsEnergy += rActionsEnergy;
            actionsCost += rActionsCost;
        }
        return new ConfigurationCost(time, idlePower, actionsEnergy + minEnergy, idlePrice, actionsCost + minCost);
    }

    private Resource<?> reduceResourceForComponent(Resource<?> excludedWorker, CloudMethodResourceDescription reduction) {
        Resource clone = new Resource(((Resource)excludedWorker).worker);
        clone.idlePower = ((Resource)excludedWorker).idlePower;
        clone.idlePrice = ((Resource)excludedWorker).idlePrice;
        Resource.access$1402(clone, new int[((Resource)excludedWorker).capacity.length]);
        System.arraycopy(((Resource)excludedWorker).capacity, 0, clone.capacity, 0, ((Resource)excludedWorker).capacity.length);
        clone.startTime = ((Resource)excludedWorker).startTime;
        clone.startEnergy = ((Resource)excludedWorker).startEnergy;
        clone.startCost = ((Resource)excludedWorker).startCost;
        clone.time = ((Resource)excludedWorker).time;
        Resource.access$1802(clone, ((Resource)excludedWorker).counts);
        Map composition = reduction.getTypeComposition();
        for (Map.Entry component : composition.entrySet()) {
            CloudInstanceTypeDescription type = (CloudInstanceTypeDescription)component.getKey();
            int count = ((int[])component.getValue())[0];
            MethodResourceDescription rd = type.getResourceDescription();
            MOCloudTypeProfile moCloudTypeProf = (MOCloudTypeProfile)this.getCloudTypeProfile(type);
            Resource resource = clone;
            resource.idlePower = resource.idlePower - moCloudTypeProf.getIdlePower() * (double)count;
            resource = clone;
            resource.idlePrice = resource.idlePrice - moCloudTypeProf.getIdlePrice() * (double)count;
            int coreId = 0;
            while (coreId < CoreManager.getCoreCount()) {
                List impls = CoreManager.getCoreImplementations((int)coreId);
                MOProfile[] profiles = new MOProfile[impls.size()];
                for (int i = 0; i < impls.size(); ++i) {
                    profiles[i] = (MOProfile)moCloudTypeProf.getImplProfiles(coreId, ((Implementation)impls.get(i)).getImplementationId());
                }
                Implementation impl = this.getBestImplementation(impls, profiles);
                int[] nArray = clone.capacity;
                int n = coreId++;
                nArray[n] = nArray[n] - rd.canHostSimultaneously((MethodResourceDescription)impl.getRequirements()) * count;
            }
        }
        return clone;
    }

    private Resource<?> createResourceForCreationRequest(ResourceCreationRequest rcr) {
        CloudMethodResourceDescription cmrd = rcr.getRequested();
        Resource r = new Resource(null);
        Map composition = cmrd.getTypeComposition();
        Resource.access$1402(r, new int[CoreManager.getCoreCount()]);
        Resource.access$1302(r, new MOProfile[CoreManager.getCoreCount()]);
        for (Map.Entry component : composition.entrySet()) {
            CloudInstanceTypeDescription type = (CloudInstanceTypeDescription)component.getKey();
            int count = ((int[])component.getValue())[0];
            MethodResourceDescription rd = type.getResourceDescription();
            MOCloudTypeProfile moCloudTypeProf = (MOCloudTypeProfile)this.getCloudTypeProfile(type);
            Resource resource = r;
            resource.idlePower = resource.idlePower + moCloudTypeProf.getIdlePower() * (double)count;
            resource = r;
            resource.idlePrice = resource.idlePrice + moCloudTypeProf.getIdlePrice() * (double)count;
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                List impls = CoreManager.getCoreImplementations((int)coreId);
                MOProfile[] profiles = new MOProfile[impls.size()];
                for (int i = 0; i < impls.size(); ++i) {
                    profiles[i] = (MOProfile)moCloudTypeProf.getImplProfiles(coreId, ((Implementation)impls.get(i)).getImplementationId());
                }
                Implementation impl = this.getBestImplementation(impls, profiles);
                int[] nArray = r.capacity;
                int n = coreId;
                nArray[n] = nArray[n] + rd.canHostSimultaneously((MethodResourceDescription)impl.getRequirements()) * count;
                MOProfile bestImplProf = (MOProfile)moCloudTypeProf.getImplProfiles(coreId, impl.getImplementationId());
                if (r.profiles[coreId] == null) {
                    r.profiles[coreId] = bestImplProf;
                    continue;
                }
                r.profiles[coreId].accumulate(bestImplProf);
            }
        }
        r.startTime = (long)(cmrd.getImage().getCreationTime() * 1000) - (System.currentTimeMillis() - rcr.getRequestedTime());
        if (r.startTime < 0L) {
            r.startTime = 0L;
        }
        r.clear();
        return r;
    }

    private Resource<?> createResourceForComponent(CloudInstanceTypeDescription citd, CloudImageDescription cid) {
        Resource r = new Resource(null);
        MOCloudTypeProfile moCloudTypeProf = (MOCloudTypeProfile)this.getCloudTypeProfile(citd);
        r.idlePower = moCloudTypeProf.getIdlePower();
        r.idlePrice = moCloudTypeProf.getIdlePrice();
        MethodResourceDescription rd = citd.getResourceDescription();
        Resource.access$1402(r, new int[CoreManager.getCoreCount()]);
        Resource.access$1302(r, new MOProfile[CoreManager.getCoreCount()]);
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            List impls = CoreManager.getCoreImplementations((int)coreId);
            MOProfile[] profiles = new MOProfile[impls.size()];
            for (int i = 0; i < impls.size(); ++i) {
                profiles[i] = (MOProfile)moCloudTypeProf.getImplProfiles(coreId, ((Implementation)impls.get(i)).getImplementationId());
            }
            Implementation impl = this.getBestImplementation(impls, profiles);
            r.capacity[coreId] = rd.canHostSimultaneously((MethodResourceDescription)impl.getRequirements());
            r.profiles[coreId] = (MOProfile)moCloudTypeProf.getImplProfiles(coreId, impl.getImplementationId());
        }
        r.startTime = cid.getCreationTime() * 1000;
        r.clear();
        return r;
    }

    private Implementation getBestImplementation(List<Implementation> impls, MOProfile[] profiles) {
        Implementation impl = impls.get(0);
        MOScore bestScore = new MOScore(0L, 0L, 0L, 0L, profiles[0].getAverageExecutionTime(), profiles[0].getPower(), profiles[0].getPrice());
        for (int i = 1; i < impls.size(); ++i) {
            double price;
            double power;
            Implementation candidate = impls.get(i);
            long length = profiles[i].getAverageExecutionTime();
            MOScore score = new MOScore(0L, 0L, 0L, 0L, length, (power = profiles[i].getPower()) * (double)length, price = profiles[i].getPrice());
            if (!Score.isBetter((Score)score, (Score)bestScore)) continue;
            bestScore = score;
            impl = candidate;
        }
        return impl;
    }

    private void addToLog(String s) {
        this.log.append(s);
    }

    private void printLog() {
        System.out.println(this.log.toString() + "\n" + "-----------------------------\n");
        this.log = new StringBuilder("-------------------------\n    CHECK SCALABILITY    \n-------------------------\n");
    }

    private class ConfigurationCost {
        private final double time;
        private final double energy;
        private final double cost;
        private final double power;
        private final double price;

        public ConfigurationCost(double time, double idlePower, double fixedEnergy, double idlePrice, double fixedCost) {
            this.time = time / 1000.0;
            this.energy = (idlePower * time + fixedEnergy) / 3600000.0;
            this.cost = (idlePrice * time + fixedCost) / 3600000.0;
            this.power = idlePower + fixedEnergy / time;
            this.price = idlePrice + fixedCost / time;
        }

        public String toString() {
            return "Configuration Cost:\n\tTime: " + this.time + "s\n" + "\tEnergy: " + this.energy + "Wh\n" + "\tCost: " + this.cost + "\u20ac\n" + "\tPower: " + this.power + "W\n" + "\tPrice: " + this.price + "\u20ac/h\n";
        }
    }

    private class ActionRemove
    extends Action {
        private final Resource<?> res;
        private final CloudInstanceTypeDescription citd;

        public ActionRemove(Resource<?> res, CloudInstanceTypeDescription reduction, ConfigurationCost cost) {
            super("Remove " + ((Resource)res).getName(), cost);
            this.citd = reduction;
            this.res = res;
        }

        @Override
        public void perform() {
            RUNTIME_LOGGER.debug("[MOResourceOptimizer] Performing Remove action " + this);
            CloudMethodWorker worker = (CloudMethodWorker)((Resource)this.res).getResource();
            CloudMethodResourceDescription reduction = new CloudMethodResourceDescription(this.citd, worker.getDescription().getImage());
            ResourceManager.requestWorkerReduction((DynamicMethodWorker)worker, (MethodResourceDescription)reduction);
        }
    }

    private class ActionAdd
    extends Action {
        private final CloudProvider provider;
        private final CloudInstanceTypeDescription instance;
        private final CloudImageDescription image;

        public ActionAdd(CloudProvider provider, CloudInstanceTypeDescription component, CloudImageDescription image, ConfigurationCost cost) {
            super("Add " + component, cost);
            this.provider = provider;
            this.image = image;
            this.instance = component;
        }

        @Override
        public void perform() {
            RUNTIME_LOGGER.debug("[MOResourceOptimizer] Performing Add action " + this);
            CloudMethodResourceDescription cmrd = new CloudMethodResourceDescription(this.instance, this.image);
            this.provider.requestResourceCreation(cmrd);
        }
    }

    private class Action {
        protected final String title;
        private final ConfigurationCost cost;

        public Action(ConfigurationCost cost) {
            this.title = "Current Configuration";
            this.cost = cost;
        }

        public Action(String title, ConfigurationCost cost) {
            this.title = title;
            this.cost = cost;
        }

        public String toString() {
            return this.title + ":\n" + this.cost.toString();
        }

        public void perform() {
        }
    }

    private class SortedList {
        private final Resource<?>[] values;

        public SortedList(int size) {
            this.values = new Resource[size];
        }

        public void initialAdd(Resource<?> r) {
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (this.values[i + 1] != null && ((Resource)r).time < ((Resource)this.values[i + 1]).time) {
                    this.values[i] = r;
                    return;
                }
                this.values[i] = this.values[i + 1];
            }
            this.values[this.values.length - 1] = r;
        }

        public void add(Resource<?> r) {
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (((Resource)r).time < ((Resource)this.values[i + 1]).time) {
                    this.values[i] = r;
                    return;
                }
                this.values[i] = this.values[i + 1];
            }
            this.values[this.values.length - 1] = r;
        }

        public Resource<?> peek() {
            return this.values[0];
        }
    }

    private class Resource<T extends WorkerResourceDescription> {
        private final MOResourceScheduler<T> worker;
        private double idlePower;
        private double idlePrice;
        private MOProfile[] profiles;
        private int[] capacity;
        private long startTime;
        private double startEnergy;
        private double startCost;
        private long time;
        private int[] counts;

        public Resource(MOResourceScheduler<T> worker) {
            this.worker = worker;
        }

        public void clear() {
            this.time = this.startTime;
            this.counts = new int[this.profiles.length];
        }

        private boolean canExecute() {
            if (this.worker != null) {
                return !this.worker.hasPendingModifications();
            }
            return true;
        }

        private boolean hasPendingModifications() {
            if (this.worker != null) {
                return this.worker.hasPendingModifications();
            }
            return true;
        }

        private List<ResourceUpdate<T>> getPendingModifications() {
            if (this.worker != null) {
                return this.worker.getPendingModifications();
            }
            return new LinkedList<ResourceUpdate<T>>();
        }

        private Worker<?> getResource() {
            if (this.worker != null) {
                return this.worker.getResource();
            }
            return null;
        }

        private String getName() {
            if (this.worker != null) {
                return this.worker.getName();
            }
            return "TEMPORARY";
        }

        static /* synthetic */ MOProfile[] access$1302(Resource x0, MOProfile[] x1) {
            x0.profiles = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1402(Resource x0, int[] x1) {
            x0.capacity = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1802(Resource x0, int[] x1) {
            x0.counts = x1;
            return x1;
        }
    }

    protected class MOCloudTypeProfile
    extends ResourceOptimizer.CloudTypeProfile {
        private final double idlePower;
        private final double idlePrice;

        public MOCloudTypeProfile(JSONObject typeJSON, JSONObject implsJSON) {
            double idlePrice;
            double idlePower;
            super((ResourceOptimizer)MOResourceOptimizer.this, typeJSON, implsJSON);
            if (typeJSON != null) {
                try {
                    idlePower = typeJSON.getDouble("idlePower");
                }
                catch (JSONException je) {
                    idlePower = 1.0;
                }
                try {
                    idlePrice = typeJSON.getDouble("idlePrice");
                }
                catch (JSONException je) {
                    idlePrice = 0.0;
                }
            } else {
                idlePower = 1.0;
                idlePrice = 0.0;
            }
            this.idlePower = idlePower;
            this.idlePrice = idlePrice;
        }

        public double getIdlePower() {
            return this.idlePower;
        }

        public double getIdlePrice() {
            return this.idlePrice;
        }

        protected Profile generateProfileForImplementation(Implementation impl, JSONObject jsonImpl) {
            return new MOProfile(jsonImpl);
        }
    }
}

