/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fullgraph.multiobjective.types;

import es.bsc.compss.scheduler.fullgraph.multiobjective.MOResourceScheduler;
import es.bsc.compss.scheduler.fullgraph.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.Gap;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.LocalOptimizationState;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public abstract class SchedulingEvent
implements Comparable<SchedulingEvent> {
    protected long expectedTimeStamp;
    protected AllocatableAction action;

    public SchedulingEvent(long timeStamp, AllocatableAction action) {
        this.expectedTimeStamp = timeStamp;
        this.action = action;
    }

    @Override
    public int compareTo(SchedulingEvent e) {
        int time = Long.compare(this.expectedTimeStamp, e.expectedTimeStamp);
        if (time == 0) {
            return this.getPriority() - e.getPriority();
        }
        return time;
    }

    public AllocatableAction getAction() {
        return this.action;
    }

    protected abstract int getPriority();

    public abstract List<SchedulingEvent> process(LocalOptimizationState var1, MOResourceScheduler<WorkerResourceDescription> var2, PriorityQueue<AllocatableAction> var3);

    public static class ResourceBlocked
    extends SchedulingEvent {
        public ResourceBlocked(long timeStamp, AllocatableAction action) {
            super(timeStamp, action);
        }

        @Override
        protected int getPriority() {
            return 0;
        }

        @Override
        public List<SchedulingEvent> process(LocalOptimizationState state, MOResourceScheduler<WorkerResourceDescription> worker, PriorityQueue<AllocatableAction> rescheduledActions) {
            MOSchedulingInformation dsi = (MOSchedulingInformation)this.action.getSchedulingInfo();
            dsi.setOnOptimization(false);
            dsi.clearPredecessors();
            dsi.clearSuccessors();
            dsi.setExpectedStart(Long.MAX_VALUE);
            dsi.setExpectedEnd(Long.MAX_VALUE);
            state.resourceBlockedAction(this.action);
            state.blockDataSuccessors(dsi);
            dsi.unlock();
            rescheduledActions.add(this.action);
            return new LinkedList<SchedulingEvent>();
        }

        public String toString() {
            return this.action + " resourceBlocked";
        }
    }

    public static class End
    extends SchedulingEvent {
        public End(long timeStamp, AllocatableAction action) {
            super(timeStamp, action);
        }

        @Override
        protected int getPriority() {
            return 0;
        }

        @Override
        public List<SchedulingEvent> process(LocalOptimizationState state, MOResourceScheduler<WorkerResourceDescription> worker, PriorityQueue<AllocatableAction> rescheduledActions) {
            LinkedList<SchedulingEvent> enabledEvents = new LinkedList<SchedulingEvent>();
            MOSchedulingInformation dsi = (MOSchedulingInformation)this.action.getSchedulingInfo();
            dsi.setOnOptimization(false);
            state.progressOnTime(this.expectedTimeStamp);
            state.releaseDataSuccessors(dsi, this.expectedTimeStamp);
            AllocatableAction currentTop = state.getMostPrioritaryRunnableAction();
            if (state.getAction() != currentTop) {
                state.replaceAction(currentTop);
            }
            if (this.action.isToReleaseResources()) {
                state.releaseResources(this.expectedTimeStamp, this.action);
            }
            state.updateConsumptions(this.action);
            while (state.canActionRun()) {
                SchedulingEvent se;
                state.removeMostPrioritaryRunnableAction(currentTop.getCoreId());
                MOSchedulingInformation topDSI = (MOSchedulingInformation)currentTop.getSchedulingInfo();
                topDSI.lock();
                topDSI.setToReschedule(false);
                if (this.action.isToReleaseResources()) {
                    se = new Start(state.getActionStartTime(), currentTop);
                    enabledEvents.addAll(se.process(state, worker, rescheduledActions));
                } else {
                    se = new ResourceBlocked(state.getActionStartTime(), currentTop);
                    enabledEvents.addAll(se.process(state, worker, rescheduledActions));
                }
                currentTop = state.getMostPrioritaryRunnableAction();
                state.replaceAction(currentTop);
            }
            return enabledEvents;
        }

        public String toString() {
            return this.action + " end @ " + this.expectedTimeStamp;
        }
    }

    public static class Start
    extends SchedulingEvent {
        public Start(long timeStamp, AllocatableAction action) {
            super(timeStamp, action);
        }

        @Override
        protected int getPriority() {
            return 1;
        }

        public String toString() {
            return this.action + " start @ " + this.expectedTimeStamp;
        }

        @Override
        public List<SchedulingEvent> process(LocalOptimizationState state, MOResourceScheduler<WorkerResourceDescription> worker, PriorityQueue<AllocatableAction> rescheduledActions) {
            LinkedList<SchedulingEvent> enabledEvents = new LinkedList<SchedulingEvent>();
            MOSchedulingInformation dsi = (MOSchedulingInformation)this.action.getSchedulingInfo();
            dsi.setExpectedStart(this.expectedTimeStamp);
            long expectedEndTime = this.getExpectedEnd(this.action, worker, this.expectedTimeStamp);
            dsi.setExpectedEnd(expectedEndTime);
            End endEvent = new End(expectedEndTime, this.action);
            enabledEvents.add(endEvent);
            dsi.clearPredecessors();
            dsi.clearSuccessors();
            List<Gap> tmpGaps = state.reserveResources((ResourceDescription)this.action.getAssignedImplementation().getRequirements(), this.expectedTimeStamp);
            for (Gap tmpGap : tmpGaps) {
                AllocatableAction gapAction = tmpGap.getOrigin();
                if (this.expectedTimeStamp == tmpGap.getEndTime()) {
                    if (gapAction == null) continue;
                    MOSchedulingInformation gapActionDSI = (MOSchedulingInformation)gapAction.getSchedulingInfo();
                    gapActionDSI.addSuccessor(this.action);
                    dsi.addPredecessor(tmpGap);
                    state.removeTmpGap(tmpGap);
                    continue;
                }
                PriorityQueue<Gap> outGaps = this.fillGap(worker, tmpGap, rescheduledActions, state);
                for (Gap outGap : outGaps) {
                    AllocatableAction pred = outGap.getOrigin();
                    if (pred != null) {
                        MOSchedulingInformation predDSI = (MOSchedulingInformation)pred.getSchedulingInfo();
                        predDSI.addSuccessor(this.action);
                        dsi.addPredecessor(outGap);
                    }
                    state.removeTmpGap(outGap);
                }
            }
            rescheduledActions.offer(this.action);
            return enabledEvents;
        }

        private PriorityQueue<Gap> fillGap(MOResourceScheduler<WorkerResourceDescription> worker, Gap gap, PriorityQueue<AllocatableAction> rescheduledActions, LocalOptimizationState state) {
            PriorityQueue<Gap> availableGaps = new PriorityQueue<Gap>(1, new Comparator<Gap>(){

                @Override
                public int compare(Gap g1, Gap g2) {
                    return Long.compare(g1.getInitialTime(), g2.getInitialTime());
                }
            });
            AllocatableAction gapAction = state.pollActionForGap(gap);
            if (gapAction != null) {
                Gap peekGap;
                MOSchedulingInformation gapActionDSI = (MOSchedulingInformation)gapAction.getSchedulingInfo();
                gapActionDSI.setToReschedule(false);
                long gapActionStart = Math.max(gapActionDSI.getExpectedStart(), gap.getInitialTime());
                if (gap.getInitialTime() != gapActionStart) {
                    Gap previousGap = new Gap(gap.getInitialTime(), gapActionStart, gap.getOrigin(), gap.getResources().copy(), 0);
                    state.replaceTmpGap(gap, previousGap);
                    availableGaps = this.fillGap(worker, previousGap, rescheduledActions, state);
                } else {
                    availableGaps.add(gap);
                }
                gapActionDSI.lock();
                gapActionDSI.setExpectedStart(gapActionStart);
                long expectedEnd = this.getExpectedEnd(gapAction, worker, gapActionStart);
                gapActionDSI.setExpectedEnd(expectedEnd);
                gapActionDSI.clearPredecessors();
                ResourceDescription desc = gapAction.getAssignedImplementation().getRequirements().copy();
                while (!desc.isDynamicUseless() && (peekGap = availableGaps.peek()) != null) {
                    AllocatableAction peekAction = peekGap.getOrigin();
                    if (peekAction != null) {
                        MOSchedulingInformation predActionDSI = (MOSchedulingInformation)peekAction.getSchedulingInfo();
                        gapActionDSI.addPredecessor(peekGap);
                        predActionDSI.addSuccessor(gapAction);
                    }
                    ResourceDescription.reduceCommonDynamics((ResourceDescription)desc, (ResourceDescription)peekGap.getResources());
                    if (!peekGap.getResources().isDynamicUseless()) continue;
                    availableGaps.poll();
                    state.removeTmpGap(gap);
                }
                LinkedList<Gap> extendedGaps = new LinkedList<Gap>();
                for (Gap g : availableGaps) {
                    Gap extendedGap = new Gap(g.getInitialTime(), gap.getEndTime(), g.getOrigin(), g.getResources(), g.getCapacity());
                    state.replaceTmpGap(extendedGap, gap);
                    extendedGaps.add(extendedGap);
                }
                availableGaps.clear();
                for (Gap eg : extendedGaps) {
                    availableGaps.addAll(this.fillGap(worker, eg, rescheduledActions, state));
                }
                gapActionDSI.clearSuccessors();
                rescheduledActions.add(gapAction);
                gapActionDSI.setOnOptimization(false);
                state.releaseDataSuccessors(gapActionDSI, expectedEnd);
                Gap actionGap = new Gap(expectedEnd, gap.getEndTime(), gapAction, (ResourceDescription)gapAction.getAssignedImplementation().getRequirements(), 0);
                state.addTmpGap(actionGap);
                availableGaps.addAll(this.fillGap(worker, actionGap, rescheduledActions, state));
            } else {
                availableGaps.add(gap);
            }
            return availableGaps;
        }

        private long getExpectedEnd(AllocatableAction action, MOResourceScheduler<WorkerResourceDescription> worker, long expectedStart) {
            long theoreticalEnd;
            if (action.isToReleaseResources()) {
                Implementation impl = action.getAssignedImplementation();
                Profile p = worker.getProfile(impl);
                long endTime = expectedStart;
                if (p != null) {
                    endTime += p.getAverageExecutionTime();
                }
                if (endTime < 0L) {
                    endTime = 0L;
                }
                theoreticalEnd = endTime;
            } else {
                theoreticalEnd = Long.MAX_VALUE;
            }
            if (theoreticalEnd < expectedStart) {
                return Long.MAX_VALUE;
            }
            return theoreticalEnd;
        }
    }
}

