/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fullgraph.multiobjective;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.fullgraph.multiobjective.MOResourceOptimizer;
import es.bsc.compss.scheduler.fullgraph.multiobjective.MOResourceScheduler;
import es.bsc.compss.scheduler.fullgraph.multiobjective.MOScheduleOptimizer;
import es.bsc.compss.scheduler.fullgraph.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.fullgraph.multiobjective.config.MOConfiguration;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.MOProfile;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.MOScore;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ResourceOptimizer;
import es.bsc.compss.util.SchedulingOptimizer;
import java.util.List;
import org.json.JSONObject;

public class MOScheduler
extends TaskScheduler {
    public MOScheduler(ActionOrchestrator orchestrator) {
        super(orchestrator);
        MOConfiguration.load();
    }

    public void customSchedulerShutdown() {
    }

    public MOProfile generateProfile(JSONObject json) {
        return new MOProfile(json);
    }

    public <T extends WorkerResourceDescription> MOResourceScheduler<T> generateSchedulerForResource(Worker<T> w, JSONObject res, JSONObject impls) {
        return new MOResourceScheduler<T>(w, res, impls);
    }

    public <T extends WorkerResourceDescription> MOSchedulingInformation generateSchedulingInformation(ResourceScheduler<T> enforcedTargetResource, List<? extends Parameter> params, Integer coreId) {
        return new MOSchedulingInformation(enforcedTargetResource);
    }

    public Score generateActionScore(AllocatableAction action) {
        return MOScheduler.getActionScore(action);
    }

    public static MOScore getActionScore(AllocatableAction action) {
        long dataTime = MOScore.getDataPredecessorTime(action.getDataPredecessors());
        return new MOScore(action.getPriority(), action.getGroupPriority(), dataTime, 0L, 0L, 0.0, 0.0);
    }

    public ResourceOptimizer generateResourceOptimizer() {
        return new MOResourceOptimizer(this);
    }

    public <T extends TaskScheduler> SchedulingOptimizer<T> generateSchedulingOptimizer() {
        return new MOScheduleOptimizer(this);
    }

    public <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        LOGGER.debug("[MOScheduler] Treating dependency free actions on resource " + resource.getName());
        for (AllocatableAction freeAction : dataFreeActions) {
            this.tryToLaunch(freeAction);
        }
        for (AllocatableAction freeAction : resourceFreeActions) {
            this.tryToLaunch(freeAction);
        }
    }
}

