/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fullgraph.multiobjective.types;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.fullgraph.multiobjective.MOSchedulingInformation;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.Gap;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.MOProfile;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.OptimizationAction;
import es.bsc.compss.scheduler.fullgraph.multiobjective.types.PriorityActionSet;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.CoreManager;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalOptimizationState {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    protected static final String LOG_PREFIX = "[MOLocalOptimizationState] ";
    private final long updateId;
    private final ResourceScheduler<WorkerResourceDescription> worker;
    private final LinkedList<Gap> gaps;
    private double runningCost;
    private double totalCost;
    private double runningEnergy;
    private double totalEnergy;
    private AllocatableAction action = null;
    private ResourceDescription missingResources;
    private long topStartTime;
    private int[][] implementationCount;
    private int[][] runningImplementationsCount;
    private long endRunningActions;
    private final List<AllocatableAction> runningActions;
    private final PriorityQueue<AllocatableAction> readyActions;
    private final PriorityActionSet selectableActions;
    private AllocatableAction resourceBlockingAction;
    private AllocatableAction dataBlockingAction;

    public LocalOptimizationState(long updateId, ResourceScheduler<WorkerResourceDescription> rs, Comparator<AllocatableAction> readyComparator, Comparator<AllocatableAction> selectionComparator) {
        this.updateId = updateId;
        this.worker = rs;
        this.totalCost = 0.0;
        this.runningCost = 0.0;
        this.totalEnergy = 0.0;
        this.runningEnergy = 0.0;
        this.gaps = new LinkedList();
        WorkerResourceDescription rd = rs.getResource().getDescription();
        Gap g = new Gap(0L, Long.MAX_VALUE, null, rd.copy(), 0);
        this.gaps.add(g);
        this.implementationCount = new int[CoreManager.getCoreCount()][];
        this.runningImplementationsCount = new int[CoreManager.getCoreCount()][];
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            this.implementationCount[coreId] = new int[CoreManager.getCoreImplementations((int)coreId).size()];
            this.runningImplementationsCount[coreId] = new int[CoreManager.getCoreImplementations((int)coreId).size()];
        }
        this.endRunningActions = 0L;
        this.resourceBlockingAction = new OptimizationAction();
        this.resourceBlockingAction.assignResource(rs);
        this.dataBlockingAction = new OptimizationAction();
        this.dataBlockingAction.assignResource(rs);
        this.runningActions = new LinkedList<AllocatableAction>();
        this.readyActions = new PriorityQueue<AllocatableAction>(1, readyComparator);
        this.selectableActions = new PriorityActionSet(selectionComparator);
    }

    public long getId() {
        return this.updateId;
    }

    public List<Gap> reserveResources(ResourceDescription resources, long startTime) {
        LinkedList<Gap> previousGaps = new LinkedList<Gap>();
        ResourceDescription requirements = resources.copy();
        Iterator gapIt = this.gaps.iterator();
        while (gapIt.hasNext() && !requirements.isDynamicUseless()) {
            Gap g = (Gap)gapIt.next();
            if (!this.checkGapForReserve(g, requirements, startTime, previousGaps)) continue;
            gapIt.remove();
        }
        return previousGaps;
    }

    private boolean checkGapForReserve(Gap g, ResourceDescription requirements, long reserveStart, List<Gap> previousGaps) {
        boolean remove = false;
        AllocatableAction gapAction = g.getOrigin();
        ResourceDescription rd = g.getResources();
        ResourceDescription reduction = ResourceDescription.reduceCommonDynamics((ResourceDescription)rd, (ResourceDescription)requirements);
        if (!reduction.isDynamicUseless()) {
            MOSchedulingInformation gapDSI;
            Gap tmpGap = new Gap(g.getInitialTime(), reserveStart, g.getOrigin(), reduction, 0);
            previousGaps.add(tmpGap);
            if (gapAction != null) {
                gapDSI = (MOSchedulingInformation)gapAction.getSchedulingInfo();
                gapDSI.addGap();
            }
            if (rd.isDynamicUseless()) {
                remove = true;
                if (gapAction != null) {
                    gapDSI = (MOSchedulingInformation)gapAction.getSchedulingInfo();
                    gapDSI.removeGap();
                }
            }
        }
        return remove;
    }

    public void releaseResources(long expectedStart, AllocatableAction action) {
        if (action.getAssignedImplementation() != null) {
            Gap gap = new Gap(expectedStart, Long.MAX_VALUE, action, action.getAssignedImplementation().getRequirements().copy(), 0);
            MOSchedulingInformation dsi = (MOSchedulingInformation)action.getSchedulingInfo();
            dsi.addGap();
            this.gaps.add(gap);
            if (this.missingResources != null) {
                ResourceDescription empty = gap.getResources().copy();
                this.topStartTime = gap.getInitialTime();
                ResourceDescription.reduceCommonDynamics((ResourceDescription)empty, (ResourceDescription)this.missingResources);
            }
        } else {
            LOGGER.debug("[MOLocalOptimizationState] Action has null implementation. Nothing done at release resources *** ");
        }
    }

    public void replaceAction(AllocatableAction action) {
        this.action = action;
        if (this.action != null) {
            this.missingResources = this.action.getAssignedImplementation().getRequirements().copy();
            for (Gap gap : this.gaps) {
                ResourceDescription empty = gap.getResources().copy();
                this.topStartTime = gap.getInitialTime();
                ResourceDescription.reduceCommonDynamics((ResourceDescription)empty, (ResourceDescription)this.missingResources);
                if (!this.missingResources.isDynamicUseless()) continue;
                break;
            }
        } else {
            this.missingResources = null;
            this.topStartTime = 0L;
        }
    }

    public void addTmpGap(Gap g) {
        AllocatableAction gapAction = g.getOrigin();
        MOSchedulingInformation gapDSI = (MOSchedulingInformation)gapAction.getSchedulingInfo();
        gapDSI.addGap();
    }

    public void replaceTmpGap(Gap gap, Gap previousGap) {
    }

    public void removeTmpGap(Gap g) {
        AllocatableAction gapAction = g.getOrigin();
        if (gapAction != null) {
            MOSchedulingInformation gapDSI = (MOSchedulingInformation)gapAction.getSchedulingInfo();
            gapDSI.removeGap();
            if (!gapDSI.hasGaps()) {
                gapDSI.unlock();
            }
        }
    }

    public AllocatableAction getAction() {
        return this.action;
    }

    public long getActionStartTime() {
        return Math.max(this.topStartTime, ((MOSchedulingInformation)this.action.getSchedulingInfo()).getExpectedStart());
    }

    public boolean canActionRun() {
        if (this.missingResources != null) {
            return this.missingResources.isDynamicUseless();
        }
        return false;
    }

    public boolean areGaps() {
        return !this.gaps.isEmpty();
    }

    public Gap peekFirstGap() {
        return this.gaps.peekFirst();
    }

    public void pollGap() {
        this.gaps.removeFirst();
    }

    public List<Gap> getGaps() {
        return this.gaps;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Optimization State at " + this.updateId + "\n");
        sb.append("\tGaps:\n");
        for (Gap gap : this.gaps) {
            sb.append("\t\t").append(gap).append("\n");
        }
        sb.append("\tTopAction:").append(this.action).append("\n");
        sb.append("\tMissing To Run:").append(this.missingResources).append("\n");
        sb.append("\tExpected Start:").append(this.topStartTime).append("\n");
        sb.append("\tPending Executions:\n");
        for (int coreId = 0; coreId < this.implementationCount.length; ++coreId) {
            sb.append("\t\tCore " + coreId + ":\n");
            for (int implId = 0; implId < this.implementationCount[coreId].length; ++implId) {
                sb.append("\t\t\tImplementation " + implId + ":" + this.implementationCount[coreId][implId] + "\n");
            }
        }
        return sb.toString();
    }

    public void runningAction(Implementation impl, MOProfile p, long pendingTime) {
        if (impl != null) {
            this.reserveResources((ResourceDescription)impl.getRequirements(), 0L);
            if (impl.getCoreId() != null && impl.getImplementationId() != null) {
                int[] nArray = this.runningImplementationsCount[impl.getCoreId()];
                int n = impl.getImplementationId();
                nArray[n] = nArray[n] + 1;
                this.endRunningActions = Math.max(this.endRunningActions, pendingTime);
                this.runningEnergy += p.getPower() * (double)pendingTime;
                this.runningCost += p.getPrice() * (double)pendingTime;
            }
        } else {
            LOGGER.debug("[MOLocalOptimizationState] Action has a null implementation. Nothing done for reserving resources ***");
        }
    }

    public long getEndRunningTime() {
        return this.endRunningActions;
    }

    public int[][] getRunningImplementations() {
        return this.runningImplementationsCount;
    }

    public double getRunningCost() {
        return this.runningCost;
    }

    public double getRunningEnergy() {
        return this.runningEnergy;
    }

    public AllocatableAction pollActionForGap(Gap gap) {
        AllocatableAction gapAction = null;
        PriorityQueue<AllocatableAction> peeks = this.selectableActions.peekAll();
        while (!peeks.isEmpty() && gapAction == null) {
            AllocatableAction candidate = peeks.poll();
            MOSchedulingInformation candidateDSI = (MOSchedulingInformation)candidate.getSchedulingInfo();
            long start = candidateDSI.getExpectedStart();
            if (start > gap.getEndTime()) continue;
            Implementation impl = candidate.getAssignedImplementation();
            Profile p = this.worker.getProfile(impl);
            long expectedLength = p.getAverageExecutionTime();
            if (gap.getEndTime() - gap.getInitialTime() < expectedLength || start + expectedLength > gap.getEndTime() || !gap.getResources().canHostDynamic(impl)) continue;
            this.selectableActions.removeFirst(candidate.getCoreId());
            gapAction = candidate;
        }
        return gapAction;
    }

    public void resourceBlockedAction(AllocatableAction action) {
        MOSchedulingInformation aDSI = (MOSchedulingInformation)action.getSchedulingInfo();
        MOSchedulingInformation rbaDSI = (MOSchedulingInformation)this.resourceBlockingAction.getSchedulingInfo();
        rbaDSI.lock();
        rbaDSI.addSuccessor(action);
        Gap opActionGap = new Gap(0L, 0L, this.resourceBlockingAction, action.getAssignedImplementation().getRequirements().copy(), 0);
        aDSI.addPredecessor(opActionGap);
        rbaDSI.unlock();
        this.updateConsumptions(action);
    }

    public void dataBlockedAction(AllocatableAction action) {
        MOSchedulingInformation aDSI = (MOSchedulingInformation)action.getSchedulingInfo();
        MOSchedulingInformation dbaDSI = (MOSchedulingInformation)this.dataBlockingAction.getSchedulingInfo();
        dbaDSI.lock();
        dbaDSI.addSuccessor(action);
        Gap opActionGap = new Gap(0L, 0L, this.dataBlockingAction, action.getAssignedImplementation().getRequirements().copy(), 0);
        aDSI.addPredecessor(opActionGap);
        dbaDSI.unlock();
        this.updateConsumptions(action);
    }

    public AllocatableAction getResourceBlockingAction() {
        return this.resourceBlockingAction;
    }

    public AllocatableAction getDataBlockingAction() {
        return this.dataBlockingAction;
    }

    public void classifyAction(AllocatableAction action, boolean hasInternal, boolean hasExternal, boolean hasResourcePredecessors, long startTime) {
        if (!hasInternal) {
            if (hasExternal) {
                if (startTime == 0L) {
                    this.selectableActions.offer(action);
                } else if (startTime == Long.MAX_VALUE) {
                    this.dataBlockedAction(action);
                } else {
                    this.readyActions.add(action);
                }
            } else if (hasResourcePredecessors) {
                this.selectableActions.offer(action);
            } else {
                this.runningActions.add(action);
            }
        }
    }

    public List<AllocatableAction> getRunningActions() {
        return this.runningActions;
    }

    public boolean areRunnableActions() {
        return !this.selectableActions.isEmpty();
    }

    public AllocatableAction getMostPrioritaryRunnableAction() {
        return this.selectableActions.peek();
    }

    public void removeMostPrioritaryRunnableAction() {
        this.selectableActions.poll();
    }

    public void removeMostPrioritaryRunnableAction(Integer coreId) {
        this.selectableActions.removeFirst(coreId);
    }

    public boolean areActionsToBeRescheduled() {
        return !this.readyActions.isEmpty();
    }

    public AllocatableAction getEarliestActionToBeRescheduled() {
        return this.readyActions.poll();
    }

    public void progressOnTime(long time) {
        AllocatableAction top;
        MOSchedulingInformation topDSI;
        long start;
        while (this.readyActions.size() > 0 && (start = (topDSI = (MOSchedulingInformation)(top = this.readyActions.peek()).getSchedulingInfo()).getExpectedStart()) <= time) {
            this.readyActions.poll();
            this.selectableActions.offer(top);
        }
    }

    public void releaseDataSuccessors(MOSchedulingInformation dsi, long timeLimit) {
        List<AllocatableAction> successors = dsi.getOptimizingSuccessors();
        for (AllocatableAction successor : successors) {
            MOSchedulingInformation successorDSI = (MOSchedulingInformation)successor.getSchedulingInfo();
            int missingParams = 0;
            long startTime = 0L;
            boolean retry = true;
            while (retry) {
                try {
                    List predecessors = successor.getDataPredecessors();
                    for (AllocatableAction predecessor : predecessors) {
                        MOSchedulingInformation predDSI = (MOSchedulingInformation)predecessor.getSchedulingInfo();
                        if (predecessor.getAssignedResource() != this.worker) {
                            startTime = Math.max(startTime, predDSI.getExpectedEnd());
                            continue;
                        }
                        if (predDSI.isOnOptimization()) {
                            ++missingParams;
                            continue;
                        }
                        startTime = Math.max(startTime, predDSI.getExpectedEnd());
                    }
                    retry = false;
                }
                catch (ConcurrentModificationException cme) {
                    missingParams = 0;
                    startTime = 0L;
                }
            }
            successorDSI.setExpectedStart(startTime);
            if (missingParams != 0) continue;
            if (successorDSI.getExpectedStart() <= timeLimit) {
                this.selectableActions.offer(successor);
                continue;
            }
            this.readyActions.add(successor);
        }
        dsi.clearOptimizingSuccessors();
    }

    public void blockDataSuccessors(MOSchedulingInformation dsi) {
        List<AllocatableAction> successors = dsi.getOptimizingSuccessors();
        for (AllocatableAction successor : successors) {
            MOSchedulingInformation sucDSI = (MOSchedulingInformation)successor.getSchedulingInfo();
            sucDSI.lock();
            if (sucDSI.isOnOptimization()) {
                sucDSI.clearPredecessors();
                sucDSI.clearSuccessors();
                this.dataBlockedAction(successor);
                this.blockDataSuccessors(sucDSI);
                sucDSI.setExpectedStart(Long.MAX_VALUE);
                sucDSI.setExpectedEnd(Long.MAX_VALUE);
                sucDSI.setOnOptimization(false);
            }
            sucDSI.unlock();
        }
    }

    public void updateConsumptions(AllocatableAction action) {
        Implementation impl = action.getAssignedImplementation();
        MOProfile p = (MOProfile)this.worker.getProfile(impl);
        if (p != null) {
            MOSchedulingInformation dsi = (MOSchedulingInformation)action.getSchedulingInfo();
            long length = dsi.getExpectedEnd() - (dsi.getExpectedStart() < 0L ? 0L : dsi.getExpectedStart());
            int[] nArray = this.implementationCount[impl.getCoreId()];
            int n = impl.getImplementationId();
            nArray[n] = nArray[n] + 1;
            this.totalEnergy += p.getPower() * (double)length;
            this.totalCost += p.getPrice() * (double)length;
        }
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    public int[][] getImplementationsCount() {
        return this.implementationCount;
    }
}

