/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.fullgraph.multiobjective.types;

import es.bsc.compss.scheduler.fullgraph.multiobjective.MOResourceScheduler;
import es.bsc.compss.scheduler.fullgraph.multiobjective.MOScheduleOptimizer;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.PriorityQueue;

public class OptimizationWorker {
    private MOResourceScheduler<WorkerResourceDescription> resource;
    private PriorityQueue<AllocatableAction> donorActions;

    public OptimizationWorker(MOResourceScheduler<WorkerResourceDescription> resource) {
        this.resource = resource;
    }

    public void localOptimization(long optimizationTS) {
        this.donorActions = this.resource.localOptimization(optimizationTS, MOScheduleOptimizer.getSelectionComparator(), MOScheduleOptimizer.getDonationComparator());
    }

    public AllocatableAction pollDonorAction() {
        return this.donorActions.poll();
    }

    public long getDonationIndicator() {
        return this.resource.getLastGapExpectedStart();
    }

    public String getName() {
        return this.resource.getName();
    }

    public MOResourceScheduler<WorkerResourceDescription> getResource() {
        return this.resource;
    }
}

