/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lifonew;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.lifonew.LIFOResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public class LIFOScheduler
extends TaskScheduler {
    protected LinkedList<AllocatableAction> unassignedReadyActionsList = new LinkedList();
    protected HashSet<AllocatableAction> unassignedReadyActionsSet = new HashSet();
    protected final HashSet<ResourceScheduler<?>> availableWorkers = new HashSet();
    protected int amountOfWorkers = 0;

    public <T extends WorkerResourceDescription> LIFOResourceScheduler<T> generateSchedulerForResource(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        return new LIFOResourceScheduler<T>(w, resJSON, implJSON);
    }

    protected <T extends WorkerResourceDescription> void workerDetected(ResourceScheduler<T> resource) {
        super.workerDetected(resource);
        this.availableWorkers.add(resource);
        ++this.amountOfWorkers;
    }

    protected <T extends WorkerResourceDescription> void workerRemoved(ResourceScheduler<T> resource) {
        super.workerRemoved(resource);
        this.availableWorkers.remove(resource);
        --this.amountOfWorkers;
        if (this.amountOfWorkers == 0) {
            for (AllocatableAction action : this.unassignedReadyActionsList) {
                this.addToBlocked(action);
            }
            this.unassignedReadyActionsList.clear();
            this.unassignedReadyActionsSet.clear();
        }
    }

    public Score generateActionScore(AllocatableAction action) {
        return new Score((long)action.getPriority(), 0L, 0L, 0L);
    }

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors()) {
            try {
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] Trying to schedule action " + action);
                }
                action.tryToSchedule(actionScore, this.availableWorkers);
                ResourceScheduler resource = action.getAssignedResource();
                if (!resource.canRunSomething()) {
                    this.availableWorkers.remove(resource);
                }
                this.removeActionFromSchedulerStructures(action);
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] Remove action " + action + " from scheduler structures");
                }
            }
            catch (UnassignedActionException ex) {
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] Introducing action " + action + " into the scheduler from try to schedule action");
                }
                this.addActionToSchedulerStructures(action);
            }
        }
    }

    public List<AllocatableAction> getUnassignedActions() {
        return this.unassignedReadyActionsList;
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Treating dependency free actions on resource " + resource.getName());
        }
        this.availableWorkers.add(resource);
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    public <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
    }

    private void addActionToSchedulerStructures(AllocatableAction action) {
        if (this.amountOfWorkers == 0) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Cannot add action " + action + " because there are not available resources");
            }
            this.addToBlocked(action);
        } else if (this.unassignedReadyActionsSet.add(action)) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Add action to scheduler structures " + action);
            }
            this.unassignedReadyActionsList.addFirst(action);
        }
    }

    private void removeActionFromSchedulerStructures(AllocatableAction action) {
        if (this.unassignedReadyActionsSet.remove(action)) {
            this.unassignedReadyActionsList.remove(action);
        }
    }

    protected <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Try to launch free actions on resource " + resource.getName() + " with " + this.unassignedReadyActionsList.size() + " candidates in this worker");
        }
        for (AllocatableAction freeAction : dataFreeActions) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing action " + freeAction + " into the scheduler from data free");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        dataFreeActions = new LinkedList<AllocatableAction>();
        for (AllocatableAction freeAction : resourceFreeActions) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing action " + freeAction + " into the scheduler from resource free");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        resourceFreeActions = new LinkedList<AllocatableAction>();
        for (AllocatableAction freeAction : blockedCandidates) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing action " + freeAction + " into the scheduler from blocked");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        blockedCandidates = new LinkedList<AllocatableAction>();
        Iterator executableActionsIterator = this.unassignedReadyActionsList.iterator();
        while (executableActionsIterator.hasNext() && !this.availableWorkers.isEmpty()) {
            AllocatableAction freeAction;
            freeAction = (AllocatableAction)executableActionsIterator.next();
            try {
                freeAction.tryToSchedule(this.generateActionScore(freeAction), this.availableWorkers);
                ResourceScheduler assignedResource = freeAction.getAssignedResource();
                this.tryToLaunch(freeAction);
                if (!assignedResource.canRunSomething()) {
                    this.availableWorkers.remove(assignedResource);
                }
                this.unassignedReadyActionsSet.remove(freeAction);
                executableActionsIterator.remove();
            }
            catch (BlockedActionException e) {
                this.unassignedReadyActionsSet.remove(freeAction);
                executableActionsIterator.remove();
                this.addToBlocked(freeAction);
            }
            catch (UnassignedActionException unassignedActionException) {}
        }
    }
}

