/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.loadbalancing;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.scheduler.loadbalancing.types.LoadBalancingScore;
import es.bsc.compss.scheduler.ready.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import org.json.JSONObject;

public class LoadBalancingResourceScheduler<T extends WorkerResourceDescription>
extends ReadyResourceScheduler<T> {
    public LoadBalancingResourceScheduler(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long priority = action.getPriority();
        long groupId = action.getGroupPriority();
        long resourceScore = 0L;
        long waitingScore = this.blocked.size();
        long implementationScore = 0L;
        return new LoadBalancingScore(priority, groupId, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long waitingScore = -action.getId();
        long resourceScore = this.calculateResourceScore(params, action);
        long implementationScore = -100L;
        LoadBalancingScore score = new LoadBalancingScore(priority, groupId, resourceScore, waitingScore, implementationScore);
        return score;
    }

    private long calculateResourceScore(TaskDescription params, AllocatableAction action) {
        long resourceScore = 0L;
        if (params != null) {
            List parameters = params.getParameters();
            resourceScore = parameters.isEmpty() ? 0L : 200L * (long)action.getSchedulingInfo().getScore((Resource)this.myWorker);
        }
        if (this.myWorker == Comm.getAppHost()) {
            ++resourceScore;
        }
        return resourceScore;
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        if (this.hasBlockedActions()) {
            return null;
        }
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            long priority = resourceScore.getPriority();
            long groupId = action.getGroupPriority();
            long resourcePriority = resourceScore.getResourceScore();
            long waitingScore = -action.getId();
            long implScore = -this.getProfile(impl).getAverageExecutionTime();
            return new LoadBalancingScore(priority, groupId, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "LoadBalancingResourceScheduler@" + this.getName();
    }
}

